/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowImpl;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TopLevelWindow
extends WebWindowImpl {
    private static final Log LOG = LogFactory.getLog(TopLevelWindow.class);
    private WebWindow opener_;

    protected TopLevelWindow(String name, WebClient webClient) {
        super(webClient);
        WebAssert.notNull("name", name);
        this.setName(name);
        this.performRegistration();
    }

    public WebWindow getParentWindow() {
        return this;
    }

    public WebWindow getTopWindow() {
        return this;
    }

    protected boolean isJavaScriptInitializationNeeded() {
        Page enclosedPage = this.getEnclosedPage();
        return this.getScriptObject() == null || enclosedPage.getWebResponse().getWebRequest().getUrl() == WebClient.URL_ABOUT_BLANK || !(enclosedPage.getWebResponse() instanceof StringWebResponse);
    }

    public String toString() {
        return "TopLevelWindow[name=\"" + this.getName() + "\"]";
    }

    public void setOpener(WebWindow opener) {
        this.opener_ = opener;
    }

    public WebWindow getOpener() {
        return this.opener_;
    }

    public void close() {
        this.setClosed();
        Page page = this.getEnclosedPage();
        if (page instanceof HtmlPage) {
            HtmlPage htmlPage = (HtmlPage)page;
            if (!htmlPage.isOnbeforeunloadAccepted()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"The registered OnbeforeunloadHandler rejected the window close event.");
                }
                return;
            }
            htmlPage.cleanUp();
        }
        this.getJobManager().shutdown();
        this.destroyChildren();
        this.getWebClient().deregisterWebWindow(this);
    }
}

