/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersion;

class BrowserConfiguration {
    private String browserFamily_;
    private String defaultValue_;
    private int minVersionNumber_ = -1;
    private int maxVersionNumber_ = Integer.MAX_VALUE;

    BrowserConfiguration() {
    }

    public static BrowserConfiguration ff(String defaultValue) {
        BrowserConfiguration browserConfiguration = new BrowserConfiguration();
        browserConfiguration.browserFamily_ = "FF";
        browserConfiguration.defaultValue_ = defaultValue;
        return browserConfiguration;
    }

    public static BrowserConfiguration ie(String defaultValue) {
        BrowserConfiguration browserConfiguration = new BrowserConfiguration();
        browserConfiguration.browserFamily_ = "IE";
        browserConfiguration.defaultValue_ = defaultValue;
        return browserConfiguration;
    }

    public static BrowserConfiguration ffBelow17(String defaultValue) {
        return BrowserConfiguration.ff(defaultValue).upTo(16);
    }

    public static BrowserConfiguration ff17up(String defaultValue) {
        return BrowserConfiguration.ff(defaultValue).startingWith(17);
    }

    public static BrowserConfiguration ie8up(String defaultValue) {
        return BrowserConfiguration.ie(defaultValue).startingWith(8);
    }

    public static boolean isDefined(BrowserVersion browserVersion, BrowserConfiguration[] browserConfigurations) {
        if (browserConfigurations == null) {
            return true;
        }
        return BrowserConfiguration.getMatchingConfiguration(browserVersion, browserConfigurations) != null;
    }

    public static BrowserConfiguration getMatchingConfiguration(BrowserVersion browserVersion, BrowserConfiguration[] browserConfigurations) {
        for (BrowserConfiguration browserConfiguration : browserConfigurations) {
            if (!browserVersion.getNickname().startsWith(browserConfiguration.browserFamily_) || !(browserVersion.getBrowserVersionNumeric() >= (float)browserConfiguration.minVersionNumber_) || !(browserVersion.getBrowserVersionNumeric() <= (float)browserConfiguration.maxVersionNumber_)) continue;
            return browserConfiguration;
        }
        return null;
    }

    public String getDefaultValue() {
        return this.defaultValue_;
    }

    public BrowserConfiguration startingWith(int minVersionNumber) {
        if (this.minVersionNumber_ != -1) {
            throw new IllegalStateException("startingWith has already been set to " + this.minVersionNumber_);
        }
        this.minVersionNumber_ = minVersionNumber;
        return this;
    }

    public BrowserConfiguration upTo(int maxVersionNumber) {
        if (this.maxVersionNumber_ != Integer.MAX_VALUE) {
            throw new IllegalStateException("below has already been set to " + this.maxVersionNumber_);
        }
        this.maxVersionNumber_ = maxVersionNumber;
        return this;
    }
}

