package Dist::Zilla::PluginBundle::Author::BLUEFEET;
$Dist::Zilla::PluginBundle::Author::BLUEFEET::VERSION = '0.01';
use Moose;
use strictures 2;
use namespace::clean;

with 'Dist::Zilla::Role::PluginBundle::Easy';

sub configure {
    my ($self) = @_;

    $self->add_bundle('Basic');
    $self->add_bundle('Git');

    $self->add_plugins(
        ['NextRelease' => {
            format => '%v %{yyyy-MM-dd}d',
        }],
        ['Git::NextVersion' => {
            first_version => '0.01',
        }],
        ['ReadmeAnyFromPod' => 'ReadmePodInRoot' => {
            type => 'pod',
        }],
        ['GithubMeta' => {
            issues => 1,
        }],
        'PkgVersion',
        'PodSyntaxTests',
        'Test::ReportPrereqs',
        'Prereqs::FromCPANfile',
    );
}

__PACKAGE__->meta->make_immutable;
1;
__END__

=head1 NAME

Dist::Zilla::PluginBundle::Author::BLUEFEET - The Dist::Zilla
plugins which Aran Deltac uses for his CPAN distributions.

=head1 SYNOPSIS

    [@Author::BLUEFEET]

=head1 DESCRIPTION

Using this L<Dist::Zilla> plugin bundle is equivalent to:

    [@Basic]
    [@Git]
    
    [NextRelease]
    format = %v %{yyyy-MM-dd}d
    
    [Git::NextVersion]
    first_version = 0.01
    
    [ReadmeAnyFromPod / ReadmePodInRoot]
    type = pod
    
    [GithubMeta]
    [PkgVersion]
    [PodSyntaxTests]
    [Test::ReportPrereqs]
    [Prereqs::FromCPANfile]

=head1 AUTHOR

Aran Clary Deltac <bluefeetE<64>gmail.com>

=head1 LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

