### 03-submission.t #############################################################################
# This file tests the simple calls to the job submit function

### Includes ######################################################################################

# Safe Perl
use warnings;
use strict;
use Carp;

use Test::More
	(qx(which qsub))
	? (tests => 13)
	: (skip_all => "SGE not available on this system");

use Test::More ; # tests => ##
use Test::Exception;
use Test::File::Contents;
use MooseX::Types::Path::Class qw(Dir File);
use File::Temp;
use File::pushd;
use File::ShareDir;
use HPCI;

use FindBin;
$ENV{PATH} = "$FindBin::Bin/../bin:$ENV{PATH}";

### Tests #################################################################################

-d 'scratch' or mkdir 'scratch';
my $tmp_dir = File::Temp->newdir( TEMPLATE => 'TEST.XXXX', DIR => 'scratch', CLEANUP => 0 );
print( "Testing in " . $tmp_dir->dirname . "\n" );
chdir $tmp_dir->dirname;
my $pre_name = 'T_Submission_';
my $inst = 0;
my $name = "$pre_name$inst";

my $cluster = 'SGE';

if ($cluster eq 'SGE') { # using modules_to_load and extra_sge_args_string
	++$inst;
	$name = "$pre_name$inst";
	mkdir $name;
	my $dir_handle = pushd( $name );
    my $group = HPCI->group( cluster => $cluster, base_dir => '.', name => $name );

    ok( $group, "Group created" );

    my $stage = $group->stage(
        command               => 'echo "yo, s\'up" | sed -e "s/yo/you hoser/" >testfile.txt',
        name                  => "testjob",
        modules_to_load       => [ 'java', 'samtools' ],
        extra_sge_args_string => "-hold_jid fakejobname123",
        resources_required    => {
            h_vmem => "1G"
        },
    );

    ok( $stage, "Stage created" );
    my $res = $group->execute;

    my $path = $stage->script_file;

    ok( -e $path, "Creates command shell script ($path)" );

    # These have a trailing slash to ensure that the module deferenceing has
    # worked. That is, we expect java/1.7.0_12 and not just java.
    file_contents_like( $path, qr/module load java\//,     'Command script is correct java'     );
    file_contents_like( $path, qr/module load samtools\//, 'Command script is correct samtools' );
    file_contents_like( $path, qr/module load Perl-BL\//,  'Command script is correct perl'     );
    file_contents_like( $path, qr/module load zmq\//,      'Command script is correct zmq'      );
    file_contents_like( "testfile.txt", qr/hoser/,         'Shell pipeline is correct'          );
}

{
	++$inst;
	$name = "$pre_name$inst";
	mkdir $name;
	my $dir_handle = pushd( $name );
    my $group = HPCI->group( cluster => $cluster, base_dir => '.', name => $name );

    my $num_jobs = 3;

    foreach my $i ( 0 .. $num_jobs ) {
        $group->stage(
            command => "echo \"yo, s'up $i\" >testfile$i.txt",
            name    => "otherjob$i",
        );
    }

    my $results = $group->execute();

	my $cnt = 0;
    while ( my ( $name, $stats ) = each %$results ) {
        like( $name, qr{^otherjob\d$}, "result $name matches" );
		++$cnt;
    }
    is( $cnt, $num_jobs + 1, 'Number of finished jobs is correct' );
}

done_testing();
