# Only EU::MM 6.52+ understands CONFIGURE_REQUIRES
use ExtUtils::MakeMaker 6.52;
use Alien::Hunspell;

my $CC = $ENV{'CXX'} || 'c++';

my $shlib_location = Alien::Hunspell->libs;
my $header_location = Alien::Hunspell->cflags;

    WriteMakefile(
        NAME          => 'Text::Hunspell',
        VERSION_FROM  => 'Hunspell.pm',
        LIBS          => [$shlib_location],
        CC            => $CC,
        LD            => '$(CC)',
        CONFIGURE_REQUIRES => {
            'ExtUtils::MakeMaker' => "6.52",
            'Alien::Hunspell'     => 0,
        },
        XSOPT         => '-C++',
        TYPEMAPS      => ['perlobject.map', 'typemap'],
        META_MERGE    => {
            resources => {
                repository => 'https://github.com/cosimo/perl5-text-hunspell',
            },
            keywords  => [ qw(hunspell spelling spell-checker text-processing) ],
        },
    );
