# Copyright (C) 2001-2004 Daniel Berrange <dan@berrange.com>
#
# $Id: Config-Record.spec.PL,v 1.8 2006/01/27 16:25:50 dan Exp $

use strict;

die unless (scalar @ARGV == 1);

unless (do 'lib/Config/Record.pm')
  {
    if ($@) { die $@ };
    die "lib/Config/Record.pm: $!";
  }
		
local $/ = undef;
$_ = <DATA>;
s/\@VERSION\@/$Config::Record::VERSION/g;

open SPEC, ">$ARGV[0]" or die "$!";
print SPEC $_;
close SPEC;
__DATA__
# Automatically generated by Config-Record.spec.PL

%define perlvendorarch %(perl -e 'use Config; print $Config{installvendorarch}')
%define perlvendorlib %(perl -e 'use Config; print $Config{installvendorlib}')
%define perlvendorprefix %(perl -e 'use Config; print $Config{vendorprefix}')
%define perlvendorman3 %{perlvendorprefix}/share/man/man3
%define perlversion %(perl -e 'use Config; print $Config{version}')

%define appname Config-Record

Summary: Config::Record - Simple configuration records
Name: perl-%{appname}
Version: @VERSION@
Release: 1
License: GPL
Group: Applications/Internet
Source: %{appname}-%{version}.tar.gz
BuildRoot: /var/tmp/%{appname}-%{version}-root
BuildArchitectures: noarch
Requires: perl >= %{perlversion}

%description
Config::Record provides a module for loading configuration
records. It supports scalar, array and hash parameters nested
to an arbitrary depth.
 
%prep
%setup -q -n %{appname}-%{version}


%build
perl Makefile.PL INSTALLDIRS=vendor PREFIX=$RPM_BUILD_ROOT/usr
make


%install
rm -rf $RPM_BUILD_ROOT
make install INSTALLVENDORMAN3DIR=$RPM_BUILD_ROOT%{perlvendorman3}
find $RPM_BUILD_ROOT -name perllocal.pod -exec rm -f {} \;
find $RPM_BUILD_ROOT -name .packlist -exec rm -f {} \;

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root)
%doc AUTHORS
%doc LICENSE
%doc README
%{perlvendorman3}/*
%{perlvendorlib}/Config/Record.pm
%{perlvendorlib}/Config/Record.pod
