
package Google::Ads::AdWords::v201302::AdExtensionOverrideService::mutate;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201302' }

__PACKAGE__->__set_name('mutate');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    Google::Ads::SOAP::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %operations_of :ATTR(:get<operations>);

__PACKAGE__->_factory(
    [ qw(        operations

    ) ],
    {
        'operations' => \%operations_of,
    },
    {
        'operations' => 'Google::Ads::AdWords::v201302::AdExtensionOverrideOperation',
    },
    {

        'operations' => 'operations',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

Google::Ads::AdWords::v201302::AdExtensionOverrideService::mutate

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
mutate from the namespace https://adwords.google.com/api/adwords/cm/v201302.

Applies the list of mutate operations. <p>Conditions for adding an ad-level AdExtension override using an AdExtension under the Ad's campaign:</p> <ol> <li>If the text ad has never been overridden, an AdExtension override may be set on the creative using an extension under the campaign, along with any override info.</li> <li>If the text ad has been overriden before, the latitude/longitude of the new extension override must be the same as the previous override and no override info can be specified (i.e. the override info will inherit from the previous override info).</li> </ol> @param operations The operations to apply. The same ad extension override cannot be specified in more than one operation. @return The applied ad extension overrides. 





=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * operations

 $element->set_operations($data);
 $element->get_operations();





=back


=head1 METHODS

=head2 new

 my $element = Google::Ads::AdWords::v201302::AdExtensionOverrideService::mutate->new($data);

Constructor. The following data structure may be passed to new():

 {
   operations =>  $a_reference_to, # see Google::Ads::AdWords::v201302::AdExtensionOverrideOperation
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

