package Koha::Contrib::Sudoc::Converter::ISHRetro;
# ABSTRACT: Convertisseur spécifique
$Koha::Contrib::Sudoc::Converter::ISHRetro::VERSION = '2.04';
use Moose;

extends 'Koha::Contrib::Sudoc::Converter';


override 'merge' => sub {
    my ($self, $sudoc, $koha) = @_;

    my @tags = ( (map { sprintf("6%02d", $_) } ( 0..99 )), '995');
    for my $tag (@tags) {
        my @fields = $sudoc->field($tag); 
        next unless @fields;
        $koha->append(@fields);
    }

    my @all_tags = map { sprintf("%03d", $_) } ( 1..999 );
    for my $tag (@all_tags) {
        next if $tag ~~ @tags || $tag == '410'; # On passe, déjà traité plus haut
        my @fields = $sudoc->field($tag);
        next unless @fields;
        next if $koha->field($tag);
        $koha->append(@fields);
    }

    $sudoc->fields( $koha->fields );
};


# Les champs à supprimer de la notice entrante.
my @todelete = qw(035 917 930 991 999);

after 'clean' => sub {
    my ($self, $record) = @_;

    # Suppression des champs SUDOC dont on ne veut pas dans le catalogue
    $record->fields( [ grep { not $_->tag ~~ @todelete } @{$record->fields} ] );
};


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Koha::Contrib::Sudoc::Converter::ISHRetro - Convertisseur spÃ©cifique

=head1 VERSION

version 2.04

=head1 AUTHOR

Frédéric Demians <f.demians@tamil.fr>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by Fréderic Demians.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
