package App::GitGot::Command::move;
$App::GitGot::Command::move::VERSION = '1.22';
# ABSTRACT: move a repo in a new directory
use Mouse;
extends 'App::GitGot::Command';
use strict;
use warnings;
use 5.010;
use namespace::autoclean;

use Cwd;
use File::Copy::Recursive qw/ dirmove /;
use Path::Class;

sub command_names { qw/ move mv / }

has destination => (
  is          => 'ro',
  isa         => 'Str',
  required    => 1,
  traits      => [qw/ Getopt /],
);

sub _execute {
  my( $self, $opt, $args ) = @_;

  my @repos = $self->active_repos;

  dir($self->destination)->mkpath if @repos > 1;

  for my $repo ( @repos ) {
    my $target_dir = -d $self->destination
      ? dir($self->destination)->subdir( dir($repo->path)->basename )
      : $self->destination;

    dirmove( $repo->path => $target_dir )
      or die "couldn't move ", $repo->name, " to '$target_dir': $!";

    $repo->{path} = "$target_dir";
    $self->write_config;

    say sprintf '%s moved to %s', $repo->name, $target_dir;
  }

}

__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::GitGot::Command::move - move a repo in a new directory

=head1 VERSION

version 1.22

=head1 AUTHOR

John SJ Anderson <genehack@genehack.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by John SJ Anderson.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
