#!/usr/bin/perl

use strict;
use lib 't/lib';

use Test::Deep qw(cmp_deeply);

use FusionInventory::Agent::Tools::Hardware;
use FusionInventory::Test::Hardware;

my %tests = (
    'cisco/C1040.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1040 Software (C1140-K9W7-M), Version 12.4(25d)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 11-Aug-11 02:58 by prod_rel_team',
            SNMPHOSTNAME => 'WIFI-IPJ-etage2-82.wifi-mngt.dauphine.fr',
            MAC          => '00:00:00:00:00:00',
            MODEL        => 'Aironet 1040 series',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1040 Software (C1140-K9W7-M), Version 12.4(25d)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 11-Aug-11 02:58 by prod_rel_team',
            SNMPHOSTNAME => 'WIFI-IPJ-etage2-82.wifi-mngt.dauphine.fr',
            MAC          => 'a4:18:75:c2:67:00',
            MODELSNMP    => 'Networking2178',
            MODEL        => 'Aironet 1040 series',
            FIRMWARE     => undef,
            SERIAL       => 'FCZ1623Z2XQ',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Aironet 1040 series',
                COMMENTS     => 'Cisco IOS Software, C1040 Software (C1140-K9W7-M), Version 12.4(25d)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 11-Aug-11 02:58 by prod_rel_team',
                NAME         => 'WIFI-IPJ-etage2-82.wifi-mngt.dauphine.fr',
                SERIAL       => 'FCZ1623Z2XQ',
                FIRMWARE     => 'CW_VERSION$12.4(25d)JA1$',
                IPS          => {
                    IP => [
                        '192.168.55.82',
                    ],
                },
                MAC          => 'a4:18:75:c2:67:00',
                UPTIME       => '(829014147) 95 days, 22:49:01.47',
                CPU          => '96',
                RAM          => '95',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Do0',
                        IFDESCR          => 'Dot11Radio0',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:18:75:c2:67:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(767607999) 88 days, 20:14:39.99',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2545707486',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2562804791',
                        IFOUTERRORS      => '7309',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Do1',
                        IFDESCR          => 'Dot11Radio1',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:18:75:a5:27:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1620) 0:00:16.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Gi0',
                        IFDESCR          => 'GigabitEthernet0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:93:4c:93:a1:b5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1559) 0:00:15.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1203274941',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2425186262',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Do0.7',
                        IFDESCR          => 'Dot11Radio0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:18:75:c2:67:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(767607999) 88 days, 20:14:39.99',
                        IFINOCTETS       => '1696380185',
                        IFOUTOCTETS      => '3114577963',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Do0.18',
                        IFDESCR          => 'Dot11Radio0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:18:75:c2:67:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(767607999) 88 days, 20:14:39.99',
                        IFINOCTETS       => '154557539',
                        IFOUTOCTETS      => '2680413485',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Do0.40',
                        IFDESCR          => 'Dot11Radio0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:18:75:c2:67:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(767607999) 88 days, 20:14:39.99',
                        IFINOCTETS       => '116190244',
                        IFOUTOCTETS      => '2076205012',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Gi0.7',
                        IFDESCR          => 'GigabitEthernet0.7',
                        IFALIAS          => 'eduspot',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:93:4c:93:a1:b5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1527) 0:00:15.27',
                        IFINOCTETS       => '1679633303',
                        IFOUTOCTETS      => '1704767676',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Gi0.18',
                        IFDESCR          => 'GigabitEthernet0.18',
                        IFALIAS          => 'eduroam',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:93:4c:93:a1:b5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1531) 0:00:15.31',
                        IFINOCTETS       => '2795453458',
                        IFOUTOCTETS      => '154132236',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Gi0.40',
                        IFDESCR          => 'GigabitEthernet0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:93:4c:93:a1:b5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1531) 0:00:15.31',
                        IFINOCTETS       => '2883284913',
                        IFOUTOCTETS      => '111865705',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'BV1',
                        IFDESCR          => 'BVI1',
                        IFTYPE           => '209',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        IP               => '192.168.55.82',
                        MAC              => 'a4:93:4c:93:a1:b5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1634) 0:00:16.34',
                        IFINOCTETS       => '607347610',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '419789539',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C1130.1.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(10b)JA3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2008 by Cisco Systems, Inc.
Compiled Wed 19-Mar-08 18:08 by prod_rel_team',
            SNMPHOSTNAME => 'ap-CP6-BU-161.wifi-mngt.dauphine.fr',
            MAC          => '00:00:00:00:00:00',
            MODEL        => 'Aironet 1130 series',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(10b)JA3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2008 by Cisco Systems, Inc.
Compiled Wed 19-Mar-08 18:08 by prod_rel_team',
            SNMPHOSTNAME => 'ap-CP6-BU-161.wifi-mngt.dauphine.fr',
            MAC          => '00:13:5f:fa:f2:50',
            MODELSNMP    => 'Networking2176',
            MODEL        => 'Aironet 1130 series',
            FIRMWARE     => undef,
            SERIAL       => 'FCZ0930Q00Z',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Aironet 1130 series',
                COMMENTS     => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(10b)JA3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2008 by Cisco Systems, Inc.
Compiled Wed 19-Mar-08 18:08 by prod_rel_team',
                NAME         => 'ap-CP6-BU-161.wifi-mngt.dauphine.fr',
                SERIAL       => 'FCZ0930Q00Z',
                FIRMWARE     => 'CW_VERSION$12.4(10b)JA3$',
                MAC          => '00:13:5f:fa:f2:50',
                CPU          => '97',
                RAM          => '23',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFDESCR          => 'Dot11Radio0',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f2:50',
                        IFLASTCHANGE     => '(7701) 0:01:17.01',
                        IFINOCTETS       => '2723745631',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2002017105',
                        IFOUTERRORS      => '91561',
                    },
                    {
                        IFNUMBER         => '2',
                        IFDESCR          => 'Dot11Radio1',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f2:30',
                        IFLASTCHANGE     => '(1204) 0:00:12.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFDESCR          => 'FastEthernet0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b1:ce',
                        IFLASTCHANGE     => '(1142) 0:00:11.42',
                        IFINOCTETS       => '1922539881',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3697487330',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFDESCR          => 'Dot11Radio0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f2:50',
                        IFLASTCHANGE     => '(7607) 0:01:16.07',
                        IFINOCTETS       => '2687372679',
                        IFOUTOCTETS      => '1195595259',
                    },
                    {
                        IFNUMBER         => '6',
                        IFDESCR          => 'Dot11Radio0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f2:50',
                        IFLASTCHANGE     => '(7607) 0:01:16.07',
                        IFINOCTETS       => '23434868',
                        IFOUTOCTETS      => '822989071',
                    },
                    {
                        IFNUMBER         => '7',
                        IFDESCR          => 'Dot11Radio0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f2:50',
                        IFLASTCHANGE     => '(7607) 0:01:16.07',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '540',
                    },
                    {
                        IFNUMBER         => '8',
                        IFDESCR          => 'Dot11Radio1.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f2:30',
                        IFLASTCHANGE     => '(1096) 0:00:10.96',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFDESCR          => 'FastEthernet0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b1:ce',
                        IFLASTCHANGE     => '(1107) 0:00:11.07',
                        IFINOCTETS       => '3495668832',
                        IFOUTOCTETS      => '2702597576',
                    },
                    {
                        IFNUMBER         => '10',
                        IFDESCR          => 'FastEthernet0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b1:ce',
                        IFLASTCHANGE     => '(1108) 0:00:11.08',
                        IFINOCTETS       => '843457950',
                        IFOUTOCTETS      => '23050498',
                    },
                    {
                        IFNUMBER         => '11',
                        IFDESCR          => 'FastEthernet0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b1:ce',
                        IFLASTCHANGE     => '(1109) 0:00:11.09',
                        IFINOCTETS       => '1016603638',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFDESCR          => 'BVI1',
                        IFTYPE           => '209',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b1:ce',
                        IFLASTCHANGE     => '(1210) 0:00:12.10',
                        IFINOCTETS       => '410354460',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '10537521',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C1130.2.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(10b)JA3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2008 by Cisco Systems, Inc.
Compiled Wed 19-Mar-08 18:08 by prod_rel_team',
            SNMPHOSTNAME => 'ap-P405-45.wifi-mngt.dauphine.fr',
            MAC          => '00:00:00:00:00:00',
            MODEL        => 'Aironet 1130 series',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(10b)JA3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2008 by Cisco Systems, Inc.
Compiled Wed 19-Mar-08 18:08 by prod_rel_team',
            SNMPHOSTNAME => 'ap-P405-45.wifi-mngt.dauphine.fr',
            MAC          => '00:13:5f:fa:fa:50',
            MODELSNMP    => 'Networking2176',
            MODEL        => 'Aironet 1130 series',
            FIRMWARE     => undef,
            SERIAL       => 'FCZ0930Q01A',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Aironet 1130 series',
                COMMENTS     => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(10b)JA3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2008 by Cisco Systems, Inc.
Compiled Wed 19-Mar-08 18:08 by prod_rel_team',
                NAME         => 'ap-P405-45.wifi-mngt.dauphine.fr',
                SERIAL       => 'FCZ0930Q01A',
                FIRMWARE     => 'CW_VERSION$12.4(10b)JA3$',
                IPS          => {
                    IP => [
                        '192.168.55.45',
                    ],
                },
                MAC          => '00:13:5f:fa:fa:50',
                UPTIME       => '(34865419) 4 days, 0:50:54.19',
                CPU          => '98',
                RAM          => '23',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Do0',
                        IFDESCR          => 'Dot11Radio0',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:fa:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7532) 0:01:15.32',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1847463852',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '782166020',
                        IFOUTERRORS      => '86765',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Do1',
                        IFDESCR          => 'Dot11Radio1',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:fa:30',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1198) 0:00:11.98',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0',
                        IFDESCR          => 'FastEthernet0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1136) 0:00:11.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3855516427',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2786837221',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Do0.7',
                        IFDESCR          => 'Dot11Radio0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:fa:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7438) 0:01:14.38',
                        IFINOCTETS       => '1833237924',
                        IFOUTOCTETS      => '3508924423',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Do0.18',
                        IFDESCR          => 'Dot11Radio0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:fa:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7438) 0:01:14.38',
                        IFINOCTETS       => '396827',
                        IFOUTOCTETS      => '694399025',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Do0.40',
                        IFDESCR          => 'Dot11Radio0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:fa:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7438) 0:01:14.38',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '6940608',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Do1.40',
                        IFDESCR          => 'Dot11Radio1.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:fa:30',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1089) 0:00:10.89',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0.7',
                        IFDESCR          => 'FastEthernet0.7',
                        IFALIAS          => 'eduspot',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1100) 0:00:11.00',
                        IFINOCTETS       => '1143594822',
                        IFOUTOCTETS      => '1841662240',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0.18',
                        IFDESCR          => 'FastEthernet0.18',
                        IFALIAS          => 'eduroam',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1102) 0:00:11.02',
                        IFINOCTETS       => '714789539',
                        IFOUTOCTETS      => '306665',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0.40',
                        IFDESCR          => 'FastEthernet0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1103) 0:00:11.03',
                        IFINOCTETS       => '970211324',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'BV1',
                        IFDESCR          => 'BVI1',
                        IFTYPE           => '209',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        IP               => '192.168.55.45',
                        MAC              => '00:14:6a:d6:b2:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1204) 0:00:12.04',
                        IFINOCTETS       => '411852720',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8408247',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C1130.3.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(21a)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Wed 16-Sep-09 18:36 by prod_rel_team',
            SNMPHOSTNAME => 'ap-D416-141.wifi-mngt.dauphine.fr',
            MAC          => '00:00:00:00:00:00',
            MODEL        => 'Aironet 1130 series',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(21a)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Wed 16-Sep-09 18:36 by prod_rel_team',
            SNMPHOSTNAME => 'ap-D416-141.wifi-mngt.dauphine.fr',
            MAC          => '00:13:5f:fa:f9:a0',
            MODELSNMP    => 'Networking2191',
            MODEL        => 'Aironet 1130 series',
            FIRMWARE     => undef,
            SERIAL       => 'FCZ0930Q01N',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Aironet 1130 series',
                COMMENTS     => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(21a)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Wed 16-Sep-09 18:36 by prod_rel_team',
                NAME         => 'ap-D416-141.wifi-mngt.dauphine.fr',
                SERIAL       => 'FCZ0930Q01N',
                FIRMWARE     => 'CW_VERSION$12.4(21a)JA1$',
                IPS          => {
                    IP => [
                        '192.168.55.141',
                    ],
                },
                MAC          => '00:13:5f:fa:f9:a0',
                UPTIME       => '(131654419) 15 days, 5:42:24.19',
                CPU          => '97',
                RAM          => '23',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Do0',
                        IFDESCR          => 'Dot11Radio0',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1986250540',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4034040569',
                        IFOUTERRORS      => '15496',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Do1',
                        IFDESCR          => 'Dot11Radio1',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f9:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1388) 0:00:13.88',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0',
                        IFDESCR          => 'FastEthernet0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1333) 0:00:13.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3182552204',
                        IFINERRORS       => '1817884',
                        IFOUTOCTETS      => '2589712033',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0b:5f:cc:d8:80',
                                    '00:16:76:cf:94:62',
                                    '00:20:a6:49:7e:fb',
                                    '00:26:b6:15:20:23',
                                    '00:26:08:f9:3d:c4',
                                    '68:a8:6d:51:65:da',
                                    '7c:d1:c3:f4:e7:89',
                                    '10:9a:dd:a5:32:33',
                                    'bc:52:b7:38:91:13',
                                    'e0:b9:ba:af:ad:4f',
                                    'e0:f8:47:34:4c:b4',
                                    'e0:06:e6:96:d4:a1',
                                    'e8:06:88:57:6d:7d',
                                    '18:a9:05:e3:0c:f5',
                                    'fc:25:3f:7b:7d:f6',
                                    '28:6a:ba:59:82:44',
                                    '34:15:9e:94:10:71',
                                    '40:6c:8f:1d:c0:7f',
                                    '4c:0f:6e:d5:3c:02',
                                    '54:04:a6:96:01:e1',
                                    '5c:96:9d:76:78:9d',
                                    '5c:ac:4c:1a:0f:00',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Do0.7',
                        IFDESCR          => 'Dot11Radio0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '1525293600',
                        IFOUTOCTETS      => '902858571',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Do0.18',
                        IFDESCR          => 'Dot11Radio0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '8650226',
                        IFOUTOCTETS      => '827133541',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Do0.40',
                        IFDESCR          => 'Dot11Radio0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '46832680',
                        IFOUTOCTETS      => '39829396',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Do1.40',
                        IFDESCR          => 'Dot11Radio1.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f9:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1288) 0:00:12.88',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0.7',
                        IFDESCR          => 'FastEthernet0.7',
                        IFALIAS          => 'eduspot',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1298) 0:00:12.98',
                        IFINOCTETS       => '3827474904',
                        IFOUTOCTETS      => '1534007354',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0.18',
                        IFDESCR          => 'FastEthernet0.18',
                        IFALIAS          => 'eduroam',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1299) 0:00:12.99',
                        IFINOCTETS       => '871447532',
                        IFOUTOCTETS      => '8082038',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0.40',
                        IFDESCR          => 'FastEthernet0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFINOCTETS       => '1834903826',
                        IFOUTOCTETS      => '46294714',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'BV1',
                        IFDESCR          => 'BVI1',
                        IFTYPE           => '209',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        IP               => '192.168.55.141',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1402) 0:00:14.02',
                        IFINOCTETS       => '476038021',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '22916493',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C1130.4.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(21a)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Wed 16-Sep-09 18:36 by prod_rel_team',
            SNMPHOSTNAME => 'ap-D416-141.wifi-mngt.dauphine.fr',
            MAC          => '00:00:00:00:00:00',
            MODEL        => 'Aironet 1130 series',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(21a)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Wed 16-Sep-09 18:36 by prod_rel_team',
            SNMPHOSTNAME => 'ap-D416-141.wifi-mngt.dauphine.fr',
            MAC          => '00:13:5f:fa:f9:a0',
            MODELSNMP    => 'Networking2191',
            MODEL        => 'Aironet 1130 series',
            FIRMWARE     => undef,
            SERIAL       => 'FCZ0930Q01N',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Aironet 1130 series',
                COMMENTS     => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(21a)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Wed 16-Sep-09 18:36 by prod_rel_team',
                NAME         => 'ap-D416-141.wifi-mngt.dauphine.fr',
                SERIAL       => 'FCZ0930Q01N',
                FIRMWARE     => 'CW_VERSION$12.4(21a)JA1$',
                IPS          => {
                    IP => [
                        '192.168.55.141',
                    ],
                },
                MAC          => '00:13:5f:fa:f9:a0',
                UPTIME       => '(131936738) 15 days, 6:29:27.38',
                CPU          => '98',
                RAM          => '23',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Do0',
                        IFDESCR          => 'Dot11Radio0',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2008650512',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4262978259',
                        IFOUTERRORS      => '15567',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Do1',
                        IFDESCR          => 'Dot11Radio1',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f9:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1388) 0:00:13.88',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0',
                        IFDESCR          => 'FastEthernet0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1333) 0:00:13.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3482914011',
                        IFINERRORS       => '1817884',
                        IFOUTOCTETS      => '2611425256',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0b:5f:cc:d8:80',
                                    '00:16:76:cf:94:62',
                                    '00:20:a6:49:7e:fb',
                                    '00:26:b6:15:20:23',
                                    '00:26:08:f9:3d:c4',
                                    '68:a8:6d:51:65:da',
                                    '7c:d1:c3:f4:e7:89',
                                    '10:9a:dd:a5:32:33',
                                    'bc:52:b7:38:91:13',
                                    'e0:b9:ba:af:ad:4f',
                                    'e0:f8:47:34:4c:b4',
                                    'e0:06:e6:96:d4:a1',
                                    'e8:06:88:57:6d:7d',
                                    '18:a9:05:e3:0c:f5',
                                    'fc:25:3f:7b:7d:f6',
                                    '28:6a:ba:59:82:44',
                                    '34:15:9e:94:10:71',
                                    '40:6c:8f:1d:c0:7f',
                                    '4c:0f:6e:d5:3c:02',
                                    '54:04:a6:96:01:e1',
                                    '5c:96:9d:76:78:9d',
                                    '5c:ac:4c:1a:0f:00',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Do0.7',
                        IFDESCR          => 'Dot11Radio0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '1545983180',
                        IFOUTOCTETS      => '1194767553',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Do0.18',
                        IFDESCR          => 'Dot11Radio0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '8650226',
                        IFOUTOCTETS      => '828451237',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Do0.40',
                        IFDESCR          => 'Dot11Radio0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '46832680',
                        IFOUTOCTETS      => '39829396',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Do1.40',
                        IFDESCR          => 'Dot11Radio1.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f9:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1288) 0:00:12.88',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0.7',
                        IFDESCR          => 'FastEthernet0.7',
                        IFALIAS          => 'eduspot',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1298) 0:00:12.98',
                        IFINOCTETS       => '4128177048',
                        IFOUTOCTETS      => '1554773976',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0.18',
                        IFDESCR          => 'FastEthernet0.18',
                        IFALIAS          => 'eduroam',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1299) 0:00:12.99',
                        IFINOCTETS       => '872932219',
                        IFOUTOCTETS      => '8082038',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0.40',
                        IFDESCR          => 'FastEthernet0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFINOCTETS       => '1835337081',
                        IFOUTOCTETS      => '46294714',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'BV1',
                        IFDESCR          => 'BVI1',
                        IFTYPE           => '209',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        IP               => '192.168.55.141',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1402) 0:00:14.02',
                        IFINOCTETS       => '476739635',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '23738876',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2924.1.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco Internetwork Operating System Software 
IOS (tm) C2900XL Software (C2900XL-C3H2S-M), Version 12.0(5)WC17, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2007 by cisco Systems, Inc.
Compiled Tue 13-Feb-07 15:27 by antonino',
            MAC          => '00:01:96:38:57:40',
            MODEL        => 'Catalyst 2924 XLv',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco Internetwork Operating System Software 
IOS (tm) C2900XL Software (C2900XL-C3H2S-M), Version 12.0(5)WC17, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2007 by cisco Systems, Inc.
Compiled Tue 13-Feb-07 15:27 by antonino',
            MAC          => '00:01:96:38:57:40',
            MODELSNMP    => 'Networking1921',
            MODEL        => 'Catalyst 2924 XLv',
            FIRMWARE     => undef,
            SERIAL       => 'FAB0411S1FB',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2924 XLv',
                COMMENTS     => 'Cisco Internetwork Operating System Software 
IOS (tm) C2900XL Software (C2900XL-C3H2S-M), Version 12.0(5)WC17, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2007 by cisco Systems, Inc.
Compiled Tue 13-Feb-07 15:27 by antonino',
                CONTACT      => 'Service Informatique',
                SERIAL       => 'FAB0411S1FB',
                MAC          => '00:01:96:38:57:40',
                UPTIME       => '(284153455) 32 days, 21:18:54.55',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3560) 0:00:35.60',
                        IFINOCTETS       => '2068559518',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '239046073',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:41',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3768) 0:00:37.68',
                        IFINOCTETS       => '4145041811',
                        IFINERRORS       => '287',
                        IFOUTOCTETS      => '2773240205',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1b:21:2c:75:79',
                                    '00:1b:21:2c:75:7d',
                                    '00:1b:21:2c:76:65',
                                    '00:1b:21:2c:76:61',
                                    '00:1e:f7:0d:8f:c5',
                                    'c4:64:13:11:31:81',
                                    'c4:64:13:11:31:60',
                                    'c4:64:13:2b:f2:25',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:42',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4316) 0:00:43.16',
                        IFINOCTETS       => '313882495',
                        IFINERRORS       => '670',
                        IFOUTOCTETS      => '3165765220',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:43',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(278322224) 32 days, 5:07:02.24',
                        IFINOCTETS       => '82051036',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2297881053',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:44',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(280583541) 32 days, 11:23:55.41',
                        IFINOCTETS       => '2615405',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '769622527',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:45',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1156003) 3:12:40.03',
                        IFINOCTETS       => '337662308',
                        IFINERRORS       => '635',
                        IFOUTOCTETS      => '3188808108',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFALIAS          => '\"PC Badge doublon\\',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:46',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(278469857) 32 days, 5:31:38.57',
                        IFINOCTETS       => '69655815',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1528986873',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:47',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3083) 0:00:30.83',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:48',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3113) 0:00:31.13',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:49',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(283443490) 32 days, 19:20:34.90',
                        IFINOCTETS       => '757175979',
                        IFINERRORS       => '7',
                        IFOUTOCTETS      => '3427157577',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(283444792) 32 days, 19:20:47.92',
                        IFINOCTETS       => '268866403',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2095387873',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(283442119) 32 days, 19:20:21.19',
                        IFINOCTETS       => '911545598',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1184611073',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(282306267) 32 days, 16:11:02.67',
                        IFINOCTETS       => '2634719610',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3752721734',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFALIAS          => 'J142A-Amphi',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(279224229) 32 days, 7:37:22.29',
                        IFINOCTETS       => '2492870',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '85878063',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3297) 0:00:32.97',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFALIAS          => 'F13-J11B',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(277924858) 32 days, 4:00:48.58',
                        IFINOCTETS       => '41476203',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '568386769',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(102521827) 11 days, 20:46:58.27',
                        IFINOCTETS       => '399066298',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2515430057',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:51',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3390) 0:00:33.90',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:52',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3419) 0:00:34.19',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:53',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(120755527) 13 days, 23:25:55.27',
                        IFINOCTETS       => '13226590',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2768247810',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFALIAS          => 'F113-J095A',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:54',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3481) 0:00:34.81',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:55',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3513) 0:00:35.13',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:56',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3557) 0:00:35.57',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:57',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3571) 0:00:35.71',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:58',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3922) 0:00:39.22',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2594458902',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '0',
                        MAC              => '00:01:96:38:57:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                    },
                ]
            },
        }
    ],
    'cisco/C2951.1.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco Internetwork Operating System Software 
IOS (tm) C2950 Software (C2950-I6K2L2Q4-M), Version 12.1(22)EA13, RELEASE SOFTWARE (fc2)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by cisco Systems, Inc.
Compiled Fri 27-F',
            MAC          => '00:0c:30:50:bb:c0',
            MODEL        => 'Catalyst 2950-24',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco Internetwork Operating System Software 
IOS (tm) C2950 Software (C2950-I6K2L2Q4-M), Version 12.1(22)EA13, RELEASE SOFTWARE (fc2)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by cisco Systems, Inc.
Compiled Fri 27-F',
            MAC          => '00:0c:30:50:bb:c0',
            MODELSNMP    => 'Networking1876',
            MODEL        => 'Catalyst 2950-24',
            FIRMWARE     => undef,
            SERIAL       => 'FOC0707Y03C',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2950-24',
                COMMENTS     => 'Cisco Internetwork Operating System Software 
IOS (tm) C2950 Software (C2950-I6K2L2Q4-M), Version 12.1(22)EA13, RELEASE SOFTWARE (fc2)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by cisco Systems, Inc.
Compiled Fri 27-F',
                CONTACT      => 'Service Informatique',
                LOCATION     => 'Recherche1-loctecN',
                SERIAL       => 'FOC0707Y03C',
                MAC          => '00:0c:30:50:bb:c0',
                UPTIME       => '(308499405) 35 days, 16:56:34.05',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFALIAS          => 'C088A-R176',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303016795) 35 days, 1:42:47.95',
                        IFINOCTETS       => '60889216',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '651190139',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFALIAS          => 'C089A-R176',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2249) 0:00:22.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFALIAS          => 'C090A-R177',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303078788) 35 days, 1:53:07.88',
                        IFINOCTETS       => '179672391',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1131240344',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFALIAS          => 'C091A-R177',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303160160) 35 days, 2:06:41.60',
                        IFINOCTETS       => '109243242',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1359788681',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(304189272) 35 days, 4:58:12.72',
                        IFINOCTETS       => '292026344',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '62877405',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(258602564) 29 days, 22:20:25.64',
                        IFINOCTETS       => '2521214202',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2918189544',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFALIAS          => 'C094A-R179',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(301712259) 34 days, 22:05:22.59',
                        IFINOCTETS       => '481054008',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '184708223',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFALIAS          => 'C095A-R179',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(305717982) 35 days, 9:12:59.82',
                        IFINOCTETS       => '2825764704',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3441235419',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFALIAS          => 'C096A-R180-Imprimante',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(305648793) 35 days, 9:01:27.93',
                        IFINOCTETS       => '2292422171',
                        IFINERRORS       => '6',
                        IFOUTOCTETS      => '2489738042',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFALIAS          => 'C085B-R175',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:ca',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(274619951) 31 days, 18:49:59.51',
                        IFINOCTETS       => '28986718',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '293541492',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:cb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2250) 0:00:22.50',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFALIAS          => 'C087B-R175',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:cc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(302864335) 35 days, 1:17:23.35',
                        IFINOCTETS       => '557354284',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1221356798',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFALIAS          => 'C088B-R176',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:cd',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(308490907) 35 days, 16:55:09.07',
                        IFINOCTETS       => '52929160',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2426562181',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFALIAS          => 'C096B-R180-Imprimante',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:ce',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2250) 0:00:22.50',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFALIAS          => 'C097A-R180-Imprimante',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:cf',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2250) 0:00:22.50',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFALIAS          => 'C098A-R181-S.Heiden',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(251528055) 29 days, 2:41:20.55',
                        IFINOCTETS       => '563162',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1629466',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFALIAS          => 'C099A-R181-S.Heiden',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303537660) 35 days, 3:09:36.60',
                        IFINOCTETS       => '1792523887',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2064844937',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFALIAS          => 'C101A-R182-Jayez-L005151',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(301768979) 34 days, 22:14:49.79',
                        IFINOCTETS       => '32917425',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '95390358',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2251) 0:00:22.51',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFALIAS          => 'C030B-R194',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(215399437) 24 days, 22:19:54.37',
                        IFINOCTETS       => '1729564485',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1203073578',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2251) 0:00:22.51',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2251) 0:00:22.51',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFALIAS          => 'A8524-01L1-253',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2251) 0:00:22.51',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFALIAS          => 'C2950-01L1-105',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3980) 0:00:39.80',
                        IFINOCTETS       => '3672798189',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2215441865',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:01:96:33:58:57',
                                    '00:1b:21:2c:75:79',
                                    '00:1b:21:2c:75:7d',
                                    '00:1b:21:2c:76:65',
                                    '00:1b:21:2c:76:61',
                                    'c4:64:13:11:31:60',
                                    'c4:64:13:2b:f2:25',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2290) 0:00:22.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => 'Vl615',
                        IFDESCR          => 'Vlan615',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2870) 0:00:28.70',
                        IFINOCTETS       => '526252508',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3161575802',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.01.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
            SNMPHOSTNAME => 'CB-27.example.com',
            MAC          => '00:24:13:ea:a7:00',
            MODEL        => 'Catalyst 2960-24TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
            SNMPHOSTNAME => 'CB-27.example.com',
            MAC          => '00:24:13:ea:a7:00',
            MODELSNMP    => 'Networking2177',
            MODEL        => 'Catalyst 2960-24TC',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1247X5DX',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-24TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
                NAME         => 'CB-27.example.com',
                SERIAL       => 'FOC1247X5DX',
                IPS          => {
                    IP => [
                        '192.168.1.27',
                    ],
                },
                MAC          => '00:24:13:ea:a7:00',
                UPTIME       => '(329794199) 38 days, 4:05:41.99',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFALIAS          => 'MNGT',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.27',
                        MAC              => '00:24:13:ea:a7:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4607) 0:00:46.07',
                        IFINOCTETS       => '1955878377',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2756311186',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFALIAS          => 'pixin-int1-inside',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(35962354) 4 days, 3:53:43.54',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '3059673658',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2957789612',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:02',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFALIAS          => 'MEDIA9-vers-CBI4061',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(45145198) 5 days, 5:24:11.98',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '106446611',
                        IFINERRORS       => '41',
                        IFOUTOCTETS      => '6780515',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:04',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFALIAS          => 'PIX-int0-outside-i',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3688819692) 426 days, 22:43:16.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '55117404',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1951371841',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:07',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(45289939) 5 days, 5:48:19.39',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '779472584',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '137886525',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:08',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:09',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(449117911) 51 days, 23:32:59.11',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3564203230',
                        IFINERRORS       => '86328',
                        IFOUTOCTETS      => '2567343375',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFALIAS          => 'Snort',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4259630157) 493 days, 0:18:21.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4193136023',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '274037618',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:07:e9:06:a6:be',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFALIAS          => 'Juniper-mgt',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(711110280) 82 days, 7:18:22.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2204612361',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1967389962',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:21:59:92:fb:7f',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFALIAS          => 'VPN-ASA-outside',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3688824604) 426 days, 22:44:06.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3669484140',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3228371931',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFALIAS          => 'VPN-ASA-inside',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:11',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3688836292) 426 days, 22:46:02.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1619195842',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1395113604',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:12',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:13',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:14',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:15',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:16',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:17',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFALIAS          => 'codec regie video pr CB1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:18',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(180206948) 20 days, 20:34:29.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '62439235',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '929961356',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFALIAS          => 'vers 3550',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:19',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(310281198) 35 days, 21:53:31.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1780492746',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3781185060',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0a:b8:92:56:40',
                                    '00:64:40:a6:58:c0',
                                    '00:64:40:a7:82:c0',
                                    '00:0b:fd:94:09:80',
                                    '00:0b:fd:9b:52:00',
                                    '00:0b:fd:ae:54:40',
                                    '00:0b:fd:15:ba:40',
                                    '00:0b:fd:15:bb:c0',
                                    '00:0b:5f:cc:d8:80',
                                    '00:0b:5f:cc:d8:8c',
                                    '00:0d:65:9e:18:40',
                                    '00:0d:bc:bd:66:c0',
                                    '00:0d:bd:92:3b:00',
                                    '00:0d:bd:92:4b:80',
                                    '00:0f:8f:47:91:c0',
                                    '00:d0:95:17:51:a3',
                                    '00:d0:95:3e:96:80',
                                    '00:d0:95:3e:96:83',
                                    '00:18:b9:92:08:40',
                                    '00:18:b9:b0:74:40',
                                    '00:18:b9:cc:27:c0',
                                    '00:18:b9:e3:75:c0',
                                    '00:18:b9:e3:7a:c0',
                                    '00:18:b9:e3:7e:40',
                                    '00:18:b9:e3:7f:40',
                                    '00:18:b9:e3:8e:40',
                                    '00:18:b9:e3:90:c0',
                                    '00:18:b9:e3:4d:40',
                                    '00:1a:6d:6c:f6:40',
                                    '00:1a:6d:b7:b8:40',
                                    '00:1a:6d:4f:6f:c0',
                                    '00:1a:6d:4f:74:c0',
                                    '00:1b:53:fd:d5:c0',
                                    '00:1b:54:d6:39:40',
                                    '00:1b:54:d6:3d:c0',
                                    '00:1b:54:db:6c:40',
                                    '00:1b:54:db:ec:c0',
                                    '00:1b:54:07:3c:c0',
                                    '00:1d:71:7c:77:c0',
                                    '00:21:59:94:bc:3f',
                                    '00:23:ab:dd:5d:c0',
                                    '00:24:13:a4:92:40',
                                    '00:24:13:ce:7d:40',
                                    '00:24:13:ce:d7:40',
                                    '00:24:50:06:4e:40',
                                    '00:04:dd:f9:93:00',
                                    '00:09:43:ec:d8:c0',
                                    '00:09:43:08:ea:c0',
                                    '00:09:43:09:04:00',
                                    '00:09:43:09:04:18',
                                    '00:09:43:09:08:40',
                                    '64:87:88:b0:79:41',
                                    '64:87:88:b0:7d:81',
                                    '64:87:88:b0:39:c1',
                                    '64:87:88:b0:3a:81',
                                    '64:87:88:b0:44:81',
                                    '64:87:88:b0:45:41',
                                    '6c:50:4d:f1:f7:40',
                                    '78:fe:3d:d4:b0:00',
                                    '78:fe:3d:d5:0e:ff',
                                    '78:fe:3d:df:1c:81',
                                    '78:fe:3d:df:20:01',
                                    '78:fe:3d:df:20:c1',
                                    '78:fe:3d:37:a8:c0',
                                    '78:fe:3d:37:5e:c0',
                                    'a8:d0:e5:b2:a0:c1',
                                    'a8:d0:e5:b2:ad:01',
                                    'a8:d0:e5:b2:ae:81',
                                    'a8:d0:e5:b2:be:41',
                                    'b4:a4:e3:eb:01:c0',
                                    'b4:14:89:32:00:40',
                                    'b4:14:89:38:19:c0',
                                    'b4:14:89:38:1d:40',
                                    'b4:14:89:38:22:40',
                                    'b4:14:89:38:28:c0',
                                    'b4:14:89:38:35:c0',
                                    'b4:14:89:38:38:40',
                                    'b4:14:89:38:3b:c0',
                                    'b8:ac:6f:94:57:ed',
                                    'b8:be:bf:af:f7:c0',
                                    'c4:0a:cb:ba:6d:c0',
                                    'c4:0a:cb:ba:6e:c0',
                                    'c4:0a:cb:cd:83:40',
                                    'c4:0a:cb:cd:86:40',
                                    'c4:0a:cb:cd:88:40',
                                    'c4:0a:cb:cd:8b:c0',
                                    'e8:e7:32:27:23:5f',
                                    'e8:e7:32:27:31:02',
                                    'e8:e7:32:27:38:30',
                                    'e8:e7:32:27:63:a0',
                                    'e8:e7:32:27:63:f4',
                                    'e8:e7:32:2a:e0:9e',
                                    'e8:e7:32:2a:e0:b6',
                                    'e8:e7:32:2a:e8:a4',
                                    'e8:e7:32:2a:e8:bc',
                                    'e8:e7:32:2b:c1:e2',
                                    'e8:e7:32:2b:c1:fb',
                                    'e8:e7:32:2b:cc:e7',
                                    'e8:e7:32:4b:78:f8',
                                    'e8:e7:32:4b:79:13',
                                    'e8:e7:32:4b:7b:b4',
                                    'e8:e7:32:4b:86:db',
                                    'e8:e7:32:4b:8a:cc',
                                    'e8:e7:32:4b:9b:d8',
                                    'e8:e7:32:5c:be:d3',
                                    'e8:04:62:1e:a3:c0',
                                    'e8:40:40:09:6a:40',
                                    'f4:7f:35:8a:2c:40',
                                    'f8:c0:01:c7:85:01',
                                    '2c:36:f8:7d:06:c0',
                                    '40:f4:ec:d6:80:40',
                                    '58:bc:27:78:54:40',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFALIAS          => 'LX250',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:1a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4259602380) 493 days, 0:13:43.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1622468503',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2698146544',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:19:d1:92:0c:4c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.02.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
            SNMPHOSTNAME => 'AP-P101-59.example.com',
            MAC          => '00:24:13:ce:d7:00',
            MODEL        => 'Catalyst 2960-24TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
            SNMPHOSTNAME => 'AP-P101-59.example.com',
            MAC          => '00:24:13:ce:d7:00',
            MODELSNMP    => 'Networking2177',
            MODEL        => 'Catalyst 2960-24TC',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1247X5D4',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-24TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
                NAME         => 'AP-P101-59.example.com',
                SERIAL       => 'FOC1247X5D4',
                MAC          => '00:24:13:ce:d7:00',
                CPU          => '81',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:40',
                        IFLASTCHANGE     => '(448584218) 51 days, 22:04:02.18',
                        IFINOCTETS       => '1969699486',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1143740170',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:01',
                        IFLASTCHANGE     => '(1666698681) 192 days, 21:43:06.81',
                        IFINOCTETS       => '160360322',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2520427958',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10002',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:02',
                        IFLASTCHANGE     => '(1288669773) 149 days, 3:38:17.73',
                        IFINOCTETS       => '1354978920',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1444296343',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10003',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:03',
                        IFLASTCHANGE     => '(1667811201) 193 days, 0:48:32.01',
                        IFINOCTETS       => '1418474807',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3697736928',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10004',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:04',
                        IFLASTCHANGE     => '(361575212) 41 days, 20:22:32.12',
                        IFINOCTETS       => '972898572',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2874278107',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10005',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:05',
                        IFLASTCHANGE     => '(361564184) 41 days, 20:20:41.84',
                        IFINOCTETS       => '842225921',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2097721511',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10006',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:06',
                        IFLASTCHANGE     => '(1460643496) 169 days, 1:20:34.96',
                        IFINOCTETS       => '612658',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '7517632',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10007',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:07',
                        IFLASTCHANGE     => '(1545691195) 178 days, 21:35:11.95',
                        IFINOCTETS       => '860540279',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '356275802',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10008',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:08',
                        IFLASTCHANGE     => '(1669007485) 193 days, 4:07:54.85',
                        IFINOCTETS       => '59734207',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1849411001',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10009',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:09',
                        IFLASTCHANGE     => '(1599428965) 185 days, 2:51:29.65',
                        IFINOCTETS       => '2469094479',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4060044107',
                        IFOUTERRORS      => '5',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10010',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0a',
                        IFLASTCHANGE     => '(1399544874) 161 days, 23:37:28.74',
                        IFINOCTETS       => '102950896',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '650135037',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10011',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0b',
                        IFLASTCHANGE     => '(4167) 0:00:41.67',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10012',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0c',
                        IFLASTCHANGE     => '(1666029375) 192 days, 19:51:33.75',
                        IFINOCTETS       => '43235636',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '680136759',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10013',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0d',
                        IFLASTCHANGE     => '(1286978674) 148 days, 22:56:26.74',
                        IFINOCTETS       => '239329601',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '828899275',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10014',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0e',
                        IFLASTCHANGE     => '(1668531324) 193 days, 2:48:33.24',
                        IFINOCTETS       => '330810944',
                        IFINERRORS       => '16887',
                        IFOUTOCTETS      => '1855427971',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10015',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0f',
                        IFLASTCHANGE     => '(1667075555) 192 days, 22:45:55.55',
                        IFINOCTETS       => '107079056',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1133282038',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10016',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:10',
                        IFLASTCHANGE     => '(1332165044) 154 days, 4:27:30.44',
                        IFINOCTETS       => '75627900',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '857357031',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10017',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:11',
                        IFLASTCHANGE     => '(1399546606) 161 days, 23:37:46.06',
                        IFINOCTETS       => '1569285360',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '209932792',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10018',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:12',
                        IFLASTCHANGE     => '(1659597753) 192 days, 1:59:37.53',
                        IFINOCTETS       => '62683816',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1032329852',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10019',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:13',
                        IFLASTCHANGE     => '(1660563317) 192 days, 4:40:33.17',
                        IFINOCTETS       => '148292480',
                        IFINERRORS       => '252',
                        IFOUTOCTETS      => '1865203761',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10020',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:14',
                        IFLASTCHANGE     => '(1286973610) 148 days, 22:55:36.10',
                        IFINOCTETS       => '1414423',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '37991943',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10021',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:15',
                        IFLASTCHANGE     => '(1666644488) 192 days, 21:34:04.88',
                        IFINOCTETS       => '470135831',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2845209002',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10022',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:16',
                        IFLASTCHANGE     => '(1539355445) 178 days, 3:59:14.45',
                        IFINOCTETS       => '383001306',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2428516158',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10023',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:17',
                        IFLASTCHANGE     => '(4168) 0:00:41.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10024',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:18',
                        IFLASTCHANGE     => '(4168) 0:00:41.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10101',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:19',
                        IFLASTCHANGE     => '(4168) 0:00:41.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:1a',
                        IFLASTCHANGE     => '(448584503) 51 days, 22:04:05.03',
                        IFINOCTETS       => '3449371397',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2995445287',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/5',
                                SYSNAME  => 'AP-Switch-51.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.51',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.03.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
            SNMPHOSTNAME => 'CP-P101-37.example.com',
            MAC          => '00:1b:54:d6:39:00',
            MODEL        => 'Catalyst 2960-24TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
            SNMPHOSTNAME => 'CP-P101-37.example.com',
            MAC          => '00:1b:54:d6:39:00',
            MODELSNMP    => 'Networking2177',
            MODEL        => 'Catalyst 2960-24TC',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1113X1PE',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-24TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
                NAME         => 'CP-P101-37.example.com',
                SERIAL       => 'FOC1113X1PE',
                MAC          => '00:1b:54:d6:39:00',
                CPU          => '89',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:40',
                        IFLASTCHANGE     => '(4584) 0:00:45.84',
                        IFINOCTETS       => '2030921664',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '951088659',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:01',
                        IFLASTCHANGE     => '(1657748225) 191 days, 20:51:22.25',
                        IFINOCTETS       => '369925658',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '926844080',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10002',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:02',
                        IFLASTCHANGE     => '(4140) 0:00:41.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10003',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:03',
                        IFLASTCHANGE     => '(1641428469) 189 days, 23:31:24.69',
                        IFINOCTETS       => '393092436',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3227489290',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10004',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:04',
                        IFLASTCHANGE     => '(4140) 0:00:41.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10005',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:05',
                        IFLASTCHANGE     => '(1668711130) 193 days, 3:18:31.30',
                        IFINOCTETS       => '521485508',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2052899224',
                        IFOUTERRORS      => '73',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10006',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:06',
                        IFLASTCHANGE     => '(4140) 0:00:41.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10007',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:07',
                        IFLASTCHANGE     => '(1149060288) 132 days, 23:50:02.88',
                        IFINOCTETS       => '152710057',
                        IFINERRORS       => '34',
                        IFOUTOCTETS      => '2698203912',
                        IFOUTERRORS      => '297',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10008',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:08',
                        IFLASTCHANGE     => '(1608943026) 186 days, 5:17:10.26',
                        IFINOCTETS       => '188163118',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1553262039',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10009',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:09',
                        IFLASTCHANGE     => '(1669071909) 193 days, 4:18:39.09',
                        IFINOCTETS       => '2609670352',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '3992264533',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10010',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0a',
                        IFLASTCHANGE     => '(1651098591) 191 days, 2:23:05.91',
                        IFINOCTETS       => '49267770',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '654794463',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10011',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0b',
                        IFLASTCHANGE     => '(1512173256) 175 days, 0:28:52.56',
                        IFINOCTETS       => '257576986',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4219065024',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10012',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0c',
                        IFLASTCHANGE     => '(1512143171) 175 days, 0:23:51.71',
                        IFINOCTETS       => '36205380',
                        IFINERRORS       => '613',
                        IFOUTOCTETS      => '347903192',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10013',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0d',
                        IFLASTCHANGE     => '(1634598779) 189 days, 4:33:07.79',
                        IFINOCTETS       => '208833434',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '191680982',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10014',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0e',
                        IFLASTCHANGE     => '(4141) 0:00:41.41',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10015',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0f',
                        IFLASTCHANGE     => '(1668167389) 193 days, 1:47:53.89',
                        IFINOCTETS       => '212801623',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2383669184',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10016',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:10',
                        IFLASTCHANGE     => '(1399398381) 161 days, 23:13:03.81',
                        IFINOCTETS       => '5589',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '631494',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10017',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:11',
                        IFLASTCHANGE     => '(1667752600) 193 days, 0:38:46.00',
                        IFINOCTETS       => '1638043019',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '469166891',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10018',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:12',
                        IFLASTCHANGE     => '(4141) 0:00:41.41',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10019',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:13',
                        IFLASTCHANGE     => '(1660466187) 192 days, 4:24:21.87',
                        IFINOCTETS       => '884179267',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3400637521',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10020',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:14',
                        IFLASTCHANGE     => '(1668286829) 193 days, 2:07:48.29',
                        IFINOCTETS       => '359416168',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '756432620',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10021',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:15',
                        IFLASTCHANGE     => '(4142) 0:00:41.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10022',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:16',
                        IFLASTCHANGE     => '(1546204896) 178 days, 23:00:48.96',
                        IFINOCTETS       => '204828',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2733536359',
                        IFOUTERRORS      => '2257',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10023',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:17',
                        IFLASTCHANGE     => '(4142) 0:00:41.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10024',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:18',
                        IFLASTCHANGE     => '(182404430) 21 days, 2:40:44.30',
                        IFINOCTETS       => '2724805151',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3155157885',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '64:87:88:b0:45:41',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10101',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:19',
                        IFLASTCHANGE     => '(16491) 0:02:44.91',
                        IFINOCTETS       => '3914931489',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2654463940',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'f8:c0:01:c7:85:01',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10102',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:1a',
                        IFLASTCHANGE     => '(1366004940) 158 days, 2:27:29.40',
                        IFINOCTETS       => '2925623154',
                        IFINERRORS       => '6',
                        IFOUTOCTETS      => '2183974366',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/4',
                                SYSNAME  => 'CP-Switch-101.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.101',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.04.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(50)SE1, RELEASE SOFTWARE (fc2)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Mon 06-Apr-09 08:36 by amvarma',
            MAC          => '00:1a:6d:9d:23:00',
            MODEL        => 'Catalyst 2960-48TT',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(50)SE1, RELEASE SOFTWARE (fc2)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Mon 06-Apr-09 08:36 by amvarma',
            MAC          => '00:1a:6d:9d:23:00',
            MODELSNMP    => 'Networking1956',
            MODEL        => 'Catalyst 2960-48TT',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1049Z7RN',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TT',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(50)SE1, RELEASE SOFTWARE (fc2)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Mon 06-Apr-09 08:36 by amvarma',
                LOCATION     => 'Recherche1-loctecN',
                SERIAL       => 'FOC1049Z7RN',
                MAC          => '00:1a:6d:9d:23:00',
                UPTIME       => '(308478285) 35 days, 16:53:02.85',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:40',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(4144) 0:00:41.44',
                        IFINOCTETS       => '3516',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '615',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:41',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7886) 0:01:18.86',
                        IFINOCTETS       => '2251471785',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '286127141',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFALIAS          => 'C046A-R131',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:01',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(274486595) 31 days, 18:27:45.95',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '8377',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8039',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFALIAS          => 'C047A-R131',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:02',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4356) 0:00:43.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFALIAS          => 'C057B-R161',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4356) 0:00:43.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFALIAS          => 'C043B-R133',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:04',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4356) 0:00:43.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFALIAS          => 'C048B-R157 F.Lupu-Dell-Scale 00:08:74:1e:46:7b',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:05',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:07',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:08',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:09',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(249372923) 28 days, 20:42:09.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1054580',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3806443766',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(299914444) 34 days, 17:05:44.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2096941',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '977213699',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(179157864) 20 days, 17:39:38.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3931513',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2396979049',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8574) 0:01:25.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2366114',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2005431730',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFALIAS          => 'C057A-R161 B.Pateyron 00:03:93:ac:33:48',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(268534034) 31 days, 1:55:40.34',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '381991911',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1003764265',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(302884951) 35 days, 1:20:49.51',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '79575793',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '651793413',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFALIAS          => 'C059A-M.Guezzah 00:11:43:a4:c8:5c',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(235757413) 27 days, 6:52:54.13',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '67899905',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '208408457',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFALIAS          => 'C060A-R163 Lafon',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:11',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4559) 0:00:45.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '394681957',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:12',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303482260) 35 days, 3:00:22.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2420463446',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1961681052',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:13',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:14',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303271002) 35 days, 2:25:10.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4021716383',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2269332039',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFALIAS          => 'C059B-R163 Mehdi Guezzah Serveur Win',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:15',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(302190971) 34 days, 23:25:09.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '211747976',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3802961593',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFALIAS          => 'C71B',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:16',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(276176642) 31 days, 23:09:26.42',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1509322',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '16797448',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFALIAS          => 'onduleur',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:17',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:18',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'Fa0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:19',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'Fa0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(301989661) 34 days, 22:51:36.61',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '9565924',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '116408328',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'Fa0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(245765225) 28 days, 10:40:52.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3452382522',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3680075113',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'Fa0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(207446855) 24 days, 0:14:28.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '51170836',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '934210769',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'Fa0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'Fa0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(179376296) 20 days, 18:16:02.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8805389',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '625009670',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'Fa0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(251422216) 29 days, 2:23:42.16',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '98215557',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '48570148',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'Fa0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:20',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4358) 0:00:43.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'Fa0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:21',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4358) 0:00:43.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'Fa0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:22',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303975821) 35 days, 4:22:38.21',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1406916349',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1184498155',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'Fa0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFALIAS          => 'conf_inter',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:23',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(296990528) 34 days, 8:58:25.28',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '4022754',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '341153770',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'Fa0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:24',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4358) 0:00:43.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'Fa0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:25',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(275058029) 31 days, 20:03:00.29',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '861396',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5073664',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'Fa0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:26',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(308468383) 35 days, 16:51:23.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '305488102',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3020738923',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'Fa0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:27',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4358) 0:00:43.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'Fa0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:28',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(257597766) 29 days, 19:32:57.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3485684785',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2816523712',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'Fa0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:29',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(301739265) 34 days, 22:09:52.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2106724549',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1169216285',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'Fa0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303457383) 35 days, 2:56:13.83',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '570676480',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1439884782',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'Fa0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(213879972) 24 days, 18:06:39.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12256557',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1641139230',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'Fa0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4359) 0:00:43.59',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'Fa0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4359) 0:00:43.59',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'Fa0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(259319200) 30 days, 0:19:52.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1748345',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1092855',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'Fa0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(267746706) 30 days, 23:44:27.06',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '15102369',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '785002890',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'Fa0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFALIAS          => 'D-h2610-poe-01L1-5026.Interface.26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:30',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4872) 0:00:48.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1892565339',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1906464200',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'b4:39:d6:49:5b:a6',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:31',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(14025619) 1 day, 14:57:36.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '174630655',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '839081165',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1b:21:2c:75:79',
                                    '00:1b:21:2c:75:7d',
                                    '00:1b:21:2c:76:65',
                                    '00:1b:21:2c:76:61',
                                    '00:1e:7a:f5:09:47',
                                    'c4:64:13:11:31:81',
                                    'c4:64:13:11:31:60',
                                    'c4:64:13:2b:f2:25',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:32',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4359) 0:00:43.59',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.08.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
            SNMPHOSTNAME => 'AP-74.example.com',
            MAC          => 'c4:0a:cb:cd:86:00',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
            SNMPHOSTNAME => 'AP-74.example.com',
            MAC          => 'c4:0a:cb:cd:86:00',
            MODELSNMP    => 'Networking2179',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1511W1A2',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
                NAME         => 'AP-74.example.com',
                MEMORY       => '4',
                SERIAL       => 'FOC1511W1A2',
                FIRMWARE     => '15.0(1)SE3',
                IPS          => {
                    IP => [
                        '192.168.1.74',
                    ],
                },
                MAC          => 'c4:0a:cb:cd:86:00',
                UPTIME       => '(347543457) 40 days, 5:23:54.57',
                CPU          => '83',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.74',
                        MAC              => 'c4:0a:cb:cd:86:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(33843) 0:05:38.43',
                        IFINOCTETS       => '1474264407',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '328275733',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFALIAS          => 'P513-AP-T-5018 ',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:01',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4122) 0:00:41.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:02',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346931458) 40 days, 3:41:54.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '236588628',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1309670942',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFALIAS          => 'AP-I-3013-P313b',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346733109) 40 days, 3:08:51.09',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '244400373',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2758132634',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:04',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347248129) 40 days, 4:34:41.29',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '306005406',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2237159677',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFALIAS          => 'AP-I-3016-P313b',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346709972) 40 days, 3:04:59.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '341205155',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4244518876',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:06',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(299032702) 34 days, 14:38:47.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '103424675',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1103108996',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:07',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347364747) 40 days, 4:54:07.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '384186304',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '680410947',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFALIAS          => 'P503-AP-I-5023',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:08',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(304905559) 35 days, 6:57:35.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1711110227',
                        IFOUTERRORS      => '5306391',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFALIAS          => 'AP-I-3023-P305TER',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:09',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4122) 0:00:41.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFALIAS          => 'AP-I-xxxx-P316',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(199152305) 23 days, 1:12:03.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '352167261',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '472288711',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4122) 0:00:41.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFALIAS          => 'AP-I-xxxx-P316',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(292879038) 33 days, 21:33:10.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '947341952',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3871739267',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4122) 0:00:41.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFALIAS          => 'P316g-P316',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347014191) 40 days, 3:55:41.91',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '310298783',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3190072208',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:11',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:12',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFALIAS          => 'AP-318B',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:13',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347064484) 40 days, 4:04:04.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '257298363',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '462767851',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFALIAS          => 'AP-I-4012',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:14',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(344231637) 39 days, 20:11:56.37',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '485150014',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2831486943',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFALIAS          => 'AP-318B',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:15',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(19407) 0:03:14.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '80068166',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3115275205',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:16',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFALIAS          => 'AP-318g',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:17',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(345462929) 39 days, 23:37:09.29',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '214483908',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1039775044',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:18',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'Fa0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFALIAS          => 'P412 AB-I-4009',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:19',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347389474) 40 days, 4:58:14.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '197928734',
                        IFINERRORS       => '10114',
                        IFOUTOCTETS      => '2278558878',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'Fa0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFALIAS          => 'P033 API-0024',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'Fa0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFALIAS          => 'AP-I-4011',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(17566) 0:02:55.66',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '660664840',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '189899557',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'Fa0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFALIAS          => 'AP-I-4118-A402',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346865571) 40 days, 3:30:55.71',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '533303751',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1170216684',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'Fa0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346295021) 40 days, 1:55:50.21',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '182135404',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1274821872',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'Fa0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFALIAS          => 'P031 API-0027',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'Fa0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(16871) 0:02:48.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '29059300',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '633177844',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'Fa0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFALIAS          => 'AP-I-4104',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:20',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(223291471) 25 days, 20:15:14.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '214096311',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '4206248334',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'Fa0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFALIAS          => 'AP-I-4037-P406BIS',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:21',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(320907355) 37 days, 3:24:33.55',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '95132469',
                        IFINERRORS       => '2369',
                        IFOUTOCTETS      => '587991352',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'Fa0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:22',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347143890) 40 days, 4:17:18.90',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '489015270',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1209925409',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'Fa0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFALIAS          => 'IRIS-CREDEP',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:23',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'Fa0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFALIAS          => 'AP-I-4116',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:24',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347141430) 40 days, 4:16:54.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '432349066',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '427746098',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'Fa0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFALIAS          => 'IRIS-CREDEP',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:25',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'Fa0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFALIAS          => 'AP-I-4115 A406',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:26',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(50167) 0:08:21.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '273611216',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3366833064',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'Fa0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFALIAS          => 'IRIS-CREDEP',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:27',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(311161429) 36 days, 0:20:14.29',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '50812277',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '523659377',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'Fa0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:28',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'Fa0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:29',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'Fa0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(48708) 0:08:07.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '510737178',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3327711715',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'Fa0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'Fa0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(46296) 0:07:42.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '614324126',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1211817539',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'Fa0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'Fa0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFALIAS          => 'IRIS-CREDEP',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'Fa0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'Fa0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:30',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:31',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:32',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(33930) 0:05:39.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2071109510',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '275105132',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/1',
                                SYSNAME  => 'AP-Switch-51.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.51',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.09.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
            SNMPHOSTNAME => 'CB-C005-208.Dauphine',
            MAC          => '64:d9:89:8d:b1:80',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
            SNMPHOSTNAME => 'CB-C005-208.Dauphine',
            MAC          => '64:d9:89:8d:b1:80',
            MODELSNMP    => 'Networking2179',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1511W19F',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
                NAME         => 'CB-C005-208.Dauphine',
                MEMORY       => '5',
                SERIAL       => 'FOC1511W19F',
                FIRMWARE     => '15.0(1)SE3',
                MAC          => '64:d9:89:8d:b1:80',
                CPU          => '89',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:c0',
                        IFLASTCHANGE     => '(595775969) 68 days, 22:55:59.69',
                        IFINOCTETS       => '2847919715',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2431876662',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:81',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10002',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:82',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10003',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:83',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10004',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:84',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10005',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:85',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10006',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:86',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10007',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:87',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10008',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:88',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10009',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:89',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10010',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8a',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10011',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8b',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10012',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8c',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10013',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8d',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10014',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8e',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10015',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8f',
                        IFLASTCHANGE     => '(1629636421) 188 days, 14:46:04.21',
                        IFINOCTETS       => '158358580',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '2542256749',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10016',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:90',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10017',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:91',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10018',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:92',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10019',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:93',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10020',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:94',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10021',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:95',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10022',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:96',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10023',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:97',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10024',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:98',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10025',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:99',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10026',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9a',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10027',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9b',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10028',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9c',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10029',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9d',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10030',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9e',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10031',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9f',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10032',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a0',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10033',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a1',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10034',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a2',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10035',
                        IFDESCR          => 'FastEthernet0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a3',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10036',
                        IFDESCR          => 'FastEthernet0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a4',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10037',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a5',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10038',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a6',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10039',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a7',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10040',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a8',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10041',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a9',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10042',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:aa',
                        IFLASTCHANGE     => '(4256) 0:00:42.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10043',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:ab',
                        IFLASTCHANGE     => '(4256) 0:00:42.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10044',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:ac',
                        IFLASTCHANGE     => '(4256) 0:00:42.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10045',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:ad',
                        IFLASTCHANGE     => '(4256) 0:00:42.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10046',
                        IFDESCR          => 'FastEthernet0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:ae',
                        IFLASTCHANGE     => '(4256) 0:00:42.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10047',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:af',
                        IFLASTCHANGE     => '(4256) 0:00:42.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10048',
                        IFDESCR          => 'FastEthernet0/48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:b0',
                        IFLASTCHANGE     => '(4256) 0:00:42.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10101',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:b1',
                        IFLASTCHANGE     => '(595776056) 68 days, 22:56:00.56',
                        IFINOCTETS       => '627337006',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2755039325',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet1/0/23',
                                SYSNAME  => 'CB-C005-202.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960S Software (C2960S-UNIVERSALK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)',
                                IP       => '192.168.1.202',
                                MODEL    => 'cisco WS-C2960S-24TD-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10102',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:b2',
                        IFLASTCHANGE     => '(4256) 0:00:42.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10501',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.10.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
            SNMPHOSTNAME => 'CB-C005-206.Dauphine',
            MAC          => '2c:36:f8:7d:09:00',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
            SNMPHOSTNAME => 'CB-C005-206.Dauphine',
            MAC          => '2c:36:f8:7d:09:00',
            MODELSNMP    => 'Networking2179',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => 'FCQ1605X4UZ',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
                NAME         => 'CB-C005-206.Dauphine',
                MEMORY       => '4',
                SERIAL       => 'FCQ1605X4UZ',
                FIRMWARE     => '15.0(1)SE3',
                MAC          => '2c:36:f8:7d:09:00',
                CPU          => '80',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:40',
                        IFLASTCHANGE     => '(596600541) 69 days, 1:13:25.41',
                        IFINOCTETS       => '2876037603',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2448955914',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:01',
                        IFLASTCHANGE     => '(4230) 0:00:42.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10002',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:02',
                        IFLASTCHANGE     => '(4230) 0:00:42.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10003',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:03',
                        IFLASTCHANGE     => '(4230) 0:00:42.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10004',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:04',
                        IFLASTCHANGE     => '(4230) 0:00:42.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10005',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:05',
                        IFLASTCHANGE     => '(4230) 0:00:42.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10006',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:06',
                        IFLASTCHANGE     => '(4230) 0:00:42.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10007',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:07',
                        IFLASTCHANGE     => '(4230) 0:00:42.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10008',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:08',
                        IFLASTCHANGE     => '(4230) 0:00:42.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10009',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:09',
                        IFLASTCHANGE     => '(4230) 0:00:42.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10010',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:0a',
                        IFLASTCHANGE     => '(4230) 0:00:42.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10011',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:0b',
                        IFLASTCHANGE     => '(4230) 0:00:42.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10012',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:0c',
                        IFLASTCHANGE     => '(4231) 0:00:42.31',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10013',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:0d',
                        IFLASTCHANGE     => '(4231) 0:00:42.31',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10014',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:0e',
                        IFLASTCHANGE     => '(1623443346) 187 days, 21:33:53.46',
                        IFINOCTETS       => '13649415',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '144458186',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10015',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:0f',
                        IFLASTCHANGE     => '(4231) 0:00:42.31',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10016',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:10',
                        IFLASTCHANGE     => '(4231) 0:00:42.31',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10017',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:11',
                        IFLASTCHANGE     => '(1626503610) 188 days, 6:03:56.10',
                        IFINOCTETS       => '1619463572',
                        IFINERRORS       => '6301',
                        IFOUTOCTETS      => '977154644',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10018',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:12',
                        IFLASTCHANGE     => '(4231) 0:00:42.31',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10019',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:13',
                        IFLASTCHANGE     => '(1633323510) 189 days, 1:00:35.10',
                        IFINOCTETS       => '2525677665',
                        IFINERRORS       => '3',
                        IFOUTOCTETS      => '3438774464',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10020',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:14',
                        IFLASTCHANGE     => '(1633441760) 189 days, 1:20:17.60',
                        IFINOCTETS       => '2557592156',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '36851033',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10021',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:15',
                        IFLASTCHANGE     => '(4231) 0:00:42.31',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10022',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:16',
                        IFLASTCHANGE     => '(4231) 0:00:42.31',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10023',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:17',
                        IFLASTCHANGE     => '(4231) 0:00:42.31',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10024',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:18',
                        IFLASTCHANGE     => '(4231) 0:00:42.31',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10025',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:19',
                        IFLASTCHANGE     => '(1600000985) 185 days, 4:26:49.85',
                        IFINOCTETS       => '193179946',
                        IFINERRORS       => '6',
                        IFOUTOCTETS      => '1349888727',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10026',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:1a',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10027',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:1b',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10028',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:1c',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10029',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:1d',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10030',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:1e',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10031',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:1f',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10032',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:20',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10033',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:21',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10034',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:22',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10035',
                        IFDESCR          => 'FastEthernet0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:23',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10036',
                        IFDESCR          => 'FastEthernet0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:24',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10037',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:25',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10038',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:26',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10039',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:27',
                        IFLASTCHANGE     => '(1632988529) 189 days, 0:04:45.29',
                        IFINOCTETS       => '2100830282',
                        IFINERRORS       => '13004',
                        IFOUTOCTETS      => '2691288013',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10040',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:28',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10041',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:29',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10042',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:2a',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10043',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:2b',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10044',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:2c',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10045',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:2d',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10046',
                        IFDESCR          => 'FastEthernet0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:2e',
                        IFLASTCHANGE     => '(1622956857) 187 days, 20:12:48.57',
                        IFINOCTETS       => '1500391',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '157324648',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10047',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:2f',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10048',
                        IFDESCR          => 'FastEthernet0/48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:30',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10101',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:31',
                        IFLASTCHANGE     => '(596600629) 69 days, 1:13:26.29',
                        IFINOCTETS       => '1720265539',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2490856586',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet1/0/22',
                                SYSNAME  => 'CB-C005-202.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960S Software (C2960S-UNIVERSALK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)',
                                IP       => '192.168.1.202',
                                MODEL    => 'cisco WS-C2960S-24TD-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10102',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:09:32',
                        IFLASTCHANGE     => '(4232) 0:00:42.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10501',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.11.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
            SNMPHOSTNAME => 'CB-C005-207.Dauphine',
            MAC          => '2c:36:f8:7d:06:80',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
            SNMPHOSTNAME => 'CB-C005-207.Dauphine',
            MAC          => '2c:36:f8:7d:06:80',
            MODELSNMP    => 'Networking2179',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => 'FCQ1605X4VP',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
                NAME         => 'CB-C005-207.Dauphine',
                MEMORY       => '4',
                SERIAL       => 'FCQ1605X4VP',
                FIRMWARE     => '15.0(1)SE3',
                MAC          => '2c:36:f8:7d:06:80',
                CPU          => '92',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:c0',
                        IFLASTCHANGE     => '(595957433) 68 days, 23:26:14.33',
                        IFINOCTETS       => '2446137012',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2022849692',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:81',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10002',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:82',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10003',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:83',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10004',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:84',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10005',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:85',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10006',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:86',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10007',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:87',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10008',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:88',
                        IFLASTCHANGE     => '(1615911411) 187 days, 0:38:34.11',
                        IFINOCTETS       => '4162799898',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2434568578',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10009',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:89',
                        IFLASTCHANGE     => '(1615374157) 186 days, 23:09:01.57',
                        IFINOCTETS       => '50514456',
                        IFINERRORS       => '45',
                        IFOUTOCTETS      => '3168236376',
                        IFOUTERRORS      => '148',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10010',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:8a',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10011',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:8b',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10012',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:8c',
                        IFLASTCHANGE     => '(1623513609) 187 days, 21:45:36.09',
                        IFINOCTETS       => '171288465',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2095312613',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10013',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:8d',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10014',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:8e',
                        IFLASTCHANGE     => '(1486671356) 172 days, 1:38:33.56',
                        IFINOCTETS       => '279026381',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3945616377',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10015',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:8f',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10016',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:90',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10017',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:91',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10018',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:92',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10019',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:93',
                        IFLASTCHANGE     => '(1631466876) 188 days, 19:51:08.76',
                        IFINOCTETS       => '1354428366',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2678286274',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10020',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:94',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10021',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:95',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10022',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:96',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10023',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:97',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10024',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:98',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10025',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:99',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10026',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:9a',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10027',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:9b',
                        IFLASTCHANGE     => '(1324013317) 153 days, 5:48:53.17',
                        IFINOCTETS       => '1354391915',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1640684234',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10028',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:9c',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10029',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:9d',
                        IFLASTCHANGE     => '(419610) 1:09:56.10',
                        IFINOCTETS       => '1535589407',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2548890840',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10030',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:9e',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10031',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:9f',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10032',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:a0',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10033',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:a1',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10034',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:a2',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10035',
                        IFDESCR          => 'FastEthernet0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:a3',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10036',
                        IFDESCR          => 'FastEthernet0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:a4',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10037',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:a5',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10038',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:a6',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10039',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:a7',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10040',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:a8',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10041',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:a9',
                        IFLASTCHANGE     => '(4126) 0:00:41.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10042',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:aa',
                        IFLASTCHANGE     => '(4126) 0:00:41.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10043',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:ab',
                        IFLASTCHANGE     => '(4126) 0:00:41.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10044',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:ac',
                        IFLASTCHANGE     => '(4126) 0:00:41.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10045',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:ad',
                        IFLASTCHANGE     => '(4126) 0:00:41.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10046',
                        IFDESCR          => 'FastEthernet0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:ae',
                        IFLASTCHANGE     => '(4126) 0:00:41.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10047',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:af',
                        IFLASTCHANGE     => '(4126) 0:00:41.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10048',
                        IFDESCR          => 'FastEthernet0/48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:b0',
                        IFLASTCHANGE     => '(4126) 0:00:41.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10101',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:b1',
                        IFLASTCHANGE     => '(595957522) 68 days, 23:26:15.22',
                        IFINOCTETS       => '3690690104',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3489062289',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet1/0/21',
                                SYSNAME  => 'CB-C005-202.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960S Software (C2960S-UNIVERSALK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)',
                                IP       => '192.168.1.202',
                                MODEL    => 'cisco WS-C2960S-24TD-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10102',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:36:f8:7d:06:b2',
                        IFLASTCHANGE     => '(4126) 0:00:41.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10501',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.12.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
            SNMPHOSTNAME => 'CB-C005-205.Dauphine',
            MAC          => 'c4:0a:cb:22:e5:80',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
            SNMPHOSTNAME => 'CB-C005-205.Dauphine',
            MAC          => 'c4:0a:cb:22:e5:80',
            MODELSNMP    => 'Networking2179',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1511W1CB',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
                NAME         => 'CB-C005-205.Dauphine',
                MEMORY       => '4',
                SERIAL       => 'FOC1511W1CB',
                FIRMWARE     => '15.0(1)SE3',
                MAC          => 'c4:0a:cb:22:e5:80',
                CPU          => '79',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:c0',
                        IFLASTCHANGE     => '(596609075) 69 days, 1:14:50.75',
                        IFINOCTETS       => '2871212296',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2443338754',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:81',
                        IFLASTCHANGE     => '(4058) 0:00:40.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10002',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:82',
                        IFLASTCHANGE     => '(4058) 0:00:40.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10003',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:83',
                        IFLASTCHANGE     => '(4058) 0:00:40.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10004',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:84',
                        IFLASTCHANGE     => '(4058) 0:00:40.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10005',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:85',
                        IFLASTCHANGE     => '(4058) 0:00:40.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10006',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:86',
                        IFLASTCHANGE     => '(4058) 0:00:40.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10007',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:87',
                        IFLASTCHANGE     => '(4058) 0:00:40.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10008',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:88',
                        IFLASTCHANGE     => '(4058) 0:00:40.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10009',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:89',
                        IFLASTCHANGE     => '(4059) 0:00:40.59',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10010',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:8a',
                        IFLASTCHANGE     => '(4059) 0:00:40.59',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10011',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:8b',
                        IFLASTCHANGE     => '(4059) 0:00:40.59',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10012',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:8c',
                        IFLASTCHANGE     => '(4059) 0:00:40.59',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10013',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:8d',
                        IFLASTCHANGE     => '(4059) 0:00:40.59',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10014',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:8e',
                        IFLASTCHANGE     => '(1631510009) 188 days, 19:58:20.09',
                        IFINOCTETS       => '1544560270',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3483278393',
                        IFOUTERRORS      => '10994',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10015',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:8f',
                        IFLASTCHANGE     => '(4059) 0:00:40.59',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10016',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:90',
                        IFLASTCHANGE     => '(1634398586) 189 days, 3:59:45.86',
                        IFINOCTETS       => '2724601483',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2696552369',
                        IFOUTERRORS      => '10943',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10017',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:91',
                        IFLASTCHANGE     => '(4059) 0:00:40.59',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10018',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:92',
                        IFLASTCHANGE     => '(4059) 0:00:40.59',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10019',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:93',
                        IFLASTCHANGE     => '(4059) 0:00:40.59',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10020',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:94',
                        IFLASTCHANGE     => '(4059) 0:00:40.59',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10021',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:95',
                        IFLASTCHANGE     => '(4059) 0:00:40.59',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10022',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:96',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10023',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:97',
                        IFLASTCHANGE     => '(1630510233) 188 days, 17:11:42.33',
                        IFINOCTETS       => '174047329',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '916141211',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10024',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:98',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10025',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:99',
                        IFLASTCHANGE     => '(1630510161) 188 days, 17:11:41.61',
                        IFINOCTETS       => '171612321',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '993850547',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10026',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:9a',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10027',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:9b',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10028',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:9c',
                        IFLASTCHANGE     => '(1476276530) 170 days, 20:46:05.30',
                        IFINOCTETS       => '787254341',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1382513486',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10029',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:9d',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10030',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:9e',
                        IFLASTCHANGE     => '(1002540637) 116 days, 0:50:06.37',
                        IFINOCTETS       => '18309',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '28180240',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10031',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:9f',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10032',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:a0',
                        IFLASTCHANGE     => '(1002352522) 116 days, 0:18:45.22',
                        IFINOCTETS       => '1961',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1145076',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10033',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:a1',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10034',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:a2',
                        IFLASTCHANGE     => '(1630510297) 188 days, 17:11:42.97',
                        IFINOCTETS       => '184171260',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2034868762',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10035',
                        IFDESCR          => 'FastEthernet0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:a3',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10036',
                        IFDESCR          => 'FastEthernet0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:a4',
                        IFLASTCHANGE     => '(1002376442) 116 days, 0:22:44.42',
                        IFINOCTETS       => '6108',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '10636434',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10037',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:a5',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10038',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:a6',
                        IFLASTCHANGE     => '(1580441927) 182 days, 22:06:59.27',
                        IFINOCTETS       => '229049',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3882553',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10039',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:a7',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10040',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:a8',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10041',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:a9',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10042',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:aa',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10043',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:ab',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10044',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:ac',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10045',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:ad',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10046',
                        IFDESCR          => 'FastEthernet0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:ae',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10047',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:af',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10048',
                        IFDESCR          => 'FastEthernet0/48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:b0',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10101',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:b1',
                        IFLASTCHANGE     => '(596609163) 69 days, 1:14:51.63',
                        IFINOCTETS       => '1510685316',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4095281856',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet1/0/24',
                                SYSNAME  => 'CB-C005-202.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960S Software (C2960S-UNIVERSALK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)',
                                IP       => '192.168.1.202',
                                MODEL    => 'cisco WS-C2960S-24TD-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10102',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:22:e5:b2',
                        IFLASTCHANGE     => '(4061) 0:00:40.61',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10501',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.20.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANLITEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2010 by Cisco Systems, Inc.
Compiled Tue 28-Sep-10 13:44 by prod_rel_team',
            SNMPHOSTNAME => 'CP-lt-40.example.com',
            MAC          => '04:c5:a4:42:f2:80',
            MODEL        => 'Catalyst 2960-8TC-S',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANLITEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2010 by Cisco Systems, Inc.
Compiled Tue 28-Sep-10 13:44 by prod_rel_team',
            SNMPHOSTNAME => 'CP-lt-40.example.com',
            MAC          => '04:c5:a4:42:f2:80',
            MODELSNMP    => 'Networking2183',
            MODEL        => 'Catalyst 2960-8TC-S',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1508V4B5',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-8TC-S',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANLITEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2010 by Cisco Systems, Inc.
Compiled Tue 28-Sep-10 13:44 by prod_rel_team',
                NAME         => 'CP-lt-40.example.com',
                MEMORY       => '22',
                SERIAL       => 'FOC1508V4B5',
                FIRMWARE     => 'CW_VERSION$12.2(50)SE5$',
                IPS          => {
                    IP => [
                        '192.168.1.40',
                    ],
                },
                MAC          => '04:c5:a4:42:f2:80',
                UPTIME       => '(69260934) 8 days, 0:23:29.34',
                CPU          => '97',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFALIAS          => 'MNGT',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.40',
                        MAC              => '04:c5:a4:42:f2:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4584) 0:00:45.84',
                        IFINOCTETS       => '1908443810',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '21744655',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:81',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4688) 0:00:46.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1599380',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '61797424',
                        IFOUTERRORS      => '2330',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'INFRA_SRV',
                                    NUMBER => '56',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:82',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4688) 0:00:46.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '658797',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '61239968',
                        IFOUTERRORS      => '2330',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'INFRA_SRV',
                                    NUMBER => '56',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:83',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4387) 0:00:43.87',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'INFRA_SRV',
                                    NUMBER => '56',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:84',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4387) 0:00:43.87',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'INALCO',
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:85',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4387) 0:00:43.87',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'INALCO',
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:86',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4387) 0:00:43.87',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'INALCO',
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:87',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4387) 0:00:43.87',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'INALCO',
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFALIAS          => 'VERS CB-INTERUFR-219 192.168.1.219 !',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:88',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(60319687) 6 days, 23:33:16.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '22175511',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2242606023',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'default',
                                    NUMBER => '1',
                                }
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '78:fe:3d:d5:0e:ff',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:89',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4861) 0:00:48.61',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '235512242',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '47433441',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet0/1',
                                SYSNAME  => 'CP1-CRIC-116.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(25)SEE1, RELEASE SOFTWARE (fc1)',
                                IP       => '192.168.1.116',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.21.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANLITEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2010 by Cisco Systems, Inc.
Compiled Tue 28-Sep-10 13:44 by prod_rel_team',
            SNMPHOSTNAME => 'default-40.example.com',
            MAC          => '04:c5:a4:42:f2:80',
            MODEL        => 'Catalyst 2960-8TC-S',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANLITEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2010 by Cisco Systems, Inc.
Compiled Tue 28-Sep-10 13:44 by prod_rel_team',
            SNMPHOSTNAME => 'default-40.example.com',
            MAC          => '04:c5:a4:42:f2:80',
            MODELSNMP    => 'Networking2183',
            MODEL        => 'Catalyst 2960-8TC-S',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1508V4B5',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-8TC-S',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANLITEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2010 by Cisco Systems, Inc.
Compiled Tue 28-Sep-10 13:44 by prod_rel_team',
                NAME         => 'default-40.example.com',
                MEMORY       => '22',
                SERIAL       => 'FOC1508V4B5',
                FIRMWARE     => 'CW_VERSION$12.2(50)SE5$',
                MAC          => '04:c5:a4:42:f2:80',
                CPU          => '90',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:c0',
                        IFLASTCHANGE     => '(4765) 0:00:47.65',
                        IFINOCTETS       => '2211338520',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '439636656',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:81',
                        IFLASTCHANGE     => '(1699518194) 196 days, 16:53:01.94',
                        IFINOCTETS       => '77646872',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1451562620',
                        IFOUTERRORS      => '18',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'INFRA_SRV',
                                    NUMBER => '56',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:82',
                        IFLASTCHANGE     => '(4687) 0:00:46.87',
                        IFINOCTETS       => '48510643',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1448479479',
                        IFOUTERRORS      => '18',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'INFRA_SRV',
                                    NUMBER => '56',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:83',
                        IFLASTCHANGE     => '(4386) 0:00:43.86',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'INFRA_SRV',
                                    NUMBER => '56',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:84',
                        IFLASTCHANGE     => '(4386) 0:00:43.86',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'INALCO',
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:85',
                        IFLASTCHANGE     => '(4386) 0:00:43.86',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'INALCO',
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:86',
                        IFLASTCHANGE     => '(4386) 0:00:43.86',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'INALCO',
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:87',
                        IFLASTCHANGE     => '(4386) 0:00:43.86',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'INALCO',
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:88',
                        IFLASTCHANGE     => '(870221628) 100 days, 17:16:56.28',
                        IFINOCTETS       => '453028979',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2918695052',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'default',
                                    NUMBER => '1',
                                }
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '78:fe:3d:d5:0e:ff',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10101',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '04:c5:a4:42:f2:89',
                        IFLASTCHANGE     => '(4859) 0:00:48.59',
                        IFINOCTETS       => '2278713857',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1132732202',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet0/1',
                                SYSNAME  => 'CP1-CRIC-116.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(25)SEE1, RELEASE SOFTWARE (fc1)',
                                IP       => '192.168.1.116',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.22.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANLITEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2010 by Cisco Systems, Inc.
Compiled Tue 28-Sep-10 13:44 by prod_rel_team',
            SNMPHOSTNAME => 'Scol-tmp-65.example.com',
            MAC          => 'e8:40:40:aa:73:80',
            MODEL        => 'Catalyst 2960-8TC-S',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANLITEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2010 by Cisco Systems, Inc.
Compiled Tue 28-Sep-10 13:44 by prod_rel_team',
            SNMPHOSTNAME => 'Scol-tmp-65.example.com',
            MAC          => 'e8:40:40:aa:73:80',
            MODELSNMP    => 'Networking2183',
            MODEL        => 'Catalyst 2960-8TC-S',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1511W532',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-8TC-S',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANLITEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2010 by Cisco Systems, Inc.
Compiled Tue 28-Sep-10 13:44 by prod_rel_team',
                NAME         => 'Scol-tmp-65.example.com',
                MEMORY       => '22',
                SERIAL       => 'FOC1511W532',
                FIRMWARE     => 'CW_VERSION$12.2(50)SE5$',
                MAC          => 'e8:40:40:aa:73:80',
                CPU          => '90',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'e8:40:40:aa:73:c0',
                        IFLASTCHANGE     => '(4851) 0:00:48.51',
                        IFINOCTETS       => '255556080',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '74494857',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'e8:40:40:aa:73:81',
                        IFLASTCHANGE     => '(4449) 0:00:44.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'e8:40:40:aa:73:82',
                        IFLASTCHANGE     => '(4449) 0:00:44.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'e8:40:40:aa:73:83',
                        IFLASTCHANGE     => '(4449) 0:00:44.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'e8:40:40:aa:73:84',
                        IFLASTCHANGE     => '(4449) 0:00:44.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'e8:40:40:aa:73:85',
                        IFLASTCHANGE     => '(4449) 0:00:44.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'e8:40:40:aa:73:86',
                        IFLASTCHANGE     => '(4449) 0:00:44.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'e8:40:40:aa:73:87',
                        IFLASTCHANGE     => '(4449) 0:00:44.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'e8:40:40:aa:73:88',
                        IFLASTCHANGE     => '(4450) 0:00:44.50',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10101',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'e8:40:40:aa:73:89',
                        IFLASTCHANGE     => '(5140) 0:00:51.40',
                        IFINOCTETS       => '478357725',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '85760601',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/13',
                                SYSNAME  => 'AP-Switch-51.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.51',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.24.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANLITEK9-M), Version 12.2(50)SE4, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2010 by Cisco Systems, Inc.
Compiled Fri 26-Mar-10 09:14 by prod_rel_team',
            SNMPHOSTNAME => 'AB-A422-7.example.com',
            MAC          => '40:f4:ec:d6:80:00',
            MODEL        => 'Catalyst 2960-8TC-S',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANLITEK9-M), Version 12.2(50)SE4, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2010 by Cisco Systems, Inc.
Compiled Fri 26-Mar-10 09:14 by prod_rel_team',
            SNMPHOSTNAME => 'AB-A422-7.example.com',
            MAC          => '40:f4:ec:d6:80:00',
            MODELSNMP    => 'Networking2184',
            MODEL        => 'Catalyst 2960-8TC-S',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1501V1PS',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-8TC-S',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANLITEK9-M), Version 12.2(50)SE4, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2010 by Cisco Systems, Inc.
Compiled Fri 26-Mar-10 09:14 by prod_rel_team',
                NAME         => 'AB-A422-7.example.com',
                MEMORY       => '23',
                SERIAL       => 'FOC1501V1PS',
                FIRMWARE     => 'CW_VERSION$12.2(50)SE4$',
                IPS          => {
                    IP => [
                        '192.168.1.7',
                    ],
                },
                MAC          => '40:f4:ec:d6:80:00',
                UPTIME       => '(1513179720) 175 days, 3:16:37.20',
                CPU          => '92',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFALIAS          => 'MNGT',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.7',
                        MAC              => '40:f4:ec:d6:80:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(18565332) 2 days, 3:34:13.32',
                        IFINOCTETS       => '2590321551',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '745432723',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '40:f4:ec:d6:80:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1480962412) 171 days, 9:47:04.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '68126956',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1326656584',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'VLAN0005',
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFALIAS          => 'A424-INFO4.2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '40:f4:ec:d6:80:02',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'VLAN0007',
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFALIAS          => 'A424-INFO4.3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '40:f4:ec:d6:80:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'VLAN0007',
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '40:f4:ec:d6:80:04',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1481346896) 171 days, 10:51:08.96',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2547705402',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '2768496992',
                        IFOUTERRORS      => '3607',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'VLAN0007',
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '40:f4:ec:d6:80:05',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'VLAN0007',
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '40:f4:ec:d6:80:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'VLAN0007',
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '40:f4:ec:d6:80:07',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'VLAN0007',
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '40:f4:ec:d6:80:08',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'VLAN0007',
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '40:f4:ec:d6:80:09',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(18565530) 2 days, 3:34:15.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1388411911',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '3543298838',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/1',
                                SYSNAME  => 'AB-Switch-1.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.1',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.25.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'AP-72.example.com',
            MAC          => 'c4:0a:cb:e6:f0:00',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'AP-72.example.com',
            MAC          => 'c4:0a:cb:e6:f0:00',
            MODELSNMP    => 'Networking2416',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
                NAME         => 'AP-72.example.com',
                MEMORY       => '20',
                IPS          => {
                    IP => [
                        '192.168.1.72',
                    ],
                },
                UPTIME       => '(353824260) 40 days, 22:50:42.60',
                CPU          => '88',
                RAM          => '60',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vlan1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.72',
                        MAC              => 'c4:0a:cb:e6:f0:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(307811) 0:51:18.11',
                        IFINOCTETS       => '1610116325',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '352821127',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'FastEthernet0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:01',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4084) 0:00:40.84',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'FastEthernet0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:02',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4084) 0:00:40.84',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'FastEthernet0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:03',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(386721) 1:04:27.21',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '507105858',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '756332041',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'FastEthernet0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:04',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(379789) 1:03:17.89',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '153360360',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3117649181',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'FastEthernet0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(290882317) 33 days, 16:00:23.17',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '680518103',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2573011663',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'FastEthernet0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4084) 0:00:40.84',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'FastEthernet0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFALIAS          => 'AP-I-6023',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:07',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(388113) 1:04:41.13',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '671089899',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '504676058',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'FastEthernet0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:08',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(345475277) 39 days, 23:39:12.77',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '4087007195',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3060679302',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'FastEthernet0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFALIAS          => 'AP-I-6024',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:09',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(389128) 1:04:51.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2609224168',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3521084609',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'FastEthernet0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:0a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347978569) 40 days, 6:36:25.69',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '341404625',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3580016358',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'FastEthernet0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:0b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(320577812) 37 days, 2:29:38.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '132249879',
                        IFINERRORS       => '1515',
                        IFOUTOCTETS      => '2442375155',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'FastEthernet0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFALIAS          => 'AP-I-4014-P417',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:0c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(321923662) 37 days, 6:13:56.62',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1067415000',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '812503561',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'FastEthernet0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:0d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(390800) 1:05:08.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '359121911',
                        IFINERRORS       => '591',
                        IFOUTOCTETS      => '3433514988',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'FastEthernet0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:0e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(381013) 1:03:30.13',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '126151082',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2621084749',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'FastEthernet0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:0f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4086) 0:00:40.86',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'FastEthernet0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(353807472) 40 days, 22:47:54.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '166036634',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1799720061',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'FastEthernet0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:11',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(321857204) 37 days, 6:02:52.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1791573126',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '823572932',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'FastEthernet0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:12',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(353200430) 40 days, 21:06:44.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '254622153',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1058979164',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'FastEthernet0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:13',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(349772612) 40 days, 11:35:26.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '303169302',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2456540728',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'FastEthernet0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:14',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346052014) 40 days, 1:15:20.14',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '48582706',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '588495127',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'FastEthernet0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFALIAS          => 'Mme-Jomier',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:15',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(302480582) 35 days, 0:13:25.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '259332300',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '948041575',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'FastEthernet0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:16',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(190731649) 22 days, 1:48:36.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1796339792',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2377537428',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'FastEthernet0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:17',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4086) 0:00:40.86',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'FastEthernet0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:18',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(294316242) 34 days, 1:32:42.42',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '321715531',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2995462255',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'FastEthernet0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:19',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(392091) 1:05:20.91',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1139046158',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4061519092',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'FastEthernet0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:1a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(353733331) 40 days, 22:35:33.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '897599736',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '608813461',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'FastEthernet0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:1b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(391652) 1:05:16.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '363832282',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '84820619',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'FastEthernet0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFALIAS          => 'AP-I-6028-B620gaucheEsc',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:1c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4086) 0:00:40.86',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'FastEthernet0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:1d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4087) 0:00:40.87',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'FastEthernet0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:1e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(353647873) 40 days, 22:21:18.73',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '501327004',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '175667222',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'FastEthernet0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:1f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4087) 0:00:40.87',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'FastEthernet0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFALIAS          => 'AP-I-5006 P512',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:20',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4087) 0:00:40.87',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'FastEthernet0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:21',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(345958465) 40 days, 0:59:44.65',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '887485319',
                        IFINERRORS       => '3',
                        IFOUTOCTETS      => '2478842366',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'FastEthernet0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFALIAS          => 'AP-I-6029-P620milieu',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:22',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347817025) 40 days, 6:09:30.25',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '209395032',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '1498951827',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '33',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'FastEthernet0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:23',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4087) 0:00:40.87',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'FastEthernet0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFALIAS          => 'AP-I-6030-P620Milieu',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:24',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4088) 0:00:40.88',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '33',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'FastEthernet0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:25',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(389135) 1:04:51.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '761494658',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '495223509',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'FastEthernet0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:26',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4088) 0:00:40.88',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'FastEthernet0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:27',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(388603) 1:04:46.03',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '42789040',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2042259921',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'FastEthernet0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFALIAS          => 'A716-AB-I-7106',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:28',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(353495549) 40 days, 21:55:55.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '29303899',
                        IFINERRORS       => '79',
                        IFOUTOCTETS      => '955469137',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '33',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'FastEthernet0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:29',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4088) 0:00:40.88',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'FastEthernet0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:2a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(379955) 1:03:19.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '715670159',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3890588264',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'FastEthernet0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:2b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(225714255) 26 days, 2:59:02.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1838664412',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4125511793',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'FastEthernet0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFALIAS          => 'AP-I-6032-P620Droit',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:2c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4089) 0:00:40.89',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '33',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'FastEthernet0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFALIAS          => 'P620 API 6027 ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:2d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(387140) 1:04:31.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '305141295',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2806555706',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '33',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'FastEthernet0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:2e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4089) 0:00:40.89',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'FastEthernet0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFALIAS          => 'P404b-AP-I-4033',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:2f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(314220564) 36 days, 8:50:05.64',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '122607678',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1393992022',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'FastEthernet0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:30',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4089) 0:00:40.89',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'GigabitEthernet0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:31',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4089) 0:00:40.89',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'GigabitEthernet0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:f0:32',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(307810) 0:51:18.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2938291536',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3960287099',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/18',
                                SYSNAME  => 'AP-Switch-51.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.51',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Null0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.26.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'CB-243.example.com',
            MAC          => 'c4:0a:cb:e6:e8:80',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'CB-243.example.com',
            MAC          => 'c4:0a:cb:e6:e8:80',
            MODELSNMP    => 'Networking2416',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
                NAME         => 'CB-243.example.com',
                MEMORY       => '20',
                IPS          => {
                    IP => [
                        '192.168.1.243',
                    ],
                },
                UPTIME       => '(414811307) 48 days, 0:15:13.07',
                CPU          => '86',
                RAM          => '60',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vlan1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.243',
                        MAC              => 'c4:0a:cb:e6:e8:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(243112293) 28 days, 3:18:42.93',
                        IFINOCTETS       => '1637558866',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '384759087',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'FastEthernet0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:81',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4102) 0:00:41.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'FastEthernet0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:82',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(413689479) 47 days, 21:08:14.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '497158253',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1780428234',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'FastEthernet0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFALIAS          => 'CB-I-6010-B640',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:83',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(407759248) 47 days, 4:39:52.48',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1918969338',
                        IFINERRORS       => '83',
                        IFOUTOCTETS      => '1656161676',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '4',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'FastEthernet0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFALIAS          => 'CB-I-4011',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:84',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347322) 0:57:53.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1333512877',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '490902365',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'FastEthernet0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:85',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(348425) 0:58:04.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2254790327',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'FastEthernet0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:86',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79316261) 9 days, 4:19:22.61',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '336681994',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1735119533',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'FastEthernet0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:87',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(286399865) 33 days, 3:33:18.65',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '57958882',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2537069231',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'FastEthernet0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFALIAS          => 'CBI519A',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:88',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(64713) 0:10:47.13',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2472680676',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3964300497',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'FastEthernet0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFALIAS          => 'CB-I-6063',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:89',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(351505) 0:58:35.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2661465463',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1478400263',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'FastEthernet0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:8a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4103) 0:00:41.03',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'FastEthernet0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:8b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(373737489) 43 days, 6:09:34.89',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '70054628',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2971444489',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'FastEthernet0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:8c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(3972) 0:00:39.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'FastEthernet0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFALIAS          => 'CBI-001 B046',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:8d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(362636524) 41 days, 23:19:25.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '64724386',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3721224604',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'FastEthernet0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFALIAS          => 'CB-I-5051 Paie',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:8e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(73773) 0:12:17.73',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '519576010',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2843625112',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'FastEthernet0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFALIAS          => 'CBI-1045 D120',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:8f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(180357) 0:30:03.57',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '1183137033',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2152244965',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'FastEthernet0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFALIAS          => 'D516  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:90',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(76978) 0:12:49.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1764424540',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3949275897',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'FastEthernet0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:91',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(413488740) 47 days, 20:34:47.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1772331613',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4283714395',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'FastEthernet0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:92',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79221) 0:13:12.21',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '279675270',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '498238424',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'FastEthernet0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:93',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(383011347) 44 days, 7:55:13.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2474377606',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2431666154',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'FastEthernet0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:94',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4104) 0:00:41.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'FastEthernet0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:95',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(414329586) 47 days, 22:54:55.86',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2145039748',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3739481889',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'FastEthernet0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFALIAS          => 'CB-I-5052',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(413415234) 47 days, 20:22:32.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '910293590',
                        IFINERRORS       => '2253',
                        IFOUTOCTETS      => '2921028326',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'FastEthernet0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:97',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(414100489) 47 days, 22:16:44.89',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2569301891',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '3572352715',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'FastEthernet0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFALIAS          => 'CBI-1040 D116',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:98',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4105) 0:00:41.05',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'FastEthernet0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:99',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(180952) 0:30:09.52',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '295295371',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3467943347',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'FastEthernet0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:9a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(4032) 0:00:40.32',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'FastEthernet0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:9b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(414019181) 47 days, 22:03:11.81',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '42248817',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2990042834',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'FastEthernet0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:9c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4105) 0:00:41.05',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'FastEthernet0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:9d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(408542162) 47 days, 6:50:21.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '603870054',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2549513280',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'FastEthernet0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:9e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(413100958) 47 days, 19:30:09.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '864068577',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '132773280',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'FastEthernet0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFALIAS          => 'RJ4.17-ROCA8-REGIE',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:9f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4106) 0:00:41.06',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'FastEthernet0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4106) 0:00:41.06',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'FastEthernet0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:a1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(413521427) 47 days, 20:40:14.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3354112056',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '3851864674',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'FastEthernet0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:a2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4106) 0:00:41.06',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'FastEthernet0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:a3',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(137703129) 15 days, 22:30:31.29',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2267002087',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2603564766',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'FastEthernet0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFALIAS          => 'CIP-B421bis',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:a4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(284034613) 32 days, 20:59:06.13',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3816451795',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2653475890',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '34',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'FastEthernet0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:a5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4107) 0:00:41.07',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'FastEthernet0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:a6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(3894) 0:00:38.94',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'FastEthernet0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:a7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(175648) 0:29:16.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1822106652',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1032818239',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'FastEthernet0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:a8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(379363881) 43 days, 21:47:18.81',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '54822205',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3750350011',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'FastEthernet0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:a9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4107) 0:00:41.07',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'FastEthernet0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:aa',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4107) 0:00:41.07',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'FastEthernet0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFALIAS          => 'B320 - CBI 3002',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:ab',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4107) 0:00:41.07',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'FastEthernet0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:ac',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4107) 0:00:41.07',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'FastEthernet0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:ad',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(293128108) 33 days, 22:14:41.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '70248823',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4137997403',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'FastEthernet0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:ae',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(129384) 0:21:33.84',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1784',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '83984',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'FastEthernet0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:af',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(413634665) 47 days, 20:59:06.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '150380800',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4260968015',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '11',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'FastEthernet0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFALIAS          => 'CBI-1041 D116',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:b0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(379351616) 43 days, 21:45:16.16',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '10167456',
                        IFINERRORS       => '122',
                        IFOUTOCTETS      => '287093414',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'GigabitEthernet0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:b1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4107) 0:00:41.07',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'GigabitEthernet0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:e6:e8:b2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(243112293) 28 days, 3:18:42.93',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1205874919',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2065905086',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet1/0/6',
                                SYSNAME  => 'CB-LT-0-6.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960S Software (C2960S-UNIVERSALK9-M), Version 15.0(2)SE, RELEASE SOFTWARE (fc1)',
                                IP       => '10.20.0.6',
                                MODEL    => 'cisco WS-C2960S-24TD-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Null0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.27.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'AB-39.example.com',
            MAC          => 'c4:0a:cb:cd:83:00',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'AB-39.example.com',
            MAC          => 'c4:0a:cb:cd:83:00',
            MODELSNMP    => 'Networking2416',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
                NAME         => 'AB-39.example.com',
                MEMORY       => '20',
                IPS          => {
                    IP => [
                        '192.168.1.39',
                    ],
                },
                UPTIME       => '(399149124) 46 days, 4:44:51.24',
                CPU          => '86',
                RAM          => '60',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vlan1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.39',
                        MAC              => 'c4:0a:cb:cd:83:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(19601) 0:03:16.01',
                        IFINOCTETS       => '1646773241',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '329970936',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'FastEthernet0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFALIAS          => 'B611-AB-I-6063',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(398986512) 46 days, 4:17:45.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1077054481',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1088658557',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'FastEthernet0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:02',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(90068) 0:15:00.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '54313218',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3893544945',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'FastEthernet0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4094) 0:00:40.94',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'FastEthernet0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:04',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(339058773) 39 days, 5:49:47.73',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3179834',
                        IFINERRORS       => '11792',
                        IFOUTOCTETS      => '163540851',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'FastEthernet0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFALIAS          => 'B613-AB-I-6059',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:05',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(373402199) 43 days, 5:13:41.99',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1442348',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '158749402',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '55',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'FastEthernet0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFALIAS          => 'B602b-AB-I-6004',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4095) 0:00:40.95',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'FastEthernet0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:07',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(274983991) 31 days, 19:50:39.91',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2017369650',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1932959363',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'FastEthernet0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:08',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(373287344) 43 days, 4:54:33.44',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '391240957',
                        IFINERRORS       => '135',
                        IFOUTOCTETS      => '1559704531',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'FastEthernet0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:09',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4095) 0:00:40.95',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'FastEthernet0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:0a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4095) 0:00:40.95',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'FastEthernet0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:0b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(355831562) 41 days, 4:25:15.62',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '429124969',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '291591497',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'FastEthernet0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:0c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(373499748) 43 days, 5:29:57.48',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '259419663',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1742189833',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'FastEthernet0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:0d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'FastEthernet0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:0e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(395997133) 45 days, 19:59:31.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '459538485',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3954590768',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'FastEthernet0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFALIAS          => 'B613-bis Ab-I-6057',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:0f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(18205) 0:03:02.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1693076107',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2993571232',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'FastEthernet0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(338548782) 39 days, 4:24:47.82',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '21782154',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3311245137',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'FastEthernet0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFALIAS          => 'B613-AB-I-6060',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:11',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(373399296) 43 days, 5:13:12.96',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '243936150',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2320429264',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'FastEthernet0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:12',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'FastEthernet0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:13',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'FastEthernet0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFALIAS          => 'AB-I-6069-B609',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:14',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'FastEthernet0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:15',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(19761) 0:03:17.61',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '204126088',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1139583024',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'FastEthernet0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:16',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(94903926) 10 days, 23:37:19.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '273076162',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '105263224',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'FastEthernet0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFALIAS          => 'PB up/down 50 fois par minute...',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:17',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(4009) 0:00:40.09',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'FastEthernet0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:18',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(83794) 0:13:57.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '295041092',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1169521450',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'FastEthernet0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFALIAS          => 'AB-I-5102',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:19',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(398403951) 46 days, 2:40:39.51',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '159279876',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1299989040',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'FastEthernet0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:1a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(83057) 0:13:50.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '154971075',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1462158495',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'FastEthernet0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFALIAS          => 'IRIS-IDEFS',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:1b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(372714182) 43 days, 3:19:01.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '177661203',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '94822713',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'FastEthernet0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:1c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(95601429) 11 days, 1:33:34.29',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2512344603',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2728136037',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'FastEthernet0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:1d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4097) 0:00:40.97',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'FastEthernet0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:1e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(398124187) 46 days, 1:54:01.87',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '92318275',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1525456045',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'FastEthernet0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFALIAS          => 'IRIS-EURISCO',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:1f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4097) 0:00:40.97',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'FastEthernet0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:20',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(396789246) 45 days, 22:11:32.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '230285879',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '644737321',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'FastEthernet0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFALIAS          => 'IRIS-LEGOS',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:21',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(373799092) 43 days, 6:19:50.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '166684226',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3667580775',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'FastEthernet0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:22',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(94510532) 10 days, 22:31:45.32',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '52192332',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '400503274',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'FastEthernet0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFALIAS          => 'IRIS-CERDO',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:23',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(397607755) 46 days, 0:27:57.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '45344558',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3406155936',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'FastEthernet0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:24',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(88446) 0:14:44.46',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '57169',
                        IFINERRORS       => '131',
                        IFOUTOCTETS      => '7049719',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'FastEthernet0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFALIAS          => 'IRIS-LEGOS',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:25',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(350712465) 40 days, 14:12:04.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '178030566',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3153998775',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'FastEthernet0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:26',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(78723) 0:13:07.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '248645438',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4040756127',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'FastEthernet0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFALIAS          => 'IRIS-LEGOS',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:27',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4098) 0:00:40.98',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'FastEthernet0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:28',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346438944) 40 days, 2:19:49.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '929532514',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1935901378',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'FastEthernet0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFALIAS          => 'IRIS-LEGOS',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:29',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(398827244) 46 days, 3:51:12.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '208685915',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1751732687',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'FastEthernet0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:2a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4098) 0:00:40.98',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'FastEthernet0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:2b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(638058) 1:46:20.58',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '19401258',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3382662662',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'FastEthernet0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:2c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(73934) 0:12:19.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '828169904',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2621710761',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'FastEthernet0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFALIAS          => 'IRIS-LEGOS',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:2d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(16148) 0:02:41.48',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '7191',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'FastEthernet0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:2e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(3929) 0:00:39.29',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'FastEthernet0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:2f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4099) 0:00:40.99',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'FastEthernet0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:30',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4099) 0:00:40.99',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'GigabitEthernet0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFALIAS          => 'B606-AB-I-6008 wifi-B606-67',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:31',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(183826324) 21 days, 6:37:43.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2407842475',
                        IFINERRORS       => '787976',
                        IFOUTOCTETS      => '629744854',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'GigabitEthernet0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFALIAS          => 'AB-Switch-1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:83:32',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(19601) 0:03:16.01',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3464173483',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1089744093',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/15',
                                SYSNAME  => 'AB-Switch-1.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.1',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Null0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.28.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'AB-35.example.com',
            MAC          => 'c4:0a:cb:95:39:00',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'AB-35.example.com',
            MAC          => 'c4:0a:cb:95:39:00',
            MODELSNMP    => 'Networking2416',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
                NAME         => 'AB-35.example.com',
                MEMORY       => '20',
                IPS          => {
                    IP => [
                        '192.168.1.35',
                    ],
                },
                UPTIME       => '(399196332) 46 days, 4:52:43.32',
                CPU          => '86',
                RAM          => '60',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vlan1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.35',
                        MAC              => 'c4:0a:cb:95:39:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(397566922) 46 days, 0:21:09.22',
                        IFINOCTETS       => '1648762067',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327002474',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'FastEthernet0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFALIAS          => 'B307-AB-I-3044',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:01',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4102) 0:00:41.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '31',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'FastEthernet0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:02',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(396563513) 45 days, 21:33:55.13',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '63981580',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '937738588',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'FastEthernet0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFALIAS          => 'UFRGEA',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4102) 0:00:41.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '31',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'FastEthernet0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFALIAS          => 'ABI-5011-B515',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:04',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(398236494) 46 days, 2:12:44.94',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '450344552',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3204214563',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '4',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'FastEthernet0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFALIAS          => 'UFRGEA',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(398401314) 46 days, 2:40:13.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '38840233',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '452614371',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '31',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'FastEthernet0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFALIAS          => 'B307-AB-I-3043',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:06',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(108190) 0:18:01.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '549493032',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'FastEthernet0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFALIAS          => 'B309-AB-I-3037',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:07',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4102) 0:00:41.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '31',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'FastEthernet0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFALIAS          => 'AB-I-0055-B021',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:08',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4103) 0:00:41.03',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '6',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'FastEthernet0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFALIAS          => 'AB-I-3032-B311b',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:09',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4103) 0:00:41.03',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'FastEthernet0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:0a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(350878119) 40 days, 14:39:41.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '67816202',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327285714',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'FastEthernet0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFALIAS          => 'AB-I-3025',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:0b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4103) 0:00:41.03',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'FastEthernet0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFALIAS          => 'B216 ABI-2017',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:0c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(120665) 0:20:06.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '650951580',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '394157597',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'FastEthernet0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFALIAS          => 'AB-I-3021',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:0d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4103) 0:00:41.03',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'FastEthernet0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFALIAS          => 'IRIS-CERDO',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:0e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4103) 0:00:41.03',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'FastEthernet0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFALIAS          => 'AB-I-3022',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:0f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4103) 0:00:41.03',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'FastEthernet0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4104) 0:00:41.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'FastEthernet0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFALIAS          => 'AB-I-3027-B313',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:11',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4104) 0:00:41.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'FastEthernet0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFALIAS          => 'B033-Lionel Lenoble',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:12',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(398731456) 46 days, 3:35:14.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '187013600',
                        IFINERRORS       => '6',
                        IFOUTOCTETS      => '2869573976',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'FastEthernet0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFALIAS          => 'AB-I-3035-B309b',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:13',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(95642711) 11 days, 1:40:27.11',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '60657',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '13077',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'FastEthernet0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:14',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(279218937) 32 days, 7:36:29.37',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '129005432',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1026310893',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'FastEthernet0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFALIAS          => 'AB-I-3024',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:15',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(345682468) 40 days, 0:13:44.68',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '16077838',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '331384323',
                        IFOUTERRORS      => '2',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'FastEthernet0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFALIAS          => 'AB-I-0046-B031',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:16',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(372688082) 43 days, 3:14:40.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '42629097',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2826019152',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'FastEthernet0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFALIAS          => 'AB-I-3028-B313',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:17',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(10666876) 1 day, 5:37:48.76',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '9715655',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '90823211',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'FastEthernet0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFALIAS          => 'AB-I 6061 B611B',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:18',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(105228) 0:17:32.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '491106439',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1386091241',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'FastEthernet0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFALIAS          => 'B030 ABI0029',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:19',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4105) 0:00:41.05',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '32',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'FastEthernet0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFALIAS          => 'AB-I-6065 B609t',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:1a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(373696278) 43 days, 6:02:42.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '357716310',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '206058251',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'FastEthernet0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFALIAS          => 'ETUD',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:1b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4105) 0:00:41.05',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '6',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'FastEthernet0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:1c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4105) 0:00:41.05',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'FastEthernet0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFALIAS          => 'ETUD',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:1d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4105) 0:00:41.05',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '6',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'FastEthernet0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:1e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4105) 0:00:41.05',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'FastEthernet0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFALIAS          => 'AB-I-3029-B313',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:1f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4106) 0:00:41.06',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'FastEthernet0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFALIAS          => 'AB-I-2015-B214',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:20',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(240662414) 27 days, 20:30:24.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1205439419',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2210751295',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'FastEthernet0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFALIAS          => 'ETUD',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:21',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4106) 0:00:41.06',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '6',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'FastEthernet0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:22',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4106) 0:00:41.06',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'FastEthernet0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFALIAS          => 'UFRGEA',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:23',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4106) 0:00:41.06',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '31',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'FastEthernet0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFALIAS          => 'AB-I-0058 B019',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:24',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(240527926) 27 days, 20:07:59.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '836343698',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4232137886',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '32',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'FastEthernet0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFALIAS          => 'ABI-6070',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:25',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(397557227) 46 days, 0:19:32.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '369211235',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2686165684',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'FastEthernet0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFALIAS          => 'B216-AB-I-2018',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:26',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4106) 0:00:41.06',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'FastEthernet0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFALIAS          => 'ABI-0039 B038',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:27',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4107) 0:00:41.07',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '6',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'FastEthernet0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFALIAS          => 'AB-I-6014-IRISRuffin',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:28',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4107) 0:00:41.07',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'FastEthernet0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFALIAS          => 'ABI-6022',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:29',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4107) 0:00:41.07',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '6',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'FastEthernet0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:2a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4107) 0:00:41.07',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'FastEthernet0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFALIAS          => 'B419 419-02-I (bloc)',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:2b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4107) 0:00:41.07',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '49',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'FastEthernet0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:2c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(375400086) 43 days, 10:46:40.86',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '87723288',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1614810966',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'FastEthernet0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFALIAS          => 'AB-I-2016',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:2d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4107) 0:00:41.07',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'FastEthernet0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFALIAS          => 'B017',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:2e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(338194023) 39 days, 3:25:40.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '288663124',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1813930953',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '6',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'FastEthernet0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:2f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4107) 0:00:41.07',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'FastEthernet0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:30',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4107) 0:00:41.07',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'GigabitEthernet0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:31',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4107) 0:00:41.07',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'GigabitEthernet0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:95:39:32',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(397566921) 46 days, 0:21:09.21',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '771322567',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1590529004',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/2',
                                SYSNAME  => 'AB-Switch-1.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.1',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Null0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.29.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'CP-106.example.com',
            MAC          => 'c4:0a:cb:cd:8b:80',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'CP-106.example.com',
            MAC          => 'c4:0a:cb:cd:8b:80',
            MODELSNMP    => 'Networking2416',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
                NAME         => 'CP-106.example.com',
                MEMORY       => '20',
                CPU          => '82',
                RAM          => '60',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vlan1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:c0',
                        IFLASTCHANGE     => '(22495) 0:03:44.95',
                        IFINOCTETS       => '324306997',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '198326962',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'FastEthernet0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:81',
                        IFLASTCHANGE     => '(120329) 0:20:03.29',
                        IFINOCTETS       => '80308107',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1592600745',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'FastEthernet0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:82',
                        IFLASTCHANGE     => '(156236660) 18 days, 1:59:26.60',
                        IFINOCTETS       => '30585837',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '132128949',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'FastEthernet0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:83',
                        IFLASTCHANGE     => '(157187364) 18 days, 4:37:53.64',
                        IFINOCTETS       => '401747940',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1589500122',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'FastEthernet0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:84',
                        IFLASTCHANGE     => '(4086) 0:00:40.86',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'FastEthernet0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:85',
                        IFLASTCHANGE     => '(147202045) 17 days, 0:53:40.45',
                        IFINOCTETS       => '159598301',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1870553961',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'FastEthernet0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:86',
                        IFLASTCHANGE     => '(4086) 0:00:40.86',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'FastEthernet0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:87',
                        IFLASTCHANGE     => '(132931) 0:22:09.31',
                        IFINOCTETS       => '452391194',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3555848377',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'FastEthernet0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:88',
                        IFLASTCHANGE     => '(157169607) 18 days, 4:34:56.07',
                        IFINOCTETS       => '137011271',
                        IFINERRORS       => '1073',
                        IFOUTOCTETS      => '172987482',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'FastEthernet0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:89',
                        IFLASTCHANGE     => '(136738) 0:22:47.38',
                        IFINOCTETS       => '84803097',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1950174094',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'FastEthernet0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:8a',
                        IFLASTCHANGE     => '(4087) 0:00:40.87',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'FastEthernet0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:8b',
                        IFLASTCHANGE     => '(142474) 0:23:44.74',
                        IFINOCTETS       => '136356734',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1729236803',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'FastEthernet0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:8c',
                        IFLASTCHANGE     => '(84365) 0:14:03.65',
                        IFINOCTETS       => '33108269',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '979250843',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'FastEthernet0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:8d',
                        IFLASTCHANGE     => '(157208813) 18 days, 4:41:28.13',
                        IFINOCTETS       => '32554739',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1466664361',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'FastEthernet0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:8e',
                        IFLASTCHANGE     => '(4087) 0:00:40.87',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'FastEthernet0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:8f',
                        IFLASTCHANGE     => '(155727668) 18 days, 0:34:36.68',
                        IFINOCTETS       => '182885356',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '11019714',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'FastEthernet0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:90',
                        IFLASTCHANGE     => '(4088) 0:00:40.88',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'FastEthernet0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:91',
                        IFLASTCHANGE     => '(155897899) 18 days, 1:02:58.99',
                        IFINOCTETS       => '185618733',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1136058308',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'FastEthernet0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:92',
                        IFLASTCHANGE     => '(120072415) 13 days, 21:32:04.15',
                        IFINOCTETS       => '32667238',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1751606549',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'FastEthernet0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:93',
                        IFLASTCHANGE     => '(972962) 2:42:09.62',
                        IFINOCTETS       => '806805605',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '845501901',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'FastEthernet0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:94',
                        IFLASTCHANGE     => '(4088) 0:00:40.88',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'FastEthernet0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:95',
                        IFLASTCHANGE     => '(159516) 0:26:35.16',
                        IFINOCTETS       => '3511113674',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2955248708',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'FastEthernet0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:96',
                        IFLASTCHANGE     => '(4089) 0:00:40.89',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'FastEthernet0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:97',
                        IFLASTCHANGE     => '(129040) 0:21:30.40',
                        IFINOCTETS       => '3895288',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '415142315',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'FastEthernet0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:98',
                        IFLASTCHANGE     => '(154708286) 17 days, 21:44:42.86',
                        IFINOCTETS       => '639422648',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1583482082',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'FastEthernet0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:99',
                        IFLASTCHANGE     => '(4089) 0:00:40.89',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'FastEthernet0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:9a',
                        IFLASTCHANGE     => '(4089) 0:00:40.89',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'FastEthernet0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:9b',
                        IFLASTCHANGE     => '(4029) 0:00:40.29',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '24',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'FastEthernet0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:9c',
                        IFLASTCHANGE     => '(50226) 0:08:22.26',
                        IFINOCTETS       => '107351309',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1105193530',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'FastEthernet0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:9d',
                        IFLASTCHANGE     => '(4089) 0:00:40.89',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '24',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'FastEthernet0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:9e',
                        IFLASTCHANGE     => '(48414) 0:08:04.14',
                        IFINOCTETS       => '259003',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '153717880',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'FastEthernet0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:9f',
                        IFLASTCHANGE     => '(4090) 0:00:40.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'FastEthernet0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:a0',
                        IFLASTCHANGE     => '(148809907) 17 days, 5:21:39.07',
                        IFINOCTETS       => '10780724',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '199413415',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'FastEthernet0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:a1',
                        IFLASTCHANGE     => '(88578895) 10 days, 6:03:08.95',
                        IFINOCTETS       => '76801671',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '325559206',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '55',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'FastEthernet0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:a2',
                        IFLASTCHANGE     => '(4090) 0:00:40.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '24',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'FastEthernet0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:a3',
                        IFLASTCHANGE     => '(123585420) 14 days, 7:17:34.20',
                        IFINOCTETS       => '2047445154',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '909692649',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'FastEthernet0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:a4',
                        IFLASTCHANGE     => '(54324491) 6 days, 6:54:04.91',
                        IFINOCTETS       => '206712049',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '288470454',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'FastEthernet0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:a5',
                        IFLASTCHANGE     => '(1440739) 4:00:07.39',
                        IFINOCTETS       => '807464',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '860035231',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'FastEthernet0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:a6',
                        IFLASTCHANGE     => '(4091) 0:00:40.91',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'FastEthernet0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:a7',
                        IFLASTCHANGE     => '(4091) 0:00:40.91',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'FastEthernet0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:a8',
                        IFLASTCHANGE     => '(39253) 0:06:32.53',
                        IFINOCTETS       => '993714857',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '26334686',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'FastEthernet0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:a9',
                        IFLASTCHANGE     => '(4091) 0:00:40.91',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'FastEthernet0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:aa',
                        IFLASTCHANGE     => '(4091) 0:00:40.91',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'FastEthernet0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:ab',
                        IFLASTCHANGE     => '(4091) 0:00:40.91',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '5',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'FastEthernet0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:ac',
                        IFLASTCHANGE     => '(3919) 0:00:39.19',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'FastEthernet0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:ad',
                        IFLASTCHANGE     => '(4091) 0:00:40.91',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'FastEthernet0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:ae',
                        IFLASTCHANGE     => '(155765287) 18 days, 0:40:52.87',
                        IFINOCTETS       => '69855460',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '314016603',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '29',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'FastEthernet0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:af',
                        IFLASTCHANGE     => '(4091) 0:00:40.91',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'FastEthernet0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:b0',
                        IFLASTCHANGE     => '(4091) 0:00:40.91',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'GigabitEthernet0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:b1',
                        IFLASTCHANGE     => '(4091) 0:00:40.91',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'GigabitEthernet0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:8b:b2',
                        IFLASTCHANGE     => '(22495) 0:03:44.95',
                        IFINOCTETS       => '667860899',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1234036200',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/22',
                                SYSNAME  => 'CP-Switch-101.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.101',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Null0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.30.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'AP-71.example.com',
            MAC          => 'c4:0a:cb:ab:68:80',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'AP-71.example.com',
            MAC          => 'c4:0a:cb:ab:68:80',
            MODELSNMP    => 'Networking2416',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
                NAME         => 'AP-71.example.com',
                MEMORY       => '20',
                CPU          => '83',
                RAM          => '60',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vlan1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:c0',
                        IFLASTCHANGE     => '(18742) 0:03:07.42',
                        IFINOCTETS       => '166336386',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '92223141',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'FastEthernet0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:81',
                        IFLASTCHANGE     => '(4093) 0:00:40.93',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'FastEthernet0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:82',
                        IFLASTCHANGE     => '(4093) 0:00:40.93',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'FastEthernet0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:83',
                        IFLASTCHANGE     => '(4093) 0:00:40.93',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'FastEthernet0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:84',
                        IFLASTCHANGE     => '(4093) 0:00:40.93',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'FastEthernet0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:85',
                        IFLASTCHANGE     => '(4093) 0:00:40.93',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'FastEthernet0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:86',
                        IFLASTCHANGE     => '(4094) 0:00:40.94',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'FastEthernet0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:87',
                        IFLASTCHANGE     => '(4094) 0:00:40.94',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'FastEthernet0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:88',
                        IFLASTCHANGE     => '(384320) 1:04:03.20',
                        IFINOCTETS       => '949969381',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '441295959',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'FastEthernet0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:89',
                        IFLASTCHANGE     => '(51159683) 5 days, 22:06:36.83',
                        IFINOCTETS       => '12485333',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '462928907',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'FastEthernet0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:8a',
                        IFLASTCHANGE     => '(5877187) 16:19:31.87',
                        IFINOCTETS       => '162391644',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2027456597',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'FastEthernet0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:8b',
                        IFLASTCHANGE     => '(413977) 1:08:59.77',
                        IFINOCTETS       => '502829',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '12616711',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'FastEthernet0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:8c',
                        IFLASTCHANGE     => '(4094) 0:00:40.94',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'FastEthernet0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:8d',
                        IFLASTCHANGE     => '(414385) 1:09:03.85',
                        IFINOCTETS       => '1436417149',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3382839916',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'FastEthernet0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:8e',
                        IFLASTCHANGE     => '(4095) 0:00:40.95',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'FastEthernet0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:8f',
                        IFLASTCHANGE     => '(414101) 1:09:01.01',
                        IFINOCTETS       => '135900175',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2459505968',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'FastEthernet0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:90',
                        IFLASTCHANGE     => '(4095) 0:00:40.95',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'FastEthernet0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:91',
                        IFLASTCHANGE     => '(79551102) 9 days, 4:58:31.02',
                        IFINOCTETS       => '110108413',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1672644216',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'FastEthernet0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:92',
                        IFLASTCHANGE     => '(391184) 1:05:11.84',
                        IFINOCTETS       => '249425464',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4177097156',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '28',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'FastEthernet0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:93',
                        IFLASTCHANGE     => '(412878) 1:08:48.78',
                        IFINOCTETS       => '95344638',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1010945089',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'FastEthernet0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:94',
                        IFLASTCHANGE     => '(4095) 0:00:40.95',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'FastEthernet0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:95',
                        IFLASTCHANGE     => '(71212257) 8 days, 5:48:42.57',
                        IFINOCTETS       => '62480892',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '850459015',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'FastEthernet0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:96',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'FastEthernet0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:97',
                        IFLASTCHANGE     => '(411787) 1:08:37.87',
                        IFINOCTETS       => '2006974792',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2379000962',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'FastEthernet0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:98',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'FastEthernet0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:99',
                        IFLASTCHANGE     => '(11117687) 1 day, 6:52:56.87',
                        IFINOCTETS       => '4563711',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '219374044',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'FastEthernet0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:9a',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'FastEthernet0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:9b',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'FastEthernet0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:9c',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'FastEthernet0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:9d',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'FastEthernet0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:9e',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'FastEthernet0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:9f',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'FastEthernet0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:a0',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'FastEthernet0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:a1',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'FastEthernet0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:a2',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'FastEthernet0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:a3',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'FastEthernet0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:a4',
                        IFLASTCHANGE     => '(4097) 0:00:40.97',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'FastEthernet0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:a5',
                        IFLASTCHANGE     => '(4097) 0:00:40.97',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'FastEthernet0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:a6',
                        IFLASTCHANGE     => '(4097) 0:00:40.97',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'FastEthernet0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:a7',
                        IFLASTCHANGE     => '(4097) 0:00:40.97',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'FastEthernet0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:a8',
                        IFLASTCHANGE     => '(4097) 0:00:40.97',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'FastEthernet0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:a9',
                        IFLASTCHANGE     => '(4097) 0:00:40.97',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '55',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'FastEthernet0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:aa',
                        IFLASTCHANGE     => '(4097) 0:00:40.97',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'FastEthernet0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:ab',
                        IFLASTCHANGE     => '(71113114) 8 days, 5:32:11.14',
                        IFINOCTETS       => '39828973',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '415391758',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '14',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'FastEthernet0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:ac',
                        IFLASTCHANGE     => '(4098) 0:00:40.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '15',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'FastEthernet0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:ad',
                        IFLASTCHANGE     => '(72050738) 8 days, 8:08:27.38',
                        IFINOCTETS       => '10411413',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '210423630',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '14',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'FastEthernet0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:ae',
                        IFLASTCHANGE     => '(78218157) 9 days, 1:16:21.57',
                        IFINOCTETS       => '15360300',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '65411852',
                        IFOUTERRORS      => '474',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'FastEthernet0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:af',
                        IFLASTCHANGE     => '(4098) 0:00:40.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'FastEthernet0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:b0',
                        IFLASTCHANGE     => '(4098) 0:00:40.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'GigabitEthernet0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:b1',
                        IFLASTCHANGE     => '(402301) 1:07:03.01',
                        IFINOCTETS       => '1199196918',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3964600438',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet0/1',
                                SYSNAME  => 'AP-A410-13.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANLITEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1)',
                                IP       => '192.168.1.13',
                                MODEL    => 'cisco WS-C2960-8TC-S',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'GigabitEthernet0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ab:68:b2',
                        IFLASTCHANGE     => '(18742) 0:03:07.42',
                        IFINOCTETS       => '2969359472',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2308685046',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/17',
                                SYSNAME  => 'AP-Switch-51.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.51',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Null0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.32.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'CP-129.example.com',
            MAC          => 'c4:0a:cb:cd:88:00',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'CP-129.example.com',
            MAC          => 'c4:0a:cb:cd:88:00',
            MODELSNMP    => 'Networking2416',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
                NAME         => 'CP-129.example.com',
                MEMORY       => '20',
                CPU          => '90',
                RAM          => '60',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vlan1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:40',
                        IFLASTCHANGE     => '(4818) 0:00:48.18',
                        IFINOCTETS       => '342494300',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '209672405',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'FastEthernet0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:01',
                        IFLASTCHANGE     => '(155851887) 18 days, 0:55:18.87',
                        IFINOCTETS       => '139092153',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1742419228',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '14',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'FastEthernet0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:02',
                        IFLASTCHANGE     => '(4067) 0:00:40.67',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'FastEthernet0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:03',
                        IFLASTCHANGE     => '(157084500) 18 days, 4:20:45.00',
                        IFINOCTETS       => '71450121',
                        IFINERRORS       => '189',
                        IFOUTOCTETS      => '532210388',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '14',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'FastEthernet0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:04',
                        IFLASTCHANGE     => '(19905) 0:03:19.05',
                        IFINOCTETS       => '430952526',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2153282605',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'FastEthernet0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:05',
                        IFLASTCHANGE     => '(42446) 0:07:04.46',
                        IFINOCTETS       => '253409112',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2083166134',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '14',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'FastEthernet0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:06',
                        IFLASTCHANGE     => '(4067) 0:00:40.67',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'FastEthernet0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:07',
                        IFLASTCHANGE     => '(4068) 0:00:40.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '14',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'FastEthernet0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:08',
                        IFLASTCHANGE     => '(4068) 0:00:40.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'FastEthernet0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:09',
                        IFLASTCHANGE     => '(11551577) 1 day, 8:05:15.77',
                        IFINOCTETS       => '7036113',
                        IFINERRORS       => '74',
                        IFOUTOCTETS      => '46155745',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'FastEthernet0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:0a',
                        IFLASTCHANGE     => '(25805) 0:04:18.05',
                        IFINOCTETS       => '303791372',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1572003616',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'FastEthernet0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:0b',
                        IFLASTCHANGE     => '(36176409) 4 days, 4:29:24.09',
                        IFINOCTETS       => '21173022',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '104717078',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'FastEthernet0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:0c',
                        IFLASTCHANGE     => '(156473469) 18 days, 2:38:54.69',
                        IFINOCTETS       => '529422442',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1497067739',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'FastEthernet0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:0d',
                        IFLASTCHANGE     => '(27594771) 3 days, 4:39:07.71',
                        IFINOCTETS       => '269553',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '556202230',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'FastEthernet0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:0e',
                        IFLASTCHANGE     => '(4068) 0:00:40.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'FastEthernet0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:0f',
                        IFLASTCHANGE     => '(156881980) 18 days, 3:46:59.80',
                        IFINOCTETS       => '290650374',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '942669195',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '14',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'FastEthernet0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:10',
                        IFLASTCHANGE     => '(155152038) 17 days, 22:58:40.38',
                        IFINOCTETS       => '425593965',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1082667493',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'FastEthernet0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:11',
                        IFLASTCHANGE     => '(61871) 0:10:18.71',
                        IFINOCTETS       => '85600087',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '415511032',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '14',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'FastEthernet0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:12',
                        IFLASTCHANGE     => '(4069) 0:00:40.69',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'FastEthernet0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:13',
                        IFLASTCHANGE     => '(157014166) 18 days, 4:09:01.66',
                        IFINOCTETS       => '1101020097',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1273830488',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '14',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'FastEthernet0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:14',
                        IFLASTCHANGE     => '(4069) 0:00:40.69',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'FastEthernet0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:15',
                        IFLASTCHANGE     => '(494680) 1:22:26.80',
                        IFINOCTETS       => '4174769',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8081125',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '14',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'FastEthernet0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:16',
                        IFLASTCHANGE     => '(156492827) 18 days, 2:42:08.27',
                        IFINOCTETS       => '219300370',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1310224702',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'FastEthernet0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:17',
                        IFLASTCHANGE     => '(156722698) 18 days, 3:20:26.98',
                        IFINOCTETS       => '182718884',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1083092560',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '14',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'FastEthernet0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:18',
                        IFLASTCHANGE     => '(70020985) 8 days, 2:30:09.85',
                        IFINOCTETS       => '35025856',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '589031780',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'FastEthernet0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:19',
                        IFLASTCHANGE     => '(70814) 0:11:48.14',
                        IFINOCTETS       => '230329713',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3842105064',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'FastEthernet0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:1a',
                        IFLASTCHANGE     => '(156472527) 18 days, 2:38:45.27',
                        IFINOCTETS       => '904740817',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1522207991',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'FastEthernet0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:1b',
                        IFLASTCHANGE     => '(4070) 0:00:40.70',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'FastEthernet0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:1c',
                        IFLASTCHANGE     => '(4070) 0:00:40.70',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'FastEthernet0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:1d',
                        IFLASTCHANGE     => '(4070) 0:00:40.70',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'FastEthernet0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:1e',
                        IFLASTCHANGE     => '(4070) 0:00:40.70',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'FastEthernet0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:1f',
                        IFLASTCHANGE     => '(4070) 0:00:40.70',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'FastEthernet0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:20',
                        IFLASTCHANGE     => '(4070) 0:00:40.70',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'FastEthernet0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:21',
                        IFLASTCHANGE     => '(4070) 0:00:40.70',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'FastEthernet0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:22',
                        IFLASTCHANGE     => '(18502) 0:03:05.02',
                        IFINOCTETS       => '54802860',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '566699409',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'FastEthernet0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:23',
                        IFLASTCHANGE     => '(78322684) 9 days, 1:33:46.84',
                        IFINOCTETS       => '639159257',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1673881452',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'FastEthernet0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:24',
                        IFLASTCHANGE     => '(4070) 0:00:40.70',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'FastEthernet0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:25',
                        IFLASTCHANGE     => '(44233383) 5 days, 2:52:13.83',
                        IFINOCTETS       => '174439316',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '333305315',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '3',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'FastEthernet0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:26',
                        IFLASTCHANGE     => '(155164185) 17 days, 23:00:41.85',
                        IFINOCTETS       => '213617248',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1165949405',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'FastEthernet0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:27',
                        IFLASTCHANGE     => '(148619821) 17 days, 4:49:58.21',
                        IFINOCTETS       => '221363175',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2459270527',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'FastEthernet0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:28',
                        IFLASTCHANGE     => '(4071) 0:00:40.71',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'FastEthernet0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:29',
                        IFLASTCHANGE     => '(66105) 0:11:01.05',
                        IFINOCTETS       => '255905393',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2966830873',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'FastEthernet0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:2a',
                        IFLASTCHANGE     => '(15690) 0:02:36.90',
                        IFINOCTETS       => '1866640217',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3051142050',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'FastEthernet0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:2b',
                        IFLASTCHANGE     => '(4071) 0:00:40.71',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'FastEthernet0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:2c',
                        IFLASTCHANGE     => '(156105339) 18 days, 1:37:33.39',
                        IFINOCTETS       => '357067127',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1322368606',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'FastEthernet0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:2d',
                        IFLASTCHANGE     => '(4071) 0:00:40.71',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'FastEthernet0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:2e',
                        IFLASTCHANGE     => '(156408486) 18 days, 2:28:04.86',
                        IFINOCTETS       => '2531683071',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4131182755',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'FastEthernet0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:2f',
                        IFLASTCHANGE     => '(4072) 0:00:40.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'FastEthernet0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:30',
                        IFLASTCHANGE     => '(4072) 0:00:40.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'GigabitEthernet0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:31',
                        IFLASTCHANGE     => '(4072) 0:00:40.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'GigabitEthernet0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:88:32',
                        IFLASTCHANGE     => '(79048) 0:13:10.48',
                        IFINOCTETS       => '1843027809',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2395085022',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/11',
                                SYSNAME  => 'CP-Switch-101.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.101',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Null0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.33.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'AP-73.example.com',
            MAC          => 'c4:0a:cb:ba:6c:00',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'AP-73.example.com',
            MAC          => 'c4:0a:cb:ba:6c:00',
            MODELSNMP    => 'Networking2416',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
                NAME         => 'AP-73.example.com',
                MEMORY       => '20',
                CPU          => '91',
                RAM          => '60',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vlan1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:40',
                        IFLASTCHANGE     => '(187468) 0:31:14.68',
                        IFINOCTETS       => '144407765',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '83035701',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'FastEthernet0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:01',
                        IFLASTCHANGE     => '(69851016) 8 days, 2:01:50.16',
                        IFINOCTETS       => '72026347',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '551563172',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'FastEthernet0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:02',
                        IFLASTCHANGE     => '(2482988) 6:53:49.88',
                        IFINOCTETS       => '5751709',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '180494199',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'FastEthernet0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:03',
                        IFLASTCHANGE     => '(714923) 1:59:09.23',
                        IFINOCTETS       => '527872396',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2127212600',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'FastEthernet0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:04',
                        IFLASTCHANGE     => '(62551534) 7 days, 5:45:15.34',
                        IFINOCTETS       => '268465910',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1544870396',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '14',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'FastEthernet0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:05',
                        IFLASTCHANGE     => '(2650923) 7:21:49.23',
                        IFINOCTETS       => '1256518',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '138162383',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'FastEthernet0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:06',
                        IFLASTCHANGE     => '(4091) 0:00:40.91',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'FastEthernet0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:07',
                        IFLASTCHANGE     => '(61877376) 7 days, 3:52:53.76',
                        IFINOCTETS       => '178580626',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1013155442',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'FastEthernet0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:08',
                        IFLASTCHANGE     => '(4091) 0:00:40.91',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'FastEthernet0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:09',
                        IFLASTCHANGE     => '(68379177) 7 days, 21:56:31.77',
                        IFINOCTETS       => '236325752',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1049235021',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'FastEthernet0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:0a',
                        IFLASTCHANGE     => '(4091) 0:00:40.91',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '13',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'FastEthernet0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:0b',
                        IFLASTCHANGE     => '(71218823) 8 days, 5:49:48.23',
                        IFINOCTETS       => '44846590',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1205965751',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'FastEthernet0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:0c',
                        IFLASTCHANGE     => '(70400905) 8 days, 3:33:29.05',
                        IFINOCTETS       => '140246634',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '907775152',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'FastEthernet0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:0d',
                        IFLASTCHANGE     => '(4091) 0:00:40.91',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'FastEthernet0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:0e',
                        IFLASTCHANGE     => '(4092) 0:00:40.92',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'FastEthernet0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:0f',
                        IFLASTCHANGE     => '(720940) 2:00:09.40',
                        IFINOCTETS       => '98005676',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '472359628',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'FastEthernet0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:10',
                        IFLASTCHANGE     => '(4092) 0:00:40.92',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'FastEthernet0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:11',
                        IFLASTCHANGE     => '(4092) 0:00:40.92',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'FastEthernet0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:12',
                        IFLASTCHANGE     => '(4092) 0:00:40.92',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'FastEthernet0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:13',
                        IFLASTCHANGE     => '(71289318) 8 days, 6:01:33.18',
                        IFINOCTETS       => '145683637',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1238652232',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'FastEthernet0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:14',
                        IFLASTCHANGE     => '(4092) 0:00:40.92',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'FastEthernet0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:15',
                        IFLASTCHANGE     => '(722434) 2:00:24.34',
                        IFINOCTETS       => '280071751',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1727731681',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'FastEthernet0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:16',
                        IFLASTCHANGE     => '(4093) 0:00:40.93',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'FastEthernet0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:17',
                        IFLASTCHANGE     => '(70989573) 8 days, 5:11:35.73',
                        IFINOCTETS       => '93118465',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '216068348',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'FastEthernet0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:18',
                        IFLASTCHANGE     => '(69618960) 8 days, 1:23:09.60',
                        IFINOCTETS       => '358479611',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '75384595',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'FastEthernet0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:19',
                        IFLASTCHANGE     => '(70789112) 8 days, 4:38:11.12',
                        IFINOCTETS       => '6781078',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '643522671',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'FastEthernet0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:1a',
                        IFLASTCHANGE     => '(779595) 2:09:55.95',
                        IFINOCTETS       => '113916008',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '741613119',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'FastEthernet0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:1b',
                        IFLASTCHANGE     => '(4093) 0:00:40.93',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'FastEthernet0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:1c',
                        IFLASTCHANGE     => '(69389190) 8 days, 0:44:51.90',
                        IFINOCTETS       => '7992856',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '241156515',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'FastEthernet0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:1d',
                        IFLASTCHANGE     => '(4094) 0:00:40.94',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'FastEthernet0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:1e',
                        IFLASTCHANGE     => '(785572) 2:10:55.72',
                        IFINOCTETS       => '189882779',
                        IFINERRORS       => '198',
                        IFOUTOCTETS      => '1817390113',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'FastEthernet0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:1f',
                        IFLASTCHANGE     => '(4094) 0:00:40.94',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'FastEthernet0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:20',
                        IFLASTCHANGE     => '(37007231) 4 days, 6:47:52.31',
                        IFINOCTETS       => '6932449',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '108639740',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'FastEthernet0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:21',
                        IFLASTCHANGE     => '(735646) 2:02:36.46',
                        IFINOCTETS       => '68568863',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '750136193',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'FastEthernet0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:22',
                        IFLASTCHANGE     => '(4094) 0:00:40.94',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'FastEthernet0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:23',
                        IFLASTCHANGE     => '(4094) 0:00:40.94',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '28',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'FastEthernet0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:24',
                        IFLASTCHANGE     => '(63540286) 7 days, 8:30:02.86',
                        IFINOCTETS       => '50578752',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '485644142',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'FastEthernet0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:25',
                        IFLASTCHANGE     => '(4095) 0:00:40.95',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'FastEthernet0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:26',
                        IFLASTCHANGE     => '(4095) 0:00:40.95',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'FastEthernet0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:27',
                        IFLASTCHANGE     => '(68243810) 7 days, 21:33:58.10',
                        IFINOCTETS       => '76692457',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '318157013',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'FastEthernet0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:28',
                        IFLASTCHANGE     => '(4095) 0:00:40.95',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'FastEthernet0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:29',
                        IFLASTCHANGE     => '(4095) 0:00:40.95',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'FastEthernet0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:2a',
                        IFLASTCHANGE     => '(796874) 2:12:48.74',
                        IFINOCTETS       => '149910350',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1121153068',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '16',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'FastEthernet0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:2b',
                        IFLASTCHANGE     => '(71436134) 8 days, 6:26:01.34',
                        IFINOCTETS       => '112096126',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '508696340',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '25',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'FastEthernet0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:2c',
                        IFLASTCHANGE     => '(45330644) 5 days, 5:55:06.44',
                        IFINOCTETS       => '26357827',
                        IFINERRORS       => '2172',
                        IFOUTOCTETS      => '397895750',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '23',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'FastEthernet0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:2d',
                        IFLASTCHANGE     => '(70794781) 8 days, 4:39:07.81',
                        IFINOCTETS       => '76860575',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '580114711',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '27',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'FastEthernet0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:2e',
                        IFLASTCHANGE     => '(71039024) 8 days, 5:19:50.24',
                        IFINOCTETS       => '4563813',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '56826608',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '33',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'FastEthernet0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:2f',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'FastEthernet0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:30',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'GigabitEthernet0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:31',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'GigabitEthernet0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6c:32',
                        IFLASTCHANGE     => '(187467) 0:31:14.67',
                        IFINOCTETS       => '2035232519',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3071486535',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/9',
                                SYSNAME  => 'AP-Switch-51.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.51',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Null0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'cisco/C2960.35.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'CP-138.example.com',
            MAC          => 'c4:0a:cb:ba:6e:80',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
            SNMPHOSTNAME => 'CP-138.example.com',
            MAC          => 'c4:0a:cb:ba:6e:80',
            MODELSNMP    => 'Networking2416',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(50)SE, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Fri 27-Feb-09 23:25 by weiliu',
                NAME         => 'CP-138.example.com',
                MEMORY       => '20',
                CPU          => '89',
                RAM          => '60',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vlan1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6e:c0',
                        IFLASTCHANGE     => '(27650) 0:04:36.50',
                        IFINOCTETS       => '303984672',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '166297533',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'FastEthernet0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6e:81',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '7',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'FastEthernet0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6e:82',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                                    NUMBER => '30',
                                }
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'FastEthernet0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:ba:6e:83',
                        IFLASTCHANGE     => '(4096) 0:00:40.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => undef,
                        