/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.mobile;

import com.opera.core.systems.EmulationProfile;
import com.opera.core.systems.mobile.OperaMobileEmulation;

public enum MobileDevices {
    AMAZON_KINDLE_FIRE(OperaMobileEmulation.builder().setResolution(600, 1024).setPPI(169).setIME(EmulationProfile.IME.TABLET).build()),
    ASUS_EEE_PAD_SLIDER_SL101(OperaMobileEmulation.builder().setWidth(1280).setIME(EmulationProfile.IME.TABLET).build()),
    ASUS_EEE_PAD_TRANSFORMER_PRIME(OperaMobileEmulation.builder().setWidth(1280).setPPI(149).setIME(EmulationProfile.IME.TABLET).build()),
    ASUS_EEE_PAD_TRANSFORMER_TF101(ASUS_EEE_PAD_TRANSFORMER_PRIME.getProfile()),
    EXOPC_SLATE(OperaMobileEmulation.builder().setResolution(1366, 768).setPPI(135).setIME(EmulationProfile.IME.TABLET).setUserAgent(OperaMobileEmulation.UserAgent.DESKTOP).build()),
    HTC_DESIRE(OperaMobileEmulation.builder().setPPI(252).build()),
    HTC_EVO_3D(OperaMobileEmulation.builder().setResolution(540, 960).setPPI(256).build()),
    HTC_EVO_4G(OperaMobileEmulation.builder().setPPI(216).build()),
    HTC_FLYER(OperaMobileEmulation.builder().setResolution(1024, 600).setPPI(170).setIME(EmulationProfile.IME.TABLET).build()),
    HTC_HERO(OperaMobileEmulation.builder().setResolution(320, 480).setPPI(180).build()),
    HTC_INSPIRE_4G(OperaMobileEmulation.builder().setPPI(216).build()),
    HTC_SENSATION_4G(OperaMobileEmulation.builder().setResolution(540, 960).setPPI(256).build()),
    HTC_SENSATION(OperaMobileEmulation.builder().setResolution(540, 960).setPPI(253).build()),
    HTC_TATTOO(OperaMobileEmulation.builder().setResolution(240, 320).setPPI(142).build()),
    HTC_WILDFIRE(OperaMobileEmulation.builder().setResolution(240, 320).setPPI(120).build()),
    LG_OPTIMUS_3D(OperaMobileEmulation.builder().setPPI(216).build()),
    LG_OPTIMUS_ONE(OperaMobileEmulation.builder().setResolution(320, 480).setPPI(160).build()),
    LG_T_MOBILE_G2X(OperaMobileEmulation.builder().setPPI(233).build()),
    LENOVO_IDEAPAD_K1(OperaMobileEmulation.builder().setResolution(1280, 149).setPPI(149).setIME(EmulationProfile.IME.TABLET).build()),
    MOTOROLA_ATRIX_4G(OperaMobileEmulation.builder().setResolution(540, 960).setPPI(267).build()),
    MOTOROLA_DROID_X(OperaMobileEmulation.builder().setResolution(854, 228).setPPI(228).build()),
    MOTOROLA_PHOTON_4G(OperaMobileEmulation.builder().setResolution(540, 960).setPPI(256).build()),
    MOTOROLA_XOOM(OperaMobileEmulation.builder().setResolution(1280, 149).setPPI(149).setIME(EmulationProfile.IME.TABLET).build()),
    NOKIA_5530_XPRESSMUSIC(OperaMobileEmulation.builder().setResolution(360, 640).setPPI(253).setIME(EmulationProfile.IME.KEYPAD).setUserAgent(OperaMobileEmulation.UserAgent.S60).build()),
    NOKIA_5800_XPRESSMUSIC(OperaMobileEmulation.builder().setResolution(360, 640).setPPI(229).setUserAgent(OperaMobileEmulation.UserAgent.S60).build()),
    NOKIA_C7_00(OperaMobileEmulation.builder().setResolution(360, 640).setPPI(210).setUserAgent(OperaMobileEmulation.UserAgent.S60).build()),
    NOKIA_E63(OperaMobileEmulation.builder().setResolution(240, 320).setPPI(170).setIME(EmulationProfile.IME.KEYPAD).setUserAgent(OperaMobileEmulation.UserAgent.S60).build()),
    NOKIA_N800(OperaMobileEmulation.builder().setResolution(640, 360).setPPI(225).setUserAgent(OperaMobileEmulation.UserAgent.MEEGO).build()),
    NOKIA_N9(OperaMobileEmulation.builder().setHeight(854).setPPI(252).setUserAgent(OperaMobileEmulation.UserAgent.MEEGO).build()),
    NOKIA_N900_MAEMO(OperaMobileEmulation.builder().setResolution(800, 480).setPPI(267).build()),
    SEMC_XPERIA_RAY(OperaMobileEmulation.builder().setHeight(854).setPPI(297).build()),
    SEMC_XPERIA_X10(OperaMobileEmulation.builder().setHeight(854).setPPI(240).build()),
    SAMSUNG_EPIC_4G(OperaMobileEmulation.builder().setPPI(233).build()),
    SAMSUNG_GALAXY_NEXUS(OperaMobileEmulation.builder().setResolution(720, 1280).setPPI(316).build()),
    SAMSUNG_GALAXY_NOTE(OperaMobileEmulation.builder().setResolution(800, 1280).setPPI(285).build()),
    SAMSUNG_GALAXY_S_II(OperaMobileEmulation.builder().setPPI(216).build()),
    SAMSUNG_GALAXY_S(OperaMobileEmulation.builder().setPPI(240).build()),
    SAMSUNG_GALAXY_TAB_10_1(OperaMobileEmulation.builder().setWidth(1280).setPPI(149).setIME(EmulationProfile.IME.TABLET).build()),
    SAMSUNG_GALAXY_TAB_7_10_PLUS(OperaMobileEmulation.builder().setResolution(1024, 600).setPPI(170).setIME(EmulationProfile.IME.TABLET).build()),
    SAMSUNG_GALAXY_TAB_8_9(OperaMobileEmulation.builder().setWidth(1280).setPPI(169).setIME(EmulationProfile.IME.TABLET).build()),
    SAMSUNG_GALAXY_TAB(OperaMobileEmulation.builder().setResolution(1024, 600).setPPI(240).setIME(EmulationProfile.IME.TABLET).build()),
    SONY_TABLET_S(OperaMobileEmulation.builder().setWidth(1280).setPPI(160).setIME(EmulationProfile.IME.TABLET).build()),
    TOSHIBA_THRIVE_10_1(OperaMobileEmulation.builder().setWidth(1024).setPPI(160).setIME(EmulationProfile.IME.TABLET).build());

    private final EmulationProfile profile;

    private MobileDevices(EmulationProfile profile) {
        this.profile = profile;
    }

    public EmulationProfile getProfile() {
        return this.profile;
    }

    public String toString() {
        return this.name().toLowerCase().replace('_', ' ');
    }

    public static MobileDevices find(String identifier) {
        identifier = identifier.toUpperCase().replace('.', '_').replace('-', '_');
        for (MobileDevices device : MobileDevices.values()) {
            if (!device.name().equals(identifier)) continue;
            return device;
        }
        return null;
    }
}

