/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.runner.inprocess;

import com.google.common.base.Preconditions;
import com.opera.core.systems.common.hash.MD5;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.imageio.ImageIO;

public class ScreenCapture {
    private final Dimension dimensions;
    private byte[] data = null;

    public ScreenCapture(Dimension dimensions) {
        this.dimensions = dimensions;
    }

    public void take() throws AWTException {
        Rectangle area = new Rectangle(this.dimensions);
        Robot robot = new Robot();
        BufferedImage image = robot.createScreenCapture(area);
        this.data = ScreenCapture.getByteArray(image);
    }

    public String getMd5() throws IOException {
        this.checkCaptureTaken();
        try {
            return MD5.of(this.getData());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Algorithm is not available in your environment: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new IOException("Unable to open stream or file: " + e.getMessage(), e);
        }
    }

    public byte[] getData() {
        this.checkCaptureTaken();
        return this.data;
    }

    private void checkCaptureTaken() {
        Preconditions.checkState(this.data != null, "Screen capture not taken yet");
    }

    public static ScreenCapture of() throws IOException {
        return ScreenCapture.of(Toolkit.getDefaultToolkit().getScreenSize());
    }

    public static ScreenCapture of(Dimension dimensions) throws IOException {
        ScreenCapture capture = new ScreenCapture(dimensions);
        try {
            capture.take();
        }
        catch (AWTException e) {
            throw new IOException(e);
        }
        return capture;
    }

    private static byte[] getByteArray(BufferedImage image) {
        Preconditions.checkNotNull(image);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", stream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return stream.toByteArray();
    }
}

