/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.browserlaunchers.DoNotUseProxyPac;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.JsonException;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.SimplePropertyDescriptor;

public class JsonToBeanConverter {
    public <T> T convert(Class<T> clazz, Object text) throws JsonException {
        try {
            return this.convert(clazz, text, 0);
        }
        catch (JSONException e) {
            throw new JsonException(e, text);
        }
    }

    private <T> T convert(Class<T> clazz, Object text, int depth) throws JSONException {
        if (text == null) {
            return null;
        }
        if (String.class.equals(clazz)) {
            return (T)text;
        }
        if (this.isPrimitive(clazz)) {
            return (T)text;
        }
        if (text instanceof Number) {
            if (text instanceof Double || text instanceof Float) {
                return (T)Double.valueOf(String.valueOf(text));
            }
            return (T)Long.valueOf(String.valueOf(text));
        }
        if (this.isPrimitive(text.getClass())) {
            return (T)text;
        }
        if (this.isEnum(clazz, text)) {
            return (T)this.convertEnum(clazz, text);
        }
        if ("".equals(String.valueOf(text))) {
            return (T)text;
        }
        if (Command.class.equals(clazz)) {
            JSONObject rawCommand = new JSONObject((String)text);
            SessionId sessionId = null;
            if (rawCommand.has("sessionId")) {
                sessionId = this.convert(SessionId.class, rawCommand.getString("sessionId"), depth + 1);
            }
            String name = rawCommand.getString("name");
            if (rawCommand.has("parameters")) {
                Map args = this.convert(HashMap.class, rawCommand.getJSONObject("parameters"), depth + 1);
                return (T)new Command(sessionId, name, args);
            }
            return (T)new Command(sessionId, name);
        }
        if (SessionId.class.equals(clazz)) {
            JSONObject object = new JSONObject((String)text);
            String value = object.getString("value");
            return (T)new SessionId(value);
        }
        if (Capabilities.class.equals(clazz)) {
            JSONObject object = new JSONObject((String)text);
            DesiredCapabilities caps = new DesiredCapabilities();
            Iterator allKeys = object.keys();
            while (allKeys.hasNext()) {
                String key = (String)allKeys.next();
                caps.setCapability(key, object.get(key));
            }
            return (T)caps;
        }
        if (DoNotUseProxyPac.class.equals(clazz)) {
            String host;
            JSONObject proxied;
            int i;
            JSONObject object = new JSONObject((String)text);
            DoNotUseProxyPac pac = new DoNotUseProxyPac();
            if (object.has("directUrls")) {
                JSONArray allUrls = object.getJSONArray("directUrls");
                i = 0;
                while (i < allUrls.length()) {
                    pac.map(allUrls.getString(i)).toNoProxy();
                    ++i;
                }
            }
            if (object.has("directHosts")) {
                JSONArray allHosts = object.getJSONArray("directHosts");
                i = 0;
                while (i < allHosts.length()) {
                    pac.mapHost(allHosts.getString(i)).toNoProxy();
                    ++i;
                }
            }
            if (object.has("proxiedHosts")) {
                proxied = object.getJSONObject("proxiedHosts");
                Iterator allHosts = proxied.keys();
                while (allHosts.hasNext()) {
                    host = (String)allHosts.next();
                    pac.mapHost(host).toProxy(proxied.getString(host));
                }
            }
            if (object.has("proxiedUrls")) {
                proxied = object.getJSONObject("proxiedUrls");
                Iterator allUrls = proxied.keys();
                while (allUrls.hasNext()) {
                    host = (String)allUrls.next();
                    pac.map(host).toProxy(proxied.getString(host));
                }
            }
            if (object.has("proxiedRegexUrls")) {
                proxied = object.getJSONObject("proxiedRegexUrls");
                Iterator allUrls = proxied.keys();
                while (allUrls.hasNext()) {
                    host = (String)allUrls.next();
                    pac.map(host).toProxy(proxied.getString(host));
                }
            }
            if (object.has("defaultProxy")) {
                if ("'DIRECT'".equals(object.getString("defaultProxy"))) {
                    pac.defaults().toNoProxy();
                } else {
                    pac.defaults().toProxy(object.getString("defaultProxy"));
                }
            }
            if (object.has("deriveFrom")) {
                try {
                    pac.deriveFrom(new URI(object.getString("deriveFrom")));
                }
                catch (URISyntaxException e) {
                    throw new WebDriverException(e);
                }
            }
            return (T)pac;
        }
        if (Date.class.equals(clazz)) {
            return (T)new Date(Long.valueOf(String.valueOf(text)));
        }
        if (text instanceof String && !((String)text).startsWith("{") && Object.class.equals(clazz)) {
            return (T)text;
        }
        if (text instanceof JSONArray) {
            return (T)this.convertList((JSONArray)text, depth);
        }
        if (text == JSONObject.NULL) {
            return null;
        }
        if (depth == 0 && text instanceof String) {
            text = ((String)text).startsWith("[") ? new JSONArray((String)text) : new JSONObject(String.valueOf(text));
        }
        if (text instanceof JSONObject) {
            JSONObject o = (JSONObject)text;
            if (Map.class.isAssignableFrom(clazz)) {
                return (T)this.convertMap(o, depth);
            }
            if (this.isPrimitive(o.getClass())) {
                return (T)o;
            }
            if (Object.class.equals(clazz)) {
                return (T)this.convertMap(o, depth);
            }
            return this.convertBean(clazz, o, depth);
        }
        if (text instanceof JSONArray) {
            return (T)this.convertList((JSONArray)text, depth + 1);
        }
        return (T)text;
    }

    private Enum convertEnum(Class clazz, Object text) {
        Class<?>[] allClasses;
        if (clazz.isEnum()) {
            return Enum.valueOf(clazz, String.valueOf(text));
        }
        Class<?>[] classArray = allClasses = clazz.getClasses();
        int n = allClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> current = classArray[n2];
            if (current.isEnum()) {
                return Enum.valueOf(current, String.valueOf(text));
            }
            ++n2;
        }
        return null;
    }

    private boolean isEnum(Class<?> clazz, Object text) {
        return clazz.isEnum() || text instanceof Enum;
    }

    public <T> T convertBean(Class<T> clazz, JSONObject toConvert, int depth) throws JSONException {
        SimplePropertyDescriptor[] allProperties;
        T t = this.newInstance(clazz);
        SimplePropertyDescriptor[] simplePropertyDescriptorArray = allProperties = SimplePropertyDescriptor.getPropertyDescriptors(clazz);
        int n = allProperties.length;
        int n2 = 0;
        while (n2 < n) {
            SimplePropertyDescriptor property = simplePropertyDescriptorArray[n2];
            if (toConvert.has(property.getName())) {
                Object value = toConvert.get(property.getName());
                Method write = property.getWriteMethod();
                if (write != null) {
                    Class<?> type = write.getParameterTypes()[0];
                    try {
                        write.invoke(t, this.convert(type, value, depth + 1));
                    }
                    catch (IllegalAccessException e) {
                        throw this.propertyWriteException(property, value, type, e);
                    }
                    catch (InvocationTargetException e) {
                        throw this.propertyWriteException(property, value, type, e);
                    }
                }
            }
            ++n2;
        }
        return t;
    }

    private <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new WebDriverException(e);
        }
        catch (IllegalAccessException e) {
            throw new WebDriverException(e);
        }
    }

    private WebDriverException propertyWriteException(SimplePropertyDescriptor property, Object value, Class<?> type, Throwable cause) {
        throw new WebDriverException(String.format("Property name: %s -> %s on class %s", property.getName(), value, type), cause);
    }

    private Map convertMap(JSONObject toConvert, int depth) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator allEntries = toConvert.keys();
        while (allEntries.hasNext()) {
            String key = (String)allEntries.next();
            map.put(key, this.convert(Object.class, toConvert.get(key), depth + 1));
        }
        return map;
    }

    private List convertList(JSONArray toConvert, int depth) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>(toConvert.length());
        int i = 0;
        while (i < toConvert.length()) {
            list.add(this.convert(Object.class, toConvert.get(i), depth + 1));
            ++i;
        }
        return list;
    }

    private boolean isPrimitive(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Character.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Void.class.isAssignableFrom(clazz);
    }
}

