/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.client;

import java.io.IOException;
import org.seleniumhq.jetty7.client.HttpExchange;
import org.seleniumhq.jetty7.http.HttpFields;
import org.seleniumhq.jetty7.io.Buffer;

public class CachedExchange
extends HttpExchange {
    private final HttpFields _responseFields;
    private volatile int _responseStatus;

    public CachedExchange(boolean cacheHeaders) {
        this._responseFields = cacheHeaders ? new HttpFields() : null;
    }

    public synchronized int getResponseStatus() {
        if (this.getStatus() < 5) {
            throw new IllegalStateException("Response not received yet");
        }
        return this._responseStatus;
    }

    public synchronized HttpFields getResponseFields() {
        if (this.getStatus() < 6) {
            throw new IllegalStateException("Headers not completely received yet");
        }
        return this._responseFields;
    }

    protected synchronized void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
        this._responseStatus = status;
        super.onResponseStatus(version, status, reason);
    }

    protected synchronized void onResponseHeader(Buffer name, Buffer value) throws IOException {
        if (this._responseFields != null) {
            this._responseFields.add(name, value.asImmutableBuffer());
        }
        super.onResponseHeader(name, value);
    }
}

