/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.net.UrlChecker;
import org.openqa.selenium.os.CommandLine;

public class DriverService {
    private final URL url;
    private final ReentrantLock lock = new ReentrantLock();
    private CommandLine process = null;
    private final String executable;
    private final ImmutableList<String> args;
    private final ImmutableMap<String, String> environment;

    protected DriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        this.executable = executable.getCanonicalPath();
        this.url = new URL(String.format("http://localhost:%d", port));
        this.args = args;
        this.environment = environment;
    }

    public URL getUrl() {
        return this.url;
    }

    protected static File findExecutable(String exeName, String exeProperty, String exeDocs, String exeDownload) {
        String defaultPath = CommandLine.find(exeName);
        String exePath = System.getProperty(exeProperty, defaultPath);
        Preconditions.checkState(exePath != null, "The path to the driver executable must be set by the %s system property; for more information, see %s. The latest version can be downloaded from %s", exeProperty, exeDocs, exeDownload);
        File exe = new File(exePath);
        DriverService.checkExecutable(exe);
        return exe;
    }

    protected static void checkExecutable(File exe) {
        Preconditions.checkState(exe.exists(), "The driver executable does not exist: %s", exe.getAbsolutePath());
        Preconditions.checkState(!exe.isDirectory(), "The driver executable is a directory: %s", exe.getAbsolutePath());
        Preconditions.checkState(FileHandler.canExecute(exe), "The driver is not executable: %s", exe.getAbsolutePath());
    }

    public boolean isRunning() {
        this.lock.lock();
        try {
            if (this.process == null) {
                return false;
            }
            boolean bl = this.process.isRunning();
            return bl;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void start() throws IOException {
        this.lock.lock();
        try {
            if (this.process != null) {
                return;
            }
            try {
                this.process = new CommandLine(this.executable, this.args.toArray(new String[0]));
                this.process.setEnvironmentVariables(this.environment);
                this.process.copyOutputTo(System.err);
                this.process.executeAsync();
                URL status = new URL(String.valueOf(this.url.toString()) + "/status");
                new UrlChecker().waitUntilAvailable(20L, TimeUnit.SECONDS, status);
            }
            catch (UrlChecker.TimeoutException e) {
                this.process.checkForError();
                throw new WebDriverException("Timed out waiting for driver server to start.", e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            if (this.process == null) {
                return;
            }
            try {
                URL killUrl = new URL(String.valueOf(this.url.toString()) + "/shutdown");
                new UrlChecker().waitUntilUnavailable(3L, TimeUnit.SECONDS, killUrl);
                this.process.destroy();
            }
            catch (MalformedURLException e) {
                throw new WebDriverException(e);
            }
            catch (UrlChecker.TimeoutException e) {
                throw new WebDriverException("Timed out waiting for driver server to shutdown.", e);
            }
        }
        finally {
            this.process = null;
            this.lock.unlock();
        }
    }

    public static abstract class Builder<DS extends DriverService, B extends Builder> {
        private int port = 0;
        private File exe = null;
        private ImmutableMap<String, String> environment = ImmutableMap.of();
        private File logFile;

        public B usingDriverExecutable(File file) {
            Preconditions.checkNotNull(file);
            DriverService.checkExecutable(file);
            this.exe = file;
            return (B)this;
        }

        public B usingPort(int port) {
            Preconditions.checkArgument(port >= 0, "Invalid port number: %d", port);
            this.port = port;
            return (B)this;
        }

        protected int getPort() {
            return this.port;
        }

        public B usingAnyFreePort() {
            this.port = 0;
            return (B)this;
        }

        @Beta
        public B withEnvironment(Map<String, String> environment) {
            this.environment = ImmutableMap.copyOf(environment);
            return (B)this;
        }

        public B withLogFile(File logFile) {
            this.logFile = logFile;
            return (B)this;
        }

        protected File getLogFile() {
            return this.logFile;
        }

        public DS build() {
            if (this.port == 0) {
                this.port = PortProber.findFreePort();
            }
            if (this.exe == null) {
                this.exe = this.findDefaultExecutable();
            }
            ImmutableList<String> args = this.createArgs();
            return this.createDriverService(this.exe, this.port, args, this.environment);
        }

        protected abstract File findDefaultExecutable();

        protected abstract ImmutableList<String> createArgs();

        protected abstract DS createDriverService(File var1, int var2, ImmutableList<String> var3, ImmutableMap<String, String> var4);
    }
}

