# Copyright 2015 Jeffrey Kegler
# This file is part of Marpa::R2.  Marpa::R2 is free software: you can
# redistribute it and/or modify it under the terms of the GNU Lesser
# General Public License as published by the Free Software Foundation,
# either version 3 of the License, or (at your option) any later version.
#
# Marpa::R2 is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser
# General Public License along with Marpa::R2.  If not, see
# http://www.gnu.org/licenses/.

package Marpa::R2::MetaG;

use 5.010;
use strict;
use warnings;

use vars qw($VERSION $STRING_VERSION);
$VERSION        = '2.105_000';
$STRING_VERSION = $VERSION;
## no critic(BuiltinFunctions::ProhibitStringyEval)
$VERSION = eval $VERSION;
## use critic

package Marpa::R2::Internal::MetaG;

use English qw( -no_match_vars );

sub hashed_grammar {
    my $hashed_metag;

## no critic(RegularExpressions::RequireDotMatchAnything)
## no critic(RegularExpressions::RequireExtendedFormatting)
## no critic(RegularExpressions::RequireLineBoundaryMatching)
## no critic(RegularExpressions::ProhibitEscapedMetacharacters)
## no critic(RegularExpressions::ProhibitComplexRegexes)

## The code after this line was automatically generated by sl_to_hash.pl
## Date: Fri Feb  6 14:39:08 2015
$hashed_metag = {
                  'character_classes' => {
                                           '[[\']]' => [
                                                         '[\']',
                                                         ''
                                                       ],
                                           '[[+-]]' => [
                                                         '[+-]',
                                                         ''
                                                       ],
                                           '[[,]]' => [
                                                        '[,]',
                                                        ''
                                                      ],
                                           '[[01]]' => [
                                                         '[01]',
                                                         ''
                                                       ],
                                           '[[1]]' => [
                                                        '[1]',
                                                        ''
                                                      ],
                                           '[[[:alnum:]]]' => [
                                                                '[[:alnum:]]',
                                                                ''
                                                              ],
                                           '[[\\#]]' => [
                                                          '[\\#]',
                                                          ''
                                                        ],
                                           '[[\\(]]' => [
                                                          '[\\(]',
                                                          ''
                                                        ],
                                           '[[\\)]]' => [
                                                          '[\\)]',
                                                          ''
                                                        ],
                                           '[[\\*]]' => [
                                                          '[\\*]',
                                                          ''
                                                        ],
                                           '[[\\+]]' => [
                                                          '[\\+]',
                                                          ''
                                                        ],
                                           '[[\\,]]' => [
                                                          '[\\,]',
                                                          ''
                                                        ],
                                           '[[\\-]]' => [
                                                          '[\\-]',
                                                          ''
                                                        ],
                                           '[[\\:]]' => [
                                                          '[\\:]',
                                                          ''
                                                        ],
                                           '[[\\;]]' => [
                                                          '[\\;]',
                                                          ''
                                                        ],
                                           '[[\\<]]' => [
                                                          '[\\<]',
                                                          ''
                                                        ],
                                           '[[\\=]]' => [
                                                          '[\\=]',
                                                          ''
                                                        ],
                                           '[[\\>]]' => [
                                                          '[\\>]',
                                                          ''
                                                        ],
                                           '[[\\[]]' => [
                                                          '[\\[]',
                                                          ''
                                                        ],
                                           '[[\\\\]]' => [
                                                           '[\\\\]',
                                                           ''
                                                         ],
                                           '[[\\]]]' => [
                                                          '[\\]]',
                                                          ''
                                                        ],
                                           '[[\\^]]' => [
                                                          '[\\^]',
                                                          ''
                                                        ],
                                           '[[\\d]]' => [
                                                          '[\\d]',
                                                          ''
                                                        ],
                                           '[[\\s\\w]]' => [
                                                             '[\\s\\w]',
                                                             ''
                                                           ],
                                           '[[\\s]]' => [
                                                          '[\\s]',
                                                          ''
                                                        ],
                                           '[[\\w]]' => [
                                                          '[\\w]',
                                                          ''
                                                        ],
                                           '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => [
                                                                                                 '[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                                 ''
                                                                                               ],
                                           '[[\\{]]' => [
                                                          '[\\{]',
                                                          ''
                                                        ],
                                           '[[\\|]]' => [
                                                          '[\\|]',
                                                          ''
                                                        ],
                                           '[[\\}]]' => [
                                                          '[\\}]',
                                                          ''
                                                        ],
                                           '[[\\~]]' => [
                                                          '[\\~]',
                                                          ''
                                                        ],
                                           '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => [
                                                                                                                 '[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                                 ''
                                                                                                               ],
                                           '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => [
                                                                                                                      '[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                                      ''
                                                                                                                    ],
                                           '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => [
                                                                                                  '[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                                  ''
                                                                                                ],
                                           '[[a-zA-Z]]' => [
                                                             '[a-zA-Z]',
                                                             ''
                                                           ],
                                           '[[a]]' => [
                                                        '[a]',
                                                        ''
                                                      ],
                                           '[[b]]' => [
                                                        '[b]',
                                                        ''
                                                      ],
                                           '[[c]]' => [
                                                        '[c]',
                                                        ''
                                                      ],
                                           '[[d]]' => [
                                                        '[d]',
                                                        ''
                                                      ],
                                           '[[e]]' => [
                                                        '[e]',
                                                        ''
                                                      ],
                                           '[[f]]' => [
                                                        '[f]',
                                                        ''
                                                      ],
                                           '[[g]]' => [
                                                        '[g]',
                                                        ''
                                                      ],
                                           '[[h]]' => [
                                                        '[h]',
                                                        ''
                                                      ],
                                           '[[i]]' => [
                                                        '[i]',
                                                        ''
                                                      ],
                                           '[[k]]' => [
                                                        '[k]',
                                                        ''
                                                      ],
                                           '[[l]]' => [
                                                        '[l]',
                                                        ''
                                                      ],
                                           '[[m]]' => [
                                                        '[m]',
                                                        ''
                                                      ],
                                           '[[n]]' => [
                                                        '[n]',
                                                        ''
                                                      ],
                                           '[[o]]' => [
                                                        '[o]',
                                                        ''
                                                      ],
                                           '[[p]]' => [
                                                        '[p]',
                                                        ''
                                                      ],
                                           '[[r]]' => [
                                                        '[r]',
                                                        ''
                                                      ],
                                           '[[s]]' => [
                                                        '[s]',
                                                        ''
                                                      ],
                                           '[[t]]' => [
                                                        '[t]',
                                                        ''
                                                      ],
                                           '[[u]]' => [
                                                        '[u]',
                                                        ''
                                                      ],
                                           '[[v]]' => [
                                                        '[v]',
                                                        ''
                                                      ],
                                           '[[w]]' => [
                                                        '[w]',
                                                        ''
                                                      ],
                                           '[[x]]' => [
                                                        '[x]',
                                                        ''
                                                      ],
                                           '[[y]]' => [
                                                        '[y]',
                                                        ''
                                                      ]
                                         },
                  'discard_default_adverbs' => undef,
                  'first_lhs' => 'statements',
                  'lexeme_default_adverbs' => {
                                                'action' => '[start,length,value]',
                                                'bless' => '::name',
                                                'latm' => '1'
                                              },
                  'rules' => {
                               'G1' => [
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'action',
                                           'lhs' => 'action',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'action',
                                           'rhs' => [
                                                      '[Lex-36]',
                                                      '[Lex-37]',
                                                      'action name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'action_name',
                                           'lhs' => 'action name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'action name',
                                           'rhs' => [
                                                      'Perl name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'action_name',
                                           'lhs' => 'action name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'action name',
                                           'rhs' => [
                                                      'array descriptor'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'action_name',
                                           'lhs' => 'action name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'action name',
                                           'rhs' => [
                                                      'reserved action name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'adverb item',
                                           'rhs' => [
                                                      'action'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'adverb item',
                                           'rhs' => [
                                                      'blessing'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'adverb item',
                                           'rhs' => [
                                                      'event specification'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'adverb item',
                                           'rhs' => [
                                                      'group association'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'adverb item',
                                           'rhs' => [
                                                      'latm specification'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'adverb item',
                                           'rhs' => [
                                                      'left association'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'adverb item',
                                           'rhs' => [
                                                      'naming'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'adverb item',
                                           'rhs' => [
                                                      'null adverb'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'adverb item',
                                           'rhs' => [
                                                      'null ranking specification'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'adverb item',
                                           'rhs' => [
                                                      'pause specification'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'adverb item',
                                           'rhs' => [
                                                      'priority specification'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'adverb item',
                                           'rhs' => [
                                                      'proper specification'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'adverb item',
                                           'rhs' => [
                                                      'rank specification'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'adverb item',
                                           'rhs' => [
                                                      'right association'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_item',
                                           'lhs' => 'adverb item',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'adverb item',
                                           'rhs' => [
                                                      'separator specification'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_list',
                                           'lhs' => 'adverb list',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'adverb list',
                                           'rhs' => [
                                                      'adverb list items'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'adverb_list_items',
                                           'lhs' => 'adverb list items',
                                           'min' => 0,
                                           'name' => 'adverb list items',
                                           'rhs' => [
                                                      'adverb item'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'alternative',
                                           'lhs' => 'alternative',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'name' => 'alternative',
                                           'rhs' => [
                                                      'rhs',
                                                      'adverb list'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'alternative_name',
                                           'lhs' => 'alternative name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'alternative name',
                                           'rhs' => [
                                                      'single quoted name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'alternative_name',
                                           'lhs' => 'alternative name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'alternative name',
                                           'rhs' => [
                                                      'standard name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'alternatives',
                                           'lhs' => 'alternatives',
                                           'min' => 1,
                                           'name' => 'alternatives',
                                           'proper' => '1',
                                           'rhs' => [
                                                      'alternative'
                                                    ],
                                           'separator' => 'op equal priority'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'blessing',
                                           'lhs' => 'blessing',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'blessing',
                                           'rhs' => [
                                                      '[Lex-73]',
                                                      '[Lex-74]',
                                                      'blessing name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'blessing_name',
                                           'lhs' => 'blessing name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'blessing name',
                                           'rhs' => [
                                                      'reserved blessing name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'blessing_name',
                                           'lhs' => 'blessing name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'blessing name',
                                           'rhs' => [
                                                      'standard name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'completion_event_declaration',
                                           'lhs' => 'completion event declaration',
                                           'mask' => [
                                                       0,
                                                       1,
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'completion event declaration',
                                           'rhs' => [
                                                      '[Lex-16]',
                                                      'event initialization',
                                                      '[Lex-17]',
                                                      '[Lex-18]',
                                                      'symbol name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'current_lexer_statement',
                                           'lhs' => 'current lexer statement',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'current lexer statement',
                                           'rhs' => [
                                                      '[Lex-25]',
                                                      '[Lex-26]',
                                                      '[Lex-27]',
                                                      'lexer name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'default_rule',
                                           'lhs' => 'default rule',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'name' => 'default rule',
                                           'rhs' => [
                                                      '[Lex-7]',
                                                      'op declare bnf',
                                                      'adverb list'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'discard_default_statement',
                                           'lhs' => 'discard default statement',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'discard default statement',
                                           'rhs' => [
                                                      '[Lex-11]',
                                                      '[Lex-12]',
                                                      '[Lex-13]',
                                                      'adverb list'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'discard_rule',
                                           'lhs' => 'discard rule',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1,
                                                       1
                                                     ],
                                           'name' => 'discard rule',
                                           'rhs' => [
                                                      '[Lex-14]',
                                                      'op declare match',
                                                      'single symbol',
                                                      'adverb list'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'empty_rule',
                                           'lhs' => 'empty rule',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'name' => 'empty rule',
                                           'rhs' => [
                                                      'lhs',
                                                      'op declare',
                                                      'adverb list'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'event_initialization',
                                           'lhs' => 'event initialization',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'name' => 'event initialization',
                                           'rhs' => [
                                                      'event name',
                                                      'event initializer'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'event_initializer',
                                           'description' => 'Empty rule for <event initializer>',
                                           'lhs' => 'event initializer',
                                           'name' => 'event initializer',
                                           'rhs' => []
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'event_initializer',
                                           'lhs' => 'event initializer',
                                           'mask' => [
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'event initializer',
                                           'rhs' => [
                                                      '[Lex-66]',
                                                      'on or off'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'event_name',
                                           'lhs' => 'event name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'event name',
                                           'rhs' => [
                                                      'reserved event name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'event_name',
                                           'lhs' => 'event name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'event name',
                                           'rhs' => [
                                                      'single quoted name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'event_name',
                                           'lhs' => 'event name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'event name',
                                           'rhs' => [
                                                      'standard name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'event_specification',
                                           'lhs' => 'event specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'event specification',
                                           'rhs' => [
                                                      '[Lex-64]',
                                                      '[Lex-65]',
                                                      'event initialization'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'group_association',
                                           'lhs' => 'group association',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       0
                                                     ],
                                           'name' => 'group association',
                                           'rhs' => [
                                                      '[Lex-44]',
                                                      '[Lex-45]',
                                                      '[Lex-46]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'inaccessible_statement',
                                           'lhs' => 'inaccessible statement',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1,
                                                       0,
                                                       0
                                                     ],
                                           'name' => 'inaccessible statement',
                                           'rhs' => [
                                                      '[Lex-28]',
                                                      '[Lex-29]',
                                                      'inaccessible treatment',
                                                      '[Lex-30]',
                                                      '[Lex-31]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'inaccessible_treatment',
                                           'lhs' => 'inaccessible treatment',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'inaccessible treatment',
                                           'rhs' => [
                                                      '[Lex-32]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'inaccessible_treatment',
                                           'lhs' => 'inaccessible treatment',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'inaccessible treatment',
                                           'rhs' => [
                                                      '[Lex-33]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'inaccessible_treatment',
                                           'lhs' => 'inaccessible treatment',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'inaccessible treatment',
                                           'rhs' => [
                                                      '[Lex-34]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'latm_specification',
                                           'lhs' => 'latm specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'latm specification',
                                           'rhs' => [
                                                      '[Lex-69]',
                                                      '[Lex-70]',
                                                      'boolean'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'latm_specification',
                                           'lhs' => 'latm specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'latm specification',
                                           'rhs' => [
                                                      '[Lex-71]',
                                                      '[Lex-72]',
                                                      'boolean'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'left_association',
                                           'lhs' => 'left association',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       0
                                                     ],
                                           'name' => 'left association',
                                           'rhs' => [
                                                      '[Lex-38]',
                                                      '[Lex-39]',
                                                      '[Lex-40]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'lexeme_default_statement',
                                           'lhs' => 'lexeme default statement',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'lexeme default statement',
                                           'rhs' => [
                                                      '[Lex-8]',
                                                      '[Lex-9]',
                                                      '[Lex-10]',
                                                      'adverb list'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'lexeme_rule',
                                           'lhs' => 'lexeme rule',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1,
                                                       1
                                                     ],
                                           'name' => 'lexeme rule',
                                           'rhs' => [
                                                      '[Lex-15]',
                                                      'op declare match',
                                                      'symbol',
                                                      'adverb list'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'lexer_name',
                                           'lhs' => 'lexer name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'lexer name',
                                           'rhs' => [
                                                      'single quoted name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'lexer_name',
                                           'lhs' => 'lexer name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'lexer name',
                                           'rhs' => [
                                                      'standard name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'lhs',
                                           'lhs' => 'lhs',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'lhs',
                                           'rhs' => [
                                                      'symbol name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'naming',
                                           'lhs' => 'naming',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'naming',
                                           'rhs' => [
                                                      '[Lex-75]',
                                                      '[Lex-76]',
                                                      'alternative name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'null_adverb',
                                           'lhs' => 'null adverb',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'null adverb',
                                           'rhs' => [
                                                      '[Lex-35]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'null_ranking_constant',
                                           'lhs' => 'null ranking constant',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'null ranking constant',
                                           'rhs' => [
                                                      '[Lex-58]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'null_ranking_constant',
                                           'lhs' => 'null ranking constant',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'null ranking constant',
                                           'rhs' => [
                                                      '[Lex-59]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'null_ranking_specification',
                                           'lhs' => 'null ranking specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'null ranking specification',
                                           'rhs' => [
                                                      '[Lex-53]',
                                                      '[Lex-54]',
                                                      'null ranking constant'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'null_ranking_specification',
                                           'lhs' => 'null ranking specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'null ranking specification',
                                           'rhs' => [
                                                      '[Lex-55]',
                                                      '[Lex-56]',
                                                      '[Lex-57]',
                                                      'null ranking constant'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'null_statement',
                                           'lhs' => 'null statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'null statement',
                                           'rhs' => [
                                                      '[Lex-0]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'nulled_event_declaration',
                                           'lhs' => 'nulled event declaration',
                                           'mask' => [
                                                       0,
                                                       1,
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'nulled event declaration',
                                           'rhs' => [
                                                      '[Lex-19]',
                                                      'event initialization',
                                                      '[Lex-20]',
                                                      '[Lex-21]',
                                                      'symbol name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'on_or_off',
                                           'lhs' => 'on or off',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'on or off',
                                           'rhs' => [
                                                      '[Lex-67]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'on_or_off',
                                           'lhs' => 'on or off',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'on or off',
                                           'rhs' => [
                                                      '[Lex-68]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'op_declare',
                                           'lhs' => 'op declare',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'op declare',
                                           'rhs' => [
                                                      'op declare bnf'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'op_declare',
                                           'lhs' => 'op declare',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'op declare',
                                           'rhs' => [
                                                      'op declare match'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'parenthesized_rhs_primary_list',
                                           'lhs' => 'parenthesized rhs primary list',
                                           'mask' => [
                                                       0,
                                                       1,
                                                       0
                                                     ],
                                           'name' => 'parenthesized rhs primary list',
                                           'rhs' => [
                                                      '[Lex-77]',
                                                      'rhs primary list',
                                                      '[Lex-78]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'pause_specification',
                                           'lhs' => 'pause specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'pause specification',
                                           'rhs' => [
                                                      '[Lex-62]',
                                                      '[Lex-63]',
                                                      'before or after'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'prediction_event_declaration',
                                           'lhs' => 'prediction event declaration',
                                           'mask' => [
                                                       0,
                                                       1,
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'prediction event declaration',
                                           'rhs' => [
                                                      '[Lex-22]',
                                                      'event initialization',
                                                      '[Lex-23]',
                                                      '[Lex-24]',
                                                      'symbol name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'priorities',
                                           'lhs' => 'priorities',
                                           'min' => 1,
                                           'name' => 'priorities',
                                           'proper' => '1',
                                           'rhs' => [
                                                      'alternatives'
                                                    ],
                                           'separator' => 'op loosen'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'priority_rule',
                                           'lhs' => 'priority rule',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'name' => 'priority rule',
                                           'rhs' => [
                                                      'lhs',
                                                      'op declare',
                                                      'priorities'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'priority_specification',
                                           'lhs' => 'priority specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'priority specification',
                                           'rhs' => [
                                                      '[Lex-60]',
                                                      '[Lex-61]',
                                                      'signed integer'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'proper_specification',
                                           'lhs' => 'proper specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'proper specification',
                                           'rhs' => [
                                                      '[Lex-49]',
                                                      '[Lex-50]',
                                                      'boolean'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'quantified_rule',
                                           'lhs' => 'quantified rule',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'name' => 'quantified rule',
                                           'rhs' => [
                                                      'lhs',
                                                      'op declare',
                                                      'single symbol',
                                                      'quantifier',
                                                      'adverb list'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'quantifier',
                                           'lhs' => 'quantifier',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'quantifier',
                                           'rhs' => [
                                                      '[Lex-79]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'quantifier',
                                           'lhs' => 'quantifier',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'quantifier',
                                           'rhs' => [
                                                      '[Lex-80]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'rank_specification',
                                           'lhs' => 'rank specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'rank specification',
                                           'rhs' => [
                                                      '[Lex-51]',
                                                      '[Lex-52]',
                                                      'signed integer'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'rhs',
                                           'lhs' => 'rhs',
                                           'min' => 1,
                                           'name' => 'rhs',
                                           'rhs' => [
                                                      'rhs primary'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'rhs_primary',
                                           'lhs' => 'rhs primary',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'rhs primary',
                                           'rhs' => [
                                                      'parenthesized rhs primary list'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'rhs_primary',
                                           'lhs' => 'rhs primary',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'rhs primary',
                                           'rhs' => [
                                                      'single quoted string'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'rhs_primary',
                                           'lhs' => 'rhs primary',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'rhs primary',
                                           'rhs' => [
                                                      'single symbol'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'rhs_primary_list',
                                           'lhs' => 'rhs primary list',
                                           'min' => 1,
                                           'name' => 'rhs primary list',
                                           'rhs' => [
                                                      'rhs primary'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'right_association',
                                           'lhs' => 'right association',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       0
                                                     ],
                                           'name' => 'right association',
                                           'rhs' => [
                                                      '[Lex-41]',
                                                      '[Lex-42]',
                                                      '[Lex-43]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'separator_specification',
                                           'lhs' => 'separator specification',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'separator specification',
                                           'rhs' => [
                                                      '[Lex-47]',
                                                      '[Lex-48]',
                                                      'single symbol'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'single_symbol',
                                           'lhs' => 'single symbol',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'single symbol',
                                           'rhs' => [
                                                      'character class'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'single_symbol',
                                           'lhs' => 'single symbol',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'single symbol',
                                           'rhs' => [
                                                      'symbol'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'start_rule',
                                           'lhs' => 'start rule',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'start rule',
                                           'rhs' => [
                                                      '[Lex-3]',
                                                      'op declare bnf',
                                                      'symbol'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'start_rule',
                                           'lhs' => 'start rule',
                                           'mask' => [
                                                       0,
                                                       0,
                                                       0,
                                                       1
                                                     ],
                                           'name' => 'start rule',
                                           'rhs' => [
                                                      '[Lex-4]',
                                                      '[Lex-5]',
                                                      '[Lex-6]',
                                                      'symbol'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'statement',
                                           'rhs' => [
                                                      'completion event declaration'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'statement',
                                           'rhs' => [
                                                      'current lexer statement'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'statement',
                                           'rhs' => [
                                                      'default rule'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'statement',
                                           'rhs' => [
                                                      'discard default statement'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'statement',
                                           'rhs' => [
                                                      'discard rule'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'statement',
                                           'rhs' => [
                                                      'empty rule'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'statement',
                                           'rhs' => [
                                                      'inaccessible statement'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'statement',
                                           'rhs' => [
                                                      'lexeme default statement'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'statement',
                                           'rhs' => [
                                                      'lexeme rule'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'statement',
                                           'rhs' => [
                                                      'null statement'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'statement',
                                           'rhs' => [
                                                      'nulled event declaration'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'statement',
                                           'rhs' => [
                                                      'prediction event declaration'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'statement',
                                           'rhs' => [
                                                      'priority rule'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'statement',
                                           'rhs' => [
                                                      'quantified rule'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'statement',
                                           'rhs' => [
                                                      'start rule'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement',
                                           'lhs' => 'statement',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'statement',
                                           'rhs' => [
                                                      'statement group'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statement_group',
                                           'lhs' => 'statement group',
                                           'mask' => [
                                                       0,
                                                       1,
                                                       1
                                                     ],
                                           'name' => 'statement group',
                                           'rhs' => [
                                                      '[Lex-1]',
                                                      'statements',
                                                      '[Lex-2]'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'statements',
                                           'lhs' => 'statements',
                                           'min' => 1,
                                           'name' => 'statements',
                                           'rhs' => [
                                                      'statement'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'symbol',
                                           'lhs' => 'symbol',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'symbol',
                                           'rhs' => [
                                                      'symbol name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'symbol_name',
                                           'lhs' => 'symbol name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'symbol name',
                                           'rhs' => [
                                                      'bare name'
                                                    ]
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'bless' => 'symbol_name',
                                           'lhs' => 'symbol name',
                                           'mask' => [
                                                       1
                                                     ],
                                           'name' => 'symbol name',
                                           'rhs' => [
                                                      'bracketed name'
                                                    ]
                                         }
                                       ],
                               'L0' => [
                                         {
                                           'lhs' => 'Perl identifier',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\w]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'Perl name',
                                           'min' => 1,
                                           'proper' => '1',
                                           'rhs' => [
                                                      'Perl identifier'
                                                    ],
                                           'separator' => 'double colon'
                                         },
                                         {
                                           'description' => 'Discard rule for <hash comment>',
                                           'lhs' => '[:discard]',
                                           'rhs' => [
                                                      'hash comment'
                                                    ]
                                         },
                                         {
                                           'description' => 'Discard rule for <whitespace>',
                                           'lhs' => '[:discard]',
                                           'rhs' => [
                                                      'whitespace'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \';\'',
                                           'lhs' => '[Lex-0]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\;]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=\'',
                                           'lhs' => '[Lex-10]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'discard\'',
                                           'lhs' => '[Lex-11]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[d]]',
                                                      '[[i]]',
                                                      '[[s]]',
                                                      '[[c]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[d]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'default\'',
                                           'lhs' => '[Lex-12]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[d]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[a]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=\'',
                                           'lhs' => '[Lex-13]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \':discard\'',
                                           'lhs' => '[Lex-14]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[d]]',
                                                      '[[i]]',
                                                      '[[s]]',
                                                      '[[c]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[d]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \':lexeme\'',
                                           'lhs' => '[Lex-15]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[x]]',
                                                      '[[e]]',
                                                      '[[m]]',
                                                      '[[e]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'event\'',
                                           'lhs' => '[Lex-16]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[e]]',
                                                      '[[v]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=\'',
                                           'lhs' => '[Lex-17]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'completed\'',
                                           'lhs' => '[Lex-18]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[c]]',
                                                      '[[o]]',
                                                      '[[m]]',
                                                      '[[p]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[t]]',
                                                      '[[e]]',
                                                      '[[d]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'event\'',
                                           'lhs' => '[Lex-19]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[e]]',
                                                      '[[v]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'{\'',
                                           'lhs' => '[Lex-1]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\{]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=\'',
                                           'lhs' => '[Lex-20]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'nulled\'',
                                           'lhs' => '[Lex-21]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[d]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'event\'',
                                           'lhs' => '[Lex-22]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[e]]',
                                                      '[[v]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=\'',
                                           'lhs' => '[Lex-23]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'predicted\'',
                                           'lhs' => '[Lex-24]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[p]]',
                                                      '[[r]]',
                                                      '[[e]]',
                                                      '[[d]]',
                                                      '[[i]]',
                                                      '[[c]]',
                                                      '[[t]]',
                                                      '[[e]]',
                                                      '[[d]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'current\'',
                                           'lhs' => '[Lex-25]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[c]]',
                                                      '[[u]]',
                                                      '[[r]]',
                                                      '[[r]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'lexer\'',
                                           'lhs' => '[Lex-26]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[x]]',
                                                      '[[e]]',
                                                      '[[r]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'is\'',
                                           'lhs' => '[Lex-27]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[i]]',
                                                      '[[s]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'inaccessible\'',
                                           'lhs' => '[Lex-28]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[i]]',
                                                      '[[n]]',
                                                      '[[a]]',
                                                      '[[c]]',
                                                      '[[c]]',
                                                      '[[e]]',
                                                      '[[s]]',
                                                      '[[s]]',
                                                      '[[i]]',
                                                      '[[b]]',
                                                      '[[l]]',
                                                      '[[e]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'is\'',
                                           'lhs' => '[Lex-29]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[i]]',
                                                      '[[s]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'}\'',
                                           'lhs' => '[Lex-2]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\}]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'by\'',
                                           'lhs' => '[Lex-30]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[b]]',
                                                      '[[y]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'default\'',
                                           'lhs' => '[Lex-31]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[d]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[a]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'warn\'',
                                           'lhs' => '[Lex-32]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[w]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[n]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'ok\'',
                                           'lhs' => '[Lex-33]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[o]]',
                                                      '[[k]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'fatal\'',
                                           'lhs' => '[Lex-34]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[f]]',
                                                      '[[a]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[l]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \',\'',
                                           'lhs' => '[Lex-35]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\,]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'action\'',
                                           'lhs' => '[Lex-36]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[c]]',
                                                      '[[t]]',
                                                      '[[i]]',
                                                      '[[o]]',
                                                      '[[n]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-37]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'assoc\'',
                                           'lhs' => '[Lex-38]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[s]]',
                                                      '[[s]]',
                                                      '[[o]]',
                                                      '[[c]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-39]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \':start\'',
                                           'lhs' => '[Lex-3]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[s]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'left\'',
                                           'lhs' => '[Lex-40]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'assoc\'',
                                           'lhs' => '[Lex-41]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[s]]',
                                                      '[[s]]',
                                                      '[[o]]',
                                                      '[[c]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-42]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'right\'',
                                           'lhs' => '[Lex-43]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[r]]',
                                                      '[[i]]',
                                                      '[[g]]',
                                                      '[[h]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'assoc\'',
                                           'lhs' => '[Lex-44]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[s]]',
                                                      '[[s]]',
                                                      '[[o]]',
                                                      '[[c]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-45]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'group\'',
                                           'lhs' => '[Lex-46]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[g]]',
                                                      '[[r]]',
                                                      '[[o]]',
                                                      '[[u]]',
                                                      '[[p]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'separator\'',
                                           'lhs' => '[Lex-47]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[e]]',
                                                      '[[p]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[a]]',
                                                      '[[t]]',
                                                      '[[o]]',
                                                      '[[r]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-48]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'proper\'',
                                           'lhs' => '[Lex-49]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[p]]',
                                                      '[[r]]',
                                                      '[[o]]',
                                                      '[[p]]',
                                                      '[[e]]',
                                                      '[[r]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'start\'',
                                           'lhs' => '[Lex-4]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-50]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'rank\'',
                                           'lhs' => '[Lex-51]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[r]]',
                                                      '[[a]]',
                                                      '[[n]]',
                                                      '[[k]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-52]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'null-ranking\'',
                                           'lhs' => '[Lex-53]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[l]]',
                                                      '[[\\-]]',
                                                      '[[r]]',
                                                      '[[a]]',
                                                      '[[n]]',
                                                      '[[k]]',
                                                      '[[i]]',
                                                      '[[n]]',
                                                      '[[g]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-54]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'null\'',
                                           'lhs' => '[Lex-55]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[l]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'rank\'',
                                           'lhs' => '[Lex-56]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[r]]',
                                                      '[[a]]',
                                                      '[[n]]',
                                                      '[[k]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-57]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'low\'',
                                           'lhs' => '[Lex-58]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[o]]',
                                                      '[[w]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'high\'',
                                           'lhs' => '[Lex-59]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[h]]',
                                                      '[[i]]',
                                                      '[[g]]',
                                                      '[[h]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'symbol\'',
                                           'lhs' => '[Lex-5]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[y]]',
                                                      '[[m]]',
                                                      '[[b]]',
                                                      '[[o]]',
                                                      '[[l]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'priority\'',
                                           'lhs' => '[Lex-60]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[p]]',
                                                      '[[r]]',
                                                      '[[i]]',
                                                      '[[o]]',
                                                      '[[r]]',
                                                      '[[i]]',
                                                      '[[t]]',
                                                      '[[y]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-61]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'pause\'',
                                           'lhs' => '[Lex-62]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[p]]',
                                                      '[[a]]',
                                                      '[[u]]',
                                                      '[[s]]',
                                                      '[[e]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-63]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'event\'',
                                           'lhs' => '[Lex-64]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[e]]',
                                                      '[[v]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-65]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=\'',
                                           'lhs' => '[Lex-66]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'on\'',
                                           'lhs' => '[Lex-67]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[o]]',
                                                      '[[n]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'off\'',
                                           'lhs' => '[Lex-68]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[o]]',
                                                      '[[f]]',
                                                      '[[f]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'forgiving\'',
                                           'lhs' => '[Lex-69]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[f]]',
                                                      '[[o]]',
                                                      '[[r]]',
                                                      '[[g]]',
                                                      '[[i]]',
                                                      '[[v]]',
                                                      '[[i]]',
                                                      '[[n]]',
                                                      '[[g]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'is\'',
                                           'lhs' => '[Lex-6]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[i]]',
                                                      '[[s]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-70]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'latm\'',
                                           'lhs' => '[Lex-71]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[a]]',
                                                      '[[t]]',
                                                      '[[m]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-72]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'bless\'',
                                           'lhs' => '[Lex-73]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[b]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[s]]',
                                                      '[[s]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-74]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'name\'',
                                           'lhs' => '[Lex-75]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[a]]',
                                                      '[[m]]',
                                                      '[[e]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'=>\'',
                                           'lhs' => '[Lex-76]',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'(\'',
                                           'lhs' => '[Lex-77]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\(]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \')\'',
                                           'lhs' => '[Lex-78]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\)]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'*\'',
                                           'lhs' => '[Lex-79]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\*]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \':default\'',
                                           'lhs' => '[Lex-7]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[d]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[a]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'+\'',
                                           'lhs' => '[Lex-80]',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\+]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'lexeme\'',
                                           'lhs' => '[Lex-8]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[x]]',
                                                      '[[e]]',
                                                      '[[m]]',
                                                      '[[e]]'
                                                    ]
                                         },
                                         {
                                           'description' => 'Internal rule for single-quoted string \'default\'',
                                           'lhs' => '[Lex-9]',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[d]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[a]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'array descriptor',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'array descriptor left bracket',
                                                      'result item descriptor list',
                                                      'array descriptor right bracket'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'array descriptor left bracket',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\[]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'array descriptor left bracket',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\[]]',
                                                      'whitespace'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'array descriptor right bracket',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\]]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'array descriptor right bracket',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'whitespace',
                                                      '[[\\]]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'bare name',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\w]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'before or after',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[f]]',
                                                      '[[t]]',
                                                      '[[e]]',
                                                      '[[r]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'before or after',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[b]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[o]]',
                                                      '[[r]]',
                                                      '[[e]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'boolean',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[01]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'bracketed name',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\<]]',
                                                      'bracketed name string',
                                                      '[[\\>]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'bracketed name string',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\s\\w]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'cc element',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'escaped cc character'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'cc element',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'negated posix char class'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'cc element',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'posix char class'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'cc element',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'safe cc character'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'cc elements',
                                           'min' => 1,
                                           'rhs' => [
                                                      'cc element'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'character class',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\[]]',
                                                      'cc elements',
                                                      '[[\\]]]',
                                                      'character class modifiers'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'character class modifier',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[i]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'character class modifier',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[i]]',
                                                      '[[c]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'character class modifiers',
                                           'min' => 0,
                                           'rhs' => [
                                                      'character class modifier'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'double colon',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[\\:]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'escaped cc character',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\\\]]',
                                                      'horizontal character'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'hash comment',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'terminated hash comment'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'hash comment',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'unterminated final hash comment'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'hash comment body',
                                           'min' => 0,
                                           'rhs' => [
                                                      'hash comment char'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'hash comment char',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'horizontal character',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'integer',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\d]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'negated posix char class',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\[]]',
                                                      '[[\\:]]',
                                                      '[[\\^]]',
                                                      'posix char class name',
                                                      '[[\\:]]',
                                                      '[[\\]]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'one or more word characters',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\w]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'op declare bnf',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[\\:]]',
                                                      '[[\\=]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'op declare match',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\~]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'op equal priority',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\|]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'op loosen',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\|]]',
                                                      '[[\\|]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'posix char class',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\[]]',
                                                      '[[\\:]]',
                                                      'posix char class name',
                                                      '[[\\:]]',
                                                      '[[\\]]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'posix char class name',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[[:alnum:]]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'reserved action name',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[\\:]]',
                                                      'one or more word characters'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'reserved blessing name',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[\\:]]',
                                                      'one or more word characters'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'reserved event name',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[s]]',
                                                      '[[y]]',
                                                      '[[m]]',
                                                      '[[b]]',
                                                      '[[o]]',
                                                      '[[l]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[h]]',
                                                      '[[s]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[a]]',
                                                      '[[m]]',
                                                      '[[e]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[r]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[e]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[v]]',
                                                      '[[a]]',
                                                      '[[l]]',
                                                      '[[u]]',
                                                      '[[e]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[g]]',
                                                      '[[t]]',
                                                      '[[h]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[y]]',
                                                      '[[m]]',
                                                      '[[b]]',
                                                      '[[o]]',
                                                      '[[l]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[v]]',
                                                      '[[a]]',
                                                      '[[l]]',
                                                      '[[u]]',
                                                      '[[e]]',
                                                      '[[s]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[g]]',
                                                      '[[1]]',
                                                      '[[s]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[t]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[g]]',
                                                      '[[1]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[g]]',
                                                      '[[t]]',
                                                      '[[h]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor list',
                                           'min' => 0,
                                           'rhs' => [
                                                      'result item descriptor'
                                                    ],
                                           'separator' => 'result item descriptor separator'
                                         },
                                         {
                                           'lhs' => 'result item descriptor separator',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[,]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'result item descriptor separator',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[,]]',
                                                      'whitespace'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'safe cc character',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'sign',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[+-]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'signed integer',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'integer'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'signed integer',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      'sign',
                                                      'integer'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'single quoted name',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\']]',
                                                      'string without single quote or vertical space',
                                                      '[[\']]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'single quoted string',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\']]',
                                                      'string without single quote or vertical space',
                                                      '[[\']]',
                                                      'character class modifiers'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'standard name',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[a-zA-Z]]',
                                                      'zero or more word characters'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'string without single quote or vertical space',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'terminated hash comment',
                                           'mask' => [
                                                       1,
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\#]]',
                                                      'hash comment body',
                                                      'vertical space char'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'unterminated final hash comment',
                                           'mask' => [
                                                       1,
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\#]]',
                                                      'hash comment body'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'vertical space char',
                                           'mask' => [
                                                       1
                                                     ],
                                           'rhs' => [
                                                      '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'whitespace',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\s]]'
                                                    ]
                                         },
                                         {
                                           'lhs' => 'zero or more word characters',
                                           'min' => 0,
                                           'rhs' => [
                                                      '[[\\w]]'
                                                    ]
                                         }
                                       ]
                             },
                  'start_lhs' => 'statements',
                  'symbols' => {
                                 'G1' => {
                                           '[Lex-0]' => {
                                                          'description' => 'Internal lexical symbol for "\';\'"',
                                                          'display_form' => '\';\'',
                                                          'dsl_form' => '\';\''
                                                        },
                                           '[Lex-10]' => {
                                                           'description' => 'Internal lexical symbol for "\'=\'"',
                                                           'display_form' => '\'=\'',
                                                           'dsl_form' => '\'=\''
                                                         },
                                           '[Lex-11]' => {
                                                           'description' => 'Internal lexical symbol for "\'discard\'"',
                                                           'display_form' => '\'discard\'',
                                                           'dsl_form' => '\'discard\''
                                                         },
                                           '[Lex-12]' => {
                                                           'description' => 'Internal lexical symbol for "\'default\'"',
                                                           'display_form' => '\'default\'',
                                                           'dsl_form' => '\'default\''
                                                         },
                                           '[Lex-13]' => {
                                                           'description' => 'Internal lexical symbol for "\'=\'"',
                                                           'display_form' => '\'=\'',
                                                           'dsl_form' => '\'=\''
                                                         },
                                           '[Lex-14]' => {
                                                           'description' => 'Internal lexical symbol for "\':discard\'"',
                                                           'display_form' => '\':discard\'',
                                                           'dsl_form' => '\':discard\''
                                                         },
                                           '[Lex-15]' => {
                                                           'description' => 'Internal lexical symbol for "\':lexeme\'"',
                                                           'display_form' => '\':lexeme\'',
                                                           'dsl_form' => '\':lexeme\''
                                                         },
                                           '[Lex-16]' => {
                                                           'description' => 'Internal lexical symbol for "\'event\'"',
                                                           'display_form' => '\'event\'',
                                                           'dsl_form' => '\'event\''
                                                         },
                                           '[Lex-17]' => {
                                                           'description' => 'Internal lexical symbol for "\'=\'"',
                                                           'display_form' => '\'=\'',
                                                           'dsl_form' => '\'=\''
                                                         },
                                           '[Lex-18]' => {
                                                           'description' => 'Internal lexical symbol for "\'completed\'"',
                                                           'display_form' => '\'completed\'',
                                                           'dsl_form' => '\'completed\''
                                                         },
                                           '[Lex-19]' => {
                                                           'description' => 'Internal lexical symbol for "\'event\'"',
                                                           'display_form' => '\'event\'',
                                                           'dsl_form' => '\'event\''
                                                         },
                                           '[Lex-1]' => {
                                                          'description' => 'Internal lexical symbol for "\'{\'"',
                                                          'display_form' => '\'{\'',
                                                          'dsl_form' => '\'{\''
                                                        },
                                           '[Lex-20]' => {
                                                           'description' => 'Internal lexical symbol for "\'=\'"',
                                                           'display_form' => '\'=\'',
                                                           'dsl_form' => '\'=\''
                                                         },
                                           '[Lex-21]' => {
                                                           'description' => 'Internal lexical symbol for "\'nulled\'"',
                                                           'display_form' => '\'nulled\'',
                                                           'dsl_form' => '\'nulled\''
                                                         },
                                           '[Lex-22]' => {
                                                           'description' => 'Internal lexical symbol for "\'event\'"',
                                                           'display_form' => '\'event\'',
                                                           'dsl_form' => '\'event\''
                                                         },
                                           '[Lex-23]' => {
                                                           'description' => 'Internal lexical symbol for "\'=\'"',
                                                           'display_form' => '\'=\'',
                                                           'dsl_form' => '\'=\''
                                                         },
                                           '[Lex-24]' => {
                                                           'description' => 'Internal lexical symbol for "\'predicted\'"',
                                                           'display_form' => '\'predicted\'',
                                                           'dsl_form' => '\'predicted\''
                                                         },
                                           '[Lex-25]' => {
                                                           'description' => 'Internal lexical symbol for "\'current\'"',
                                                           'display_form' => '\'current\'',
                                                           'dsl_form' => '\'current\''
                                                         },
                                           '[Lex-26]' => {
                                                           'description' => 'Internal lexical symbol for "\'lexer\'"',
                                                           'display_form' => '\'lexer\'',
                                                           'dsl_form' => '\'lexer\''
                                                         },
                                           '[Lex-27]' => {
                                                           'description' => 'Internal lexical symbol for "\'is\'"',
                                                           'display_form' => '\'is\'',
                                                           'dsl_form' => '\'is\''
                                                         },
                                           '[Lex-28]' => {
                                                           'description' => 'Internal lexical symbol for "\'inaccessible\'"',
                                                           'display_form' => '\'inaccessible\'',
                                                           'dsl_form' => '\'inaccessible\''
                                                         },
                                           '[Lex-29]' => {
                                                           'description' => 'Internal lexical symbol for "\'is\'"',
                                                           'display_form' => '\'is\'',
                                                           'dsl_form' => '\'is\''
                                                         },
                                           '[Lex-2]' => {
                                                          'description' => 'Internal lexical symbol for "\'}\'"',
                                                          'display_form' => '\'}\'',
                                                          'dsl_form' => '\'}\''
                                                        },
                                           '[Lex-30]' => {
                                                           'description' => 'Internal lexical symbol for "\'by\'"',
                                                           'display_form' => '\'by\'',
                                                           'dsl_form' => '\'by\''
                                                         },
                                           '[Lex-31]' => {
                                                           'description' => 'Internal lexical symbol for "\'default\'"',
                                                           'display_form' => '\'default\'',
                                                           'dsl_form' => '\'default\''
                                                         },
                                           '[Lex-32]' => {
                                                           'description' => 'Internal lexical symbol for "\'warn\'"',
                                                           'display_form' => '\'warn\'',
                                                           'dsl_form' => '\'warn\''
                                                         },
                                           '[Lex-33]' => {
                                                           'description' => 'Internal lexical symbol for "\'ok\'"',
                                                           'display_form' => '\'ok\'',
                                                           'dsl_form' => '\'ok\''
                                                         },
                                           '[Lex-34]' => {
                                                           'description' => 'Internal lexical symbol for "\'fatal\'"',
                                                           'display_form' => '\'fatal\'',
                                                           'dsl_form' => '\'fatal\''
                                                         },
                                           '[Lex-35]' => {
                                                           'description' => 'Internal lexical symbol for "\',\'"',
                                                           'display_form' => '\',\'',
                                                           'dsl_form' => '\',\''
                                                         },
                                           '[Lex-36]' => {
                                                           'description' => 'Internal lexical symbol for "\'action\'"',
                                                           'display_form' => '\'action\'',
                                                           'dsl_form' => '\'action\''
                                                         },
                                           '[Lex-37]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-38]' => {
                                                           'description' => 'Internal lexical symbol for "\'assoc\'"',
                                                           'display_form' => '\'assoc\'',
                                                           'dsl_form' => '\'assoc\''
                                                         },
                                           '[Lex-39]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-3]' => {
                                                          'description' => 'Internal lexical symbol for "\':start\'"',
                                                          'display_form' => '\':start\'',
                                                          'dsl_form' => '\':start\''
                                                        },
                                           '[Lex-40]' => {
                                                           'description' => 'Internal lexical symbol for "\'left\'"',
                                                           'display_form' => '\'left\'',
                                                           'dsl_form' => '\'left\''
                                                         },
                                           '[Lex-41]' => {
                                                           'description' => 'Internal lexical symbol for "\'assoc\'"',
                                                           'display_form' => '\'assoc\'',
                                                           'dsl_form' => '\'assoc\''
                                                         },
                                           '[Lex-42]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-43]' => {
                                                           'description' => 'Internal lexical symbol for "\'right\'"',
                                                           'display_form' => '\'right\'',
                                                           'dsl_form' => '\'right\''
                                                         },
                                           '[Lex-44]' => {
                                                           'description' => 'Internal lexical symbol for "\'assoc\'"',
                                                           'display_form' => '\'assoc\'',
                                                           'dsl_form' => '\'assoc\''
                                                         },
                                           '[Lex-45]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-46]' => {
                                                           'description' => 'Internal lexical symbol for "\'group\'"',
                                                           'display_form' => '\'group\'',
                                                           'dsl_form' => '\'group\''
                                                         },
                                           '[Lex-47]' => {
                                                           'description' => 'Internal lexical symbol for "\'separator\'"',
                                                           'display_form' => '\'separator\'',
                                                           'dsl_form' => '\'separator\''
                                                         },
                                           '[Lex-48]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-49]' => {
                                                           'description' => 'Internal lexical symbol for "\'proper\'"',
                                                           'display_form' => '\'proper\'',
                                                           'dsl_form' => '\'proper\''
                                                         },
                                           '[Lex-4]' => {
                                                          'description' => 'Internal lexical symbol for "\'start\'"',
                                                          'display_form' => '\'start\'',
                                                          'dsl_form' => '\'start\''
                                                        },
                                           '[Lex-50]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-51]' => {
                                                           'description' => 'Internal lexical symbol for "\'rank\'"',
                                                           'display_form' => '\'rank\'',
                                                           'dsl_form' => '\'rank\''
                                                         },
                                           '[Lex-52]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-53]' => {
                                                           'description' => 'Internal lexical symbol for "\'null-ranking\'"',
                                                           'display_form' => '\'null-ranking\'',
                                                           'dsl_form' => '\'null-ranking\''
                                                         },
                                           '[Lex-54]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-55]' => {
                                                           'description' => 'Internal lexical symbol for "\'null\'"',
                                                           'display_form' => '\'null\'',
                                                           'dsl_form' => '\'null\''
                                                         },
                                           '[Lex-56]' => {
                                                           'description' => 'Internal lexical symbol for "\'rank\'"',
                                                           'display_form' => '\'rank\'',
                                                           'dsl_form' => '\'rank\''
                                                         },
                                           '[Lex-57]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-58]' => {
                                                           'description' => 'Internal lexical symbol for "\'low\'"',
                                                           'display_form' => '\'low\'',
                                                           'dsl_form' => '\'low\''
                                                         },
                                           '[Lex-59]' => {
                                                           'description' => 'Internal lexical symbol for "\'high\'"',
                                                           'display_form' => '\'high\'',
                                                           'dsl_form' => '\'high\''
                                                         },
                                           '[Lex-5]' => {
                                                          'description' => 'Internal lexical symbol for "\'symbol\'"',
                                                          'display_form' => '\'symbol\'',
                                                          'dsl_form' => '\'symbol\''
                                                        },
                                           '[Lex-60]' => {
                                                           'description' => 'Internal lexical symbol for "\'priority\'"',
                                                           'display_form' => '\'priority\'',
                                                           'dsl_form' => '\'priority\''
                                                         },
                                           '[Lex-61]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-62]' => {
                                                           'description' => 'Internal lexical symbol for "\'pause\'"',
                                                           'display_form' => '\'pause\'',
                                                           'dsl_form' => '\'pause\''
                                                         },
                                           '[Lex-63]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-64]' => {
                                                           'description' => 'Internal lexical symbol for "\'event\'"',
                                                           'display_form' => '\'event\'',
                                                           'dsl_form' => '\'event\''
                                                         },
                                           '[Lex-65]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-66]' => {
                                                           'description' => 'Internal lexical symbol for "\'=\'"',
                                                           'display_form' => '\'=\'',
                                                           'dsl_form' => '\'=\''
                                                         },
                                           '[Lex-67]' => {
                                                           'description' => 'Internal lexical symbol for "\'on\'"',
                                                           'display_form' => '\'on\'',
                                                           'dsl_form' => '\'on\''
                                                         },
                                           '[Lex-68]' => {
                                                           'description' => 'Internal lexical symbol for "\'off\'"',
                                                           'display_form' => '\'off\'',
                                                           'dsl_form' => '\'off\''
                                                         },
                                           '[Lex-69]' => {
                                                           'description' => 'Internal lexical symbol for "\'forgiving\'"',
                                                           'display_form' => '\'forgiving\'',
                                                           'dsl_form' => '\'forgiving\''
                                                         },
                                           '[Lex-6]' => {
                                                          'description' => 'Internal lexical symbol for "\'is\'"',
                                                          'display_form' => '\'is\'',
                                                          'dsl_form' => '\'is\''
                                                        },
                                           '[Lex-70]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-71]' => {
                                                           'description' => 'Internal lexical symbol for "\'latm\'"',
                                                           'display_form' => '\'latm\'',
                                                           'dsl_form' => '\'latm\''
                                                         },
                                           '[Lex-72]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-73]' => {
                                                           'description' => 'Internal lexical symbol for "\'bless\'"',
                                                           'display_form' => '\'bless\'',
                                                           'dsl_form' => '\'bless\''
                                                         },
                                           '[Lex-74]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-75]' => {
                                                           'description' => 'Internal lexical symbol for "\'name\'"',
                                                           'display_form' => '\'name\'',
                                                           'dsl_form' => '\'name\''
                                                         },
                                           '[Lex-76]' => {
                                                           'description' => 'Internal lexical symbol for "\'=>\'"',
                                                           'display_form' => '\'=>\'',
                                                           'dsl_form' => '\'=>\''
                                                         },
                                           '[Lex-77]' => {
                                                           'description' => 'Internal lexical symbol for "\'(\'"',
                                                           'display_form' => '\'(\'',
                                                           'dsl_form' => '\'(\''
                                                         },
                                           '[Lex-78]' => {
                                                           'description' => 'Internal lexical symbol for "\')\'"',
                                                           'display_form' => '\')\'',
                                                           'dsl_form' => '\')\''
                                                         },
                                           '[Lex-79]' => {
                                                           'description' => 'Internal lexical symbol for "\'*\'"',
                                                           'display_form' => '\'*\'',
                                                           'dsl_form' => '\'*\''
                                                         },
                                           '[Lex-7]' => {
                                                          'description' => 'Internal lexical symbol for "\':default\'"',
                                                          'display_form' => '\':default\'',
                                                          'dsl_form' => '\':default\''
                                                        },
                                           '[Lex-80]' => {
                                                           'description' => 'Internal lexical symbol for "\'+\'"',
                                                           'display_form' => '\'+\'',
                                                           'dsl_form' => '\'+\''
                                                         },
                                           '[Lex-8]' => {
                                                          'description' => 'Internal lexical symbol for "\'lexeme\'"',
                                                          'display_form' => '\'lexeme\'',
                                                          'dsl_form' => '\'lexeme\''
                                                        },
                                           '[Lex-9]' => {
                                                          'description' => 'Internal lexical symbol for "\'default\'"',
                                                          'display_form' => '\'default\'',
                                                          'dsl_form' => '\'default\''
                                                        }
                                         },
                                 'L' => {
                                          '[:discard]' => {
                                                            'description' => 'Internal LHS for lexer "L0" discard',
                                                            'display_form' => ':discard'
                                                          },
                                          '[Lex-0]' => {
                                                         'description' => 'Internal lexical symbol for "\';\'"',
                                                         'display_form' => '\';\'',
                                                         'dsl_form' => '\';\''
                                                       },
                                          '[Lex-10]' => {
                                                          'description' => 'Internal lexical symbol for "\'=\'"',
                                                          'display_form' => '\'=\'',
                                                          'dsl_form' => '\'=\''
                                                        },
                                          '[Lex-11]' => {
                                                          'description' => 'Internal lexical symbol for "\'discard\'"',
                                                          'display_form' => '\'discard\'',
                                                          'dsl_form' => '\'discard\''
                                                        },
                                          '[Lex-12]' => {
                                                          'description' => 'Internal lexical symbol for "\'default\'"',
                                                          'display_form' => '\'default\'',
                                                          'dsl_form' => '\'default\''
                                                        },
                                          '[Lex-13]' => {
                                                          'description' => 'Internal lexical symbol for "\'=\'"',
                                                          'display_form' => '\'=\'',
                                                          'dsl_form' => '\'=\''
                                                        },
                                          '[Lex-14]' => {
                                                          'description' => 'Internal lexical symbol for "\':discard\'"',
                                                          'display_form' => '\':discard\'',
                                                          'dsl_form' => '\':discard\''
                                                        },
                                          '[Lex-15]' => {
                                                          'description' => 'Internal lexical symbol for "\':lexeme\'"',
                                                          'display_form' => '\':lexeme\'',
                                                          'dsl_form' => '\':lexeme\''
                                                        },
                                          '[Lex-16]' => {
                                                          'description' => 'Internal lexical symbol for "\'event\'"',
                                                          'display_form' => '\'event\'',
                                                          'dsl_form' => '\'event\''
                                                        },
                                          '[Lex-17]' => {
                                                          'description' => 'Internal lexical symbol for "\'=\'"',
                                                          'display_form' => '\'=\'',
                                                          'dsl_form' => '\'=\''
                                                        },
                                          '[Lex-18]' => {
                                                          'description' => 'Internal lexical symbol for "\'completed\'"',
                                                          'display_form' => '\'completed\'',
                                                          'dsl_form' => '\'completed\''
                                                        },
                                          '[Lex-19]' => {
                                                          'description' => 'Internal lexical symbol for "\'event\'"',
                                                          'display_form' => '\'event\'',
                                                          'dsl_form' => '\'event\''
                                                        },
                                          '[Lex-1]' => {
                                                         'description' => 'Internal lexical symbol for "\'{\'"',
                                                         'display_form' => '\'{\'',
                                                         'dsl_form' => '\'{\''
                                                       },
                                          '[Lex-20]' => {
                                                          'description' => 'Internal lexical symbol for "\'=\'"',
                                                          'display_form' => '\'=\'',
                                                          'dsl_form' => '\'=\''
                                                        },
                                          '[Lex-21]' => {
                                                          'description' => 'Internal lexical symbol for "\'nulled\'"',
                                                          'display_form' => '\'nulled\'',
                                                          'dsl_form' => '\'nulled\''
                                                        },
                                          '[Lex-22]' => {
                                                          'description' => 'Internal lexical symbol for "\'event\'"',
                                                          'display_form' => '\'event\'',
                                                          'dsl_form' => '\'event\''
                                                        },
                                          '[Lex-23]' => {
                                                          'description' => 'Internal lexical symbol for "\'=\'"',
                                                          'display_form' => '\'=\'',
                                                          'dsl_form' => '\'=\''
                                                        },
                                          '[Lex-24]' => {
                                                          'description' => 'Internal lexical symbol for "\'predicted\'"',
                                                          'display_form' => '\'predicted\'',
                                                          'dsl_form' => '\'predicted\''
                                                        },
                                          '[Lex-25]' => {
                                                          'description' => 'Internal lexical symbol for "\'current\'"',
                                                          'display_form' => '\'current\'',
                                                          'dsl_form' => '\'current\''
                                                        },
                                          '[Lex-26]' => {
                                                          'description' => 'Internal lexical symbol for "\'lexer\'"',
                                                          'display_form' => '\'lexer\'',
                                                          'dsl_form' => '\'lexer\''
                                                        },
                                          '[Lex-27]' => {
                                                          'description' => 'Internal lexical symbol for "\'is\'"',
                                                          'display_form' => '\'is\'',
                                                          'dsl_form' => '\'is\''
                                                        },
                                          '[Lex-28]' => {
                                                          'description' => 'Internal lexical symbol for "\'inaccessible\'"',
                                                          'display_form' => '\'inaccessible\'',
                                                          'dsl_form' => '\'inaccessible\''
                                                        },
                                          '[Lex-29]' => {
                                                          'description' => 'Internal lexical symbol for "\'is\'"',
                                                          'display_form' => '\'is\'',
                                                          'dsl_form' => '\'is\''
                                                        },
                                          '[Lex-2]' => {
                                                         'description' => 'Internal lexical symbol for "\'}\'"',
                                                         'display_form' => '\'}\'',
                                                         'dsl_form' => '\'}\''
                                                       },
                                          '[Lex-30]' => {
                                                          'description' => 'Internal lexical symbol for "\'by\'"',
                                                          'display_form' => '\'by\'',
                                                          'dsl_form' => '\'by\''
                                                        },
                                          '[Lex-31]' => {
                                                          'description' => 'Internal lexical symbol for "\'default\'"',
                                                          'display_form' => '\'default\'',
                                                          'dsl_form' => '\'default\''
                                                        },
                                          '[Lex-32]' => {
                                                          'description' => 'Internal lexical symbol for "\'warn\'"',
                                                          'display_form' => '\'warn\'',
                                                          'dsl_form' => '\'warn\''
                                                        },
                                          '[Lex-33]' => {
                                                          'description' => 'Internal lexical symbol for "\'ok\'"',
                                                          'display_form' => '\'ok\'',
                                                          'dsl_form' => '\'ok\''
                                                        },
                                          '[Lex-34]' => {
                                                          'description' => 'Internal lexical symbol for "\'fatal\'"',
                                                          'display_form' => '\'fatal\'',
                                                          'dsl_form' => '\'fatal\''
                                                        },
                                          '[Lex-35]' => {
                                                          'description' => 'Internal lexical symbol for "\',\'"',
                                                          'display_form' => '\',\'',
                                                          'dsl_form' => '\',\''
                                                        },
                                          '[Lex-36]' => {
                                                          'description' => 'Internal lexical symbol for "\'action\'"',
                                                          'display_form' => '\'action\'',
                                                          'dsl_form' => '\'action\''
                                                        },
                                          '[Lex-37]' => {
                                                          'description' => 'Internal lexical symbol for "\'=>\'"',
                                                          'display_form' => '\'=>\'',
                                                          'dsl_form' => '\'=>\''
                                                        },
                                          '[Lex-38]' => {
                                                          'description' => 'Internal lexical symbol for "\'assoc\'"',
                                                          'display_form' => '\'assoc\'',
                                                          'dsl_form' => '\'assoc\''
                                                        },
                                          '[Lex-39]' => {
                                                          'description' => 'Internal lexical symbol for "\'=>\'"',
                                                          'display_form' => '\'=>\'',
                                                          'dsl_form' => '\'=>\''
                                                        },
                                          '[Lex-3]' => {
                                                         'description' => 'Internal lexical symbol for "\':start\'"',
                                                         'display_form' => '\':start\'',
                                                         'dsl_form' => '\':start\''
                                                       },
                                          '[Lex-40]' => {
                                                          'description' => 'Internal lexical symbol for "\'left\'"',
                                                          'display_form' => '\'left\'',
                                                          'dsl_form' => '\'left\''
                                                        },
                                          '[Lex-41]' => {
                                                          'description' => 'Internal lexical symbol for "\'assoc\'"',
                                                          'display_form' => '\'assoc\'',
                                                          'dsl_form' => '\'assoc\''
                                                        },
                                          '[Lex-42]' => {
                                                          'description' => 'Internal lexical symbol for "\'=>\'"',
                                                          'display_form' => '\'=>\'',
                                                          'dsl_form' => '\'=>\''
                                                        },
                                          '[Lex-43]' => {
                                                          'description' => 'Internal lexical symbol for "\'right\'"',
                                                          'display_form' => '\'right\'',
                                                          'dsl_form' => '\'right\''
                                                        },
                                          '[Lex-44]' => {
                                                          'description' => 'Internal lexical symbol for "\'assoc\'"',
                                                          'display_form' => '\'assoc\'',
                                                          'dsl_form' => '\'assoc\''
                                                        },
                                          '[Lex-45]' => {
                                                          'description' => 'Internal lexical symbol for "\'=>\'"',
                                                          'display_form' => '\'=>\'',
                                                          'dsl_form' => '\'=>\''
                                                        },
                                          '[Lex-46]' => {
                                                          'description' => 'Internal lexical symbol for "\'group\'"',
                                                          'display_form' => '\'group\'',
                                                          'dsl_form' => '\'group\''
                                                        },
                                          '[Lex-47]' => {
                                                          'description' => 'Internal lexical symbol for "\'separator\'"',
                                                          'display_form' => '\'separator\'',
                                                          'dsl_form' => '\'separator\''
                                                        },
                                          '[Lex-48]' => {
                                                          'description' => 'Internal lexical symbol for "\'=>\'"',
                                                          'display_form' => '\'=>\'',
                                                          'dsl_form' => '\'=>\''
                                                        },
                                          '[Lex-49]' => {
                                                          'description' => 'Internal lexical symbol for "\'proper\'"',
                                                          'display_form' => '\'proper\'',
                                                          'dsl_form' => '\'proper\''
                                                        },
                                          '[Lex-4]' => {
                                                         'description' => 'Internal lexical symbol for "\'start\'"',
                                                         'display_form' => '\'start\'',
                                                         'dsl_form' => '\'start\''
                                                       },
                                          '[Lex-50]' => {
                                                          'description' => 'Internal lexical symbol for "\'=>\'"',
                                                          'display_form' => '\'=>\'',
                                                          'dsl_form' => '\'=>\''
                                                        },
                                          '[Lex-51]' => {
                                                          'description' => 'Internal lexical symbol for "\'rank\'"',
                                                          'display_form' => '\'rank\'',
                                                          'dsl_form' => '\'rank\''
                                                        },
                                          '[Lex-52]' => {
                                                          'description' => 'Internal lexical symbol for "\'=>\'"',
                                                          'display_form' => '\'=>\'',
                                                          'dsl_form' => '\'=>\''
                                                        },
                                          '[Lex-53]' => {
                                                          'description' => 'Internal lexical symbol for "\'null-ranking\'"',
                                                          'display_form' => '\'null-ranking\'',
                                                          'dsl_form' => '\'null-ranking\''
                                                        },
                                          '[Lex-54]' => {
                                                          'description' => 'Internal lexical symbol for "\'=>\'"',
                                                          'display_form' => '\'=>\'',
                                                          'dsl_form' => '\'=>\''
                                                        },
                                          '[Lex-55]' => {
                                                          'description' => 'Internal lexical symbol for "\'null\'"',
                                                          'display_form' => '\'null\'',
                                                          'dsl_form' => '\'null\''
                                                        },
                                          '[Lex-56]' => {
                                                          'description' => 'Internal lexical symbol for "\'rank\'"',
                                                          'display_form' => '\'rank\'',
                                                          'dsl_form' => '\'rank\''
                                                        },
                                          '[Lex-57]' => {
                                                          'description' => 'Internal lexical symbol for "\'=>\'"',
                                                          'display_form' => '\'=>\'',
                                                          'dsl_form' => '\'=>\''
                                                        },
                                          '[Lex-58]' => {
                                                          'description' => 'Internal lexical symbol for "\'low\'"',
                                                          'display_form' => '\'low\'',
                                                          'dsl_form' => '\'low\''
                                                        },
                                          '[Lex-59]' => {
                                                          'description' => 'Internal lexical symbol for "\'high\'"',
                                                          'display_form' => '\'high\'',
                                                          'dsl_form' => '\'high\''
                                                        },
                                          '[Lex-5]' => {
                                                         'description' => 'Internal lexical symbol for "\'symbol\'"',
                                                         'display_form' => '\'symbol\'',
                                                         'dsl_form' => '\'symbol\''
                                                       },
                                          '[Lex-60]' => {
                                                          'description' => 'Internal lexical symbol for "\'priority\'"',
                                                          'display_form' => '\'priority\'',
                                                          'dsl_form' => '\'priority\''
                                                        },
                                          '[Lex-61]' => {
                                                          'description' => 'Internal lexical symbol for "\'=>\'"',
                                                          'display_form' => '\'=>\'',
                                                          'dsl_form' => '\'=>\''
                                                        },
                                          '[Lex-62]' => {
                                                          'description' => 'Internal lexical symbol for "\'pause\'"',
                                                          'display_form' => '\'pause\'',
                                                          'dsl_form' => '\'pause\''
                                                        },
                                          '[Lex-63]' => {
                                                          'description' => 'Internal lexical symbol for "\'=>\'"',
                                                          'display_form' => '\'=>\'',
                                                          'dsl_form' => '\'=>\''
                                                        },
                                          '[Lex-64]' => {
                                                          'description' => 'Internal lexical symbol for "\'event\'"',
                                                          'display_form' => '\'event\'',
                                                          'dsl_form' => '\'event\''
                                                        },
                                          '[Lex-65]' => {
                                                          'description' => 'Internal lexical symbol for "\'=>\'"',
                                                          'display_form' => '\'=>\'',
                                                          'dsl_form' => '\'=>\''
                                                        },
                                          '[Lex-66]' => {
                                                          'description' => 'Internal lexical symbol for "\'=\'"',
                                                          'display_form' => '\'=\'',
                                                          'dsl_form' => '\'=\''
                                                        },
                                          '[Lex-67]' => {
                                                          'description' => 'Internal lexical symbol for "\'on\'"',
                                                          'display_form' => '\'on\'',
                                                          'dsl_form' => '\'on\''
                                                        },
                                          '[Lex-68]' => {
                                                          'description' => 'Internal lexical symbol for "\'off\'"',
                                                          'display_form' => '\'off\'',
                                                          'dsl_form' => '\'off\''
                                                        },
                                          '[Lex-69]' => {
                                                          'description' => 'Internal lexical symbol for "\'forgiving\'"',
                                                          'display_form' => '\'forgiving\'',
                                                          'dsl_form' => '\'forgiving\''
                                                        },
                                          '[Lex-6]' => {
                                                         'description' => 'Internal lexical symbol for "\'is\'"',
                                                         'display_form' => '\'is\'',
                                                         'dsl_form' => '\'is\''
                                                       },
                                          '[Lex-70]' => {
                                                          'description' => 'Internal lexical symbol for "\'=>\'"',
                                                          'display_form' => '\'=>\'',
                                                          'dsl_form' => '\'=>\''
                                                        },
                                          '[Lex-71]' => {
                                                          'description' => 'Internal lexical symbol for "\'latm\'"',
                                                          'display_form' => '\'latm\'',
                                                          'dsl_form' => '\'latm\''
                                                        },
                                          '[Lex-72]' => {
                                                          'description' => 'Internal lexical symbol for "\'=>\'"',
                                                          'display_form' => '\'=>\'',
                                                          'dsl_form' => '\'=>\''
                                                        },
                                          '[Lex-73]' => {
                                                          'description' => 'Internal lexical symbol for "\'bless\'"',
                                                          'display_form' => '\'bless\'',
                                                          'dsl_form' => '\'bless\''
                                                        },
                                          '[Lex-74]' => {
                                                          'description' => 'Internal lexical symbol for "\'=>\'"',
                                                          'display_form' => '\'=>\'',
                                                          'dsl_form' => '\'=>\''
                                                        },
                                          '[Lex-75]' => {
                                                          'description' => 'Internal lexical symbol for "\'name\'"',
                                                          'display_form' => '\'name\'',
                                                          'dsl_form' => '\'name\''
                                                        },
                                          '[Lex-76]' => {
                                                          'description' => 'Internal lexical symbol for "\'=>\'"',
                                                          'display_form' => '\'=>\'',
                                                          'dsl_form' => '\'=>\''
                                                        },
                                          '[Lex-77]' => {
                                                          'description' => 'Internal lexical symbol for "\'(\'"',
                                                          'display_form' => '\'(\'',
                                                          'dsl_form' => '\'(\''
                                                        },
                                          '[Lex-78]' => {
                                                          'description' => 'Internal lexical symbol for "\')\'"',
                                                          'display_form' => '\')\'',
                                                          'dsl_form' => '\')\''
                                                        },
                                          '[Lex-79]' => {
                                                          'description' => 'Internal lexical symbol for "\'*\'"',
                                                          'display_form' => '\'*\'',
                                                          'dsl_form' => '\'*\''
                                                        },
                                          '[Lex-7]' => {
                                                         'description' => 'Internal lexical symbol for "\':default\'"',
                                                         'display_form' => '\':default\'',
                                                         'dsl_form' => '\':default\''
                                                       },
                                          '[Lex-80]' => {
                                                          'description' => 'Internal lexical symbol for "\'+\'"',
                                                          'display_form' => '\'+\'',
                                                          'dsl_form' => '\'+\''
                                                        },
                                          '[Lex-8]' => {
                                                         'description' => 'Internal lexical symbol for "\'lexeme\'"',
                                                         'display_form' => '\'lexeme\'',
                                                         'dsl_form' => '\'lexeme\''
                                                       },
                                          '[Lex-9]' => {
                                                         'description' => 'Internal lexical symbol for "\'default\'"',
                                                         'display_form' => '\'default\'',
                                                         'dsl_form' => '\'default\''
                                                       },
                                          '[[\']]' => {
                                                        'description' => 'Character class: [\']',
                                                        'display_form' => '[\']',
                                                        'dsl_form' => '[\']'
                                                      },
                                          '[[+-]]' => {
                                                        'description' => 'Character class: [+-]',
                                                        'display_form' => '[+-]',
                                                        'dsl_form' => '[+-]'
                                                      },
                                          '[[,]]' => {
                                                       'description' => 'Character class: [,]',
                                                       'display_form' => '[,]',
                                                       'dsl_form' => '[,]'
                                                     },
                                          '[[01]]' => {
                                                        'description' => 'Character class: [01]',
                                                        'display_form' => '[01]',
                                                        'dsl_form' => '[01]'
                                                      },
                                          '[[1]]' => {
                                                       'description' => 'Character class: [1]',
                                                       'display_form' => '[1]',
                                                       'dsl_form' => '[1]'
                                                     },
                                          '[[[:alnum:]]]' => {
                                                               'description' => 'Character class: [[:alnum:]]',
                                                               'display_form' => '[[:alnum:]]',
                                                               'dsl_form' => '[[:alnum:]]'
                                                             },
                                          '[[\\#]]' => {
                                                         'description' => 'Character class: [\\#]',
                                                         'display_form' => '[\\#]',
                                                         'dsl_form' => '[\\#]'
                                                       },
                                          '[[\\(]]' => {
                                                         'description' => 'Character class: [\\(]',
                                                         'display_form' => '[\\(]',
                                                         'dsl_form' => '[\\(]'
                                                       },
                                          '[[\\)]]' => {
                                                         'description' => 'Character class: [\\)]',
                                                         'display_form' => '[\\)]',
                                                         'dsl_form' => '[\\)]'
                                                       },
                                          '[[\\*]]' => {
                                                         'description' => 'Character class: [\\*]',
                                                         'display_form' => '[\\*]',
                                                         'dsl_form' => '[\\*]'
                                                       },
                                          '[[\\+]]' => {
                                                         'description' => 'Character class: [\\+]',
                                                         'display_form' => '[\\+]',
                                                         'dsl_form' => '[\\+]'
                                                       },
                                          '[[\\,]]' => {
                                                         'description' => 'Character class: [\\,]',
                                                         'display_form' => '[\\,]',
                                                         'dsl_form' => '[\\,]'
                                                       },
                                          '[[\\-]]' => {
                                                         'description' => 'Character class: [\\-]',
                                                         'display_form' => '[\\-]',
                                                         'dsl_form' => '[\\-]'
                                                       },
                                          '[[\\:]]' => {
                                                         'description' => 'Character class: [\\:]',
                                                         'display_form' => '[\\:]',
                                                         'dsl_form' => '[\\:]'
                                                       },
                                          '[[\\;]]' => {
                                                         'description' => 'Character class: [\\;]',
                                                         'display_form' => '[\\;]',
                                                         'dsl_form' => '[\\;]'
                                                       },
                                          '[[\\<]]' => {
                                                         'description' => 'Character class: [\\<]',
                                                         'display_form' => '[\\<]',
                                                         'dsl_form' => '[\\<]'
                                                       },
                                          '[[\\=]]' => {
                                                         'description' => 'Character class: [\\=]',
                                                         'display_form' => '[\\=]',
                                                         'dsl_form' => '[\\=]'
                                                       },
                                          '[[\\>]]' => {
                                                         'description' => 'Character class: [\\>]',
                                                         'display_form' => '[\\>]',
                                                         'dsl_form' => '[\\>]'
                                                       },
                                          '[[\\[]]' => {
                                                         'description' => 'Character class: [\\[]',
                                                         'display_form' => '[\\[]',
                                                         'dsl_form' => '[\\[]'
                                                       },
                                          '[[\\\\]]' => {
                                                          'description' => 'Character class: [\\\\]',
                                                          'display_form' => '[\\\\]',
                                                          'dsl_form' => '[\\\\]'
                                                        },
                                          '[[\\]]]' => {
                                                         'description' => 'Character class: [\\]]',
                                                         'display_form' => '[\\]]',
                                                         'dsl_form' => '[\\]]'
                                                       },
                                          '[[\\^]]' => {
                                                         'description' => 'Character class: [\\^]',
                                                         'display_form' => '[\\^]',
                                                         'dsl_form' => '[\\^]'
                                                       },
                                          '[[\\d]]' => {
                                                         'description' => 'Character class: [\\d]',
                                                         'display_form' => '[\\d]',
                                                         'dsl_form' => '[\\d]'
                                                       },
                                          '[[\\s\\w]]' => {
                                                            'description' => 'Character class: [\\s\\w]',
                                                            'display_form' => '[\\s\\w]',
                                                            'dsl_form' => '[\\s\\w]'
                                                          },
                                          '[[\\s]]' => {
                                                         'description' => 'Character class: [\\s]',
                                                         'display_form' => '[\\s]',
                                                         'dsl_form' => '[\\s]'
                                                       },
                                          '[[\\w]]' => {
                                                         'description' => 'Character class: [\\w]',
                                                         'display_form' => '[\\w]',
                                                         'dsl_form' => '[\\w]'
                                                       },
                                          '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                                'description' => 'Character class: [\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                                'display_form' => '[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                                'dsl_form' => '[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]'
                                                                                              },
                                          '[[\\{]]' => {
                                                         'description' => 'Character class: [\\{]',
                                                         'display_form' => '[\\{]',
                                                         'dsl_form' => '[\\{]'
                                                       },
                                          '[[\\|]]' => {
                                                         'description' => 'Character class: [\\|]',
                                                         'display_form' => '[\\|]',
                                                         'dsl_form' => '[\\|]'
                                                       },
                                          '[[\\}]]' => {
                                                         'description' => 'Character class: [\\}]',
                                                         'display_form' => '[\\}]',
                                                         'dsl_form' => '[\\}]'
                                                       },
                                          '[[\\~]]' => {
                                                         'description' => 'Character class: [\\~]',
                                                         'display_form' => '[\\~]',
                                                         'dsl_form' => '[\\~]'
                                                       },
                                          '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => {
                                                                                                                'description' => 'Character class: [^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                                'display_form' => '[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                                'dsl_form' => '[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]'
                                                                                                              },
                                          '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => {
                                                                                                                     'description' => 'Character class: [^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                                     'display_form' => '[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                                     'dsl_form' => '[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]'
                                                                                                                   },
                                          '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                                 'description' => 'Character class: [^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                                 'display_form' => '[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                                 'dsl_form' => '[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]'
                                                                                               },
                                          '[[a-zA-Z]]' => {
                                                            'description' => 'Character class: [a-zA-Z]',
                                                            'display_form' => '[a-zA-Z]',
                                                            'dsl_form' => '[a-zA-Z]'
                                                          },
                                          '[[a]]' => {
                                                       'description' => 'Character class: [a]',
                                                       'display_form' => '[a]',
                                                       'dsl_form' => '[a]'
                                                     },
                                          '[[b]]' => {
                                                       'description' => 'Character class: [b]',
                                                       'display_form' => '[b]',
                                                       'dsl_form' => '[b]'
                                                     },
                                          '[[c]]' => {
                                                       'description' => 'Character class: [c]',
                                                       'display_form' => '[c]',
                                                       'dsl_form' => '[c]'
                                                     },
                                          '[[d]]' => {
                                                       'description' => 'Character class: [d]',
                                                       'display_form' => '[d]',
                                                       'dsl_form' => '[d]'
                                                     },
                                          '[[e]]' => {
                                                       'description' => 'Character class: [e]',
                                                       'display_form' => '[e]',
                                                       'dsl_form' => '[e]'
                                                     },
                                          '[[f]]' => {
                                                       'description' => 'Character class: [f]',
                                                       'display_form' => '[f]',
                                                       'dsl_form' => '[f]'
                                                     },
                                          '[[g]]' => {
                                                       'description' => 'Character class: [g]',
                                                       'display_form' => '[g]',
                                                       'dsl_form' => '[g]'
                                                     },
                                          '[[h]]' => {
                                                       'description' => 'Character class: [h]',
                                                       'display_form' => '[h]',
                                                       'dsl_form' => '[h]'
                                                     },
                                          '[[i]]' => {
                                                       'description' => 'Character class: [i]',
                                                       'display_form' => '[i]',
                                                       'dsl_form' => '[i]'
                                                     },
                                          '[[k]]' => {
                                                       'description' => 'Character class: [k]',
                                                       'display_form' => '[k]',
                                                       'dsl_form' => '[k]'
                                                     },
                                          '[[l]]' => {
                                                       'description' => 'Character class: [l]',
                                                       'display_form' => '[l]',
                                                       'dsl_form' => '[l]'
                                                     },
                                          '[[m]]' => {
                                                       'description' => 'Character class: [m]',
                                                       'display_form' => '[m]',
                                                       'dsl_form' => '[m]'
                                                     },
                                          '[[n]]' => {
                                                       'description' => 'Character class: [n]',
                                                       'display_form' => '[n]',
                                                       'dsl_form' => '[n]'
                                                     },
                                          '[[o]]' => {
                                                       'description' => 'Character class: [o]',
                                                       'display_form' => '[o]',
                                                       'dsl_form' => '[o]'
                                                     },
                                          '[[p]]' => {
                                                       'description' => 'Character class: [p]',
                                                       'display_form' => '[p]',
                                                       'dsl_form' => '[p]'
                                                     },
                                          '[[r]]' => {
                                                       'description' => 'Character class: [r]',
                                                       'display_form' => '[r]',
                                                       'dsl_form' => '[r]'
                                                     },
                                          '[[s]]' => {
                                                       'description' => 'Character class: [s]',
                                                       'display_form' => '[s]',
                                                       'dsl_form' => '[s]'
                                                     },
                                          '[[t]]' => {
                                                       'description' => 'Character class: [t]',
                                                       'display_form' => '[t]',
                                                       'dsl_form' => '[t]'
                                                     },
                                          '[[u]]' => {
                                                       'description' => 'Character class: [u]',
                                                       'display_form' => '[u]',
                                                       'dsl_form' => '[u]'
                                                     },
                                          '[[v]]' => {
                                                       'description' => 'Character class: [v]',
                                                       'display_form' => '[v]',
                                                       'dsl_form' => '[v]'
                                                     },
                                          '[[w]]' => {
                                                       'description' => 'Character class: [w]',
                                                       'display_form' => '[w]',
                                                       'dsl_form' => '[w]'
                                                     },
                                          '[[x]]' => {
                                                       'description' => 'Character class: [x]',
                                                       'display_form' => '[x]',
                                                       'dsl_form' => '[x]'
                                                     },
                                          '[[y]]' => {
                                                       'description' => 'Character class: [y]',
                                                       'display_form' => '[y]',
                                                       'dsl_form' => '[y]'
                                                     }
                                        }
                               }
                };
## The code before this line was automatically generated by sl_to_hash.pl

##use critic

    return $hashed_metag;

} ## end sub meta_grammar

1;

# vim: expandtab shiftwidth=4:
