
package Paws::Lambda::UpdateAlias;
  use Moose;
  has Description => (is => 'ro', isa => 'Str');
  has FunctionName => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'FunctionName' , required => 1);
  has FunctionVersion => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'Name' , required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'UpdateAlias');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/2015-03-31/functions/{FunctionName}/aliases/{Name}');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'PUT');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::Lambda::AliasConfiguration');
  class_has _result_key => (isa => 'Str', is => 'ro', default => 'UpdateAliasResult');
1;

### main pod documentation begin ###

=head1 NAME

Paws::Lambda::UpdateAlias - Arguments for method UpdateAlias on Paws::Lambda

=head1 DESCRIPTION

This class represents the parameters used for calling the method UpdateAlias on the 
AWS Lambda service. Use the attributes of this class
as arguments to method UpdateAlias.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to UpdateAlias.

As an example:

  $service_obj->UpdateAlias(Att1 => $value1, Att2 => $value2, ...);

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.

=head1 ATTRIBUTES


=head2 Description => Str

  You can optionally change the description of the alias using this
parameter.


=head2 B<REQUIRED> FunctionName => Str

  The function name for which the alias is created.


=head2 FunctionVersion => Str

  Using this parameter you can optionally change the Lambda function
version to which the alias to points to.


=head2 B<REQUIRED> Name => Str

  The alias name.



=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method UpdateAlias in L<Paws::Lambda>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: https://github.com/pplu/aws-sdk-perl

Please report bugs to: https://github.com/pplu/aws-sdk-perl/issues

=cut

