/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.Dataset;
import edu.stanford.nlp.classify.RVFDataset;
import edu.stanford.nlp.ling.BasicDatum;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneralDataset<L, F>
implements Serializable,
Iterable<RVFDatum<L, F>> {
    private static final long serialVersionUID = 19157757130054829L;
    public Index<L> labelIndex;
    public Index<F> featureIndex;
    protected int[] labels;
    protected int[][] data;
    protected int size;

    public Index<L> labelIndex() {
        return this.labelIndex;
    }

    public Index<F> featureIndex() {
        return this.featureIndex;
    }

    public int numFeatures() {
        return this.featureIndex.size();
    }

    public int numClasses() {
        return this.labelIndex.size();
    }

    public int[] getLabelsArray() {
        this.labels = this.trimToSize(this.labels);
        return this.labels;
    }

    public int[][] getDataArray() {
        this.data = this.trimToSize(this.data);
        return this.data;
    }

    public abstract double[][] getValuesArray();

    public void clear() {
        this.clear(10);
    }

    public void clear(int numDatums) {
        this.initialize(numDatums);
    }

    protected abstract void initialize(int var1);

    public abstract RVFDatum<L, F> getRVFDatum(int var1);

    public abstract Datum<L, F> getDatum(int var1);

    public abstract void add(Datum<L, F> var1);

    public float[] getFeatureCounts() {
        float[] counts = new float[this.featureIndex.size()];
        int m = this.size;
        for (int i = 0; i < m; ++i) {
            int n = this.data[i].length;
            for (int j = 0; j < n; ++j) {
                int n2 = this.data[i][j];
                counts[n2] = (float)((double)counts[n2] + 1.0);
            }
        }
        return counts;
    }

    public void applyFeatureCountThreshold(int k) {
        int i;
        float[] counts = this.getFeatureCounts();
        HashIndex<F> newFeatureIndex = new HashIndex<F>();
        int[] featMap = new int[this.featureIndex.size()];
        for (i = 0; i < featMap.length; ++i) {
            F feat = this.featureIndex.get(i);
            if (counts[i] >= (float)k) {
                int newIndex = newFeatureIndex.size();
                newFeatureIndex.add(feat);
                featMap[i] = newIndex;
                continue;
            }
            featMap[i] = -1;
        }
        this.featureIndex = newFeatureIndex;
        for (i = 0; i < this.size; ++i) {
            int j;
            ArrayList<Integer> featList = new ArrayList<Integer>(this.data[i].length);
            for (j = 0; j < this.data[i].length; ++j) {
                if (featMap[this.data[i][j]] < 0) continue;
                featList.add(featMap[this.data[i][j]]);
            }
            this.data[i] = new int[featList.size()];
            for (j = 0; j < this.data[i].length; ++j) {
                this.data[i][j] = (Integer)featList.get(j);
            }
        }
    }

    public void applyFeatureMaxCountThreshold(int k) {
        int i;
        float[] counts = this.getFeatureCounts();
        HashIndex<F> newFeatureIndex = new HashIndex<F>();
        int[] featMap = new int[this.featureIndex.size()];
        for (i = 0; i < featMap.length; ++i) {
            F feat = this.featureIndex.get(i);
            if (counts[i] <= (float)k) {
                int newIndex = newFeatureIndex.size();
                newFeatureIndex.add(feat);
                featMap[i] = newIndex;
                continue;
            }
            featMap[i] = -1;
        }
        this.featureIndex = newFeatureIndex;
        for (i = 0; i < this.size; ++i) {
            int j;
            ArrayList<Integer> featList = new ArrayList<Integer>(this.data[i].length);
            for (j = 0; j < this.data[i].length; ++j) {
                if (featMap[this.data[i][j]] < 0) continue;
                featList.add(featMap[this.data[i][j]]);
            }
            this.data[i] = new int[featList.size()];
            for (j = 0; j < this.data[i].length; ++j) {
                this.data[i][j] = (Integer)featList.get(j);
            }
        }
    }

    public int numFeatureTokens() {
        int x = 0;
        int m = this.size;
        for (int i = 0; i < m; ++i) {
            x += this.data[i].length;
        }
        return x;
    }

    public int numFeatureTypes() {
        return this.featureIndex.size();
    }

    public void addAll(Iterable<? extends Datum<L, F>> data) {
        for (Datum<L, F> d : data) {
            this.add(d);
        }
    }

    public abstract Pair<GeneralDataset<L, F>, GeneralDataset<L, F>> split(int var1, int var2);

    public abstract Pair<GeneralDataset<L, F>, GeneralDataset<L, F>> split(double var1);

    public int size() {
        return this.size;
    }

    protected void trimData() {
        this.data = this.trimToSize(this.data);
    }

    protected void trimLabels() {
        this.labels = this.trimToSize(this.labels);
    }

    protected int[] trimToSize(int[] i) {
        int[] newI = new int[this.size];
        System.arraycopy(i, 0, newI, 0, this.size);
        return newI;
    }

    protected int[][] trimToSize(int[][] i) {
        int[][] newI = new int[this.size][];
        System.arraycopy(i, 0, newI, 0, this.size);
        return newI;
    }

    protected double[][] trimToSize(double[][] i) {
        double[][] newI = new double[this.size][];
        System.arraycopy(i, 0, newI, 0, this.size);
        return newI;
    }

    public GeneralDataset<L, F> sampleDataset(int randomSeed, double sampleFrac, boolean sampleWithReplacement) {
        GeneralDataset subset;
        int sampleSize = (int)((double)this.size() * sampleFrac);
        Random rand = new Random(randomSeed);
        if (this instanceof RVFDataset) {
            subset = new RVFDataset();
        } else if (this instanceof Dataset) {
            subset = new Dataset();
        } else {
            throw new RuntimeException("Can't handle this type of GeneralDataset.");
        }
        if (sampleWithReplacement) {
            for (int i = 0; i < sampleSize; ++i) {
                int datumNum = rand.nextInt(this.size());
                subset.add(this.getDatum(datumNum));
            }
        } else {
            HashSet<Integer> indicedSampled = new HashSet<Integer>();
            while (subset.size() < sampleSize) {
                int datumNum = rand.nextInt(this.size());
                if (indicedSampled.contains(datumNum)) continue;
                subset.add(this.getDatum(datumNum));
                indicedSampled.add(datumNum);
            }
        }
        return subset;
    }

    public abstract void summaryStatistics();

    public Iterator<L> labelIterator() {
        return this.labelIndex.iterator();
    }

    public GeneralDataset<L, F> mapDataset(GeneralDataset<L, F> dataset) {
        GeneralDataset newDataset = dataset instanceof RVFDataset ? new RVFDataset<L, F>(this.featureIndex, this.labelIndex) : new Dataset<L, F>(this.featureIndex, this.labelIndex);
        this.featureIndex.lock();
        this.labelIndex.lock();
        for (int i = 0; i < dataset.size(); ++i) {
            newDataset.add(dataset.getDatum(i));
        }
        this.featureIndex.unlock();
        this.labelIndex.unlock();
        return newDataset;
    }

    public static <L, L2, F> Datum<L2, F> mapDatum(Datum<L, F> d, Map<L, L2> labelMapping, L2 defaultLabel) {
        Datum d2 = null;
        L2 newLabel = labelMapping.get(d.label());
        if (newLabel == null) {
            newLabel = defaultLabel;
        }
        d2 = d instanceof RVFDatum ? new RVFDatum(((RVFDatum)d).asFeaturesCounter(), newLabel) : new BasicDatum(d.asFeatures(), newLabel);
        return d2;
    }

    public <L2> GeneralDataset<L2, F> mapDataset(GeneralDataset<L, F> dataset, Index<L2> newLabelIndex, Map<L, L2> labelMapping, L2 defaultLabel) {
        GeneralDataset newDataset = dataset instanceof RVFDataset ? new RVFDataset<L2, F>(this.featureIndex, newLabelIndex) : new Dataset<L2, F>(this.featureIndex, newLabelIndex);
        this.featureIndex.lock();
        this.labelIndex.lock();
        for (int i = 0; i < dataset.size(); ++i) {
            Datum<L, F> d = dataset.getDatum(i);
            Datum<L2, F> d2 = GeneralDataset.mapDatum(d, labelMapping, defaultLabel);
            newDataset.add(d2);
        }
        this.featureIndex.unlock();
        this.labelIndex.unlock();
        return newDataset;
    }

    public void printSVMLightFormat() {
        this.printSVMLightFormat(new PrintWriter(System.out));
    }

    public String[] makeSvmLabelMap() {
        String[] labelMap = new String[this.numClasses()];
        if (this.numClasses() > 2) {
            for (int i = 0; i < labelMap.length; ++i) {
                labelMap[i] = String.valueOf(i + 1);
            }
        } else {
            labelMap = new String[]{"+1", "-1"};
        }
        return labelMap;
    }

    public void printSVMLightFormat(PrintWriter pw) {
        String[] labelMap = this.makeSvmLabelMap();
        for (int i = 0; i < this.size; ++i) {
            RVFDatum<L, F> d = this.getRVFDatum(i);
            Counter<F> c = d.asFeaturesCounter();
            ClassicCounter<Integer> printC = new ClassicCounter<Integer>();
            for (F f : c.keySet()) {
                printC.setCount(this.featureIndex.indexOf(f), c.getCount(f));
            }
            Object[] features = printC.keySet().toArray(new Integer[printC.keySet().size()]);
            Arrays.sort(features);
            StringBuilder sb = new StringBuilder();
            sb.append(labelMap[this.labels[i]]).append(' ');
            Object[] arr$ = features;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int f = (Integer)arr$[i$];
                sb.append(f + 1).append(':').append(printC.getCount(f)).append(' ');
            }
            pw.println(sb.toString());
        }
    }

    @Override
    public Iterator<RVFDatum<L, F>> iterator() {
        return new Iterator<RVFDatum<L, F>>(){
            int id = 0;

            @Override
            public boolean hasNext() {
                return this.id < GeneralDataset.this.size();
            }

            @Override
            public RVFDatum<L, F> next() {
                return GeneralDataset.this.getRVFDatum(this.id++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

