/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.MentionExtractor;
import edu.stanford.nlp.dcoref.SieveCoreferenceSystem;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CoreMap;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MUCMentionExtractor
extends MentionExtractor {
    private TokenizerFactory<CoreLabel> tokenizerFactory;
    private String fileContents;
    private int currentOffset;

    public MUCMentionExtractor(LexicalizedParser parser, Dictionaries dict, Properties props, SieveCoreferenceSystem.Semantics semantics) throws Exception {
        super(dict, semantics);
        String fileName = props.getProperty("dcoref.muc");
        this.fileContents = IOUtils.slurpFile(fileName);
        this.currentOffset = 0;
        this.tokenizerFactory = PTBTokenizer.factory(false, new CoreLabelTokenFactory(false));
        this.stanfordProcessor = this.loadStanfordProcessor(props);
    }

    public Document nextDoc() {
        Mention m;
        int i;
        ArrayList<List<CoreLabel>> allWords = new ArrayList<List<CoreLabel>>();
        ArrayList<Tree> allTrees = new ArrayList<Tree>();
        ArrayList<List<Mention>> allGoldMentions = new ArrayList<List<Mention>>();
        ArrayList<Annotation> allSentences = new ArrayList<Annotation>();
        Annotation docAnno = new Annotation("");
        Pattern docPattern = Pattern.compile("<DOC>(.*?)</DOC>", 34);
        Pattern sentencePattern = Pattern.compile("(<s>|<hl>|<dd>|<DATELINE>)(.*?)(</s>|</hl>|</dd>|</DATELINE>)", 34);
        Matcher docMatcher = docPattern.matcher(this.fileContents);
        if (!docMatcher.find(this.currentOffset)) {
            return null;
        }
        this.currentOffset = docMatcher.end();
        String doc = docMatcher.group(1);
        Matcher sentenceMatcher = sentencePattern.matcher(doc);
        String ner = null;
        Pattern docIDPattern = Pattern.compile("<DOCNO>(.*?)</DOCNO>", 34);
        Matcher docIDMatcher = docIDPattern.matcher(doc);
        this.currentDocumentID = docIDMatcher.find() ? docIDMatcher.group(1) : "documentAfter " + this.currentDocumentID;
        while (sentenceMatcher.find()) {
            Object w;
            String sentenceString = sentenceMatcher.group(2);
            List<CoreLabel> words = this.tokenizerFactory.getTokenizer(new StringReader(sentenceString)).tokenize();
            for (int i2 = 0; i2 < words.size(); ++i2) {
                CoreLabel w2 = words.get(i2);
                if (i2 > 0 && w2.word().equals("$")) {
                    if (!words.get(i2 - 1).word().endsWith("PRP") && !words.get(i2 - 1).word().endsWith("WP")) continue;
                    words.get(i2 - 1).set(CoreAnnotations.TextAnnotation.class, words.get(i2 - 1).word() + "$");
                    words.remove(i2);
                    --i2;
                    continue;
                }
                if (!w2.word().equals("\\/") || words.get(i2 - 1).word().equals("</COREF>")) continue;
                w2.set(CoreAnnotations.TextAnnotation.class, words.get(i2 - 1).word() + "\\/" + words.get(i2 + 1).word());
                words.remove(i2 + 1);
                words.remove(i2 - 1);
            }
            ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>();
            Stack<Mention> stack = new Stack<Mention>();
            ArrayList<Mention> mentions = new ArrayList<Mention>();
            allWords.add(sentence);
            allGoldMentions.add(mentions);
            for (CoreLabel word : words) {
                Matcher m2;
                w = (String)word.get(CoreAnnotations.TextAnnotation.class);
                if (!((String)w).startsWith("<") && ((String)w).contains("\\/") && ((String)w).lastIndexOf("\\/") != ((String)w).length() - 2) {
                    int i3 = ((String)w).lastIndexOf("\\/");
                    String w1 = ((String)w).substring(0, i3);
                    word.set(CoreAnnotations.TextAnnotation.class, w1);
                    word.remove(CoreAnnotations.CurrentAnnotation.class);
                    sentence.add(word);
                    continue;
                }
                if (((String)w).startsWith("<") && !((String)w).startsWith("<COREF") && !((String)w).startsWith("</")) {
                    Pattern nerPattern = Pattern.compile("<(.*?)>");
                    m2 = nerPattern.matcher((CharSequence)w);
                    m2.find();
                    ner = m2.group(1);
                    continue;
                }
                if (((String)w).startsWith("</") && !((String)w).startsWith("</COREF")) {
                    Pattern nerPattern = Pattern.compile("</(.*?)>");
                    m2 = nerPattern.matcher((CharSequence)w);
                    m2.find();
                    String ner1 = m2.group(1);
                    if (ner != null && !ner.equals(ner1)) {
                        throw new RuntimeException("Unmatched NE labels in MUC file: " + ner + " v. " + ner1);
                    }
                    ner = null;
                    continue;
                }
                if (((String)w).startsWith("<COREF")) {
                    Mention mention = new Mention();
                    mention.startIndex = sentence.size();
                    Pattern idPattern = Pattern.compile("ID=\\\"(.*?)\\\"");
                    Pattern refPattern = Pattern.compile("REF=\\\"(.*?)\\\"");
                    Matcher m3 = idPattern.matcher((CharSequence)w);
                    m3.find();
                    mention.mentionID = Integer.valueOf(m3.group(1));
                    m3 = refPattern.matcher((CharSequence)w);
                    if (m3.find()) {
                        mention.originalRef = Integer.valueOf(m3.group(1));
                    }
                    stack.push(mention);
                    continue;
                }
                if (((String)w).equals("</COREF>")) {
                    Mention mention = (Mention)stack.pop();
                    mention.endIndex = sentence.size();
                    mentions.add(mention);
                    continue;
                }
                word.remove(CoreAnnotations.CurrentAnnotation.class);
                sentence.add(word);
            }
            StringBuilder textContent = new StringBuilder();
            for (int i4 = 0; i4 < sentence.size(); ++i4) {
                w = (CoreLabel)sentence.get(i4);
                ((ArrayCoreMap)w).set(CoreAnnotations.IndexAnnotation.class, i4 + 1);
                ((ArrayCoreMap)w).set(CoreAnnotations.UtteranceAnnotation.class, 0);
                if (i4 > 0) {
                    textContent.append(" ");
                }
                textContent.append(((CoreLabel)w).getString(CoreAnnotations.TextAnnotation.class));
            }
            Annotation sentCoreMap = new Annotation(textContent.toString());
            allSentences.add(sentCoreMap);
            sentCoreMap.set(CoreAnnotations.TokensAnnotation.class, sentence);
        }
        HashMap<Integer, Mention> idMention = new HashMap<Integer, Mention>();
        for (i = 0; i < allGoldMentions.size(); ++i) {
            for (int j = 0; j < ((List)allGoldMentions.get(i)).size(); ++j) {
                m = (Mention)((List)allGoldMentions.get(i)).get(j);
                idMention.put(m.mentionID, m);
            }
        }
        for (i = 0; i < allGoldMentions.size(); ++i) {
            block7: for (int j = 0; j < ((List)allGoldMentions.get(i)).size(); ++j) {
                m = (Mention)((List)allGoldMentions.get(i)).get(j);
                if (m.goldCorefClusterID != -1) continue;
                if (m.originalRef == -1) {
                    m.goldCorefClusterID = m.mentionID;
                    continue;
                }
                int ref = m.originalRef;
                while (true) {
                    Mention m2 = (Mention)idMention.get(ref);
                    if (m2.goldCorefClusterID != -1) {
                        m.goldCorefClusterID = m2.goldCorefClusterID;
                        continue block7;
                    }
                    if (m2.originalRef == -1) {
                        m.goldCorefClusterID = m2.goldCorefClusterID = m2.mentionID;
                        continue block7;
                    }
                    ref = m2.originalRef;
                }
            }
        }
        docAnno.set(CoreAnnotations.SentencesAnnotation.class, allSentences);
        this.stanfordProcessor.annotate(docAnno);
        if (allSentences.size() != allWords.size()) {
            throw new RuntimeException();
        }
        for (i = 0; i < allSentences.size(); ++i) {
            List annotatedSent = (List)((CoreMap)allSentences.get(i)).get(CoreAnnotations.TokensAnnotation.class);
            List unannotatedSent = (List)allWords.get(i);
            List mentionInSent = (List)allGoldMentions.get(i);
            for (Mention m4 : mentionInSent) {
                m4.dependency = (SemanticGraph)((Object)((CoreMap)allSentences.get(i)).get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class));
            }
            if (annotatedSent.size() != unannotatedSent.size()) {
                throw new RuntimeException();
            }
            int k = 0;
            int j = 0;
            while (j < annotatedSent.size()) {
                CoreLabel annotatedWord = (CoreLabel)annotatedSent.get(j);
                CoreLabel unannotatedWord = (CoreLabel)unannotatedSent.get(k);
                if (!((String)annotatedWord.get(CoreAnnotations.TextAnnotation.class)).equals(unannotatedWord.get(CoreAnnotations.TextAnnotation.class))) {
                    throw new RuntimeException();
                }
                ++j;
                ++k;
            }
            allWords.set(i, annotatedSent);
            allTrees.add((Tree)((CoreMap)allSentences.get(i)).get(CoreAnnotations.TreeAnnotation.class));
        }
        List<List<Mention>> allPredictedMentions = this.mentionFinder.extractPredictedMentions(docAnno, this.maxID, this.dictionaries);
        return this.arrange(docAnno, allWords, allTrees, allPredictedMentions, allGoldMentions, true);
    }
}

