/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.Entity;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.sequences.SequenceListener;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Index;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityCachingAbstractSequencePrior<IN extends CoreMap>
implements SequenceModel,
SequenceListener {
    protected int[] sequence;
    protected int backgroundSymbol;
    protected int numClasses;
    protected int[] possibleValues;
    protected Index<String> classIndex;
    protected List<IN> doc;
    private boolean VERBOSE = false;
    Entity[] entities;

    public EntityCachingAbstractSequencePrior(String backgroundSymbol, Index<String> classIndex, List<IN> doc) {
        this.classIndex = classIndex;
        this.backgroundSymbol = classIndex.indexOf(backgroundSymbol);
        this.numClasses = classIndex.size();
        this.possibleValues = new int[this.numClasses];
        for (int i = 0; i < this.numClasses; ++i) {
            this.possibleValues[i] = i;
        }
        this.doc = doc;
    }

    @Override
    public int leftWindow() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int rightWindow() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int[] getPossibleValues(int position) {
        return this.possibleValues;
    }

    @Override
    public double scoreOf(int[] sequence, int pos) {
        return this.scoresOf(sequence, pos)[sequence[pos]];
    }

    @Override
    public int length() {
        return this.doc.size();
    }

    public int getNumClasses() {
        return this.classIndex.size();
    }

    public double[] getConditionalDistribution(int[] sequence, int position) {
        double[] probs = this.scoresOf(sequence, position);
        ArrayMath.logNormalize(probs);
        probs = ArrayMath.exp(probs);
        return probs;
    }

    @Override
    public double[] scoresOf(int[] sequence, int position) {
        double[] probs = new double[this.numClasses];
        int origClass = sequence[position];
        for (int label = 0; label < this.numClasses; ++label) {
            sequence[position] = label;
            this.updateSequenceElement(sequence, position, 0);
            probs[label] = this.scoreOf(sequence);
        }
        sequence[position] = origClass;
        return probs;
    }

    @Override
    public void setInitialSequence(int[] initialSequence) {
        this.sequence = initialSequence;
        this.entities = new Entity[initialSequence.length];
        Arrays.fill(this.entities, null);
        for (int i = 0; i < initialSequence.length; ++i) {
            if (initialSequence[i] == this.backgroundSymbol) continue;
            Entity entity = this.extractEntity(initialSequence, i);
            this.addEntityToEntitiesArray(entity);
            i += entity.words.size() - 1;
        }
    }

    private void addEntityToEntitiesArray(Entity entity) {
        for (int j = entity.startPosition; j < entity.startPosition + entity.words.size(); ++j) {
            this.entities[j] = entity;
        }
    }

    public Entity extractEntity(int[] sequence, int position) {
        Entity entity = new Entity();
        entity.type = sequence[position];
        entity.startPosition = position;
        entity.words = new ArrayList<String>();
        while (position < sequence.length) {
            if (sequence[position] == entity.type) {
                String word = (String)((CoreMap)this.doc.get(position)).get(CoreAnnotations.TextAnnotation.class);
                entity.words.add(word);
                if (position == sequence.length - 1) {
                    entity.otherOccurrences = this.otherOccurrences(entity);
                }
            } else {
                entity.otherOccurrences = this.otherOccurrences(entity);
                break;
            }
            ++position;
        }
        return entity;
    }

    public int[] otherOccurrences(Entity entity) {
        ArrayList<Integer> other = new ArrayList<Integer>();
        for (int i = 0; i < this.doc.size(); ++i) {
            if (i == entity.startPosition || !this.matches(entity, i)) continue;
            other.add(i);
        }
        return EntityCachingAbstractSequencePrior.toArray(other);
    }

    public static int[] toArray(List<Integer> list) {
        int[] arr = new int[list.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    public boolean matches(Entity entity, int position) {
        String word = (String)((CoreMap)this.doc.get(position)).get(CoreAnnotations.TextAnnotation.class);
        if (word.equalsIgnoreCase(entity.words.get(0))) {
            for (int j = 1; j < entity.words.size(); ++j) {
                if (position + j >= this.doc.size()) {
                    return false;
                }
                String nextWord = (String)((CoreMap)this.doc.get(position + j)).get(CoreAnnotations.TextAnnotation.class);
                if (nextWord.equalsIgnoreCase(entity.words.get(j))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean joiningTwoEntities(int[] sequence, int position) {
        if (sequence[position] == this.backgroundSymbol) {
            return false;
        }
        if (position > 0 && position < sequence.length - 1) {
            return sequence[position] == sequence[position - 1] && sequence[position] == sequence[position + 1];
        }
        return false;
    }

    public boolean splittingTwoEntities(int[] sequence, int position) {
        if (position > 0 && position < sequence.length - 1) {
            return this.entities[position - 1] == this.entities[position + 1] && this.entities[position - 1] != null;
        }
        return false;
    }

    public boolean appendingEntity(int[] sequence, int position) {
        if (position > 0) {
            if (this.entities[position - 1] == null) {
                return false;
            }
            Entity prev = this.entities[position - 1];
            return sequence[position] == sequence[position - 1] && prev.startPosition + prev.words.size() == position;
        }
        return false;
    }

    public boolean prependingEntity(int[] sequence, int position) {
        if (position < sequence.length - 1) {
            if (this.entities[position + 1] == null) {
                return false;
            }
            return sequence[position] == sequence[position + 1];
        }
        return false;
    }

    public boolean addingSingletonEntity(int[] sequence, int position) {
        if (sequence[position] == this.backgroundSymbol) {
            return false;
        }
        if (position > 0 && sequence[position - 1] == sequence[position]) {
            return false;
        }
        return position >= sequence.length - 1 || sequence[position + 1] != sequence[position];
    }

    public boolean removingEndOfEntity(int[] sequence, int position) {
        if (position > 0) {
            if (sequence[position - 1] == this.backgroundSymbol) {
                return false;
            }
            Entity prev = this.entities[position - 1];
            if (prev != null) {
                return prev.startPosition + prev.words.size() > position;
            }
        }
        return false;
    }

    public boolean removingBeginningOfEntity(int[] sequence, int position) {
        if (position < sequence.length - 1) {
            if (sequence[position + 1] == this.backgroundSymbol) {
                return false;
            }
            Entity next = this.entities[position + 1];
            if (next != null) {
                return next.startPosition <= position;
            }
        }
        return false;
    }

    public boolean noChange(int[] sequence, int position) {
        if (position > 0 && sequence[position - 1] == sequence[position]) {
            return this.entities[position - 1] == this.entities[position];
        }
        if (position < sequence.length - 1 && sequence[position + 1] == sequence[position]) {
            return this.entities[position] == this.entities[position + 1];
        }
        return false;
    }

    @Override
    public void updateSequenceElement(int[] sequence, int position, int oldVal) {
        if (this.VERBOSE) {
            System.out.println("changing position " + position + " from " + this.classIndex.get(oldVal) + " to " + this.classIndex.get(sequence[position]));
        }
        this.sequence = sequence;
        if (this.noChange(sequence, position)) {
            if (this.VERBOSE) {
                System.out.println("no change");
            }
            if (this.VERBOSE) {
                System.out.println(this);
            }
            return;
        }
        if (this.joiningTwoEntities(sequence, position)) {
            if (this.VERBOSE) {
                System.out.println("joining 2 entities");
            }
            Entity newEntity = new Entity();
            Entity prev = this.entities[position - 1];
            Entity next = this.entities[position + 1];
            newEntity.startPosition = prev.startPosition;
            newEntity.words = new ArrayList<String>();
            newEntity.words.addAll(prev.words);
            String word = (String)((CoreMap)this.doc.get(position)).get(CoreAnnotations.TextAnnotation.class);
            newEntity.words.add(word);
            newEntity.words.addAll(next.words);
            newEntity.type = sequence[position];
            ArrayList<Integer> other = new ArrayList<Integer>();
            for (int i = 0; i < prev.otherOccurrences.length; ++i) {
                int pos = prev.otherOccurrences[i];
                if (!this.matches(newEntity, pos)) continue;
                other.add(pos);
            }
            newEntity.otherOccurrences = EntityCachingAbstractSequencePrior.toArray(other);
            this.addEntityToEntitiesArray(newEntity);
            if (this.VERBOSE) {
                System.out.println(this);
            }
            return;
        }
        if (this.splittingTwoEntities(sequence, position)) {
            if (this.VERBOSE) {
                System.out.println("splitting into 2 entities");
            }
            Entity entity = this.entities[position];
            Entity prev = new Entity();
            prev.type = entity.type;
            prev.startPosition = entity.startPosition;
            prev.words = new ArrayList<String>(entity.words.subList(0, position - entity.startPosition));
            prev.otherOccurrences = this.otherOccurrences(prev);
            this.addEntityToEntitiesArray(prev);
            Entity next = new Entity();
            next.type = entity.type;
            next.startPosition = position + 1;
            next.words = new ArrayList<String>(entity.words.subList(position - entity.startPosition + 1, entity.words.size()));
            next.otherOccurrences = this.otherOccurrences(next);
            this.addEntityToEntitiesArray(next);
            if (sequence[position] == this.backgroundSymbol) {
                this.entities[position] = null;
            } else {
                Entity newEntity = new Entity();
                newEntity.startPosition = position;
                newEntity.type = sequence[position];
                newEntity.words = new ArrayList<String>();
                String word = (String)((CoreMap)this.doc.get(position)).get(CoreAnnotations.TextAnnotation.class);
                newEntity.words.add(word);
                newEntity.otherOccurrences = this.otherOccurrences(newEntity);
                this.entities[position] = newEntity;
            }
            if (this.VERBOSE) {
                System.out.println(this);
            }
            return;
        }
        if (this.prependingEntity(sequence, position)) {
            if (this.VERBOSE) {
                System.out.println("prepending entity");
            }
            Entity newEntity = new Entity();
            Entity next = this.entities[position + 1];
            newEntity.startPosition = position;
            newEntity.words = new ArrayList<String>();
            String word = (String)((CoreMap)this.doc.get(position)).get(CoreAnnotations.TextAnnotation.class);
            newEntity.words.add(word);
            newEntity.words.addAll(next.words);
            newEntity.type = sequence[position];
            newEntity.otherOccurrences = this.otherOccurrences(newEntity);
            this.addEntityToEntitiesArray(newEntity);
            if (this.removingEndOfEntity(sequence, position)) {
                if (this.VERBOSE) {
                    System.out.println(" ... and removing end of previous entity.");
                }
                Entity prev = this.entities[position - 1];
                prev.words.remove(prev.words.size() - 1);
                prev.otherOccurrences = this.otherOccurrences(prev);
            }
            if (this.VERBOSE) {
                System.out.println(this);
            }
            return;
        }
        if (this.appendingEntity(sequence, position)) {
            if (this.VERBOSE) {
                System.out.println("appending entity");
            }
            Entity newEntity = new Entity();
            Entity prev = this.entities[position - 1];
            newEntity.startPosition = prev.startPosition;
            newEntity.words = new ArrayList<String>();
            newEntity.words.addAll(prev.words);
            String word = (String)((CoreMap)this.doc.get(position)).get(CoreAnnotations.TextAnnotation.class);
            newEntity.words.add(word);
            newEntity.type = sequence[position];
            ArrayList<Integer> other = new ArrayList<Integer>();
            for (int i = 0; i < prev.otherOccurrences.length; ++i) {
                int pos = prev.otherOccurrences[i];
                if (!this.matches(newEntity, pos)) continue;
                other.add(pos);
            }
            newEntity.otherOccurrences = EntityCachingAbstractSequencePrior.toArray(other);
            this.addEntityToEntitiesArray(newEntity);
            if (this.removingBeginningOfEntity(sequence, position)) {
                if (this.VERBOSE) {
                    System.out.println(" ... and removing beginning of next entity.");
                }
                this.entities[position + 1].words.remove(0);
                ++this.entities[position + 1].startPosition;
            }
            if (this.VERBOSE) {
                System.out.println(this);
            }
            return;
        }
        if (this.addingSingletonEntity(sequence, position)) {
            Entity newEntity = new Entity();
            if (this.VERBOSE) {
                System.out.println("adding singleton entity");
            }
            newEntity.startPosition = position;
            newEntity.words = new ArrayList<String>();
            String word = (String)((CoreMap)this.doc.get(position)).get(CoreAnnotations.TextAnnotation.class);
            newEntity.words.add(word);
            newEntity.type = sequence[position];
            newEntity.otherOccurrences = this.otherOccurrences(newEntity);
            this.addEntityToEntitiesArray(newEntity);
            if (this.removingEndOfEntity(sequence, position)) {
                if (this.VERBOSE) {
                    System.out.println(" ... and removing end of previous entity.");
                }
                Entity prev = this.entities[position - 1];
                prev.words.remove(prev.words.size() - 1);
                prev.otherOccurrences = this.otherOccurrences(prev);
            }
            if (this.removingBeginningOfEntity(sequence, position)) {
                if (this.VERBOSE) {
                    System.out.println(" ... and removing beginning of next entity.");
                }
                this.entities[position + 1].words.remove(0);
                ++this.entities[position + 1].startPosition;
            }
            if (this.VERBOSE) {
                System.out.println(this);
            }
            return;
        }
        if (this.removingEndOfEntity(sequence, position)) {
            if (this.VERBOSE) {
                System.out.println("splitting off prev entity");
            }
            Entity prev = this.entities[position - 1];
            prev.words.remove(prev.words.size() - 1);
            prev.otherOccurrences = this.otherOccurrences(prev);
            this.entities[position] = null;
        } else if (this.removingBeginningOfEntity(sequence, position)) {
            if (this.VERBOSE) {
                System.out.println("splitting off next entity");
            }
            Entity next = this.entities[position + 1];
            next.words.remove(0);
            ++next.startPosition;
            next.otherOccurrences = this.otherOccurrences(next);
            this.entities[position] = null;
        } else {
            this.entities[position] = null;
        }
        if (this.VERBOSE) {
            System.out.println(this);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.entities.length; ++i) {
            sb.append(i);
            sb.append("\t");
            String word = (String)((CoreMap)this.doc.get(i)).get(CoreAnnotations.TextAnnotation.class);
            sb.append(word);
            sb.append("\t");
            sb.append(this.classIndex.get(this.sequence[i]));
            if (this.entities[i] != null) {
                sb.append("\t");
                sb.append(this.entities[i].toString(this.classIndex));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString(int pos) {
        StringBuffer sb = new StringBuffer();
        for (int i = Math.max(0, pos - 10); i < Math.min(this.entities.length, pos + 10); ++i) {
            sb.append(i);
            sb.append("\t");
            String word = (String)((CoreMap)this.doc.get(i)).get(CoreAnnotations.TextAnnotation.class);
            sb.append(word);
            sb.append("\t");
            sb.append(this.classIndex.get(this.sequence[i]));
            if (this.entities[i] != null) {
                sb.append("\t");
                sb.append(this.entities[i].toString(this.classIndex));
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

