/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.AcquisitionsPrior;
import edu.stanford.nlp.ie.EmpiricalNERPrior;
import edu.stanford.nlp.ie.EntityCachingAbstractSequencePrior;
import edu.stanford.nlp.ie.SeminarsPrior;
import edu.stanford.nlp.ie.UniformPrior;
import edu.stanford.nlp.ie.crf.CRFClassifierEvaluator;
import edu.stanford.nlp.ie.crf.CRFCliqueTree;
import edu.stanford.nlp.ie.crf.CRFDatum;
import edu.stanford.nlp.ie.crf.CRFFeatureExporter;
import edu.stanford.nlp.ie.crf.CRFLabel;
import edu.stanford.nlp.ie.crf.CRFLogConditionalObjectiveFloatFunction;
import edu.stanford.nlp.ie.crf.CRFLogConditionalObjectiveFunction;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.maxent.Convert;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.optimization.AbstractCachingDiffFloatFunction;
import edu.stanford.nlp.optimization.AbstractStochasticCachingDiffFunction;
import edu.stanford.nlp.optimization.DiffFloatFunction;
import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.Evaluator;
import edu.stanford.nlp.optimization.Function;
import edu.stanford.nlp.optimization.HasEvaluators;
import edu.stanford.nlp.optimization.HybridMinimizer;
import edu.stanford.nlp.optimization.MemoryEvaluator;
import edu.stanford.nlp.optimization.Minimizer;
import edu.stanford.nlp.optimization.QNMinimizer;
import edu.stanford.nlp.optimization.ResultStoringFloatMonitor;
import edu.stanford.nlp.optimization.ResultStoringMonitor;
import edu.stanford.nlp.optimization.SGDMinimizer;
import edu.stanford.nlp.optimization.SGDToQNMinimizer;
import edu.stanford.nlp.optimization.SMDMinimizer;
import edu.stanford.nlp.optimization.ScaledSGDMinimizer;
import edu.stanford.nlp.optimization.StochasticDiffFunctionTester;
import edu.stanford.nlp.optimization.StochasticInPlaceMinimizer;
import edu.stanford.nlp.sequences.BeamBestSequenceFinder;
import edu.stanford.nlp.sequences.BestSequenceFinder;
import edu.stanford.nlp.sequences.Clique;
import edu.stanford.nlp.sequences.CoolingSchedule;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.ExactBestSequenceFinder;
import edu.stanford.nlp.sequences.FactoredSequenceListener;
import edu.stanford.nlp.sequences.FactoredSequenceModel;
import edu.stanford.nlp.sequences.FeatureFactory;
import edu.stanford.nlp.sequences.PlainTextDocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.sequences.SequenceGibbsSampler;
import edu.stanford.nlp.sequences.SequenceListener;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.sequences.TrueCasingDocumentReaderAndWriter;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.PaddedList;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRFClassifier<IN extends CoreMap>
extends AbstractSequenceClassifier<IN> {
    Index<CRFLabel>[] labelIndices;
    double[][] weights;
    Index<String> featureIndex;
    int[] map;
    public static final String DEFAULT_CLASSIFIER = "ner-eng-ie.crf-3-all2008.ser.gz";
    private static final boolean VERBOSE = false;

    protected CRFClassifier() {
        super(new SeqClassifierFlags());
    }

    public CRFClassifier(Properties props) {
        super(props);
    }

    public CRFClassifier(SeqClassifierFlags flags) {
        super(flags);
    }

    public CRFClassifier(CRFClassifier<IN> crf) {
        super(crf.flags);
        this.windowSize = crf.windowSize;
        this.featureFactory = crf.featureFactory;
        this.pad = crf.pad;
        this.knownLCWords = crf.knownLCWords != null ? new HashSet(crf.knownLCWords) : null;
        this.featureIndex = crf.featureIndex != null ? new HashIndex<String>(crf.featureIndex.objectsList()) : null;
        Index index = this.classIndex = crf.classIndex != null ? new HashIndex(crf.classIndex.objectsList()) : null;
        if (crf.labelIndices != null) {
            this.labelIndices = new HashIndex[crf.labelIndices.length];
            for (int i = 0; i < crf.labelIndices.length; ++i) {
                this.labelIndices[i] = crf.labelIndices[i] != null ? new HashIndex<CRFLabel>(crf.labelIndices[i].objectsList()) : null;
            }
        } else {
            this.labelIndices = null;
        }
        int numFeatures = this.featureIndex.size();
        this.weights = new double[numFeatures][];
        for (int i = 0; i < numFeatures; ++i) {
            String feature = this.featureIndex.get(i);
            int index2 = crf.featureIndex.indexOf(feature);
            this.weights[i] = new double[crf.weights[index2].length];
            System.arraycopy(crf.weights[index2], 0, this.weights[i], 0, this.weights[i].length);
        }
        this.readerAndWriter = crf.readerAndWriter;
    }

    public int getNumWeights() {
        if (this.weights == null) {
            return 0;
        }
        int numWeights = 0;
        for (double[] wts : this.weights) {
            numWeights += wts.length;
        }
        return numWeights;
    }

    private int getFeatureTypeIndex(int i) {
        return CRFClassifier.getFeatureTypeIndex(this.featureIndex.get(i));
    }

    private static int getFeatureTypeIndex(String feature) {
        if (feature.endsWith("|C")) {
            return 0;
        }
        if (feature.endsWith("|CpC")) {
            return 1;
        }
        if (feature.endsWith("|Cp2C")) {
            return 2;
        }
        if (feature.endsWith("|Cp3C")) {
            return 3;
        }
        if (feature.endsWith("|Cp4C")) {
            return 4;
        }
        if (feature.endsWith("|Cp5C")) {
            return 5;
        }
        throw new RuntimeException("Unknown feature type " + feature);
    }

    public void scaleWeights(double scale) {
        for (int i = 0; i < this.weights.length; ++i) {
            int j = 0;
            while (j < this.weights[i].length) {
                double[] dArray = this.weights[i];
                int n = j++;
                dArray[n] = dArray[n] * scale;
            }
        }
    }

    private void combineWeights(CRFClassifier<IN> crf, double weight2) {
        int i;
        int i2;
        int numFeatures = this.featureIndex.size();
        int oldNumFeatures = this.weights.length;
        HashMap<CRFLabel, CRFLabel> crfLabelMap = new HashMap<CRFLabel, CRFLabel>();
        for (i2 = 0; i2 < crf.labelIndices.length; ++i2) {
            for (int j = 0; j < crf.labelIndices[i2].size(); ++j) {
                CRFLabel labels = crf.labelIndices[i2].get(j);
                int[] newLabelIndices = new int[i2 + 1];
                for (int ci = 0; ci <= i2; ++ci) {
                    String classLabel = (String)crf.classIndex.get(labels.getLabel()[ci]);
                    newLabelIndices[ci] = this.classIndex.indexOf(classLabel);
                }
                CRFLabel newLabels = new CRFLabel(newLabelIndices);
                crfLabelMap.put(labels, newLabels);
                int k = this.labelIndices[i2].indexOf(newLabels);
            }
        }
        this.map = new int[numFeatures];
        for (i2 = 0; i2 < numFeatures; ++i2) {
            this.map[i2] = this.getFeatureTypeIndex(i2);
        }
        double[][] newWeights = new double[numFeatures][];
        for (i = 0; i < numFeatures; ++i) {
            int length = this.labelIndices[this.map[i]].size();
            newWeights[i] = new double[length];
            if (i >= oldNumFeatures) continue;
            assert (length >= this.weights[i].length);
            System.arraycopy(this.weights[i], 0, newWeights[i], 0, this.weights[i].length);
        }
        this.weights = newWeights;
        for (i = 0; i < crf.weights.length; ++i) {
            String feature = crf.featureIndex.get(i);
            int newIndex = this.featureIndex.indexOf(feature);
            if (this.weights[newIndex].length < crf.weights[i].length) {
                throw new RuntimeException("Incompatible CRFClassifier: weight length mismatch for feature " + newIndex + ": " + this.featureIndex.get(newIndex) + " (also feature " + i + ": " + crf.featureIndex.get(i) + ") " + ", len1=" + this.weights[newIndex].length + ", len2=" + crf.weights[i].length);
            }
            int featureTypeIndex = this.map[newIndex];
            for (int j = 0; j < crf.weights[i].length; ++j) {
                CRFLabel labels = crf.labelIndices[featureTypeIndex].get(j);
                CRFLabel newLabels = (CRFLabel)crfLabelMap.get(labels);
                int k = this.labelIndices[featureTypeIndex].indexOf(newLabels);
                double[] dArray = this.weights[newIndex];
                int n = k;
                dArray[n] = dArray[n] + crf.weights[i][j] * weight2;
            }
        }
    }

    public void combine(CRFClassifier<IN> crf, double weight2) {
        Timing timer = new Timing();
        if (!this.pad.equals(crf.pad)) {
            throw new RuntimeException("Incompatible CRFClassifier: pad does not match");
        }
        if (this.windowSize != crf.windowSize) {
            throw new RuntimeException("Incompatible CRFClassifier: windowSize does not match");
        }
        if (this.labelIndices.length != crf.labelIndices.length) {
            throw new RuntimeException("Incompatible CRFClassifier: labelIndices length does not match");
        }
        this.classIndex.addAll(crf.classIndex.objectsList());
        int oldNumFeatures1 = this.featureIndex.size();
        int oldNumFeatures2 = crf.featureIndex.size();
        int oldNumWeights1 = this.getNumWeights();
        int oldNumWeights2 = crf.getNumWeights();
        this.featureIndex.addAll(crf.featureIndex.objectsList());
        this.knownLCWords.addAll(crf.knownLCWords);
        assert (this.weights.length == oldNumFeatures1);
        for (int i = 0; i < this.labelIndices.length; ++i) {
            this.labelIndices[i].addAll(crf.labelIndices[i].objectsList());
        }
        System.err.println("Combining weights: will automatically match labelIndices");
        this.combineWeights(crf, weight2);
        int numFeatures = this.featureIndex.size();
        int numWeights = this.getNumWeights();
        long elapsedMs = timer.stop();
        System.err.println("numFeatures: orig1=" + oldNumFeatures1 + ", orig2=" + oldNumFeatures2 + ", combined=" + numFeatures);
        System.err.println("numWeights: orig1=" + oldNumWeights1 + ", orig2=" + oldNumWeights2 + ", combined=" + numWeights);
        System.err.println("Time to combine CRFClassifier: " + Timing.toSecondsString(elapsedMs) + " seconds");
    }

    public void dropFeaturesBelowThreshold(double threshold) {
        HashIndex<String> newFeatureIndex = new HashIndex<String>();
        block0: for (int i = 0; i < this.weights.length; ++i) {
            double smallest = this.weights[i][0];
            double biggest = this.weights[i][0];
            for (int j = 1; j < this.weights[i].length; ++j) {
                if (this.weights[i][j] > biggest) {
                    biggest = this.weights[i][j];
                }
                if (this.weights[i][j] < smallest) {
                    smallest = this.weights[i][j];
                }
                if (!(biggest - smallest > threshold)) continue;
                newFeatureIndex.add(this.featureIndex.get(i));
                continue block0;
            }
        }
        int[] newMap = new int[newFeatureIndex.size()];
        for (int i = 0; i < newMap.length; ++i) {
            int index = this.featureIndex.indexOf((String)newFeatureIndex.get(i));
            newMap[i] = this.map[index];
        }
        this.map = newMap;
        this.featureIndex = newFeatureIndex;
    }

    public Pair<int[][][], int[]> documentToDataAndLabels(List<IN> document) {
        int docSize = document.size();
        int[][][] data = new int[docSize][this.windowSize][];
        int[] labels = new int[docSize];
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        for (int j = 0; j < docSize; ++j) {
            CRFDatum<List<String>, CRFLabel> d = this.makeDatum(document, j, this.featureFactory);
            List<List<String>> features = d.asFeatures();
            int fSize = features.size();
            for (int k = 0; k < fSize; ++k) {
                Collection cliqueFeatures = features.get(k);
                data[j][k] = new int[cliqueFeatures.size()];
                int m = 0;
                for (String feature : cliqueFeatures) {
                    int index = this.featureIndex.indexOf(feature);
                    if (index < 0) continue;
                    data[j][k][m] = index;
                    ++m;
                }
                if (m >= data[j][k].length) continue;
                int[] f = new int[m];
                System.arraycopy(data[j][k], 0, f, 0, m);
                data[j][k] = f;
            }
            CoreMap wi = (CoreMap)document.get(j);
            labels[j] = this.classIndex.indexOf(wi.get(CoreAnnotations.AnswerAnnotation.class));
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        return new Pair<int[][][], int[]>(data, labels);
    }

    public void printLabelInformation(String testFile) throws Exception {
        ObjectBank documents = this.makeObjectBankFromFile(testFile);
        for (List document : documents) {
            this.printLabelValue(document);
        }
    }

    public void printLabelValue(List<IN> document) {
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        DecimalFormat nf = new DecimalFormat();
        ArrayList classes = new ArrayList();
        for (int i = 0; i < this.classIndex.size(); ++i) {
            classes.add(this.classIndex.get(i));
        }
        Object[] columnHeaders = classes.toArray(new String[classes.size()]);
        for (int j = 0; j < document.size(); ++j) {
            System.out.println("--== " + (String)((CoreMap)document.get(j)).get(CoreAnnotations.TextAnnotation.class) + " ==--");
            ArrayList<String[]> lines = new ArrayList<String[]>();
            ArrayList<String> rowHeaders = new ArrayList<String>();
            ArrayList<String> line = new ArrayList<String>();
            for (int p = 0; p < this.labelIndices.length; ++p) {
                if (j + p >= document.size()) continue;
                CRFDatum<List<String>, CRFLabel> d = this.makeDatum(document, j + p, this.featureFactory);
                List<List<String>> features = d.asFeatures();
                int fSize = features.size();
                for (int k = p; k < fSize; ++k) {
                    Collection cliqueFeatures = features.get(k);
                    for (String feature : cliqueFeatures) {
                        int index = this.featureIndex.indexOf(feature);
                        if (index < 0) continue;
                        rowHeaders.add(feature + '[' + -p + ']');
                        double[] values = new double[this.labelIndices[0].size()];
                        for (CRFLabel label : this.labelIndices[k]) {
                            int[] l = label.getLabel();
                            double v = this.weights[index][this.labelIndices[k].indexOf(label)];
                            int n = l[l.length - 1 - p];
                            values[n] = values[n] + v;
                        }
                        for (double value : values) {
                            line.add(nf.format(value));
                        }
                        lines.add(line.toArray(new String[line.size()]));
                        line = new ArrayList();
                    }
                }
                System.out.println(StringUtils.makeAsciiTable((Object[][])lines.toArray((T[])new String[lines.size()][0]), rowHeaders.toArray(new String[rowHeaders.size()]), columnHeaders, 0, 1, true));
                System.out.println();
            }
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
    }

    public Pair<int[][][][], int[][]> documentsToDataAndLabels(Collection<List<IN>> documents) {
        ArrayList<int[][][]> data = new ArrayList<int[][][]>();
        ArrayList<int[]> labels = new ArrayList<int[]>();
        int numDatums = 0;
        for (List<IN> doc : documents) {
            Pair<int[][][], int[]> docPair = this.documentToDataAndLabels(doc);
            data.add(docPair.first());
            labels.add(docPair.second());
            numDatums += doc.size();
        }
        System.err.println("numClasses: " + this.classIndex.size() + ' ' + this.classIndex);
        System.err.println("numDocuments: " + data.size());
        System.err.println("numDatums: " + numDatums);
        System.err.println("numFeatures: " + this.featureIndex.size());
        this.printFeatures();
        int[][][][] dataA = new int[][][][]{};
        int[][] labelsA = new int[][]{};
        return new Pair<T[], T[]>(data.toArray((T[])dataA), labels.toArray((T[])labelsA));
    }

    public List<Pair<int[][][], int[]>> documentsToDataAndLabelsList(Collection<List<IN>> documents) {
        int numDatums = 0;
        ArrayList<Pair<int[][][], int[]>> docList = new ArrayList<Pair<int[][][], int[]>>();
        for (List<IN> doc : documents) {
            Pair<int[][][], int[]> docPair = this.documentToDataAndLabels(doc);
            docList.add(docPair);
            numDatums += doc.size();
        }
        System.err.println("numClasses: " + this.classIndex.size() + ' ' + this.classIndex);
        System.err.println("numDocuments: " + docList.size());
        System.err.println("numDatums: " + numDatums);
        System.err.println("numFeatures: " + this.featureIndex.size());
        return docList;
    }

    private void printFeatures() {
        if (this.flags.printFeatures == null) {
            return;
        }
        try {
            String enc = this.flags.inputEncoding;
            if (this.flags.inputEncoding == null) {
                System.err.println("flags.inputEncoding doesn't exist, Use UTF-8 as default");
                enc = "UTF-8";
            }
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream("feats-" + this.flags.printFeatures + ".txt"), enc), true);
            for (String feat : this.featureIndex) {
                pw.println(feat);
            }
            pw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void makeAnswerArraysAndTagIndex(Collection<List<IN>> ob) {
        int i;
        int i2;
        HashSet[] featureIndices = new HashSet[this.windowSize];
        for (i2 = 0; i2 < this.windowSize; ++i2) {
            featureIndices[i2] = new HashSet();
        }
        this.labelIndices = new HashIndex[this.windowSize];
        for (i2 = 0; i2 < this.labelIndices.length; ++i2) {
            this.labelIndices[i2] = new HashIndex<CRFLabel>();
        }
        Index<CRFLabel> labelIndex = this.labelIndices[this.windowSize - 1];
        this.classIndex = new HashIndex();
        this.classIndex.add(this.flags.backgroundSymbol);
        HashSet[] seenBackgroundFeatures = new HashSet[]{new HashSet(), new HashSet()};
        for (List<IN> doc : ob) {
            int j;
            if (this.flags.useReverse) {
                Collections.reverse(doc);
            }
            int docSize = doc.size();
            for (j = 0; j < docSize; ++j) {
                String ans = (String)((CoreMap)doc.get(j)).get(CoreAnnotations.AnswerAnnotation.class);
                this.classIndex.add(ans);
            }
            for (j = 0; j < docSize; ++j) {
                CRFDatum<List<String>, CRFLabel> d = this.makeDatum(doc, j, this.featureFactory);
                labelIndex.add(d.label());
                List<List<String>> features = d.asFeatures();
                int fsize = features.size();
                for (int k = 0; k < fsize; ++k) {
                    Collection cliqueFeatures = features.get(k);
                    if (k < 2 && this.flags.removeBackgroundSingletonFeatures) {
                        String ans = (String)((CoreMap)doc.get(j)).get(CoreAnnotations.AnswerAnnotation.class);
                        boolean background = ans.equals(this.flags.backgroundSymbol);
                        if (k == 1 && j > 0 && background) {
                            ans = (String)((CoreMap)doc.get(j - 1)).get(CoreAnnotations.AnswerAnnotation.class);
                            background = ans.equals(this.flags.backgroundSymbol);
                        }
                        if (background) {
                            for (String f : cliqueFeatures) {
                                if (featureIndices[k].contains(f)) continue;
                                if (seenBackgroundFeatures[k].contains(f)) {
                                    seenBackgroundFeatures[k].remove(f);
                                    featureIndices[k].add(f);
                                    continue;
                                }
                                seenBackgroundFeatures[k].add(f);
                            }
                            continue;
                        }
                        seenBackgroundFeatures[k].removeAll(cliqueFeatures);
                        featureIndices[k].addAll(cliqueFeatures);
                        continue;
                    }
                    featureIndices[k].addAll(cliqueFeatures);
                }
            }
            if (!this.flags.useReverse) continue;
            Collections.reverse(doc);
        }
        int numFeatures = 0;
        for (i = 0; i < this.windowSize; ++i) {
            numFeatures += featureIndices[i].size();
        }
        this.featureIndex = new HashIndex<String>();
        this.map = new int[numFeatures];
        for (i = 0; i < this.windowSize; ++i) {
            this.featureIndex.addAll(featureIndices[i]);
            for (String str : featureIndices[i]) {
                this.map[this.featureIndex.indexOf((String)str)] = i;
            }
        }
        if (this.flags.useObservedSequencesOnly) {
            int liSize = labelIndex.size();
            for (i = 0; i < liSize; ++i) {
                CRFLabel label = labelIndex.get(i);
                for (int j = this.windowSize - 2; j >= 0; --j) {
                    label = label.getOneSmallerLabel();
                    this.labelIndices[j].add(label);
                }
            }
        } else {
            for (i = 0; i < this.labelIndices.length; ++i) {
                this.labelIndices[i] = CRFClassifier.allLabels(i + 1, this.classIndex);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static Index<CRFLabel> allLabels(int window, Index classIndex) {
        label = new int[window];
        numClasses = classIndex.size();
        labelIndex = new HashIndex<CRFLabel>();
        block0: while (true) {
            l = new CRFLabel(label);
            labelIndex.add(l);
            label1 = new int[window];
            System.arraycopy(label, 0, label1, 0, label.length);
            label = label1;
            j = 0;
            while (true) {
                if (j >= label.length) continue block0;
                v0 = j;
                label[v0] = label[v0] + 1;
                if (label[j] >= numClasses) ** break;
                continue block0;
                label[j] = 0;
                if (j == label.length - 1) break block0;
                ++j;
            }
            break;
        }
        return labelIndex;
    }

    public CRFDatum<List<String>, CRFLabel> makeDatum(List<IN> info, int loc, FeatureFactory<IN> featureFactory) {
        this.pad.set(CoreAnnotations.AnswerAnnotation.class, this.flags.backgroundSymbol);
        PaddedList<CoreMap> pInfo = new PaddedList<CoreMap>(info, this.pad);
        ArrayList<List<String>> features = new ArrayList<List<String>>();
        HashSet<Clique> done = new HashSet<Clique>();
        for (int i = 0; i < this.windowSize; ++i) {
            ArrayList<String> featuresC = new ArrayList<String>();
            List<Clique> windowCliques = FeatureFactory.getCliques(i, 0);
            windowCliques.removeAll(done);
            done.addAll(windowCliques);
            for (Clique c : windowCliques) {
                featuresC.addAll(featureFactory.getCliqueFeatures(pInfo, loc, c));
            }
            features.add(featuresC);
        }
        int[] labels = new int[this.windowSize];
        for (int i = 0; i < this.windowSize; ++i) {
            String answer = (String)pInfo.get(loc + i - this.windowSize + 1).get(CoreAnnotations.AnswerAnnotation.class);
            labels[i] = this.classIndex.indexOf(answer);
        }
        this.printFeatureLists(pInfo.get(loc), features);
        CRFDatum<List<String>, CRFLabel> d = new CRFDatum<List<String>, CRFLabel>(features, new CRFLabel(labels));
        return d;
    }

    @Override
    public List<IN> classify(List<IN> document) {
        if (this.flags.doGibbs) {
            try {
                return this.classifyGibbs(document);
            }
            catch (Exception e) {
                System.err.println("Error running testGibbs inference!");
                e.printStackTrace();
                return null;
            }
        }
        if (this.flags.crfType.equalsIgnoreCase("maxent")) {
            return this.classifyMaxEnt(document);
        }
        throw new RuntimeException("Unsupported inference type: " + this.flags.crfType);
    }

    private List<IN> classify(List<IN> document, Pair<int[][][], int[]> documentDataAndLabels) {
        if (this.flags.doGibbs) {
            try {
                return this.classifyGibbs(document, documentDataAndLabels);
            }
            catch (Exception e) {
                System.err.println("Error running testGibbs inference!");
                e.printStackTrace();
                return null;
            }
        }
        if (this.flags.crfType.equalsIgnoreCase("maxent")) {
            return this.classifyMaxEnt(document, documentDataAndLabels);
        }
        throw new RuntimeException("Unsupported inference type: " + this.flags.crfType);
    }

    public void classifyAndWriteAnswers(Collection<List<IN>> documents, List<Pair<int[][][], int[]>> documentDataAndLabels, OutputStream outStream) throws IOException {
        Timing timer = new Timing();
        ClassicCounter<String> entityTP = new ClassicCounter<String>();
        ClassicCounter<String> entityFP = new ClassicCounter<String>();
        ClassicCounter<String> entityFN = new ClassicCounter<String>();
        boolean resultsCounted = true;
        int numWords = 0;
        int numDocs = 0;
        for (List<IN> doc : documents) {
            this.classify(doc, documentDataAndLabels.get(numDocs));
            numWords += doc.size();
            this.writeAnswers(doc, outStream);
            resultsCounted = resultsCounted && this.countResults(doc, entityTP, entityFP, entityFN);
            ++numDocs;
        }
        long millis = timer.stop();
        double wordspersec = (double)numWords / ((double)millis / 1000.0);
        DecimalFormat nf = new DecimalFormat("0.00");
        System.err.println(StringUtils.getShortClassName(this) + " tagged " + numWords + " words in " + numDocs + " documents at " + nf.format(wordspersec) + " words per second.");
        if (resultsCounted) {
            this.printResults(entityTP, entityFP, entityFN);
        }
    }

    @Override
    public SequenceModel getSequenceModel(List<IN> doc) {
        Pair<int[][][], int[]> p = this.documentToDataAndLabels(doc);
        return this.getSequenceModel(doc, p);
    }

    public SequenceModel getSequenceModel(List<IN> doc, Pair<int[][][], int[]> documentDataAndLabels) {
        Pair<int[][][], int[]> p = documentDataAndLabels;
        int[][][] data = p.first();
        CRFCliqueTree cliqueTree = CRFCliqueTree.getCalibratedCliqueTree(this.weights, data, this.labelIndices, this.classIndex.size(), this.classIndex, this.flags.backgroundSymbol);
        return new TestSequenceModel(cliqueTree);
    }

    public List<IN> classifyMaxEnt(List<IN> document) {
        if (document.isEmpty()) {
            return document;
        }
        SequenceModel model = this.getSequenceModel(document);
        return this.classifyMaxEnt(document, model);
    }

    private List<IN> classifyMaxEnt(List<IN> document, Pair<int[][][], int[]> documentDataAndLabels) {
        if (document.isEmpty()) {
            return document;
        }
        SequenceModel model = this.getSequenceModel(document, documentDataAndLabels);
        return this.classifyMaxEnt(document, model);
    }

    private List<IN> classifyMaxEnt(List<IN> document, SequenceModel model) {
        BestSequenceFinder tagInference;
        if (document.isEmpty()) {
            return document;
        }
        if (this.flags.inferenceType == null) {
            this.flags.inferenceType = "Viterbi";
        }
        if (this.flags.inferenceType.equalsIgnoreCase("Viterbi")) {
            tagInference = new ExactBestSequenceFinder();
        } else if (this.flags.inferenceType.equalsIgnoreCase("Beam")) {
            tagInference = new BeamBestSequenceFinder(this.flags.beamSize);
        } else {
            throw new RuntimeException("Unknown inference type: " + this.flags.inferenceType + ". Your options are Viterbi|Beam.");
        }
        int[] bestSequence = tagInference.bestSequence(model);
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        int docSize = document.size();
        for (int j = 0; j < docSize; ++j) {
            CoreMap wi = (CoreMap)document.get(j);
            String guess = (String)this.classIndex.get(bestSequence[j + this.windowSize - 1]);
            wi.set(CoreAnnotations.AnswerAnnotation.class, guess);
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        return document;
    }

    public List<IN> classifyGibbs(List<IN> document) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Pair<int[][][], int[]> p = this.documentToDataAndLabels(document);
        return this.classifyGibbs(document, p);
    }

    public List<IN> classifyGibbs(List<IN> document, Pair<int[][][], int[]> documentDataAndLabels) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        EntityCachingAbstractSequencePrior prior;
        CRFCliqueTree cliqueTree;
        Pair<int[][][], int[]> p = documentDataAndLabels;
        int[][][] data = p.first();
        List<IN> newDocument = document;
        if (this.flags.useReverse) {
            Collections.reverse(document);
            newDocument = new ArrayList<IN>(document);
            Collections.reverse(document);
        }
        SequenceModel model = cliqueTree = CRFCliqueTree.getCalibratedCliqueTree(this.weights, data, this.labelIndices, this.classIndex.size(), this.classIndex, this.flags.backgroundSymbol);
        SequenceListener listener = cliqueTree;
        SequenceListener priorModel = null;
        SequenceListener priorListener = null;
        if (this.flags.useNERPrior) {
            priorModel = prior = new EmpiricalNERPrior<IN>(this.flags.backgroundSymbol, this.classIndex, newDocument);
            priorListener = prior;
        } else if (this.flags.useAcqPrior) {
            priorModel = prior = new AcquisitionsPrior<IN>(this.flags.backgroundSymbol, this.classIndex, newDocument);
            priorListener = prior;
        } else if (this.flags.useSemPrior) {
            priorModel = prior = new SeminarsPrior<IN>(this.flags.backgroundSymbol, this.classIndex, newDocument);
            priorListener = prior;
        } else if (this.flags.useUniformPrior) {
            UniformPrior<IN> uniPrior = new UniformPrior<IN>(this.flags.backgroundSymbol, this.classIndex, newDocument);
            priorModel = uniPrior;
            priorListener = uniPrior;
        } else {
            throw new RuntimeException("no prior specified");
        }
        model = new FactoredSequenceModel(model, (SequenceModel)((Object)priorModel));
        listener = new FactoredSequenceListener(listener, priorListener);
        SequenceGibbsSampler sampler = new SequenceGibbsSampler(0, 0, listener);
        int[] sequence = new int[cliqueTree.length()];
        if (this.flags.initViterbi) {
            TestSequenceModel testSequenceModel = new TestSequenceModel(cliqueTree);
            ExactBestSequenceFinder tagInference = new ExactBestSequenceFinder();
            int[] bestSequence = tagInference.bestSequence(testSequenceModel);
            System.arraycopy(bestSequence, this.windowSize - 1, sequence, 0, sequence.length);
        } else {
            int[] initialSequence = SequenceGibbsSampler.getRandomSequence(model);
            System.arraycopy(initialSequence, 0, sequence, 0, sequence.length);
        }
        SequenceGibbsSampler.verbose = 0;
        if (this.flags.annealingType.equalsIgnoreCase("linear")) {
            sequence = sampler.findBestUsingAnnealing(model, CoolingSchedule.getLinearSchedule(1.0, this.flags.numSamples), sequence);
        } else if (this.flags.annealingType.equalsIgnoreCase("exp") || this.flags.annealingType.equalsIgnoreCase("exponential")) {
            sequence = sampler.findBestUsingAnnealing(model, CoolingSchedule.getExponentialSchedule(1.0, this.flags.annealingRate, this.flags.numSamples), sequence);
        } else {
            throw new RuntimeException("No annealing type specified");
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        int dsize = newDocument.size();
        for (int j = 0; j < dsize; ++j) {
            CoreMap wi = (CoreMap)document.get(j);
            if (wi == null) {
                throw new RuntimeException("");
            }
            if (this.classIndex == null) {
                throw new RuntimeException("");
            }
            wi.set(CoreAnnotations.AnswerAnnotation.class, this.classIndex.get(sequence[j]));
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        return document;
    }

    public List<IN> classifyGibbsUsingPrior(List<IN> sentence, SequenceModel[] priorModels, SequenceListener[] priorListeners, double[] modelWts) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        CRFCliqueTree cliqueTree;
        if (priorModels.length + 1 != modelWts.length) {
            throw new RuntimeException("modelWts array should be longer than the priorModels array by 1 unit since it also includes the weight of the CRF model at position 0.");
        }
        Pair<int[][][], int[]> p = this.documentToDataAndLabels(sentence);
        int[][][] data = p.first();
        List<IN> newDocument = sentence;
        if (this.flags.useReverse) {
            Collections.reverse(sentence);
            newDocument = new ArrayList<IN>(sentence);
            Collections.reverse(sentence);
        }
        SequenceModel model = cliqueTree = CRFCliqueTree.getCalibratedCliqueTree(this.weights, data, this.labelIndices, this.classIndex.size(), this.classIndex, this.flags.backgroundSymbol);
        SequenceListener listener = cliqueTree;
        SequenceModel[] models = new SequenceModel[priorModels.length + 1];
        models[0] = model;
        for (int i = 1; i < models.length; ++i) {
            models[i] = priorModels[i - 1];
        }
        model = new FactoredSequenceModel(models, modelWts);
        SequenceListener[] listeners = new SequenceListener[priorListeners.length + 1];
        listeners[0] = listener;
        for (int i = 1; i < listeners.length; ++i) {
            listeners[i] = priorListeners[i - 1];
        }
        listener = new FactoredSequenceListener(listeners);
        SequenceGibbsSampler sampler = new SequenceGibbsSampler(0, 0, listener);
        int[] sequence = new int[cliqueTree.length()];
        if (this.flags.initViterbi) {
            TestSequenceModel testSequenceModel = new TestSequenceModel(cliqueTree);
            ExactBestSequenceFinder tagInference = new ExactBestSequenceFinder();
            int[] bestSequence = tagInference.bestSequence(testSequenceModel);
            System.arraycopy(bestSequence, this.windowSize - 1, sequence, 0, sequence.length);
        } else {
            int[] initialSequence = SequenceGibbsSampler.getRandomSequence(model);
            System.arraycopy(initialSequence, 0, sequence, 0, sequence.length);
        }
        SequenceGibbsSampler.verbose = 0;
        if (this.flags.annealingType.equalsIgnoreCase("linear")) {
            sequence = sampler.findBestUsingAnnealing(model, CoolingSchedule.getLinearSchedule(1.0, this.flags.numSamples), sequence);
        } else if (this.flags.annealingType.equalsIgnoreCase("exp") || this.flags.annealingType.equalsIgnoreCase("exponential")) {
            sequence = sampler.findBestUsingAnnealing(model, CoolingSchedule.getExponentialSchedule(1.0, this.flags.annealingRate, this.flags.numSamples), sequence);
        } else {
            throw new RuntimeException("No annealing type specified");
        }
        if (this.flags.useReverse) {
            Collections.reverse(sentence);
        }
        int dsize = newDocument.size();
        for (int j = 0; j < dsize; ++j) {
            CoreMap wi = (CoreMap)sentence.get(j);
            if (wi == null) {
                throw new RuntimeException("");
            }
            if (this.classIndex == null) {
                throw new RuntimeException("");
            }
            wi.set(CoreAnnotations.AnswerAnnotation.class, this.classIndex.get(sequence[j]));
        }
        if (this.flags.useReverse) {
            Collections.reverse(sentence);
        }
        return sentence;
    }

    public List<IN> classifyGibbsUsingPrior(List<IN> sentence, SequenceModel priorModel, SequenceListener priorListener, double model1Wt, double model2Wt) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        CRFCliqueTree cliqueTree;
        Pair<int[][][], int[]> p = this.documentToDataAndLabels(sentence);
        int[][][] data = p.first();
        List<IN> newDocument = sentence;
        if (this.flags.useReverse) {
            newDocument = new ArrayList<IN>(sentence);
            Collections.reverse(newDocument);
        }
        SequenceModel model = cliqueTree = CRFCliqueTree.getCalibratedCliqueTree(this.weights, data, this.labelIndices, this.classIndex.size(), this.classIndex, this.flags.backgroundSymbol);
        SequenceListener listener = cliqueTree;
        model = new FactoredSequenceModel(model, priorModel, model1Wt, model2Wt);
        listener = new FactoredSequenceListener(listener, priorListener);
        SequenceGibbsSampler sampler = new SequenceGibbsSampler(0, 0, listener);
        int[] sequence = new int[cliqueTree.length()];
        if (this.flags.initViterbi) {
            TestSequenceModel testSequenceModel = new TestSequenceModel(cliqueTree);
            ExactBestSequenceFinder tagInference = new ExactBestSequenceFinder();
            int[] bestSequence = tagInference.bestSequence(testSequenceModel);
            System.arraycopy(bestSequence, this.windowSize - 1, sequence, 0, sequence.length);
        } else {
            int[] initialSequence = SequenceGibbsSampler.getRandomSequence(model);
            System.arraycopy(initialSequence, 0, sequence, 0, sequence.length);
        }
        SequenceGibbsSampler.verbose = 0;
        if (this.flags.annealingType.equalsIgnoreCase("linear")) {
            sequence = sampler.findBestUsingAnnealing(model, CoolingSchedule.getLinearSchedule(1.0, this.flags.numSamples), sequence);
        } else if (this.flags.annealingType.equalsIgnoreCase("exp") || this.flags.annealingType.equalsIgnoreCase("exponential")) {
            sequence = sampler.findBestUsingAnnealing(model, CoolingSchedule.getExponentialSchedule(1.0, this.flags.annealingRate, this.flags.numSamples), sequence);
        } else {
            throw new RuntimeException("No annealing type specified");
        }
        if (this.flags.useReverse) {
            Collections.reverse(sentence);
        }
        int dsize = newDocument.size();
        for (int j = 0; j < dsize; ++j) {
            CoreMap wi = (CoreMap)sentence.get(j);
            if (wi == null) {
                throw new RuntimeException("");
            }
            if (this.classIndex == null) {
                throw new RuntimeException("");
            }
            wi.set(CoreAnnotations.AnswerAnnotation.class, this.classIndex.get(sequence[j]));
        }
        if (this.flags.useReverse) {
            Collections.reverse(sentence);
        }
        return sentence;
    }

    @Override
    public void printProbsDocument(List<IN> document) {
        Pair<int[][][], int[]> p = this.documentToDataAndLabels(document);
        int[][][] data = p.first();
        CRFCliqueTree cliqueTree = CRFCliqueTree.getCalibratedCliqueTree(this.weights, data, this.labelIndices, this.classIndex.size(), this.classIndex, this.flags.backgroundSymbol);
        for (int i = 0; i < cliqueTree.length(); ++i) {
            CoreMap wi = (CoreMap)document.get(i);
            System.out.print((String)wi.get(CoreAnnotations.TextAnnotation.class) + '\t');
            Iterator iter = this.classIndex.iterator();
            while (iter.hasNext()) {
                String label = (String)iter.next();
                int index = this.classIndex.indexOf(label);
                double prob = cliqueTree.prob(i, index);
                System.out.print(label + '=' + prob);
                if (iter.hasNext()) {
                    System.out.print("\t");
                    continue;
                }
                System.out.print("\n");
            }
        }
    }

    public void printFirstOrderProbs(String filename) {
        this.flags.ocrTrain = false;
        ObjectBank docs = this.makeObjectBankFromFile(filename);
        this.printFirstOrderProbsDocuments(docs);
    }

    public void printFirstOrderProbsDocuments(ObjectBank<List<IN>> documents) {
        for (List<IN> doc : documents) {
            this.printFirstOrderProbsDocument(doc);
            System.out.println();
        }
    }

    public List<CRFCliqueTree> getCliqueTrees(String filename) {
        this.flags.ocrTrain = false;
        ArrayList<CRFCliqueTree> cts = new ArrayList<CRFCliqueTree>();
        ObjectBank docs = this.makeObjectBankFromFile(filename);
        for (List doc : docs) {
            cts.add(this.getCliqueTree(doc));
        }
        return cts;
    }

    private CRFCliqueTree getCliqueTree(List<IN> document) {
        Pair<int[][][], int[]> p = this.documentToDataAndLabels(document);
        int[][][] data = p.first();
        return CRFCliqueTree.getCalibratedCliqueTree(this.weights, data, this.labelIndices, this.classIndex.size(), this.classIndex, this.flags.backgroundSymbol);
    }

    public void printFirstOrderProbsDocument(List<IN> document) {
        CRFCliqueTree cliqueTree = this.getCliqueTree(document);
        for (int i = 0; i < cliqueTree.length(); ++i) {
            CoreMap wi = (CoreMap)document.get(i);
            System.out.print((String)wi.get(CoreAnnotations.TextAnnotation.class) + '\t');
            Iterator iter = this.classIndex.iterator();
            while (iter.hasNext()) {
                String label = (String)iter.next();
                int index = this.classIndex.indexOf(label);
                if (i == 0) {
                    double prob = cliqueTree.prob(i, index);
                    System.out.print(label + '=' + prob);
                    if (iter.hasNext()) {
                        System.out.print("\t");
                        continue;
                    }
                    System.out.print("\n");
                    continue;
                }
                Iterator iter1 = this.classIndex.iterator();
                while (iter1.hasNext()) {
                    String label1 = (String)iter1.next();
                    int index1 = this.classIndex.indexOf(label1);
                    double prob = cliqueTree.prob(i, new int[]{index1, index});
                    System.out.print(label1 + '_' + label + '=' + prob);
                    if (iter.hasNext() || iter1.hasNext()) {
                        System.out.print("\t");
                        continue;
                    }
                    System.out.print("\n");
                }
            }
        }
    }

    @Override
    public void train(Collection<List<IN>> docs) {
        Timing timer = new Timing();
        timer.start();
        this.makeAnswerArraysAndTagIndex(docs);
        long elapsedMs = timer.stop();
        System.err.println("Time to convert docs to feature indices: " + Timing.toSecondsString(elapsedMs) + " seconds");
        if (this.flags.exportFeatures != null) {
            timer.start();
            CRFFeatureExporter<IN> featureExporter = new CRFFeatureExporter<IN>(this);
            featureExporter.printFeatures(this.flags.exportFeatures, docs);
            elapsedMs = timer.stop();
            System.err.println("Time to export features: " + Timing.toSecondsString(elapsedMs) + " seconds");
        }
        for (int i = 0; i <= this.flags.numTimesPruneFeatures; ++i) {
            Object[] weights;
            Object[] initialWeights;
            Minimizer minimizer;
            Object func;
            List processedData;
            timer.start();
            Pair<int[][][][], int[][]> dataAndLabels = this.documentsToDataAndLabels(docs);
            elapsedMs = timer.stop();
            System.err.println("Time to convert docs to data/labels: " + Timing.toSecondsString(elapsedMs) + " seconds");
            Evaluator[] evaluators = null;
            if (this.flags.evaluateIters > 0) {
                CRFClassifierEvaluator crfEvaluator;
                ArrayList<Evaluator> evaluatorList = new ArrayList<Evaluator>();
                evaluatorList.add(new MemoryEvaluator());
                if (this.flags.evaluateTrain) {
                    crfEvaluator = new CRFClassifierEvaluator("Train set", this);
                    ArrayList<Pair<int[][][], int[]>> trainDataAndLabels = new ArrayList<Pair<int[][][], int[]>>();
                    for (int j = 0; j < dataAndLabels.first().length; ++j) {
                        Pair<int[][][], int[]> p = new Pair<int[][][], int[]>(dataAndLabels.first()[j], dataAndLabels.second()[j]);
                        trainDataAndLabels.add(p);
                    }
                    crfEvaluator.setTestData(docs, trainDataAndLabels);
                    crfEvaluator.setEvalCmd(this.flags.evalCmd);
                    evaluatorList.add(crfEvaluator);
                }
                if (this.flags.testFile != null) {
                    crfEvaluator = new CRFClassifierEvaluator("Test set (" + this.flags.testFile + ")", this);
                    ObjectBank testObjBank = this.makeObjectBankFromFile(this.flags.testFile);
                    List<Pair<int[][][], int[]>> testDataAndLabels = this.documentsToDataAndLabelsList(testObjBank);
                    crfEvaluator.setTestData(testObjBank, testDataAndLabels);
                    crfEvaluator.setEvalCmd(this.flags.evalCmd);
                    evaluatorList.add(crfEvaluator);
                }
                if (this.flags.testFiles != null) {
                    String[] testFiles;
                    for (String testFile : testFiles = this.flags.testFiles.split(",")) {
                        CRFClassifierEvaluator crfEvaluator2 = new CRFClassifierEvaluator("Test set (" + testFile + ")", this);
                        ObjectBank testObjBank = this.makeObjectBankFromFile(testFile);
                        List<Pair<int[][][], int[]>> testDataAndLabels = this.documentsToDataAndLabelsList(testObjBank);
                        crfEvaluator2.setTestData(testObjBank, testDataAndLabels);
                        crfEvaluator2.setEvalCmd(this.flags.evalCmd);
                        evaluatorList.add(crfEvaluator2);
                    }
                }
                evaluators = new Evaluator[evaluatorList.size()];
                evaluatorList.toArray(evaluators);
            }
            if (this.flags.numTimesPruneFeatures == i) {
                docs = null;
            }
            File featIndexFile = null;
            if (this.flags.saveFeatureIndexToDisk) {
                try {
                    System.err.println("Writing feature index to temporary file.");
                    featIndexFile = IOUtils.writeObjectToTempFile(this.featureIndex, "featIndex" + i + ".tmp");
                    this.featureIndex = null;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not open temporary feature index file for writing.");
                }
            }
            Object data = dataAndLabels.first();
            Object labels = dataAndLabels.second();
            if (this.flags.loadProcessedData != null && (processedData = CRFClassifier.loadProcessedData(this.flags.loadProcessedData)) != null) {
                int[][][][] allData = new int[((int[][][][])data).length + processedData.size()][][][];
                int[][] allLabels = new int[((int[][])labels).length + processedData.size()][];
                System.arraycopy(data, 0, allData, 0, ((int[][][][])data).length);
                System.arraycopy(labels, 0, allLabels, 0, ((int[][])labels).length);
                this.addProcessedData(processedData, allData, allLabels, ((int[][][][])data).length);
                data = allData;
                labels = allLabels;
            }
            if (this.flags.useFloat) {
                func = new CRFLogConditionalObjectiveFloatFunction((int[][][][])data, (int[][])labels, (Index)this.featureIndex, this.windowSize, this.classIndex, (Index[])this.labelIndices, this.map, this.flags.backgroundSymbol, this.flags.sigma);
                ((CRFLogConditionalObjectiveFloatFunction)func).crfType = this.flags.crfType;
                if (this.flags.interimOutputFreq != 0) {
                    ResultStoringFloatMonitor monitor = new ResultStoringFloatMonitor(this.flags.interimOutputFreq, this.flags.serializeTo);
                    minimizer = new QNMinimizer(monitor);
                } else {
                    minimizer = new QNMinimizer();
                }
                if (i == 0) {
                    ((QNMinimizer)minimizer).setM(this.flags.QNsize);
                } else {
                    ((QNMinimizer)minimizer).setM(this.flags.QNsize2);
                }
                if (this.flags.initialWeights == null) {
                    initialWeights = ((AbstractCachingDiffFloatFunction)func).initial();
                } else {
                    try {
                        System.err.println("Reading initial weights from file " + this.flags.initialWeights);
                        DataInputStream dis = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(this.flags.initialWeights))));
                        initialWeights = Convert.readFloatArr(dis);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not read from float initial weight file " + this.flags.initialWeights);
                    }
                }
                System.err.println("numWeights: " + initialWeights.length);
                weights = ((QNMinimizer)minimizer).minimize((DiffFloatFunction)func, (float)this.flags.tolerance, (float[])initialWeights);
                this.weights = ArrayMath.floatArrayToDoubleArray(((CRFLogConditionalObjectiveFloatFunction)func).to2D((float[])weights));
            } else {
                func = new CRFLogConditionalObjectiveFunction((int[][][][])data, (int[][])labels, (Index)this.featureIndex, this.windowSize, this.classIndex, (Index[])this.labelIndices, this.map, this.flags.backgroundSymbol, this.flags.sigma);
                ((CRFLogConditionalObjectiveFunction)func).crfType = this.flags.crfType;
                if (evaluators != null) {
                    for (Evaluator eval : evaluators) {
                        if (!(eval instanceof CRFClassifierEvaluator)) continue;
                        ((CRFClassifierEvaluator)eval).setHelperFunction((CRFLogConditionalObjectiveFunction)func);
                    }
                }
                minimizer = this.getMinimizer(i, evaluators);
                if (this.flags.initialWeights == null) {
                    initialWeights = ((AbstractStochasticCachingDiffFunction)func).initial();
                } else {
                    try {
                        System.err.println("Reading initial weights from file " + this.flags.initialWeights);
                        DataInputStream dis = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(this.flags.initialWeights))));
                        initialWeights = Convert.readDoubleArr(dis);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not read from double initial weight file " + this.flags.initialWeights);
                    }
                }
                System.err.println("numWeights: " + initialWeights.length);
                if (this.flags.testObjFunction) {
                    StochasticDiffFunctionTester tester = new StochasticDiffFunctionTester((Function)func);
                    if (tester.testSumOfBatches((double[])initialWeights, 1.0E-4)) {
                        System.err.println("Testing complete... exiting");
                        System.exit(1);
                    } else {
                        System.err.println("Testing failed....exiting");
                        System.exit(1);
                    }
                }
                weights = minimizer.minimize(func, this.flags.tolerance, (double[])initialWeights);
                this.weights = ((CRFLogConditionalObjectiveFunction)func).to2D((double[])weights);
            }
            if (this.flags.saveFeatureIndexToDisk) {
                try {
                    System.err.println("Reading temporary feature index file.");
                    this.featureIndex = (Index)IOUtils.readObjectFromFile(featIndexFile);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not open temporary feature index file for reading.");
                }
            }
            if (i == this.flags.numTimesPruneFeatures) continue;
            this.dropFeaturesBelowThreshold(this.flags.featureDiffThresh);
            System.err.println("Removing features with weight below " + this.flags.featureDiffThresh + " and retraining...");
        }
    }

    protected Minimizer getMinimizer() {
        return this.getMinimizer(0, null);
    }

    protected Minimizer getMinimizer(int featurePruneIteration, Evaluator[] evaluators) {
        Minimizer<DiffFunction> minimizer = null;
        if (this.flags.useQN) {
            int QNmem = featurePruneIteration == 0 ? this.flags.QNsize : this.flags.QNsize2;
            if (this.flags.interimOutputFreq != 0) {
                ResultStoringMonitor monitor = new ResultStoringMonitor(this.flags.interimOutputFreq, this.flags.serializeTo);
                minimizer = new QNMinimizer(monitor, QNmem, this.flags.useRobustQN);
            } else {
                minimizer = new QNMinimizer(QNmem, this.flags.useRobustQN);
            }
        } else if (this.flags.useInPlaceSGD) {
            StochasticInPlaceMinimizer sgdMinimizer = new StochasticInPlaceMinimizer(this.flags.sigma, this.flags.SGDPasses, this.flags.tuneSampleSize);
            if (this.flags.useSGDtoQN) {
                QNMinimizer qnMinimizer;
                int QNmem = featurePruneIteration == 0 ? this.flags.QNsize : this.flags.QNsize2;
                if (this.flags.interimOutputFreq != 0) {
                    ResultStoringMonitor monitor = new ResultStoringMonitor(this.flags.interimOutputFreq, this.flags.serializeTo);
                    qnMinimizer = new QNMinimizer(monitor, QNmem, this.flags.useRobustQN);
                } else {
                    qnMinimizer = new QNMinimizer(QNmem, this.flags.useRobustQN);
                }
                minimizer = new HybridMinimizer(sgdMinimizer, qnMinimizer, this.flags.SGDPasses);
            } else {
                minimizer = sgdMinimizer;
            }
        } else if (this.flags.useSGDtoQN) {
            minimizer = new SGDToQNMinimizer(this.flags);
        } else if (this.flags.useSMD) {
            minimizer = new SMDMinimizer(this.flags.initialGain, this.flags.stochasticBatchSize, this.flags.stochasticMethod, this.flags.SGDPasses);
        } else if (this.flags.useSGD) {
            minimizer = new SGDMinimizer(this.flags.initialGain, this.flags.stochasticBatchSize);
        } else if (this.flags.useScaledSGD) {
            minimizer = new ScaledSGDMinimizer(this.flags.initialGain, this.flags.stochasticBatchSize, this.flags.SGDPasses, this.flags.scaledSGDMethod);
        } else if (this.flags.l1reg > 0.0) {
            minimizer = (Minimizer)ReflectionLoading.loadByReflection("edu.stanford.nlp.optimization.OWLQNMinimizer", this.flags.l1reg);
        }
        if (minimizer instanceof HasEvaluators) {
            ((HasEvaluators)((Object)minimizer)).setEvaluators(this.flags.evaluateIters, evaluators);
        }
        if (minimizer == null) {
            throw new RuntimeException("No minimizer assigned!");
        }
        return minimizer;
    }

    protected List<CRFDatum> extractDatumSequence(int[][][] allData, int beginPosition, int endPosition, List<IN> labeledWordInfos) {
        CRFDatum datum;
        ArrayList<Collection<Object>> cliqueFeatures;
        int position;
        ArrayList<CRFDatum> result = new ArrayList<CRFDatum>();
        int beginContext = beginPosition - this.windowSize + 1;
        if (beginContext < 0) {
            beginContext = 0;
        }
        for (position = beginContext; position < beginPosition; ++position) {
            cliqueFeatures = new ArrayList<Collection<Object>>();
            for (int i = 0; i < this.windowSize; ++i) {
                cliqueFeatures.add(Collections.emptySet());
            }
            datum = new CRFDatum(cliqueFeatures, ((CoreMap)labeledWordInfos.get(position)).get(CoreAnnotations.AnswerAnnotation.class));
            result.add(datum);
        }
        for (position = beginPosition; position <= endPosition; ++position) {
            cliqueFeatures = new ArrayList();
            for (int i = 0; i < this.windowSize; ++i) {
                ArrayList<String> features = new ArrayList<String>();
                for (int j = 0; j < allData[position][i].length; ++j) {
                    features.add(this.featureIndex.get(allData[position][i][j]));
                }
                cliqueFeatures.add(features);
            }
            datum = new CRFDatum(cliqueFeatures, ((CoreMap)labeledWordInfos.get(position)).get(CoreAnnotations.AnswerAnnotation.class));
            result.add(datum);
        }
        return result;
    }

    protected void addProcessedData(List<List<CRFDatum<Collection<String>, String>>> processedData, int[][][][] data, int[][] labels, int offset) {
        int pdSize = processedData.size();
        for (int i = 0; i < pdSize; ++i) {
            int dataIndex = i + offset;
            List<CRFDatum<Collection<String>, String>> document = processedData.get(i);
            int dsize = document.size();
            labels[dataIndex] = new int[dsize];
            data[dataIndex] = new int[dsize][][];
            for (int j = 0; j < dsize; ++j) {
                CRFDatum<Collection<String>, String> crfDatum = document.get(j);
                labels[dataIndex][j] = this.classIndex.indexOf(crfDatum.label());
                List<Collection<String>> cliques = crfDatum.asFeatures();
                int csize = cliques.size();
                data[dataIndex][j] = new int[csize][];
                for (int k = 0; k < csize; ++k) {
                    Collection<String> features = cliques.get(k);
                    data[dataIndex][j][k] = new int[features.size()];
                    int m = 0;
                    try {
                        for (String feature : features) {
                            if (this.featureIndex == null) {
                                System.out.println("Feature is NULL!");
                            }
                            data[dataIndex][j][k][m] = this.featureIndex.indexOf(feature);
                            ++m;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.printf("[index=%d, j=%d, k=%d, m=%d]\n", dataIndex, j, k, m);
                        System.err.println("data.length                    " + data.length);
                        System.err.println("data[dataIndex].length         " + data[dataIndex].length);
                        System.err.println("data[dataIndex][j].length      " + data[dataIndex][j].length);
                        System.err.println("data[dataIndex][j][k].length   " + data[dataIndex][j].length);
                        System.err.println("data[dataIndex][j][k][m]       " + data[dataIndex][j][k][m]);
                        return;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static void saveProcessedData(List datums, String filename) {
        System.err.print("Saving processsed data of size " + datums.size() + " to serialized file...");
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(filename));
            oos.writeObject(datums);
        }
        catch (IOException iOException) {
            IOUtils.closeIgnoringExceptions(oos);
            catch (Throwable throwable) {
                IOUtils.closeIgnoringExceptions(oos);
                throw throwable;
            }
        }
        IOUtils.closeIgnoringExceptions(oos);
        System.err.println("done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List loadProcessedData(String filename) {
        System.err.print("Loading processed data from serialized file...");
        ObjectInputStream ois = null;
        List result = Collections.emptyList();
        try {
            ois = new ObjectInputStream(new FileInputStream(filename));
            result = (List)ois.readObject();
            IOUtils.closeIgnoringExceptions(ois);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeIgnoringExceptions(ois);
        }
        System.err.println("done. Got " + result.size() + " datums.");
        return result;
    }

    public void loadTextClassifier(String text, Properties props) throws ClassCastException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        int count;
        System.err.println("Loading Text Classifier from " + text);
        BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(text))));
        String line = br.readLine();
        String[] toks = line.split("\\t");
        if (!toks[0].equals("labelIndices.length=")) {
            throw new RuntimeException("format error");
        }
        int size = Integer.parseInt(toks[1]);
        this.labelIndices = new HashIndex[size];
        for (int labelIndicesIdx = 0; labelIndicesIdx < size; ++labelIndicesIdx) {
            line = br.readLine();
            toks = line.split("\\t");
            if (!toks[0].startsWith("labelIndices[") || !toks[0].endsWith("].size()=")) {
                throw new RuntimeException("format error");
            }
            int labelIndexSize = Integer.parseInt(toks[1]);
            this.labelIndices[labelIndicesIdx] = new HashIndex<CRFLabel>();
            for (int count2 = 0; count2 < labelIndexSize; ++count2) {
                line = br.readLine();
                toks = line.split("\\t");
                int idx = Integer.parseInt(toks[0]);
                if (count2 != idx) {
                    throw new RuntimeException("format error");
                }
                String[] crflabelstr = toks[1].split(" ");
                int[] crflabel = new int[crflabelstr.length];
                for (int i = 0; i < crflabelstr.length; ++i) {
                    crflabel[i] = Integer.parseInt(crflabelstr[i]);
                }
                CRFLabel crfL = new CRFLabel(crflabel);
                this.labelIndices[labelIndicesIdx].add(crfL);
            }
        }
        System.err.printf("DEBUG: labelIndices.length=\t%d\n", this.labelIndices.length);
        for (int i = 0; i < this.labelIndices.length; ++i) {
            System.err.printf("DEBUG: labelIndices[%d].size()=\t%d\n", i, this.labelIndices[i].size());
            for (int j = 0; j < this.labelIndices[i].size(); ++j) {
                int[] label = this.labelIndices[i].get(j).getLabel();
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int l : label) {
                    list.add(l);
                }
                System.err.printf("DEBUG: %d\t%s\n", j, StringUtils.join(list, " "));
            }
        }
        line = br.readLine();
        toks = line.split("\\t");
        if (!toks[0].equals("classIndex.size()=")) {
            throw new RuntimeException("format error");
        }
        int classIndexSize = Integer.parseInt(toks[1]);
        this.classIndex = new HashIndex();
        for (count = 0; count < classIndexSize; ++count) {
            line = br.readLine();
            toks = line.split("\\t");
            int idx = Integer.parseInt(toks[0]);
            if (count != idx) {
                throw new RuntimeException("format error");
            }
            this.classIndex.add(toks[1]);
        }
        System.err.printf("DEBUG: classIndex.size()=\t%d\n", this.classIndex.size());
        for (int i = 0; i < this.classIndex.size(); ++i) {
            System.err.printf("DEBUG: %d\t%s\n", i, this.classIndex.get(i));
        }
        line = br.readLine();
        toks = line.split("\\t");
        if (!toks[0].equals("featureIndex.size()=")) {
            throw new RuntimeException("format error");
        }
        int featureIndexSize = Integer.parseInt(toks[1]);
        this.featureIndex = new HashIndex<String>();
        for (count = 0; count < featureIndexSize; ++count) {
            line = br.readLine();
            toks = line.split("\\t");
            int idx = Integer.parseInt(toks[0]);
            if (count != idx) {
                throw new RuntimeException("format error");
            }
            this.featureIndex.add(toks[1]);
        }
        System.err.printf("DEBUG: featureIndex.size()=\t%d\n", this.featureIndex.size());
        line = br.readLine();
        if (!line.equals("<flags>")) {
            throw new RuntimeException("format error");
        }
        Properties p = new Properties();
        line = br.readLine();
        while (!line.equals("</flags>")) {
            String[] keyValue = line.split("=");
            p.setProperty(keyValue[0], keyValue[1]);
            line = br.readLine();
        }
        this.flags = new SeqClassifierFlags(p);
        System.err.println("DEBUG: <flags>");
        System.err.print(this.flags.toString());
        System.err.println("DEBUG: </flags>");
        line = br.readLine();
        String[] featureFactoryName = line.split(" ");
        if (!featureFactoryName[0].equals("<featureFactory>") || !featureFactoryName[2].equals("</featureFactory>")) {
            throw new RuntimeException("format error");
        }
        this.featureFactory = (FeatureFactory)Class.forName(featureFactoryName[1]).newInstance();
        this.featureFactory.init(this.flags);
        this.reinit();
        line = br.readLine();
        String[] windowSizeName = line.split(" ");
        if (!windowSizeName[0].equals("<windowSize>") || !windowSizeName[2].equals("</windowSize>")) {
            throw new RuntimeException("format error");
        }
        this.windowSize = Integer.parseInt(windowSizeName[1]);
        line = br.readLine();
        toks = line.split("\\t");
        if (!toks[0].equals("weights.length=")) {
            throw new RuntimeException("format error");
        }
        int weightsLength = Integer.parseInt(toks[1]);
        this.weights = new double[weightsLength][];
        for (count = 0; count < weightsLength; ++count) {
            line = br.readLine();
            toks = line.split("\\t");
            int weights2Length = Integer.parseInt(toks[0]);
            this.weights[count] = new double[weights2Length];
            String[] weightsValue = toks[1].split(" ");
            if (weights2Length != weightsValue.length) {
                throw new RuntimeException("weights format error");
            }
            for (int i2 = 0; i2 < weights2Length; ++i2) {
                this.weights[count][i2] = Double.parseDouble(weightsValue[i2]);
            }
        }
        System.err.printf("DEBUG: double[%d][] weights loaded\n", weightsLength);
        line = br.readLine();
        if (line != null) {
            throw new RuntimeException("weights format error");
        }
    }

    public void serializeTextClassifier(String serializePath) {
        System.err.print("Serializing Text classifier to " + serializePath + "...");
        try {
            int i;
            PrintWriter pw = new PrintWriter(new GZIPOutputStream(new FileOutputStream(serializePath)));
            pw.printf("labelIndices.length=\t%d\n", this.labelIndices.length);
            for (i = 0; i < this.labelIndices.length; ++i) {
                pw.printf("labelIndices[%d].size()=\t%d\n", i, this.labelIndices[i].size());
                for (int j = 0; j < this.labelIndices[i].size(); ++j) {
                    int[] label = this.labelIndices[i].get(j).getLabel();
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    for (int l : label) {
                        list.add(l);
                    }
                    pw.printf("%d\t%s\n", j, StringUtils.join(list, " "));
                }
            }
            pw.printf("classIndex.size()=\t%d\n", this.classIndex.size());
            for (i = 0; i < this.classIndex.size(); ++i) {
                pw.printf("%d\t%s\n", i, this.classIndex.get(i));
            }
            pw.printf("featureIndex.size()=\t%d\n", this.featureIndex.size());
            for (i = 0; i < this.featureIndex.size(); ++i) {
                pw.printf("%d\t%s\n", i, this.featureIndex.get(i));
            }
            pw.println("<flags>");
            pw.print(this.flags.toString());
            pw.println("</flags>");
            pw.printf("<featureFactory> %s </featureFactory>\n", this.featureFactory.getClass().getName());
            pw.printf("<windowSize> %d </windowSize>\n", this.windowSize);
            pw.printf("weights.length=\t%d\n", this.weights.length);
            for (double[] ws : this.weights) {
                ArrayList<Double> list = new ArrayList<Double>();
                for (double w : ws) {
                    list.add(w);
                }
                pw.printf("%d\t%s\n", ws.length, StringUtils.join(list, " "));
            }
            pw.close();
            System.err.println("done.");
        }
        catch (Exception e) {
            System.err.println("Failed");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serializeClassifier(String serializePath) {
        System.err.print("Serializing classifier to " + serializePath + "...");
        ObjectOutputStream oos = null;
        try {
            oos = IOUtils.writeStreamFromString(serializePath);
            oos.writeObject(this.labelIndices);
            oos.writeObject(this.classIndex);
            oos.writeObject(this.featureIndex);
            oos.writeObject(this.flags);
            oos.writeObject(this.featureFactory);
            oos.writeInt(this.windowSize);
            oos.writeObject(this.weights);
            if (this.readerAndWriter instanceof TrueCasingDocumentReaderAndWriter) {
                oos.writeObject(TrueCasingDocumentReaderAndWriter.knownWords);
            }
            oos.writeObject(this.knownLCWords);
            System.err.println("done.");
        }
        catch (Exception e) {
            System.err.println("Failed");
            e.printStackTrace();
        }
        finally {
            IOUtils.closeIgnoringExceptions(oos);
        }
    }

    @Override
    public void loadClassifier(ObjectInputStream ois, Properties props) throws ClassCastException, IOException, ClassNotFoundException {
        this.labelIndices = (Index[])ois.readObject();
        this.classIndex = (Index)ois.readObject();
        this.featureIndex = (Index)ois.readObject();
        this.flags = (SeqClassifierFlags)ois.readObject();
        this.featureFactory = (FeatureFactory)ois.readObject();
        if (props != null) {
            this.flags.setProperties(props, false);
        }
        this.reinit();
        this.windowSize = ois.readInt();
        this.weights = (double[][])ois.readObject();
        if (this.readerAndWriter instanceof TrueCasingDocumentReaderAndWriter) {
            TrueCasingDocumentReaderAndWriter.knownWords = (Set)ois.readObject();
        }
        this.knownLCWords = (Set)ois.readObject();
    }

    public void loadDefaultClassifier() {
        this.loadJarClassifier(DEFAULT_CLASSIFIER, null);
    }

    public void loadDefaultClassifier(Properties props) {
        this.loadJarClassifier(DEFAULT_CLASSIFIER, props);
    }

    public static <IN extends CoreMap> CRFClassifier<IN> getDefaultClassifier() {
        CRFClassifier<IN> crf = new CRFClassifier<IN>();
        crf.loadDefaultClassifier();
        return crf;
    }

    public static <IN extends CoreMap> CRFClassifier<IN> getDefaultClassifier(Properties props) {
        CRFClassifier<IN> crf = new CRFClassifier<IN>();
        crf.loadDefaultClassifier(props);
        return crf;
    }

    public static <IN extends CoreMap> CRFClassifier<IN> getJarClassifier(String resourceName, Properties props) {
        CRFClassifier<IN> crf = new CRFClassifier<IN>();
        crf.loadJarClassifier(resourceName, props);
        return crf;
    }

    public static <IN extends CoreMap> CRFClassifier<IN> getClassifier(File file) throws IOException, ClassCastException, ClassNotFoundException {
        CRFClassifier<IN> crf = new CRFClassifier<IN>();
        crf.loadClassifier(file);
        return crf;
    }

    public static CRFClassifier getClassifier(InputStream in) throws IOException, ClassCastException, ClassNotFoundException {
        CRFClassifier crf = new CRFClassifier();
        crf.loadClassifier(in);
        return crf;
    }

    public static CRFClassifier getClassifierNoExceptions(String loadPath) {
        CRFClassifier crf = new CRFClassifier();
        crf.loadClassifierNoExceptions(loadPath);
        return crf;
    }

    public static CRFClassifier getClassifier(String loadPath) throws IOException, ClassCastException, ClassNotFoundException {
        CRFClassifier crf = new CRFClassifier();
        crf.loadClassifier(loadPath);
        return crf;
    }

    public static CRFClassifier getClassifier(String loadPath, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
        CRFClassifier crf = new CRFClassifier();
        crf.loadClassifier(loadPath, props);
        return crf;
    }

    public static void main(String[] args) throws Exception {
        StringUtils.printErrInvocationString("CRFClassifier", args);
        Properties props = StringUtils.argsToProperties(args);
        CRFClassifier crf = new CRFClassifier(props);
        String testFile = crf.flags.testFile;
        String textFile = crf.flags.textFile;
        String loadPath = crf.flags.loadClassifier;
        String loadTextPath = crf.flags.loadTextClassifier;
        String serializeTo = crf.flags.serializeTo;
        String serializeToText = crf.flags.serializeToText;
        if (loadPath != null) {
            crf.loadClassifierNoExceptions(loadPath, props);
        } else if (loadTextPath != null) {
            System.err.println("Warning: this is now only tested for Chinese Segmenter");
            System.err.println("(Sun Dec 23 00:59:39 2007) (pichuan)");
            try {
                crf.loadTextClassifier(loadTextPath, props);
            }
            catch (Exception e) {
                throw new RuntimeException("error loading " + loadTextPath, e);
            }
        } else if (crf.flags.loadJarClassifier != null) {
            crf.loadJarClassifier(crf.flags.loadJarClassifier, props);
        } else if (crf.flags.trainFile != null || crf.flags.trainFileList != null) {
            crf.train();
        } else {
            crf.loadDefaultClassifier();
        }
        if (serializeTo != null) {
            crf.serializeClassifier(serializeTo);
        }
        if (serializeToText != null) {
            crf.serializeTextClassifier(serializeToText);
        }
        if (testFile != null) {
            if (crf.flags.searchGraphPrefix != null) {
                crf.classifyAndWriteViterbiSearchGraph(testFile, crf.flags.searchGraphPrefix);
            } else if (crf.flags.printFirstOrderProbs) {
                crf.printFirstOrderProbs(testFile);
            } else if (crf.flags.printProbs) {
                crf.printProbs(testFile);
            } else if (crf.flags.useKBest) {
                int k = crf.flags.kBest;
                crf.classifyAndWriteAnswersKBest(testFile, k);
            } else if (crf.flags.printLabelValue) {
                crf.printLabelInformation(testFile);
            } else {
                crf.classifyAndWriteAnswers(testFile);
            }
        }
        if (textFile != null) {
            DocumentReaderAndWriter oldRW = crf.readerAndWriter;
            crf.readerAndWriter = new PlainTextDocumentReaderAndWriter();
            crf.readerAndWriter.init(crf.flags);
            crf.classifyAndWriteAnswers(textFile);
            crf.readerAndWriter = oldRW;
        }
    }

    public static class TestSequenceModel
    implements SequenceModel {
        private int window;
        private int numClasses;
        private CRFCliqueTree cliqueTree;
        private int[] tags;
        private int[] backgroundTag;

        public TestSequenceModel(CRFCliqueTree cliqueTree) {
            this.cliqueTree = cliqueTree;
            this.window = cliqueTree.window();
            this.numClasses = cliqueTree.getNumClasses();
            this.tags = new int[this.numClasses];
            for (int i = 0; i < this.tags.length; ++i) {
                this.tags[i] = i;
            }
            this.backgroundTag = new int[]{cliqueTree.backgroundIndex()};
        }

        public int length() {
            return this.cliqueTree.length();
        }

        public int leftWindow() {
            return this.window - 1;
        }

        public int rightWindow() {
            return 0;
        }

        public int[] getPossibleValues(int pos) {
            if (pos < this.window - 1) {
                return this.backgroundTag;
            }
            return this.tags;
        }

        public double scoreOf(int[] tags, int pos) {
            int[] previous = new int[this.window - 1];
            int realPos = pos - this.window + 1;
            for (int i = 0; i < this.window - 1; ++i) {
                previous[i] = tags[realPos + i];
            }
            return this.cliqueTree.condLogProbGivenPrevious(realPos, tags[pos], previous);
        }

        public double[] scoresOf(int[] tags, int pos) {
            int i;
            int realPos = pos - this.window + 1;
            double[] scores = new double[this.numClasses];
            int[] previous = new int[this.window - 1];
            for (i = 0; i < this.window - 1; ++i) {
                previous[i] = tags[realPos + i];
            }
            for (i = 0; i < this.numClasses; ++i) {
                scores[i] = this.cliqueTree.condLogProbGivenPrevious(realPos, i, previous);
            }
            return scores;
        }

        public double scoreOf(int[] sequence) {
            throw new UnsupportedOperationException();
        }
    }
}

