/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.common;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.ModCollinsHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;

public class NoPunctuationHeadFinder
extends ModCollinsHeadFinder {
    private static final long serialVersionUID = 1201891305937180385L;

    private boolean isPunctuationLabel(String label) {
        return !Character.isLetter(label.charAt(0)) && !label.equals("$") && !label.equals("%");
    }

    protected int postOperationFix(int headIdx, Tree[] daughterTrees) {
        String label;
        int index;
        for (index = super.postOperationFix(headIdx, daughterTrees); index > 0 && this.isPunctuationLabel(label = daughterTrees[index].label().value()); --index) {
        }
        return index;
    }

    public static void main(String[] args) {
        DiskTreebank treebank = new DiskTreebank();
        CategoryWordTag.suppressTerminalDetails = true;
        treebank.loadPath(args[0]);
        final NoPunctuationHeadFinder chf = new NoPunctuationHeadFinder();
        ((Treebank)treebank).apply(new TreeVisitor(){

            public void visitTree(Tree pt) {
                pt.percolateHeads(chf);
                pt.pennPrint();
                System.out.println();
            }
        });
    }
}

