/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.common;

import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTokenize {
    public static ArrayList<String> tokenize(String line) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(line);
        while (tokenizer.hasMoreElements()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    public static ArrayList<String> tokenize(String line, String separators) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(line, separators);
        while (tokenizer.hasMoreElements()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    private static int findNonWhitespace(String s, int start) {
        while (start < s.length()) {
            if (!Character.isWhitespace(s.charAt(start))) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    private static int findWhitespace(String s, int start) {
        while (start < s.length()) {
            if (Character.isWhitespace(s.charAt(start))) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    private static String normalizeQuotes(String str) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\\' && i < str.length() - 1 && str.charAt(i + 1) == '\"') continue;
            buffer.append(str.charAt(i));
        }
        return buffer.toString();
    }

    public static ArrayList<String> tokenizeWithQuotes(String line) {
        ArrayList<String> tokens = new ArrayList<String>();
        int position = 0;
        while ((position = SimpleTokenize.findNonWhitespace(line, position)) != -1) {
            int end = -1;
            if (line.charAt(position) == '\"' && (position == 0 || line.charAt(position - 1) != '\\')) {
                int current = position;
                while (true) {
                    if ((end = line.indexOf(34, current + 1)) == -1) {
                        end = line.length();
                        break;
                    }
                    if (line.charAt(end - 1) != '\\') {
                        ++end;
                        break;
                    }
                    current = end;
                }
                tokens.add(SimpleTokenize.normalizeQuotes(line.substring(position + 1, end - 1)));
            } else {
                end = SimpleTokenize.findWhitespace(line, position + 1);
                if (end == -1) {
                    end = line.length();
                }
                tokens.add(new String(line.substring(position, end)));
            }
            position = end;
        }
        return tokens;
    }

    public static String quotify(String str) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('\"');
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\"') {
                buffer.append('\\');
            }
            buffer.append(str.charAt(i));
        }
        buffer.append('\"');
        return buffer.toString();
    }

    public static void main(String[] argv) {
        String in = "T \"Athens \\\"the beautiful\\\"\" \"Athens\" \"\" \"Greece\"";
        System.err.println("Input: " + in);
        System.err.println(SimpleTokenize.tokenizeWithQuotes(in));
    }
}

