/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.regexp;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.PlainTextDocumentReaderAndWriter;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PaddedList;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberSequenceClassifier
extends AbstractSequenceClassifier<CoreLabel> {
    private static final boolean DEBUG = false;
    public static final Pattern MONTH_PATTERN = Pattern.compile("January|Jan\\.?|February|Feb\\.?|March|Mar\\.?|April|Apr\\.?|May|June|Jun\\.?|July|Jul\\.?|August|Aug\\.?|September|Sept?\\.?|October|Oct\\.?|November|Nov\\.?|December|Dec\\.");
    public static final Pattern YEAR_PATTERN = Pattern.compile("[1-3][0-9]{3}|'?[0-9]{2}");
    public static final Pattern DAY_PATTERN = Pattern.compile("(?:[1-9]|[12][0-9]|3[01])(?:st|nd|rd)?");
    public static final Pattern DATE_PATTERN = Pattern.compile("[0-3][0-9]/[0-3][0-9]/[1-9][0-9]{3}");
    public static final Pattern DATE_PATTERN2 = Pattern.compile("[12][0-9]{3}[-/][01][0-9][-/][0-3][0-9]");
    public static final Pattern TIME_PATTERN = Pattern.compile("[0-2]?[0-9]:[0-5][0-9]");
    public static final Pattern TIME_PATTERN2 = Pattern.compile("[0-2][0-9]:[0-5][0-9]:[0-5][0-9]");
    public static final Pattern CURRENCY_WORD_PATTERN = Pattern.compile("(?:dollar|cent|euro|pound)s?|penny|pence|yen|yuan");
    public static final Pattern ORDINAL_PATTERN = Pattern.compile("(?i)[2-9]?1st|[2-9]?2nd|[2-9]?3rd|1[0-9]th|[2-9]?[04-9]th|100+th|zeroth|first|second|third|fourth|fifth|sixth|seventh|eighth|ninth|tenth|eleventh|twelfth|thirteenth|fourteenth|fifteenth|sixteenth|seventeenth|eighteenth|nineteenth|twentieth|twenty-first|twenty-second|twenty-third|twenty-fourth|twenty-fifth|twenty-sixth|twenty-seventh|twenty-eighth|twenty-ninth|thirtieth|thirty-first|fortieth|fiftieth|sixtieth|seventieth|eightieth|ninetieth|hundredth|thousandth|millionth");
    public static final Pattern ARMY_TIME_MORNING = Pattern.compile("0([0-9])([0-9]){2}");
    public static final Pattern GENERIC_TIME_WORDS = Pattern.compile("(morning|evening|night|noon|midnight|teatime|lunchtime|dinnertime|suppertime|afternoon|midday|dusk|dawn|sunup|sundown|daybreak|day)");

    public NumberSequenceClassifier() {
        this(new Properties());
        if (!CURRENCY_WORD_PATTERN.matcher("pounds").matches()) {
            System.err.println("NumberSequence: Currency pattern broken");
        }
    }

    public NumberSequenceClassifier(Properties props) {
        super(props);
    }

    @Override
    public List<CoreLabel> classify(List<CoreLabel> document) {
        PaddedList<CoreMap> pl = new PaddedList<CoreMap>(document, this.pad);
        int sz = pl.size();
        for (int i = 0; i < sz; ++i) {
            CoreLabel me = (CoreLabel)pl.get(i);
            CoreLabel prev = (CoreLabel)pl.get(i - 1);
            CoreLabel next = (CoreLabel)pl.get(i + 1);
            CoreLabel next2 = (CoreLabel)pl.get(i + 2);
            me.set(CoreAnnotations.AnswerAnnotation.class, this.flags.backgroundSymbol);
            if ((me.word().equals("$") || me.word().equals("&#163") || me.word().equals("\u00a3") || me.word().equals("\u00a5") || me.word().equals("#") || me.word().equals("\u20ac") || me.word().equals("US$") || me.word().equals("HK$") || me.word().equals("A$")) && (prev.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CD") || next.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CD"))) {
                me.set(CoreAnnotations.AnswerAnnotation.class, "MONEY");
                continue;
            }
            if (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CD")) {
                if (TIME_PATTERN.matcher(me.word()).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "TIME");
                    continue;
                }
                if (TIME_PATTERN2.matcher(me.word()).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "TIME");
                    continue;
                }
                if (DATE_PATTERN.matcher(me.word()).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                    continue;
                }
                if (DATE_PATTERN2.matcher(me.word()).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                    continue;
                }
                if (next.get(CoreAnnotations.TextAnnotation.class) != null && me.get(CoreAnnotations.TextAnnotation.class) != null && DAY_PATTERN.matcher((CharSequence)me.get(CoreAnnotations.TextAnnotation.class)).matches() && MONTH_PATTERN.matcher((CharSequence)next.get(CoreAnnotations.TextAnnotation.class)).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                    continue;
                }
                if (prev.get(CoreAnnotations.TextAnnotation.class) != null && MONTH_PATTERN.matcher((CharSequence)prev.get(CoreAnnotations.TextAnnotation.class)).matches() && me.get(CoreAnnotations.TextAnnotation.class) != null && DAY_PATTERN.matcher((CharSequence)me.get(CoreAnnotations.TextAnnotation.class)).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                    continue;
                }
                if (NumberSequenceClassifier.rightScanFindsMoneyWord(pl, i) && !NumberSequenceClassifier.leftScanFindsWeightWord(pl, i)) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "MONEY");
                    continue;
                }
                if (ARMY_TIME_MORNING.matcher(me.word()).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "TIME");
                    continue;
                }
                if (YEAR_PATTERN.matcher(me.word()).matches() && prev.getString(CoreAnnotations.AnswerAnnotation.class).equals("DATE") && (MONTH_PATTERN.matcher(prev.word()).matches() || ((String)((CoreLabel)pl.get(i - 2)).get(CoreAnnotations.AnswerAnnotation.class)).equals("DATE"))) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                    continue;
                }
                if (prev.getString(CoreAnnotations.AnswerAnnotation.class).equals("MONEY")) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "MONEY");
                    continue;
                }
                me.set(CoreAnnotations.AnswerAnnotation.class, "NUMBER");
                continue;
            }
            if (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class) != null && me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals(",") && prev.getString(CoreAnnotations.AnswerAnnotation.class).equals("DATE") && next.word() != null && YEAR_PATTERN.matcher(next.word()).matches()) {
                me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                continue;
            }
            if (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NNP") && MONTH_PATTERN.matcher(me.word()).matches()) {
                if (!prev.getString(CoreAnnotations.AnswerAnnotation.class).equals("DATE") && !next.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CD")) continue;
                me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                continue;
            }
            if (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class) != null && me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CC")) {
                String wd;
                if (prev.get(CoreAnnotations.PartOfSpeechAnnotation.class) == null || !((String)prev.get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("CD") || next.get(CoreAnnotations.PartOfSpeechAnnotation.class) == null || !((String)next.get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("CD") || me.get(CoreAnnotations.TextAnnotation.class) == null || !((String)me.get(CoreAnnotations.TextAnnotation.class)).equalsIgnoreCase("and") || !(wd = prev.word()).equalsIgnoreCase("hundred") && !wd.equalsIgnoreCase("thousand") && !wd.equalsIgnoreCase("million") && !wd.equalsIgnoreCase("billion") && !wd.equalsIgnoreCase("trillion")) continue;
                me.set(CoreAnnotations.AnswerAnnotation.class, "NUMBER");
                continue;
            }
            if (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class) != null && (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NN") || me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NNS"))) {
                if (CURRENCY_WORD_PATTERN.matcher(me.word()).matches()) {
                    if (!prev.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CD") || !prev.getString(CoreAnnotations.AnswerAnnotation.class).equals("MONEY")) continue;
                    me.set(CoreAnnotations.AnswerAnnotation.class, "MONEY");
                    continue;
                }
                if (me.word().equals("m") || me.word().equals("b")) {
                    if (prev.getString(CoreAnnotations.AnswerAnnotation.class).equals("MONEY")) {
                        me.set(CoreAnnotations.AnswerAnnotation.class, "MONEY");
                        continue;
                    }
                    me.set(CoreAnnotations.AnswerAnnotation.class, "NUMBER");
                    continue;
                }
                if (ORDINAL_PATTERN.matcher(me.word()).matches()) {
                    if ((next.word() == null || !MONTH_PATTERN.matcher(next.word()).matches()) && (next.word() == null || !next.word().equalsIgnoreCase("of") || next2.word() == null || !MONTH_PATTERN.matcher(next2.word()).matches())) continue;
                    me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                    continue;
                }
                if (!GENERIC_TIME_WORDS.matcher(me.word()).matches()) continue;
                me.set(CoreAnnotations.AnswerAnnotation.class, "TIME");
                continue;
            }
            if (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("JJ")) {
                if (next.word() != null && MONTH_PATTERN.matcher(next.word()).matches() || next.word() != null && next.word().equalsIgnoreCase("of") && next2.word() != null && MONTH_PATTERN.matcher(next2.word()).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                    continue;
                }
                if (!ORDINAL_PATTERN.matcher(me.word()).matches()) continue;
                me.set(CoreAnnotations.AnswerAnnotation.class, "ORDINAL");
                continue;
            }
            if (!me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("IN") || !me.word().equalsIgnoreCase("of") || prev.get(CoreAnnotations.TextAnnotation.class) == null || !ORDINAL_PATTERN.matcher((CharSequence)prev.get(CoreAnnotations.TextAnnotation.class)).matches() || next.get(CoreAnnotations.TextAnnotation.class) == null || !MONTH_PATTERN.matcher((CharSequence)next.get(CoreAnnotations.TextAnnotation.class)).matches()) continue;
            me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
        }
        return document;
    }

    private static boolean leftScanFindsWeightWord(List<CoreLabel> pl, int i) {
        for (int j = i - 1; j >= 0 && j >= i - 3; --j) {
            CoreLabel fl = pl.get(j);
            if (!fl.word().startsWith("weigh")) continue;
            return true;
        }
        return false;
    }

    private static boolean rightScanFindsMoneyWord(List<CoreLabel> pl, int i) {
        int j;
        int sz = pl.size();
        for (j = i; j < sz && pl.get(j).getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CD"); ++j) {
        }
        if (j >= sz) {
            return false;
        }
        String tag = pl.get(j).getString(CoreAnnotations.PartOfSpeechAnnotation.class);
        String word = pl.get(j).word();
        return (tag.equals("NN") || tag.equals("NNS")) && CURRENCY_WORD_PATTERN.matcher(word).matches();
    }

    @Override
    public void train(Collection<List<CoreLabel>> docs) {
    }

    @Override
    public void printProbsDocument(List<CoreLabel> document) {
    }

    @Override
    public void serializeClassifier(String serializePath) {
        System.err.print("Serializing classifier to " + serializePath + "...");
        System.err.println("done.");
    }

    @Override
    public void loadClassifier(ObjectInputStream in, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
    }

    public static void main(String[] args) throws Exception {
        Properties props = StringUtils.argsToProperties(args);
        NumberSequenceClassifier cmm = new NumberSequenceClassifier(props);
        String trainFile = cmm.flags.trainFile;
        String testFile = cmm.flags.testFile;
        String textFile = cmm.flags.textFile;
        String loadPath = cmm.flags.loadClassifier;
        String serializeTo = cmm.flags.serializeTo;
        if (loadPath != null) {
            cmm.loadClassifierNoExceptions(loadPath);
            cmm.flags.setProperties(props);
        } else if (trainFile != null) {
            cmm.train(trainFile);
        }
        if (serializeTo != null) {
            cmm.serializeClassifier(serializeTo);
        }
        if (testFile != null) {
            cmm.classifyAndWriteAnswers(testFile);
        }
        if (textFile != null) {
            DocumentReaderAndWriter oldRW = cmm.readerAndWriter;
            cmm.readerAndWriter = new PlainTextDocumentReaderAndWriter();
            cmm.classifyAndWriteAnswers(textFile);
            cmm.readerAndWriter = oldRW;
        }
    }
}

