/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.LineSearcher;
import edu.stanford.nlp.util.Function;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoldenSectionLineSearch
implements LineSearcher {
    private static final double GOLDEN_RATIO = (1.0 + Math.sqrt(5.0)) / 2.0;
    private static final double GOLDEN_SECTION = GOLDEN_RATIO / (1.0 + GOLDEN_RATIO);
    private static boolean VERBOSE = true;
    private HashMap<Double, Double> memory = new HashMap();
    private boolean geometric;
    private double tol;
    private double low;
    private double high;
    private static final NumberFormat nf = new DecimalFormat("0.000");

    public GoldenSectionLineSearch(double tol, double low, double high) {
        this(false, tol, low, high);
    }

    public GoldenSectionLineSearch(double tol, double low, double high, boolean verbose) {
        this(false, tol, low, high, verbose);
    }

    public GoldenSectionLineSearch(boolean geometric) {
        this(geometric, 1.0E-4, 0.01, 10.0);
    }

    public GoldenSectionLineSearch(boolean geometric, double tol, double low, double high) {
        this.geometric = geometric;
        this.tol = tol;
        this.low = low;
        this.high = high;
    }

    public GoldenSectionLineSearch(boolean geometric, double tol, double low, double high, boolean verbose) {
        this.geometric = geometric;
        this.tol = tol;
        this.low = low;
        this.high = high;
        VERBOSE = verbose;
    }

    public double minimize(Function<Double, Double> function, double tol, double low, double high) {
        this.tol = tol;
        this.low = low;
        this.high = high;
        return this.minimize(function);
    }

    @Override
    public double minimize(Function<Double, Double> function) {
        boolean searchRight;
        double oldY;
        double mid;
        double tol = this.tol;
        double low = this.low;
        double high = this.high;
        double flow = function.apply(low);
        double fhigh = function.apply(high);
        if (VERBOSE) {
            System.err.println("Finding min between " + low + " (value: " + flow + ") and " + high + " (value: " + fhigh + ")");
        }
        if (VERBOSE) {
            System.err.println("20 point gridsearch for good mid point....");
        }
        double bestPoint = low;
        double bestVal = flow;
        double incr = (high - low) / 22.0;
        for (mid = low + incr; mid < high; mid += incr) {
            oldY = function.apply(mid);
            if (VERBOSE) {
                System.err.print("Probed at " + mid + ", value is " + oldY);
            }
            if (oldY < bestVal) {
                bestPoint = mid;
                bestVal = oldY;
                if (VERBOSE) {
                    System.err.print(" [best so far!]");
                }
            }
            if (!VERBOSE) continue;
            System.err.println();
        }
        mid = bestPoint;
        oldY = bestVal;
        boolean bl = searchRight = mid < low + (high - low) / 2.0;
        if (oldY < flow && oldY < fhigh) {
            if (VERBOSE) {
                System.err.println("Found a good mid point at (" + mid + ", " + oldY + ")");
            }
        } else {
            System.err.println("Warning: GoldenSectionLineSearch grid search couldn't find slope!!");
            mid = this.goldenMean(low, high);
            oldY = function.apply(mid);
            searchRight = false;
        }
        this.memory.put(mid, oldY);
        while (this.geometric ? high / low > 1.0 + tol : high - low > tol) {
            if (VERBOSE) {
                System.err.println("Current low, mid, high: " + nf.format(low) + " " + nf.format(mid) + " " + nf.format(high));
            }
            double newX = this.goldenMean(searchRight ? high : low, mid);
            double newY = function.apply(newX);
            this.memory.put(newX, newY);
            if (VERBOSE) {
                System.err.println("Probed " + (searchRight ? "right" : "left") + " at " + newX + ", value is " + newY);
            }
            if (newY < oldY) {
                if (searchRight) {
                    low = mid;
                } else {
                    high = mid;
                }
                mid = newX;
                oldY = newY;
                continue;
            }
            if (searchRight) {
                high = newX;
            } else {
                low = newX;
            }
            searchRight = !searchRight;
        }
        return mid;
    }

    public void dumpMemory() {
        Object[] keys = this.memory.keySet().toArray(new Double[this.memory.keySet().size()]);
        Arrays.sort(keys);
        for (Object key : keys) {
            System.err.println(key + "\t" + this.memory.get(key));
        }
    }

    public void discretizeCompute(Function<Double, Double> function, int numPoints, double low, double high) {
        double inc = (high - low) / (double)numPoints;
        this.memory = new HashMap();
        for (int i = 0; i < numPoints; ++i) {
            double x = low + (double)i * inc;
            double y = function.apply(x);
            this.memory.put(x, y);
            System.err.println("for point " + x + "\t" + y);
        }
        this.dumpMemory();
    }

    private double goldenMean(double a, double b) {
        if (this.geometric) {
            return a * Math.pow(b / a, GOLDEN_SECTION);
        }
        return a + (b - a) * GOLDEN_SECTION;
    }

    public static void main(String[] args) {
        GoldenSectionLineSearch min = new GoldenSectionLineSearch(true, 1.0E-5, 0.001, 121.0);
        Function<Double, Double> f1 = new Function<Double, Double>(){

            @Override
            public Double apply(Double x) {
                return Math.log(x * x - x + 1.0);
            }
        };
        System.out.println(min.minimize(f1));
        System.out.println();
        min = new GoldenSectionLineSearch(false, 1.0E-5, 0.0, 1.0);
        Function<Double, Double> f2 = new Function<Double, Double>(){

            @Override
            public Double apply(Double x) {
                return x < 0.1 ? 0.0 : (x > 0.2 ? 0.0 : (x - 0.1) * (x - 0.2));
            }
        };
        System.out.println(min.minimize(f2));
    }
}

