/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.Evaluator;
import edu.stanford.nlp.optimization.HasEvaluators;
import edu.stanford.nlp.optimization.Minimizer;
import edu.stanford.nlp.optimization.QNMinimizer;
import edu.stanford.nlp.optimization.SMDMinimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HybridMinimizer
implements Minimizer<DiffFunction>,
HasEvaluators {
    Minimizer<DiffFunction> firstMinimizer = new SMDMinimizer<DiffFunction>();
    Minimizer<DiffFunction> secondMinimizer = new QNMinimizer(15);
    int iterationCutoff = 1000;

    public HybridMinimizer(Minimizer<DiffFunction> minimizerOne, Minimizer<DiffFunction> minimizerTwo, int iterationCutoff) {
        this.firstMinimizer = minimizerOne;
        this.secondMinimizer = minimizerTwo;
        this.iterationCutoff = iterationCutoff;
    }

    @Override
    public void setEvaluators(int iters, Evaluator[] evaluators) {
        if (this.firstMinimizer instanceof HasEvaluators) {
            ((HasEvaluators)((Object)this.firstMinimizer)).setEvaluators(iters, evaluators);
        }
        if (this.secondMinimizer instanceof HasEvaluators) {
            ((HasEvaluators)((Object)this.secondMinimizer)).setEvaluators(iters, evaluators);
        }
    }

    @Override
    public double[] minimize(DiffFunction function, double functionTolerance, double[] initial) {
        return this.minimize(function, functionTolerance, initial, -1);
    }

    @Override
    public double[] minimize(DiffFunction function, double functionTolerance, double[] initial, int maxIterations) {
        double[] x = this.firstMinimizer.minimize(function, functionTolerance, initial, this.iterationCutoff);
        x = this.secondMinimizer.minimize(function, functionTolerance, x, maxIterations);
        return x;
    }
}

