/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.IntDependency;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammar;
import edu.stanford.nlp.parser.lexparser.Test;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Triple;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChineseSimWordAvgDepGrammar
extends MLEDependencyGrammar {
    private static final long serialVersionUID = -1845503582705055342L;
    private double simSmooth = 10.0;
    private static final String argHeadFile = "simWords/ArgHead.5";
    private static final String headArgFile = "simWords/HeadArg.5";
    private Map<Pair<Integer, String>, List<Triple<Integer, String, Double>>> simArgMap;
    private Map<Pair<Integer, String>, List<Triple<Integer, String, Double>>> simHeadMap;
    private boolean debug = true;
    private boolean verbose = false;
    private ClassicCounter<String> statsCounter = new ClassicCounter();

    public ChineseSimWordAvgDepGrammar(TreebankLangParserParams tlpParams, boolean directional, boolean distance, boolean coarseDistance) {
        super(tlpParams, directional, distance, coarseDistance);
        this.simHeadMap = ChineseSimWordAvgDepGrammar.getMap(headArgFile);
        this.simArgMap = ChineseSimWordAvgDepGrammar.getMap(argHeadFile);
    }

    public static Map<Pair<Integer, String>, List<Triple<Integer, String, Double>>> getMap(String filename) {
        HashMap<Pair<Integer, String>, List<Triple<Integer, String, Double>>> hashMap = new HashMap<Pair<Integer, String>, List<Triple<Integer, String, Double>>>();
        try {
            String wordMapLine;
            BufferedReader wordMapBReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            Pattern linePattern = Pattern.compile("sim\\((.+)/(.+):(.+)/(.+)\\)=(.+)");
            while ((wordMapLine = wordMapBReader.readLine()) != null) {
                Matcher m = linePattern.matcher(wordMapLine);
                if (!m.matches()) {
                    System.err.println("Ill-formed line in similar word map file: " + wordMapLine);
                    continue;
                }
                Pair<Integer, String> iTW = new Pair<Integer, String>(ChineseSimWordAvgDepGrammar.wordNumberer().number(m.group(1)), m.group(2));
                double score = Double.parseDouble(m.group(5));
                ArrayList<Triple<Integer, String, Double>> tripleList = (ArrayList<Triple<Integer, String, Double>>)hashMap.get(iTW);
                if (tripleList == null) {
                    tripleList = new ArrayList<Triple<Integer, String, Double>>();
                    hashMap.put(iTW, tripleList);
                }
                tripleList.add(new Triple<Integer, String, Double>(ChineseSimWordAvgDepGrammar.wordNumberer().number(m.group(3)), m.group(4), score));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading similar words file!");
        }
        return hashMap;
    }

    @Override
    public double scoreTB(IntDependency dependency) {
        return Test.depWeight * Math.log(this.probTBwithSimWords(dependency));
    }

    public void setLex(Lexicon lex) {
        this.lex = lex;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        System.err.println("SimWordAvg stats:");
        System.err.println(this.statsCounter);
    }

    private double probTBwithSimWords(IntDependency dependency) {
        double pSim_aTW_hTd;
        if (!this.directional) {
            dependency.leftHeaded = false;
        }
        if (this.verbose) {
            System.out.println("Generating " + dependency);
        }
        short distance = dependency.distance;
        boolean leftHeaded = dependency.leftHeaded;
        int hW = dependency.head.word;
        int aW = dependency.arg.word;
        IntTaggedWord aTW = dependency.arg;
        IntTaggedWord hTW = dependency.head;
        double pb_stop_hTWds = this.getStopProb(dependency);
        boolean isRoot = ChineseSimWordAvgDepGrammar.rootTW(dependency.head);
        if (dependency.arg.word == -2) {
            if (isRoot) {
                return 0.0;
            }
            return pb_stop_hTWds;
        }
        double pb_go_hTWds = 1.0 - pb_stop_hTWds;
        if (isRoot) {
            pb_go_hTWds = 1.0;
        }
        dependency.distance = this.valenceBin(distance);
        double c_aTW_hTWd = this.argCounter.getCount(dependency);
        dependency.arg.word = -1;
        double c_aT_hTWd = this.argCounter.getCount(dependency);
        dependency.arg.word = aW;
        dependency.arg = wildTW;
        double c_hTWd = this.argCounter.getCount(dependency);
        dependency.arg = aTW;
        dependency.head.word = -1;
        double c_aTW_hTd = this.argCounter.getCount(dependency);
        dependency.arg.word = -1;
        double c_aT_hTd = this.argCounter.getCount(dependency);
        dependency.arg.word = aW;
        dependency.arg = wildTW;
        double c_hTd = this.argCounter.getCount(dependency);
        dependency.arg = aTW;
        dependency.head.word = hW;
        dependency.head = wildTW;
        dependency.leftHeaded = false;
        dependency.distance = (short)-1;
        double c_aTW = this.argCounter.getCount(dependency);
        dependency.arg.word = -1;
        double c_aT = this.argCounter.getCount(dependency);
        dependency.arg.word = aW;
        dependency.leftHeaded = leftHeaded;
        dependency.head = hTW;
        dependency.distance = distance;
        double p_aTW_hTd = c_hTd > 0.0 ? c_aTW_hTd / c_hTd : 0.0;
        double p_aT_hTd = c_hTd > 0.0 ? c_aT_hTd / c_hTd : 0.0;
        double p_aTW_aT = c_aTW > 0.0 ? c_aTW / c_aT : 1.0;
        double pb_aT_hTWd = (c_aT_hTWd + this.smooth_aT_hTWd * p_aT_hTd) / (c_hTWd + this.smooth_aT_hTWd);
        List<Triple<Integer, String, Double>> sim2head = null;
        List<Triple<Integer, String, Double>> sim2arg = null;
        sim2arg = this.simArgMap.get(new Pair<Integer, String>(dependency.arg.word, this.stringBasicCategory(dependency.arg.tag)));
        sim2head = this.simHeadMap.get(new Pair<Integer, String>(dependency.head.word, this.stringBasicCategory(dependency.head.tag)));
        ArrayList simArg = new ArrayList();
        ArrayList simHead = new ArrayList();
        if (sim2arg != null) {
            for (Triple<Integer, String, Double> t : sim2arg) {
                simArg.add(t.first);
            }
        }
        if (sim2head != null) {
            for (Triple<Integer, String, Double> t : sim2head) {
                simHead.add(t.first);
            }
        }
        double cSim_aTW_hTd = 0.0;
        double cSim_hTd = 0.0;
        Iterator i$ = simHead.iterator();
        while (i$.hasNext()) {
            int h = (Integer)i$.next();
            dependency.arg = aTW;
            dependency.head = hTW;
            dependency.head.word = h;
            cSim_aTW_hTd += this.argCounter.getCount(dependency);
            dependency.arg = wildTW;
            cSim_hTd += this.argCounter.getCount(dependency);
        }
        dependency.arg = aTW;
        dependency.head = hTW;
        double d = pSim_aTW_hTd = cSim_hTd > 0.0 ? cSim_aTW_hTd / cSim_hTd : 0.0;
        if (this.debug && pSim_aTW_hTd > 0.0) {
            System.out.println(dependency + "\t" + pSim_aTW_hTd);
        }
        double smoothSim_aTW_hTWd = 17.7;
        double smooth_aTW_hTWd = 35.4;
        double pb_aTW_hTWd = (c_aTW_hTWd + smoothSim_aTW_hTWd * pSim_aTW_hTd + smooth_aTW_hTWd * p_aTW_hTd) / (c_hTWd + smoothSim_aTW_hTWd + smooth_aTW_hTWd);
        System.out.println(dependency);
        System.out.println(c_aTW_hTWd + " + " + smoothSim_aTW_hTWd + " * " + pSim_aTW_hTd + " + " + smooth_aTW_hTWd + " * " + p_aTW_hTd);
        System.out.println("--------------------------------  = " + pb_aTW_hTWd);
        System.out.println(c_hTWd + " + " + smoothSim_aTW_hTWd + " + " + smooth_aTW_hTWd);
        System.out.println();
        double score = (this.interp * pb_aTW_hTWd + (1.0 - this.interp) * p_aTW_aT * pb_aT_hTWd) * pb_go_hTWds;
        if (this.verbose) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(2);
            System.out.println("  c_aTW_hTWd: " + c_aTW_hTWd + "; c_aT_hTWd: " + c_aT_hTWd + "; c_hTWd: " + c_hTWd);
            System.out.println("  c_aTW_hTd: " + c_aTW_hTd + "; c_aT_hTd: " + c_aT_hTd + "; c_hTd: " + c_hTd);
            System.out.println("  Generated with pb_go_hTWds: " + nf.format(pb_go_hTWds) + " pb_aTW_hTWd: " + nf.format(pb_aTW_hTWd) + " p_aTW_aT: " + nf.format(p_aTW_aT) + " pb_aT_hTWd: " + nf.format(pb_aT_hTWd));
            System.out.println("  NoDist score: " + score);
        }
        if (Test.prunePunc && this.pruneTW(aTW)) {
            return 1.0;
        }
        if (Double.isNaN(score)) {
            score = 0.0;
        }
        if (score < 1.0E-40) {
            score = 0.0;
        }
        return score;
    }

    private double probSimilarWordAvg(IntDependency dep) {
        double smoothProb;
        double simProb;
        IntTaggedWord hTW;
        int tag;
        IntTaggedWord aTW;
        double regProb = this.probTB(dep);
        this.statsCounter.incrementCount("total");
        List<Triple<Integer, String, Double>> sim2head = null;
        List<Triple<Integer, String, Double>> sim2arg = null;
        sim2arg = this.simArgMap.get(new Pair<Integer, String>(dep.arg.word, this.stringBasicCategory(dep.arg.tag)));
        sim2head = this.simHeadMap.get(new Pair<Integer, String>(dep.head.word, this.stringBasicCategory(dep.head.tag)));
        if (sim2head == null && sim2arg == null) {
            return regProb;
        }
        double sumScores = 0.0;
        double sumWeights = 0.0;
        if (sim2head == null) {
            aTW = dep.arg;
            this.statsCounter.incrementCount("aSim");
            for (Triple<Integer, String, Double> simArg : sim2arg) {
                double weight2 = Math.exp(-50.0 * (Double)simArg.third);
                int numT = ChineseSimWordAvgDepGrammar.tagNumberer().total();
                for (tag = 0; tag < numT; ++tag) {
                    if (!this.stringBasicCategory(tag).equals(simArg.second)) continue;
                    dep.arg = new IntTaggedWord((Integer)simArg.first, tag);
                    double probArg = Math.exp(this.lex.score(dep.arg, 0));
                    if (probArg == 0.0) continue;
                    sumScores += this.probTB(dep) * weight2 / probArg;
                    sumWeights += weight2;
                }
            }
            dep.arg = aTW;
        } else if (sim2arg == null) {
            hTW = dep.head;
            this.statsCounter.incrementCount("hSim");
            for (Triple<Integer, String, Double> simHead : sim2head) {
                double weight3 = Math.exp(-50.0 * (Double)simHead.third);
                int numT = ChineseSimWordAvgDepGrammar.tagNumberer().total();
                for (tag = 0; tag < numT; ++tag) {
                    if (!this.stringBasicCategory(tag).equals(simHead.second)) continue;
                    dep.head = new IntTaggedWord((Integer)simHead.first, tag);
                    sumScores += this.probTB(dep) * weight3;
                    sumWeights += weight3;
                }
            }
            dep.head = hTW;
        } else {
            hTW = dep.head;
            IntTaggedWord aTW2 = dep.arg;
            this.statsCounter.incrementCount("hSim");
            this.statsCounter.incrementCount("aSim");
            this.statsCounter.incrementCount("aSim&hSim");
            for (Triple<Integer, String, Double> simArg : sim2arg) {
                int numT = ChineseSimWordAvgDepGrammar.tagNumberer().total();
                for (int aTag = 0; aTag < numT; ++aTag) {
                    if (!this.stringBasicCategory(aTag).equals(simArg.second)) continue;
                    dep.arg = new IntTaggedWord((Integer)simArg.first, aTag);
                    double probArg = Math.exp(this.lex.score(dep.arg, 0));
                    if (probArg == 0.0) continue;
                    for (Triple<Integer, String, Double> simHead : sim2head) {
                        for (int hTag = 0; hTag < numT; ++hTag) {
                            if (!this.stringBasicCategory(hTag).equals(simHead.second)) continue;
                            dep.head = new IntTaggedWord((Integer)simHead.first, aTag);
                            double weight4 = Math.exp(-50.0 * (Double)simHead.third) * Math.exp(-50.0 * (Double)simArg.third);
                            sumScores += this.probTB(dep) * weight4 / probArg;
                            sumWeights += weight4;
                        }
                    }
                }
            }
            dep.head = hTW;
            dep.arg = aTW2;
        }
        aTW = dep.arg;
        dep.arg = wildTW;
        double countHead = this.argCounter.getCount(dep);
        dep.arg = aTW;
        if (sim2arg == null) {
            simProb = sumScores / sumWeights;
        } else {
            double probArg = Math.exp(this.lex.score(dep.arg, 0));
            simProb = probArg * sumScores / sumWeights;
        }
        if (simProb == 0.0) {
            this.statsCounter.incrementCount("simProbZero");
        }
        if (regProb == 0.0) {
            this.statsCounter.incrementCount("regProbZero");
        }
        if ((smoothProb = (countHead * regProb + this.simSmooth * simProb) / (countHead + this.simSmooth)) == 0.0) {
            this.statsCounter.incrementCount("smoothProbZero");
        }
        return smoothProb;
    }

    private String stringBasicCategory(int tag) {
        return this.tlp.basicCategory((String)ChineseSimWordAvgDepGrammar.tagNumberer().object(tag));
    }

    static {
        System.runFinalizersOnExit((boolean)true);
    }
}

