/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.Factory;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatorPool {
    private Map<String, Annotator> annotators = new HashMap<String, Annotator>();
    private Map<String, Factory<Annotator>> factories = new HashMap<String, Factory<Annotator>>();

    public void register(String name, Factory<Annotator> factory) {
        if (this.factories.containsKey(name)) {
            String fmt = "name %s already associated with factory %s";
            String msg = String.format(fmt, name, this.factories.get(name));
            throw new IllegalArgumentException(msg);
        }
        this.factories.put(name, factory);
    }

    public synchronized Annotator get(String name) {
        if (!this.annotators.containsKey(name)) {
            Factory<Annotator> factory = this.factories.get(name);
            if (factory == null) {
                throw new IllegalArgumentException("no annotator named " + name);
            }
            this.annotators.put(name, factory.create());
        }
        return this.annotators.get(name);
    }
}

