/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.AnnotationLookup;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.CoreMapAttributeAggregator;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.Interval;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkAnnotationUtils {
    private static final Logger logger = Logger.getLogger(ChunkAnnotationUtils.class.getName());
    private static CoreLabelTokenFactory tokenFactory = new CoreLabelTokenFactory(true);

    public static boolean checkOffsets(CoreMap docAnnotation) {
        boolean okay = true;
        String docText = (String)docAnnotation.get(CoreAnnotations.TextAnnotation.class);
        String docId = (String)docAnnotation.get(CoreAnnotations.DocIDAnnotation.class);
        List docTokens = (List)docAnnotation.get(CoreAnnotations.TokensAnnotation.class);
        List sentences = (List)docAnnotation.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap sentence : sentences) {
            String sentText = (String)sentence.get(CoreAnnotations.TextAnnotation.class);
            List sentTokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            int sentBeginChar = (Integer)sentence.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            int sentEndChar = (Integer)sentence.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            int sentBeginToken = (Integer)sentence.get(CoreAnnotations.TokenBeginAnnotation.class);
            int sentEndToken = (Integer)sentence.get(CoreAnnotations.TokenEndAnnotation.class);
            String docTextSpan = docText.substring(sentBeginChar, sentEndChar);
            ArrayList docTokenSpan = new ArrayList(docTokens.subList(sentBeginToken, sentEndToken));
            logger.fine("Checking Document " + docId + " span (" + sentBeginChar + "," + sentEndChar + ") ");
            if (!docTextSpan.equals(sentText)) {
                okay = false;
                logger.fine("WARNING: Document " + docId + " span does not match sentence");
                logger.fine("DocSpanText: " + docTextSpan);
                logger.fine("SentenceText: " + sentText);
            }
            String sentTokenStr = ChunkAnnotationUtils.getTokenText(sentTokens, CoreAnnotations.TextAnnotation.class);
            String docTokenStr = ChunkAnnotationUtils.getTokenText(docTokenSpan, CoreAnnotations.TextAnnotation.class);
            if (docTokenStr.equals(sentTokenStr)) continue;
            okay = false;
            logger.fine("WARNING: Document " + docId + " tokens does not match sentence");
            logger.fine("DocSpanTokens: " + docTokenStr);
            logger.fine("SentenceTokens: " + sentTokenStr);
        }
        return okay;
    }

    public static boolean fixTokenOffsets(CoreMap docAnnotation) {
        List docTokens = (List)docAnnotation.get(CoreAnnotations.TokensAnnotation.class);
        List sentences = (List)docAnnotation.get(CoreAnnotations.SentencesAnnotation.class);
        int i = 0;
        CoreLabel curDocToken = (CoreLabel)docTokens.get(0);
        for (CoreMap sentence : sentences) {
            List sentTokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            CoreLabel sentTokenFirst = (CoreLabel)sentTokens.get(0);
            while (curDocToken != sentTokenFirst) {
                if (++i >= docTokens.size()) {
                    return false;
                }
                curDocToken = (CoreLabel)docTokens.get(i);
            }
            int sentTokenBegin = i;
            CoreLabel sentTokenLast = (CoreLabel)sentTokens.get(sentTokens.size() - 1);
            while (curDocToken != sentTokenLast) {
                if (++i >= docTokens.size()) {
                    return false;
                }
                curDocToken = (CoreLabel)docTokens.get(i);
            }
            int sentTokenEnd = i + 1;
            sentence.set(CoreAnnotations.TokenBeginAnnotation.class, sentTokenBegin);
            sentence.set(CoreAnnotations.TokenEndAnnotation.class, sentTokenEnd);
        }
        return true;
    }

    public static void copyUnsetAnnotations(CoreMap src, CoreMap dest) {
        Set<Class<?>> otherKeys = src.keySet();
        for (Class<?> key : otherKeys) {
            if (dest.has(key)) continue;
            dest.set(key, src.get(key));
        }
    }

    public static boolean fixChunkTokenBoundaries(CoreMap docAnnotation, List<IntPair> chunkCharOffsets) {
        String text = (String)docAnnotation.get(CoreAnnotations.TextAnnotation.class);
        List tokens = (List)docAnnotation.get(CoreAnnotations.TokensAnnotation.class);
        ArrayList<CoreLabel> output = new ArrayList<CoreLabel>(tokens.size());
        int i = 0;
        CoreLabel token = (CoreLabel)tokens.get(i);
        for (IntPair offsets : chunkCharOffsets) {
            assert (token.beginPosition() >= 0);
            assert (token.endPosition() >= 0);
            int offsetBegin = offsets.getSource();
            int offsetEnd = offsets.getTarget();
            while (offsetBegin < (Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) || offsetBegin >= (Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)) {
                output.add(token);
                if (++i >= tokens.size()) {
                    return false;
                }
                token = (CoreLabel)tokens.get(i);
            }
            while (offsetEnd > (Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)) {
                if (offsetBegin > (Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)) {
                    if (offsetEnd < (Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)) {
                        output.add(tokenFactory.makeToken(text.substring(token.beginPosition(), offsetBegin), token.beginPosition(), offsetBegin - token.beginPosition()));
                        output.add(tokenFactory.makeToken(text.substring(offsetBegin, offsetEnd), offsetBegin, offsetEnd - offsetBegin));
                        output.add(tokenFactory.makeToken(text.substring(offsetEnd, token.endPosition()), offsetEnd, token.endPosition() - offsetEnd));
                    } else {
                        output.add(tokenFactory.makeToken(text.substring(token.beginPosition(), offsetBegin), token.beginPosition(), offsetBegin - token.beginPosition()));
                        output.add(tokenFactory.makeToken(text.substring(offsetBegin, token.endPosition()), offsetBegin, token.endPosition() - offsetBegin));
                    }
                } else if (offsetEnd < (Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)) {
                    output.add(tokenFactory.makeToken(text.substring(token.beginPosition(), offsetEnd), token.beginPosition(), offsetEnd - token.beginPosition()));
                    output.add(tokenFactory.makeToken(text.substring(offsetEnd, token.endPosition()), offsetEnd, token.endPosition() - offsetEnd));
                } else {
                    output.add(token);
                }
                if (++i >= tokens.size()) {
                    return false;
                }
                token = (CoreLabel)tokens.get(i);
            }
        }
        while (i < tokens.size()) {
            token = (CoreLabel)tokens.get(i);
            output.add(token);
            ++i;
        }
        docAnnotation.set(CoreAnnotations.TokensAnnotation.class, output);
        return true;
    }

    public static CoreMap getMergedChunk(List<? extends CoreMap> chunkList, String origText, int chunkIndexStart, int chunkIndexEnd) {
        CoreMap firstChunk = chunkList.get(chunkIndexStart);
        CoreMap lastChunk = chunkList.get(chunkIndexEnd - 1);
        int firstCharOffset = (Integer)firstChunk.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        int lastCharOffset = (Integer)lastChunk.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        int firstTokenIndex = (Integer)firstChunk.get(CoreAnnotations.TokenBeginAnnotation.class);
        int lastTokenIndex = (Integer)lastChunk.get(CoreAnnotations.TokenEndAnnotation.class);
        String chunkText = origText.substring(firstCharOffset, lastCharOffset);
        Annotation newChunk = new Annotation(chunkText);
        newChunk.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, firstCharOffset);
        newChunk.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, lastCharOffset);
        newChunk.set(CoreAnnotations.TokenBeginAnnotation.class, firstTokenIndex);
        newChunk.set(CoreAnnotations.TokenEndAnnotation.class, lastTokenIndex);
        ArrayList tokens = new ArrayList(lastTokenIndex - firstTokenIndex);
        for (int i = chunkIndexStart; i < chunkIndexEnd; ++i) {
            CoreMap chunk = chunkList.get(i);
            tokens.addAll((Collection)chunk.get(CoreAnnotations.TokensAnnotation.class));
        }
        newChunk.set(CoreAnnotations.TokensAnnotation.class, tokens);
        return newChunk;
    }

    public static CoreMap getMergedChunk(List<? extends CoreMap> chunkList, int chunkIndexStart, int chunkIndexEnd, Map<Class, CoreMapAttributeAggregator> aggregators) {
        Annotation newChunk = new Annotation("");
        for (Map.Entry<Class, CoreMapAttributeAggregator> entry : aggregators.entrySet()) {
            Object value = entry.getValue().aggregate(entry.getKey(), chunkList.subList(chunkIndexStart, chunkIndexEnd));
            newChunk.set(entry.getKey(), value);
        }
        return newChunk;
    }

    public static Interval<Integer> getChunkOffsetsUsingCharOffsets(List<? extends CoreMap> chunkList, int charStart, int charEnd) {
        int start;
        int chunkStart = 0;
        int chunkEnd = chunkList.size();
        int i = 0;
        while (i < chunkList.size() && (start = ((Integer)chunkList.get(i).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)).intValue()) <= charStart) {
            chunkStart = i++;
        }
        for (i = chunkStart; i < chunkList.size(); ++i) {
            start = (Integer)chunkList.get(i).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            if (start <= charEnd) continue;
            chunkEnd = i;
            break;
        }
        return Interval.toInterval(chunkStart, chunkEnd, Interval.INTERVAL_OPEN_END);
    }

    public static void mergeChunks(List<CoreMap> chunkList, String origText, int chunkIndexStart, int chunkIndexEnd) {
        CoreMap newChunk = ChunkAnnotationUtils.getMergedChunk(chunkList, origText, chunkIndexStart, chunkIndexEnd);
        int nChunksToRemove = chunkIndexEnd - chunkIndexStart - 1;
        for (int i = 0; i < nChunksToRemove; ++i) {
            chunkList.remove(chunkIndexStart);
        }
        chunkList.set(chunkIndexStart, newChunk);
    }

    public static Character getFirstNonWsChar(CoreMap sent) {
        String sentText = (String)sent.get(CoreAnnotations.TextAnnotation.class);
        for (int j = 0; j < sentText.length(); ++j) {
            char c = sentText.charAt(j);
            if (Character.isWhitespace(c)) continue;
            return Character.valueOf(c);
        }
        return null;
    }

    public static Integer getFirstNonWsCharOffset(CoreMap sent, boolean relative) {
        String sentText = (String)sent.get(CoreAnnotations.TextAnnotation.class);
        for (int j = 0; j < sentText.length(); ++j) {
            char c = sentText.charAt(j);
            if (Character.isWhitespace(c)) continue;
            if (relative) {
                return j;
            }
            return j + (Integer)sent.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        }
        return null;
    }

    public static String getTrimmedText(CoreMap sent) {
        String sentText = (String)sent.get(CoreAnnotations.TextAnnotation.class);
        return sentText.trim();
    }

    public static boolean fixChunkSentenceBoundaries(CoreMap docAnnotation, List<IntPair> chunkCharOffsets) {
        return ChunkAnnotationUtils.fixChunkSentenceBoundaries(docAnnotation, chunkCharOffsets, false, false, false);
    }

    public static boolean fixChunkSentenceBoundaries(CoreMap docAnnotation, List<IntPair> chunkCharOffsets, boolean offsetsAreNotSorted, boolean extendedFixSentence, boolean moreExtendedFixSentence) {
        int i;
        String text = (String)docAnnotation.get(CoreAnnotations.TextAnnotation.class);
        List sentences = (List)docAnnotation.get(CoreAnnotations.SentencesAnnotation.class);
        if (sentences == null || sentences.size() == 0) {
            return true;
        }
        if (chunkCharOffsets != null) {
            i = 0;
            CoreMap sentence = (CoreMap)sentences.get(i);
            for (IntPair offsets : chunkCharOffsets) {
                int offsetBegin = offsets.getSource();
                int offsetEnd = offsets.getTarget();
                while (offsetBegin < (Integer)sentence.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) || offsetBegin >= (Integer)sentence.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)) {
                    if (++i >= sentences.size()) {
                        return false;
                    }
                    sentence = (CoreMap)sentences.get(i);
                }
                if ((Integer)sentence.get(CoreAnnotations.CharacterOffsetEndAnnotation.class) < offsetEnd) {
                    int startSentIndex = i;
                    while (offsetEnd > (Integer)sentence.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)) {
                        if (++i >= sentences.size()) {
                            return false;
                        }
                        sentence = (CoreMap)sentences.get(i);
                    }
                    Integer firstNonWsCharOffset = ChunkAnnotationUtils.getFirstNonWsCharOffset(sentence, false);
                    if (firstNonWsCharOffset != null && firstNonWsCharOffset >= offsetEnd) {
                        sentence = (CoreMap)sentences.get(--i);
                    }
                    ChunkAnnotationUtils.mergeChunks(sentences, text, startSentIndex, i + 1);
                    i = startSentIndex;
                    sentence = (CoreMap)sentences.get(i);
                }
                if (extendedFixSentence && i + 1 < sentences.size()) {
                    int offsetEndInSentText;
                    boolean entityAtSentEnd = true;
                    int sentCharBegin = (Integer)sentence.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                    String sentText = (String)sentence.get(CoreAnnotations.TextAnnotation.class);
                    for (int j = offsetEndInSentText = offsetEnd - sentCharBegin; j < sentText.length(); ++j) {
                        char c = sentText.charAt(j);
                        if (Character.isWhitespace(c)) continue;
                        entityAtSentEnd = false;
                        break;
                    }
                    boolean doMerge = false;
                    if (entityAtSentEnd) {
                        CoreMap nextSentence = (CoreMap)sentences.get(i + 1);
                        Character c = ChunkAnnotationUtils.getFirstNonWsChar(nextSentence);
                        if (c != null) {
                            boolean bl = doMerge = !Character.isUpperCase(c.charValue());
                            if (!doMerge) {
                                logger.fine("No merge: c is '" + c + "'");
                            }
                        } else {
                            logger.fine("No merge: no char");
                        }
                    } else {
                        logger.fine("No merge: entity not at end");
                    }
                    if (doMerge) {
                        logger.fine("Merge chunks");
                        ChunkAnnotationUtils.mergeChunks(sentences, text, i, i + 2);
                    }
                }
                if (offsetsAreNotSorted) {
                    i = 0;
                }
                sentence = (CoreMap)sentences.get(i);
            }
        }
        if (moreExtendedFixSentence) {
            i = 0;
            while (i + 1 < sentences.size()) {
                boolean doMerge = false;
                CoreMap sentence = (CoreMap)sentences.get(i);
                CoreMap nextSentence = (CoreMap)sentences.get(i + 1);
                String sentTrimmedText = ChunkAnnotationUtils.getTrimmedText(sentence);
                String nextSentTrimmedText = ChunkAnnotationUtils.getTrimmedText(nextSentence);
                if (sentTrimmedText.length() <= 1 || nextSentTrimmedText.length() <= 1) {
                    doMerge = true;
                } else {
                    Character c = ChunkAnnotationUtils.getFirstNonWsChar(nextSentence);
                    if (c != null && !Character.isUpperCase(c.charValue()) && (c.charValue() == ',' || Character.isLowerCase(c.charValue()))) {
                        doMerge = true;
                    }
                }
                if (doMerge) {
                    ChunkAnnotationUtils.mergeChunks(sentences, text, i, i + 2);
                    continue;
                }
                ++i;
            }
        }
        return true;
    }

    public static void annotateChunk(CoreMap chunk, List<CoreLabel> tokens, int tokenStartIndex, int tokenEndIndex, int totalTokenOffset) {
        ArrayList<CoreLabel> chunkTokens = new ArrayList<CoreLabel>(tokens.subList(tokenStartIndex, tokenEndIndex));
        chunk.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, ((CoreLabel)chunkTokens.get(0)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class));
        chunk.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, ((CoreLabel)chunkTokens.get(chunkTokens.size() - 1)).get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
        chunk.set(CoreAnnotations.TokensAnnotation.class, chunkTokens);
        chunk.set(CoreAnnotations.TokenBeginAnnotation.class, tokenStartIndex + totalTokenOffset);
        chunk.set(CoreAnnotations.TokenEndAnnotation.class, tokenEndIndex + totalTokenOffset);
    }

    public static String getTokenText(List<? extends CoreMap> tokens, Class tokenTextKey) {
        return ChunkAnnotationUtils.getTokenText(tokens, tokenTextKey, " ");
    }

    public static String getTokenText(List<? extends CoreMap> tokens, Class tokenTextKey, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (CoreMap coreMap : tokens) {
            if (sb.length() != 0) {
                sb.append(delimiter);
            }
            sb.append(coreMap.get(tokenTextKey));
        }
        return sb.toString();
    }

    public static void annotateChunkText(CoreMap chunk, Class tokenTextKey) {
        List chunkTokens = (List)chunk.get(CoreAnnotations.TokensAnnotation.class);
        String text = ChunkAnnotationUtils.getTokenText(chunkTokens, tokenTextKey);
        chunk.set(CoreAnnotations.TextAnnotation.class, text);
    }

    public static void annotateChunkText(CoreMap chunk, CoreMap origAnnotation) {
        String annoText = (String)origAnnotation.get(CoreAnnotations.TextAnnotation.class);
        Integer annoBeginCharOffset = (Integer)origAnnotation.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        if (annoBeginCharOffset == null) {
            annoBeginCharOffset = 0;
        }
        int chunkBeginCharOffset = (Integer)chunk.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) - annoBeginCharOffset;
        int chunkEndCharOffset = (Integer)chunk.get(CoreAnnotations.CharacterOffsetEndAnnotation.class) - annoBeginCharOffset;
        if (chunkBeginCharOffset < 0) {
            logger.info("Adjusting begin char offset from " + chunkBeginCharOffset + " to 0");
            logger.info("Chunk begin offset: " + chunk.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) + ", Source text begin offset " + annoBeginCharOffset);
            chunkBeginCharOffset = 0;
        }
        if (chunkBeginCharOffset > annoText.length()) {
            logger.info("Adjusting begin char offset from " + chunkBeginCharOffset + " to " + annoText.length());
            logger.info("Chunk begin offset: " + chunk.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) + ", Source text begin offset " + annoBeginCharOffset);
            chunkBeginCharOffset = annoText.length();
        }
        if (chunkEndCharOffset < 0) {
            logger.info("Adjusting end char offset from " + chunkEndCharOffset + " to 0");
            logger.info("Chunk end offset: " + chunk.get(CoreAnnotations.CharacterOffsetEndAnnotation.class) + ", Source text begin offset " + annoBeginCharOffset);
            chunkEndCharOffset = 0;
        }
        if (chunkEndCharOffset > annoText.length()) {
            logger.info("Adjusting end char offset from " + chunkEndCharOffset + " to " + annoText.length());
            logger.info("Chunk end offset: " + chunk.get(CoreAnnotations.CharacterOffsetEndAnnotation.class) + ", Source text begin offset " + annoBeginCharOffset);
            chunkEndCharOffset = annoText.length();
        }
        String chunkText = annoText.substring(chunkBeginCharOffset, chunkEndCharOffset);
        chunk.set(CoreAnnotations.TextAnnotation.class, chunkText);
    }

    public static void annotateChunkTokens(CoreMap chunk, Class tokenChunkKey, Class tokenLabelKey) {
        List chunkTokens = (List)chunk.get(CoreAnnotations.TokensAnnotation.class);
        if (tokenLabelKey != null) {
            String text = (String)chunk.get(CoreAnnotations.TextAnnotation.class);
            for (CoreLabel t : chunkTokens) {
                t.set(tokenLabelKey, text);
            }
        }
        if (tokenChunkKey != null) {
            for (CoreLabel t : chunkTokens) {
                t.set(tokenChunkKey, chunk);
            }
        }
    }

    public static Annotation getAnnotatedChunk(List<CoreLabel> tokens, int tokenStartIndex, int tokenEndIndex, int totalTokenOffset) {
        Annotation chunk = new Annotation("");
        ChunkAnnotationUtils.annotateChunk(chunk, tokens, tokenStartIndex, tokenEndIndex, totalTokenOffset);
        return chunk;
    }

    public static Annotation getAnnotatedChunk(List<CoreLabel> tokens, int tokenStartIndex, int tokenEndIndex, int totalTokenOffset, Class tokenChunkKey, Class tokenTextKey, Class tokenLabelKey) {
        Annotation chunk = ChunkAnnotationUtils.getAnnotatedChunk(tokens, tokenStartIndex, tokenEndIndex, totalTokenOffset);
        ChunkAnnotationUtils.annotateChunkText((CoreMap)chunk, tokenTextKey);
        ChunkAnnotationUtils.annotateChunkTokens(chunk, tokenChunkKey, tokenLabelKey);
        return chunk;
    }

    public static Annotation getAnnotatedChunk(CoreMap annotation, int tokenStartIndex, int tokenEndIndex) {
        Integer annoTokenBegin = (Integer)annotation.get(CoreAnnotations.TokenBeginAnnotation.class);
        if (annoTokenBegin == null) {
            annoTokenBegin = 0;
        }
        List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        Annotation chunk = ChunkAnnotationUtils.getAnnotatedChunk(tokens, tokenStartIndex, tokenEndIndex, annoTokenBegin);
        String text = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        if (text != null) {
            ChunkAnnotationUtils.annotateChunkText((CoreMap)chunk, annotation);
        } else {
            ChunkAnnotationUtils.annotateChunkText((CoreMap)chunk, CoreAnnotations.TextAnnotation.class);
        }
        return chunk;
    }

    public static Annotation getAnnotatedChunk(CoreMap annotation, int tokenStartIndex, int tokenEndIndex, Class tokenChunkKey, Class tokenLabelKey) {
        Annotation chunk = ChunkAnnotationUtils.getAnnotatedChunk(annotation, tokenStartIndex, tokenEndIndex);
        ChunkAnnotationUtils.annotateChunkTokens(chunk, tokenChunkKey, tokenLabelKey);
        return chunk;
    }

    public static CoreMap getAnnotatedChunkUsingCharOffsets(CoreMap annotation, int charOffsetStart, int charOffsetEnd) {
        List<CoreMap> cm = ChunkAnnotationUtils.getAnnotatedChunksUsingSortedCharOffsets(annotation, CollectionUtils.makeList(new IntPair(charOffsetStart, charOffsetEnd)));
        if (cm != null && cm.size() > 0) {
            return cm.get(0);
        }
        return null;
    }

    public static List<CoreMap> getAnnotatedChunksUsingSortedCharOffsets(CoreMap annotation, List<IntPair> charOffsets) {
        return ChunkAnnotationUtils.getAnnotatedChunksUsingSortedCharOffsets(annotation, charOffsets, true, null, null, false);
    }

    public static List<CoreMap> getAnnotatedChunksUsingSortedCharOffsets(CoreMap annotation, List<IntPair> charOffsets, boolean charOffsetIsRelative, Class tokenChunkKey, Class tokenLabelKey, boolean allowPartialTokens) {
        Integer annoTokenBegin;
        String annoText = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        ArrayList<CoreMap> chunks = new ArrayList<CoreMap>(charOffsets.size());
        List annoTokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        Integer annoCharBegin = (Integer)annotation.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        if (annoCharBegin == null) {
            annoCharBegin = 0;
        }
        if ((annoTokenBegin = (Integer)annotation.get(CoreAnnotations.TokenBeginAnnotation.class)) == null) {
            annoTokenBegin = 0;
        }
        int i = 0;
        for (IntPair p : charOffsets) {
            int j;
            int beginRelCharOffset = charOffsetIsRelative ? p.getSource() : p.getSource() - annoCharBegin;
            int endRelCharOffset = charOffsetIsRelative ? p.getTarget() : p.getTarget() - annoCharBegin;
            int beginCharOffset = beginRelCharOffset + annoCharBegin;
            int endCharOffset = endRelCharOffset + annoCharBegin;
            if (beginRelCharOffset >= annoText.length()) break;
            if (endRelCharOffset > annoText.length()) {
                endRelCharOffset = annoText.length();
            }
            if (allowPartialTokens) {
                while (i < annoTokens.size() && ((CoreLabel)annoTokens.get(i)).endPosition() <= beginCharOffset) {
                    ++i;
                }
            } else {
                while (i < annoTokens.size() && ((CoreLabel)annoTokens.get(i)).beginPosition() < beginCharOffset) {
                    ++i;
                }
            }
            if (i >= annoTokens.size()) break;
            int tokenBegin = i;
            if (allowPartialTokens) {
                for (j = i; j < annoTokens.size() && ((CoreLabel)annoTokens.get(j)).beginPosition() < endCharOffset; ++j) {
                }
            } else {
                while (j < annoTokens.size() && ((CoreLabel)annoTokens.get(j)).endPosition() <= endCharOffset) {
                    assert (((CoreLabel)annoTokens.get(j)).beginPosition() >= beginCharOffset);
                    ++j;
                }
            }
            int tokenEnd = j;
            ArrayList chunkTokens = new ArrayList(annoTokens.subList(tokenBegin, tokenEnd));
            String chunkText = annoText.substring(beginRelCharOffset, endRelCharOffset);
            Annotation chunk = new Annotation(chunkText);
            chunk.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, beginCharOffset);
            chunk.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, endCharOffset);
            chunk.set(CoreAnnotations.TokensAnnotation.class, chunkTokens);
            chunk.set(CoreAnnotations.TokenBeginAnnotation.class, tokenBegin + annoTokenBegin);
            chunk.set(CoreAnnotations.TokenEndAnnotation.class, tokenEnd + annoTokenBegin);
            ChunkAnnotationUtils.annotateChunkTokens(chunk, tokenChunkKey, tokenLabelKey);
            chunks.add(chunk);
            if (j < annoTokens.size()) continue;
            break;
        }
        if (chunks.size() != charOffsets.size()) {
            logger.warning("WARNING: Only " + chunks.size() + "/" + charOffsets.size() + " chunks found.  Check if offsets are sorted/nonoverlapping");
        }
        return chunks;
    }

    public static void annotateChunk(CoreMap annotation, Class newAnnotationKey, Class aggrKey, CoreMapAttributeAggregator aggregator) {
        Object v = aggregator.aggregate(aggrKey, (List)annotation.get(CoreAnnotations.TokensAnnotation.class));
        annotation.set(newAnnotationKey, v);
    }

    public static void annotateChunk(CoreMap chunk, Map<String, String> attributes) {
        for (String attr : attributes.keySet()) {
            String value = attributes.get(attr);
            AnnotationLookup.KeyLookup lookup = AnnotationLookup.getCoreKey(attr);
            if (attr != null) {
                if (value != null) {
                    try {
                        Class<?> valueClass = AnnotationLookup.getValueType(lookup.coreKey);
                        if (valueClass == String.class) {
                            chunk.set(lookup.coreKey, value);
                            continue;
                        }
                        Method valueOfMethod = valueClass.getMethod("valueOf", String.class);
                        if (valueOfMethod == null) continue;
                        chunk.set(lookup.coreKey, valueOfMethod.invoke(valueClass, value));
                        continue;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Unable to annotate attribute " + attr, ex);
                    }
                }
                chunk.set(lookup.coreKey, null);
                continue;
            }
            throw new UnsupportedOperationException("Unknown attributes: " + attr);
        }
    }

    public static void annotateChunks(List<? extends CoreMap> chunks, int start, int end, Map<String, String> attributes) {
        for (int i = start; i < end; ++i) {
            ChunkAnnotationUtils.annotateChunk(chunks.get(i), attributes);
        }
    }

    public static void annotateChunks(List<? extends CoreMap> chunks, Map<String, String> attributes) {
        for (CoreMap coreMap : chunks) {
            ChunkAnnotationUtils.annotateChunk(coreMap, attributes);
        }
    }
}

