/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.CorefCoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomAnnotationSerializer
implements AnnotationSerializer {
    private final boolean compress;
    private static final Object LOCK = new Object();
    private static final String SPACE_HOLDER = "##";

    public CustomAnnotationSerializer() {
        this(true);
    }

    public CustomAnnotationSerializer(boolean compress) {
        this.compress = compress;
    }

    @Override
    public Annotation load(InputStream is) throws IOException, ClassNotFoundException, ClassCastException {
        is = new BufferedInputStream(is);
        if (this.compress) {
            is = new GZIPInputStream(is);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        Annotation doc = new Annotation("");
        String line = reader.readLine().trim();
        if (line.length() > 0) {
            String[] bits = line.split(" ");
            if (bits.length % 4 != 0) {
                throw new RuntimeIOException("ERROR: Incorrect format for the serialized coref graph: " + line);
            }
            ArrayList<Pair<IntTuple, IntTuple>> corefGraph = new ArrayList<Pair<IntTuple, IntTuple>>();
            for (int i = 0; i < bits.length; i += 4) {
                IntTuple src = new IntTuple(2);
                IntTuple dst = new IntTuple(2);
                src.set(0, Integer.parseInt(bits[i]));
                src.set(1, Integer.parseInt(bits[i + 1]));
                dst.set(0, Integer.parseInt(bits[i + 2]));
                dst.set(1, Integer.parseInt(bits[i + 3]));
                corefGraph.add(new Pair<IntTuple, IntTuple>(src, dst));
            }
            doc.set(CorefCoreAnnotations.CorefGraphAnnotation.class, corefGraph);
        }
        ArrayList<Annotation> sentences = new ArrayList<Annotation>();
        while ((line = reader.readLine()) != null) {
            Annotation sentence = new Annotation("");
            Tree tree = new PennTreeReader(new StringReader(line), new LabeledScoredTreeFactory(CoreLabel.factory())).readTree();
            sentence.set(CoreAnnotations.TreeAnnotation.class, tree);
            IntermediateSemanticGraph intermCollapsedDeps = this.loadDependencyGraph(reader);
            IntermediateSemanticGraph intermUncollapsedDeps = this.loadDependencyGraph(reader);
            IntermediateSemanticGraph intermCcDeps = this.loadDependencyGraph(reader);
            ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>();
            while ((line = reader.readLine()) != null && line.length() != 0) {
                CoreLabel token = CustomAnnotationSerializer.loadToken(line);
                tokens.add(token);
            }
            sentence.set(CoreAnnotations.TokensAnnotation.class, tokens);
            SemanticGraph collapsedDeps = this.convertIntermediateGraph(intermCollapsedDeps, tokens);
            sentence.set(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, collapsedDeps);
            SemanticGraph uncollapsedDeps = this.convertIntermediateGraph(intermUncollapsedDeps, tokens);
            sentence.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, uncollapsedDeps);
            SemanticGraph ccDeps = this.convertIntermediateGraph(intermCcDeps, tokens);
            sentence.set(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, ccDeps);
            sentences.add(sentence);
        }
        doc.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        reader.close();
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SemanticGraph convertIntermediateGraph(IntermediateSemanticGraph ig, List<CoreLabel> sentence) {
        SemanticGraph graph = new SemanticGraph();
        HashMap<Integer, IndexedWord> nodes = new HashMap<Integer, IndexedWord>();
        for (IntermediateNode in : ig.nodes) {
            CoreLabel token = sentence.get(in.index - 1);
            IndexedWord word = new IndexedWord(in.docId, in.sentIndex, in.index, token);
            word.set(CoreAnnotations.ValueAnnotation.class, word.get(CoreAnnotations.TextAnnotation.class));
            if (in.copyAnnotation >= 0) {
                word.set(CoreAnnotations.CopyAnnotation.class, in.copyAnnotation);
            }
            nodes.put(word.index(), word);
        }
        for (IndexedWord node : nodes.values()) {
            graph.addVertex(node);
        }
        for (IntermediateEdge ie : ig.edges) {
            IndexedWord source = (IndexedWord)nodes.get(ie.source);
            assert (source != null);
            IndexedWord target = (IndexedWord)nodes.get(ie.target);
            assert (target != null);
            Object object = LOCK;
            synchronized (object) {
                GrammaticalRelation rel = GrammaticalRelation.valueOf(ie.dep);
                graph.addEdge(source, target, rel, 1.0);
            }
        }
        if (!graph.isEmpty()) {
            graph.resetRoots();
        }
        return graph;
    }

    private IntermediateSemanticGraph loadDependencyGraph(BufferedReader reader) throws IOException {
        String[] bbits;
        String[] bits;
        IntermediateSemanticGraph graph = new IntermediateSemanticGraph();
        String line = reader.readLine().trim();
        if (line.length() > 0) {
            bits = line.split("\t");
            if (bits.length < 3) {
                throw new RuntimeException("ERROR: Invalid dependency node line: " + line);
            }
            String docId = bits[0];
            if (docId.equals("-")) {
                docId = "";
            }
            int sentIndex = Integer.valueOf(bits[1]);
            for (int i = 2; i < bits.length; ++i) {
                String bit = bits[i];
                bbits = bit.split("-");
                int copyAnnotation = -1;
                if (bbits.length > 2) {
                    throw new RuntimeException("ERROR: Invalid format for dependency graph: " + line);
                }
                if (bbits.length == 2) {
                    copyAnnotation = Integer.valueOf(bbits[1]);
                }
                int index = Integer.valueOf(bbits[0]);
                graph.nodes.add(new IntermediateNode(docId, sentIndex, index, copyAnnotation));
            }
        }
        if ((line = reader.readLine().trim()).length() > 0) {
            for (String bit : bits = line.split("\t")) {
                bbits = bit.split(" ");
                if (bbits.length != 3) {
                    throw new RuntimeException("ERROR: Invalid format for dependency graph: " + line);
                }
                String dep = bbits[0];
                int source = Integer.valueOf(bbits[1]);
                int target = Integer.valueOf(bbits[2]);
                graph.edges.add(new IntermediateEdge(dep, source, target));
            }
        }
        return graph;
    }

    private static void saveDependencyGraph(SemanticGraph graph, PrintWriter pw) {
        if (graph == null) {
            pw.println();
            pw.println();
            return;
        }
        if (graph.vertexList() != null && graph.vertexList().size() > 0) {
            IndexedWord first = graph.vertexList().get(0);
            String docId = (String)first.get(CoreAnnotations.DocIDAnnotation.class);
            if (docId != null && docId.length() > 0) {
                pw.print(docId);
            } else {
                pw.print("-");
            }
            pw.print("\t");
            pw.print(first.get(CoreAnnotations.SentenceIndexAnnotation.class));
        }
        for (IndexedWord node : graph.vertexList()) {
            pw.print("\t");
            pw.print(node.index());
            if (!node.containsKey(CoreAnnotations.CopyAnnotation.class)) continue;
            pw.print("-");
            pw.print(node.get(CoreAnnotations.CopyAnnotation.class));
        }
        pw.println();
        boolean first = true;
        for (SemanticGraphEdge edge : graph.edgeList()) {
            if (!first) {
                pw.print("\t");
            }
            String rel = edge.getRelation().toString();
            rel = rel.replaceAll("\\s+", "");
            pw.print(rel);
            pw.print(" ");
            pw.print(((IndexedWord)edge.getSource()).index());
            pw.print(" ");
            pw.print(((IndexedWord)edge.getTarget()).index());
            first = false;
        }
        pw.println();
    }

    @Override
    public void save(Annotation corpus, OutputStream os) throws IOException {
        os = new BufferedOutputStream(os);
        if (this.compress) {
            os = new GZIPOutputStream(os);
        }
        PrintWriter pw = new PrintWriter(os);
        List corefGraph = (List)corpus.get(CorefCoreAnnotations.CorefGraphAnnotation.class);
        if (corefGraph != null) {
            boolean first = true;
            for (Pair arc : corefGraph) {
                if (!first) {
                    pw.print(" ");
                }
                pw.printf("%d %d %d %d", ((IntTuple)arc.first).get(0), ((IntTuple)arc.first).get(1), ((IntTuple)arc.second).get(0), ((IntTuple)arc.second).get(1));
                first = false;
            }
        }
        pw.println();
        List sentences = (List)corpus.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap sent : sentences) {
            Tree tree = (Tree)sent.get(CoreAnnotations.TreeAnnotation.class);
            if (tree != null) {
                String treeString = tree.toString();
                treeString = treeString.replaceAll("\n", " ");
                pw.println(treeString);
            } else {
                pw.println();
            }
            SemanticGraph collapsedDeps = (SemanticGraph)((Object)sent.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class));
            CustomAnnotationSerializer.saveDependencyGraph(collapsedDeps, pw);
            SemanticGraph uncollapsedDeps = (SemanticGraph)((Object)sent.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class));
            CustomAnnotationSerializer.saveDependencyGraph(uncollapsedDeps, pw);
            SemanticGraph ccDeps = (SemanticGraph)((Object)sent.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class));
            CustomAnnotationSerializer.saveDependencyGraph(ccDeps, pw);
            List tokens = (List)sent.get(CoreAnnotations.TokensAnnotation.class);
            if (tokens != null) {
                for (CoreLabel token : tokens) {
                    CustomAnnotationSerializer.saveToken(token, pw);
                    pw.println();
                }
            }
            pw.println();
        }
        pw.close();
    }

    private static CoreLabel loadToken(String line) {
        CoreLabel token = new CoreLabel();
        String[] bits = line.split("\t", -1);
        if (bits.length < 7) {
            throw new RuntimeIOException("ERROR: Invalid format token for serialized token (only " + bits.length + " tokens): " + line);
        }
        String word = bits[0].replaceAll(SPACE_HOLDER, " ");
        token.set(CoreAnnotations.TextAnnotation.class, word);
        token.set(CoreAnnotations.TextAnnotation.class, word);
        if (bits[1].length() > 0 || bits[0].length() == 0) {
            String lemma = bits[1].replaceAll(SPACE_HOLDER, " ");
            token.set(CoreAnnotations.LemmaAnnotation.class, lemma);
        }
        if (bits[2].length() > 0) {
            token.set(CoreAnnotations.PartOfSpeechAnnotation.class, bits[2]);
        }
        if (bits[3].length() > 0) {
            token.set(CoreAnnotations.NamedEntityTagAnnotation.class, bits[3]);
        }
        if (bits[4].length() > 0) {
            token.set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, bits[4]);
        }
        if (bits[5].length() > 0) {
            token.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, Integer.parseInt(bits[5]));
        }
        if (bits[6].length() > 0) {
            token.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, Integer.parseInt(bits[6]));
        }
        return token;
    }

    private static void saveToken(CoreLabel token, PrintWriter pw) {
        String word = (String)token.get(CoreAnnotations.TextAnnotation.class);
        if (word != null) {
            word = word.replaceAll("\\s+", SPACE_HOLDER);
            pw.print(word);
        }
        pw.print("\t");
        String lemma = (String)token.get(CoreAnnotations.LemmaAnnotation.class);
        if (lemma != null) {
            lemma = lemma.replaceAll("\\s+", SPACE_HOLDER);
            pw.print(lemma);
        }
        pw.print("\t");
        String pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
        if (pos != null) {
            pw.print(pos);
        }
        pw.print("\t");
        String ner = (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class);
        if (ner != null) {
            pw.print(ner);
        }
        pw.print("\t");
        String normNer = (String)token.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
        if (normNer != null) {
            pw.print(normNer);
        }
        pw.print("\t");
        Integer charBegin = (Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        if (charBegin != null) {
            pw.print(charBegin);
        }
        pw.print("\t");
        Integer charEnd = (Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        if (charEnd != null) {
            pw.print(charEnd);
        }
    }

    public static void main(String[] args) throws Exception {
        Properties props = StringUtils.argsToProperties(args);
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        String file = props.getProperty("file");
        String text = IOUtils.slurpFile(file);
        Annotation doc = new Annotation(text);
        pipeline.annotate(doc);
        CustomAnnotationSerializer ser = new CustomAnnotationSerializer(false);
        PrintStream os = new PrintStream(new FileOutputStream(file + ".ser"));
        ser.save(doc, os);
        os.close();
        System.out.println("Serialized annotation saved in " + file + ".ser");
    }

    private static class IntermediateEdge {
        int source;
        int target;
        String dep;

        IntermediateEdge(String dep, int source, int target) {
            this.dep = dep;
            this.source = source;
            this.target = target;
        }
    }

    private static class IntermediateNode {
        String docId;
        int sentIndex;
        int index;
        int copyAnnotation;

        IntermediateNode(String docId, int sentIndex, int index, int copy) {
            this.docId = docId;
            this.sentIndex = sentIndex;
            this.index = index;
            this.copyAnnotation = copy;
        }
    }

    private static class IntermediateSemanticGraph {
        List<IntermediateNode> nodes = new ArrayList<IntermediateNode>();
        List<IntermediateEdge> edges = new ArrayList<IntermediateEdge>();

        IntermediateSemanticGraph() {
        }
    }
}

