/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.dcoref.CorefChain;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.MentionExtractor;
import edu.stanford.nlp.dcoref.RuleBasedCorefMentionFinder;
import edu.stanford.nlp.dcoref.SieveCoreferenceSystem;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.CorefCoreAnnotations;
import edu.stanford.nlp.ling.CyclicCoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;

public class DeterministicCorefAnnotator
implements Annotator {
    private static final boolean VERBOSE = false;
    private final MentionExtractor mentionExtractor;
    private final SieveCoreferenceSystem corefSystem;
    private final boolean OLD_FORMAT;

    public DeterministicCorefAnnotator(Properties props) {
        try {
            this.corefSystem = new SieveCoreferenceSystem(props);
            this.mentionExtractor = new MentionExtractor(this.corefSystem.dictionaries(), this.corefSystem.semantics());
            this.OLD_FORMAT = Boolean.parseBoolean(props.getProperty("oldCorefFormat", "false"));
        }
        catch (Exception e) {
            System.err.println("ERROR: cannot create DeterministicCorefAnnotator!");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void annotate(Annotation annotation) {
        ArrayList<Tree> trees = new ArrayList<Tree>();
        ArrayList<List<CoreLabel>> sentences = new ArrayList<List<CoreLabel>>();
        Annotation anno = new Annotation(annotation);
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            int sentNum = 0;
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                CoreMap s = (CoreMap)((List)anno.get(CoreAnnotations.SentencesAnnotation.class)).get(sentNum++);
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                sentences.add(tokens);
                s.set(CoreAnnotations.TokensAnnotation.class, tokens);
                Tree tree = (Tree)sentence.get(CoreAnnotations.TreeAnnotation.class);
                Tree treeCopy = tree.treeSkeletonCopy();
                trees.add(treeCopy);
                s.set(CoreAnnotations.TreeAnnotation.class, treeCopy);
                MentionExtractor.mergeLabels(treeCopy, tokens);
                MentionExtractor.initializeUtterance(tokens);
            }
        } else {
            System.err.println("ERROR: this coreference resolution system requires SentencesAnnotation!");
            return;
        }
        RuleBasedCorefMentionFinder finder = new RuleBasedCorefMentionFinder();
        List<List<Mention>> allUnprocessedMentions = finder.extractPredictedMentions(anno, 0, this.corefSystem.dictionaries());
        Document document = this.mentionExtractor.arrange(annotation, sentences, trees, allUnprocessedMentions);
        List<List<Mention>> orderedMentions = document.getOrderedMentions();
        Map<Integer, CorefChain> result = this.corefSystem.coref(document);
        annotation.set(CorefCoreAnnotations.CorefChainAnnotation.class, result);
        if (this.OLD_FORMAT) {
            List<Pair<IntTuple, IntTuple>> links = SieveCoreferenceSystem.getLinks(result);
            ArrayList<List> sents = new ArrayList<List>();
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                sents.add(tokens);
            }
            ArrayList<Pair<IntTuple, IntTuple>> graph = new ArrayList<Pair<IntTuple, IntTuple>>();
            SimpleGraph jgraph = new SimpleGraph(DefaultEdge.class);
            for (Pair<IntTuple, IntTuple> link : links) {
                int srcSent = ((IntTuple)link.first).get(0);
                int srcTok = orderedMentions.get((int)(srcSent - 1)).get((int)(((IntTuple)link.first).get((int)1) - 1)).headIndex + 1;
                int dstSent = ((IntTuple)link.second).get(0);
                int dstTok = orderedMentions.get((int)(dstSent - 1)).get((int)(((IntTuple)link.second).get((int)1) - 1)).headIndex + 1;
                IntTuple dst = new IntTuple(2);
                dst.set(0, dstSent);
                dst.set(1, dstTok);
                IntTuple intTuple = new IntTuple(2);
                intTuple.set(0, srcSent);
                intTuple.set(1, srcTok);
                graph.add(new Pair<IntTuple, IntTuple>(intTuple, dst));
                if (intTuple.equals(dst)) continue;
                jgraph.addVertex((Object)intTuple);
                jgraph.addVertex((Object)dst);
                jgraph.addEdge((Object)intTuple, (Object)dst);
            }
            annotation.set(CorefCoreAnnotations.CorefGraphAnnotation.class, graph);
            ConnectivityInspector conn = new ConnectivityInspector((UndirectedGraph)jgraph);
            List corefConnectedComponents = conn.connectedSets();
            for (Set corefCluster : corefConnectedComponents) {
                HashSet<CoreLabel> coreferentTokens = new HashSet<CoreLabel>();
                HashSet<CyclicCoreLabel> cyclicCoreferentTokens = new HashSet<CyclicCoreLabel>();
                for (IntTuple intTuple : corefCluster) {
                    CoreMap sentence = (CoreMap)((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).get(intTuple.get(0) - 1);
                    CoreLabel token = (CoreLabel)((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).get(intTuple.get(1) - 1);
                    coreferentTokens.add(token);
                    cyclicCoreferentTokens.add(new CyclicCoreLabel(token));
                }
                for (CoreLabel coreLabel : coreferentTokens) {
                    coreLabel.set(CorefCoreAnnotations.CorefClusterAnnotation.class, cyclicCoreferentTokens);
                }
                for (CoreLabel coreLabel : cyclicCoreferentTokens) {
                    coreLabel.set(CorefCoreAnnotations.CorefClusterAnnotation.class, cyclicCoreferentTokens);
                }
            }
        }
    }
}

