/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.DeprecatedAnnotations;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Timing;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSTaggerAnnotator
implements Annotator {
    final MaxentTagger pos;
    private final boolean VERBOSE;
    private int maxSentenceLength;

    public POSTaggerAnnotator() throws Exception {
        this(true);
    }

    public POSTaggerAnnotator(boolean verbose) throws Exception {
        this(System.getProperty("pos.model", MaxentTagger.DEFAULT_NLP_GROUP_MODEL_PATH), verbose);
    }

    public POSTaggerAnnotator(String posLoc, boolean verbose) throws Exception {
        this(posLoc, verbose, Integer.MAX_VALUE);
    }

    public POSTaggerAnnotator(String posLoc, boolean verbose, int maxSentenceLength) throws Exception {
        this(POSTaggerAnnotator.loadModel(posLoc, verbose), verbose, maxSentenceLength);
    }

    public POSTaggerAnnotator(MaxentTagger model, boolean verbose) {
        this(model, verbose, Integer.MAX_VALUE);
    }

    public POSTaggerAnnotator(MaxentTagger model, boolean verbose, int maxSentenceLength) {
        this.pos = model;
        this.VERBOSE = verbose;
        this.maxSentenceLength = maxSentenceLength;
    }

    public void setMaxSentenceLength(int maxLen) {
        this.maxSentenceLength = maxLen;
    }

    private static MaxentTagger loadModel(String loc, boolean verbose) throws Exception {
        Timing timer = null;
        if (verbose) {
            timer = new Timing();
            timer.doing("Loading POS Model [" + loc + ']');
        }
        MaxentTagger tagger = new MaxentTagger(loc);
        if (verbose) {
            timer.done();
        }
        return tagger;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (annotation.has(DeprecatedAnnotations.WordsPLAnnotation.class)) {
            List sentences = (List)annotation.get(DeprecatedAnnotations.WordsPLAnnotation.class);
            for (List words : sentences) {
                this.processText(words);
            }
        } else if (annotation.has(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                ArrayList<TaggedWord> tagged = null;
                tagged = this.pos.apply(tokens);
                for (int i = 0; i < tokens.size(); ++i) {
                    ((CoreLabel)tokens.get(i)).set(CoreAnnotations.PartOfSpeechAnnotation.class, tagged.get(i).tag());
                }
            }
        } else {
            throw new RuntimeException("unable to find words/tokens in: " + annotation);
        }
    }

    public List<? extends CoreLabel> processText(List<? extends CoreLabel> text) {
        if (text.size() > this.maxSentenceLength) {
            return this.processTextLargerThanMaxLen(text);
        }
        ArrayList<TaggedWord> tagged = this.pos.apply((List<? extends HasWord>)new ArrayList<CoreLabel>(text));
        Iterator<TaggedWord> taggedIter = tagged.iterator();
        for (CoreLabel coreLabel : text) {
            TaggedWord cur = taggedIter.next();
            coreLabel.setTag(cur.tag());
        }
        return text;
    }

    private List<? extends CoreLabel> processTextLargerThanMaxLen(List<? extends CoreLabel> text) {
        int startIndx = 0;
        int endIndx = startIndx + this.maxSentenceLength < text.size() ? startIndx + this.maxSentenceLength : text.size();
        while (true) {
            System.out.println(startIndx + "\t" + endIndx);
            List<? extends CoreLabel> textToTag = text.subList(startIndx, endIndx);
            ArrayList<TaggedWord> tagged = this.pos.apply(textToTag);
            Iterator<TaggedWord> taggedIter = tagged.iterator();
            for (CoreLabel coreLabel : textToTag) {
                TaggedWord cur = taggedIter.next();
                coreLabel.setTag(cur.tag());
            }
            if (startIndx + this.maxSentenceLength >= text.size()) break;
            endIndx = (startIndx += this.maxSentenceLength) + this.maxSentenceLength < text.size() ? startIndx + this.maxSentenceLength : text.size();
        }
        return text;
    }
}

