/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.AmbiguityClass;
import edu.stanford.nlp.tagger.maxent.Dictionary;
import edu.stanford.nlp.tagger.maxent.TTags;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;

public class AmbiguityClasses {
    private final Index<AmbiguityClass> classes;
    private static final String naWord = "NA";
    protected final AmbiguityClass naClass = new AmbiguityClass();

    public AmbiguityClasses(TTags ttags) {
        this.classes = new HashIndex<AmbiguityClass>();
        this.naClass.init(naWord, ttags);
    }

    private int add(AmbiguityClass a) {
        if (this.classes.contains(a)) {
            return this.classes.indexOf(a);
        }
        this.classes.add(a);
        return this.classes.indexOf(a);
    }

    protected int getClass(String word, Dictionary dict, int veryCommonWordThresh, TTags ttags) {
        if (word.equals(naWord)) {
            return -2;
        }
        if (dict.isUnknown(word)) {
            return -1;
        }
        AmbiguityClass a = dict.sum(word) > veryCommonWordThresh ? new AmbiguityClass(word, true, dict, ttags) : new AmbiguityClass(word, dict, ttags);
        return this.add(a);
    }
}

