/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.Dictionary;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.RareExtractor;

class ExtractorStartSentenceCap
extends RareExtractor {
    private transient Dictionary dict;
    private static final long serialVersionUID = 25L;

    protected void setGlobalHolder(MaxentTagger tagger) {
        this.dict = tagger.dict;
    }

    String extract(History h, PairsHolder pH) {
        String prevTag = pH.getTag(h, -1);
        if (prevTag == null) {
            return "0";
        }
        if (!prevTag.equals("NA")) {
            return "0";
        }
        String s = pH.getWord(h, 0);
        if (ExtractorStartSentenceCap.startsUpperCase(s)) {
            String s1 = s.toLowerCase();
            if (this.dict.isUnknown(s1)) {
                return "0";
            }
            return this.dict.getFirstTag(s1);
        }
        return "0";
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isDynamic() {
        return true;
    }
}

