/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.Dataset;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Triple;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossValidator<L, F> {
    private GeneralDataset<L, F> originalTrainData;
    private int kfold;
    private SavedState[] savedStates;

    public CrossValidator(GeneralDataset<L, F> trainData) {
        this(trainData, 5);
    }

    public CrossValidator(GeneralDataset<L, F> trainData, int kfold) {
        this.originalTrainData = trainData;
        this.kfold = kfold;
        this.savedStates = new SavedState[kfold];
        for (int i = 0; i < this.savedStates.length; ++i) {
            this.savedStates[i] = new SavedState();
        }
    }

    private Iterator<Triple<GeneralDataset<L, F>, GeneralDataset<L, F>, SavedState>> iterator() {
        return new CrossValidationIterator();
    }

    public double computeAverage(Function<Triple<GeneralDataset<L, F>, GeneralDataset<L, F>, SavedState>, Double> function) {
        double sum = 0.0;
        Iterator<Triple<GeneralDataset<L, F>, GeneralDataset<L, F>, SavedState>> foldIt = this.iterator();
        while (foldIt.hasNext()) {
            sum += function.apply(foldIt.next()).doubleValue();
        }
        return sum / (double)this.kfold;
    }

    public static void main(String[] args) {
        Dataset<String, String> d = Dataset.readSVMLightFormat(args[0]);
        Iterator<Triple<GeneralDataset<String, String>, GeneralDataset<String, String>, SavedState>> it = super.iterator();
        if (it.hasNext()) {
            it.next();
        }
    }

    public static class SavedState {
        public Object state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CrossValidationIterator
    implements Iterator<Triple<GeneralDataset<L, F>, GeneralDataset<L, F>, SavedState>> {
        int iter = 0;

        CrossValidationIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.iter < CrossValidator.this.kfold;
        }

        @Override
        public void remove() {
            throw new RuntimeException("CrossValidationIterator doesn't support remove()");
        }

        @Override
        public Triple<GeneralDataset<L, F>, GeneralDataset<L, F>, SavedState> next() {
            if (this.iter == CrossValidator.this.kfold) {
                return null;
            }
            int start = CrossValidator.this.originalTrainData.size() * this.iter / CrossValidator.this.kfold;
            int end = CrossValidator.this.originalTrainData.size() * (this.iter + 1) / CrossValidator.this.kfold;
            Pair split = CrossValidator.this.originalTrainData.split(start, end);
            return new Triple(split.first(), split.second(), CrossValidator.this.savedStates[this.iter++]);
        }
    }
}

