/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.CorefCluster;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.ling.CorefCoreAnnotations;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.IntTuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorefChain {
    private int chainID;
    private List<CorefMention> mentions;
    private HashMap<IntPair, CorefMention> mentionMap;
    private CorefMention representative = null;

    public List<CorefMention> getCorefMentions() {
        return this.mentions;
    }

    public CorefMention getMention(IntPair position) {
        return this.mentionMap.get(position);
    }

    public CorefMention getRepresentativeMention() {
        return this.representative;
    }

    public int getChainID() {
        return this.chainID;
    }

    public CorefChain(CorefCluster c, HashMap<Mention, IntTuple> positions) {
        this.chainID = c.clusterID;
        this.mentions = new ArrayList<CorefMention>();
        this.mentionMap = new HashMap();
        for (Mention m : c.getCorefMentions()) {
            CorefMention men = new CorefMention(m);
            IntTuple pos = positions.get(m);
            men.position = new IntTuple(2);
            men.position.set(0, pos.get(0) + 1);
            men.position.set(1, pos.get(1) + 1);
            this.mentions.add(men);
            this.mentionMap.put(new IntPair(men.sentNum, men.headIndex), men);
            if (!men.moreRepresentativeThan(this.representative)) continue;
            this.representative = men;
        }
        Collections.sort(this.mentions, new MentionComparator());
    }

    public String toString() {
        return this.mentions.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MentionComparator
    implements Comparator<CorefMention> {
        protected MentionComparator() {
        }

        @Override
        public int compare(CorefMention m1, CorefMention m2) {
            if (m1.sentNum < m2.sentNum) {
                return -1;
            }
            if (m1.sentNum > m2.sentNum) {
                return 1;
            }
            if (m1.startIndex < m2.startIndex) {
                return -1;
            }
            if (m1.startIndex > m2.startIndex) {
                return 1;
            }
            if (m1.endIndex > m2.endIndex) {
                return -1;
            }
            if (m1.endIndex < m2.endIndex) {
                return 1;
            }
            return 0;
        }
    }

    public static class CorefMention {
        public Dictionaries.MentionType mentionType;
        public Dictionaries.Number number;
        public Dictionaries.Gender gender;
        public Dictionaries.Animacy animacy;
        public int startIndex;
        public int endIndex;
        public int headIndex;
        public int corefClusterID;
        public int mentionID;
        public int sentNum;
        public IntTuple position;

        public CorefMention(Mention m) {
            this.mentionType = m.mentionType;
            this.number = m.number;
            this.gender = m.gender;
            this.animacy = m.animacy;
            this.startIndex = m.startIndex + 1;
            this.endIndex = m.endIndex + 1;
            this.headIndex = m.headIndex + 1;
            this.corefClusterID = m.corefClusterID;
            this.sentNum = m.sentNum + 1;
            this.mentionID = m.mentionID;
            m.headWord.set(CorefCoreAnnotations.CorefClusterIdAnnotation.class, this.corefClusterID);
        }

        public String toString() {
            return this.position.toString();
        }

        private boolean moreRepresentativeThan(CorefMention m) {
            if (m == null) {
                return true;
            }
            if (this.mentionType != m.mentionType) {
                return this.mentionType == Dictionaries.MentionType.PROPER && m.mentionType != Dictionaries.MentionType.PROPER || this.mentionType == Dictionaries.MentionType.NOMINAL && m.mentionType == Dictionaries.MentionType.PRONOMINAL;
            }
            if (this.headIndex - this.startIndex > m.headIndex - m.startIndex) {
                return true;
            }
            return this.sentNum < m.sentNum || this.sentNum == m.sentNum && this.headIndex < m.headIndex;
        }
    }
}

