/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.fsm;

import edu.stanford.nlp.fsm.Block;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Maps;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransducerGraph
implements Cloneable {
    public static final Object EPSILON_INPUT = "EPSILON";
    private static final Object DEFAULT_START_NODE = "START";
    private static Random r = new Random();
    private Set<Arc> arcs = new HashSet<Arc>();
    private Map<Object, Set<Arc>> arcsBySource = Generics.newHashMap();
    private Map<Object, Set<Arc>> arcsByTarget = Generics.newHashMap();
    private Map<Object, Set<Arc>> arcsByInput = Generics.newHashMap();
    private Map<Pair<Object, Object>, Arc> arcsBySourceAndInput = Generics.newHashMap();
    private Map<Object, Set<Arc>> arcsByTargetAndInput = Generics.newHashMap();
    private Object startNode;
    private Set endNodes = new HashSet();
    private boolean checkDeterminism = false;
    private boolean dotWeightInverted = false;

    public void setDeterminism(boolean checkDeterminism) {
        this.checkDeterminism = checkDeterminism;
    }

    public TransducerGraph() {
        this.setStartNode(DEFAULT_START_NODE);
    }

    public TransducerGraph(TransducerGraph other) {
        this(other, (ArcProcessor)null);
    }

    public TransducerGraph(TransducerGraph other, ArcProcessor arcProcessor) {
        this(other.getArcs(), other.getStartNode(), other.getEndNodes(), arcProcessor, null);
    }

    public TransducerGraph(TransducerGraph other, NodeProcessor nodeProcessor) {
        this(other.getArcs(), other.getStartNode(), other.getEndNodes(), null, nodeProcessor);
    }

    public TransducerGraph(Set<Arc> newArcs, Object startNode, Set endNodes, ArcProcessor arcProcessor, NodeProcessor nodeProcessor) {
        this();
        NodeProcessorWrappingArcProcessor arcProcessor2 = null;
        if (nodeProcessor != null) {
            arcProcessor2 = new NodeProcessorWrappingArcProcessor(nodeProcessor);
        }
        for (Arc a : newArcs) {
            a = new Arc(a);
            if (arcProcessor != null) {
                a = arcProcessor.processArc(a);
            }
            if (arcProcessor2 != null) {
                a = arcProcessor2.processArc(a);
            }
            this.addArc(a);
        }
        this.startNode = nodeProcessor != null ? nodeProcessor.processNode(startNode) : startNode;
        if (nodeProcessor != null) {
            if (endNodes != null) {
                for (Object o : endNodes) {
                    this.endNodes.add(nodeProcessor.processNode(o));
                }
            }
        } else if (endNodes != null) {
            this.endNodes.addAll(endNodes);
        }
    }

    public TransducerGraph(Set<Arc> newArcs) {
        this(newArcs, null, null, null, null);
    }

    public TransducerGraph clone() {
        TransducerGraph result = new TransducerGraph(this, (ArcProcessor)null);
        return result;
    }

    public Set<Arc> getArcs() {
        return this.arcs;
    }

    public Set getNodes() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.arcsBySource.keySet());
        result.addAll(this.arcsByTarget.keySet());
        return result;
    }

    public Set getInputs() {
        return this.arcsByInput.keySet();
    }

    public void setStartNode(Object o) {
        this.startNode = o;
    }

    public void setEndNode(Object o) {
        this.endNodes.add(o);
    }

    public Object getStartNode() {
        return this.startNode;
    }

    public Set getEndNodes() {
        return this.endNodes;
    }

    public Set<Arc> getArcsByInput(Object node) {
        return this.ensure(this.arcsByInput.get(node));
    }

    public Set<Arc> getArcsBySource(Object node) {
        return this.ensure(this.arcsBySource.get(node));
    }

    protected Set<Arc> ensure(Set<Arc> s) {
        if (s == null) {
            return Collections.emptySet();
        }
        return s;
    }

    public Set<Arc> getArcsByTarget(Object node) {
        return this.ensure(this.arcsByTarget.get(node));
    }

    public Arc getArcBySourceAndInput(Object node, Object input) {
        return this.arcsBySourceAndInput.get(Generics.newPair(node, input));
    }

    public Set<Arc> getArcsByTargetAndInput(Object node, Object input) {
        return this.ensure(this.arcsByTargetAndInput.get(Generics.newPair(node, input)));
    }

    public Arc getArc(Object source, Object target) {
        Set<Arc> arcsFromSource = this.arcsBySource.get(source);
        Set<Arc> arcsToTarget = this.arcsByTarget.get(target);
        HashSet<Arc> result = Generics.newHashSet();
        result.addAll(arcsFromSource);
        result.retainAll(arcsToTarget);
        if (result.size() < 1) {
            return null;
        }
        if (result.size() > 1) {
            throw new RuntimeException("Problem in TransducerGraph data structures.");
        }
        Iterator iterator = result.iterator();
        return (Arc)iterator.next();
    }

    public boolean addArc(Object source, Object target, Object input, Object output) {
        Arc<Object, Object, Object> a = new Arc<Object, Object, Object>(source, target, input, output);
        return this.addArc(a);
    }

    protected boolean addArc(Arc a) {
        Object source = a.getSourceNode();
        Object target = a.getTargetNode();
        Object input = a.getInput();
        if (source == null || target == null || input == null) {
            return false;
        }
        if (this.arcs.contains(a)) {
            return false;
        }
        Pair p = Generics.newPair(source, input);
        if (this.arcsBySourceAndInput.containsKey(p) && this.checkDeterminism) {
            throw new RuntimeException("Creating nondeterminism while inserting arc " + a + " because it already has arc " + this.arcsBySourceAndInput.get(p) + this.checkDeterminism);
        }
        this.arcsBySourceAndInput.put(p, a);
        Maps.putIntoValueHashSet(this.arcsBySource, source, a);
        p = Generics.newPair(target, input);
        Maps.putIntoValueHashSet(this.arcsByTargetAndInput, p, a);
        Maps.putIntoValueHashSet(this.arcsByTarget, target, a);
        Maps.putIntoValueHashSet(this.arcsByInput, input, a);
        this.arcs.add(a);
        return true;
    }

    public boolean removeArc(Arc a) {
        Object source = a.getSourceNode();
        Object target = a.getTargetNode();
        Object input = a.getInput();
        if (!this.arcs.remove(a)) {
            return false;
        }
        Pair p = Generics.newPair(source, input);
        if (!this.arcsBySourceAndInput.containsKey(p)) {
            return false;
        }
        this.arcsBySourceAndInput.remove(p);
        Set<Arc> s = this.arcsBySource.get(source);
        if (s == null) {
            return false;
        }
        if (!s.remove(a)) {
            return false;
        }
        p = Generics.newPair(target, input);
        s = this.arcsByTargetAndInput.get(p);
        if (s == null) {
            return false;
        }
        if (!s.remove(a)) {
            return false;
        }
        s = this.arcsByTarget.get(target);
        if (s == null) {
            return false;
        }
        s = this.arcsByInput.get(input);
        if (s == null) {
            return false;
        }
        return s.remove(a);
    }

    public boolean canAddArc(Object source, Object target, Object input, Object output) {
        Arc<Object, Object, Object> a = new Arc<Object, Object, Object>(source, target, input, output);
        if (this.arcs.contains(a)) {
            return false;
        }
        Pair<Object, Object> p = Generics.newPair(source, input);
        return !this.arcsBySourceAndInput.containsKey(p);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.depthFirstSearch(true, sb);
        return sb.toString();
    }

    public void setDotWeightingInverted(boolean inverted) {
        this.dotWeightInverted = true;
    }

    public String asDOTString() {
        int mag;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(3);
        nf.setMinimumFractionDigits(1);
        StringBuffer result = new StringBuffer();
        Set nodes = this.getNodes();
        result.append("digraph G {\n");
        int sz = this.arcs.size();
        int ht = 105;
        for (mag = 250; sz > mag; mag *= 2) {
            ht += 105;
        }
        int wd = 8;
        for (mag = 500; sz > mag; mag *= 4) {
            wd += 8;
        }
        double htd = (double)ht / 10.0;
        result.append("size = \"" + wd + "," + htd + "\";\n");
        result.append("graph [rankdir = \"LR\"];\n");
        result.append("graph [ranksep = \"0.2\"];\n");
        for (Object node : nodes) {
            String cleanString = StringUtils.fileNameClean(node.toString());
            result.append(cleanString);
            result.append(" [ ");
            result.append("label=\"" + node.toString() + "\"");
            result.append("height=\"0.3\", width=\"0.3\"");
            result.append(" ];\n");
            for (Arc arc : this.getArcsBySource(node)) {
                result.append(StringUtils.fileNameClean(arc.getSourceNode().toString()));
                result.append(" -> ");
                result.append(StringUtils.fileNameClean(arc.getTargetNode().toString()));
                result.append(" [ ");
                result.append("label=\"");
                result.append(arc.getInput());
                result.append(" : ");
                Object output = arc.getOutput();
                String wt = "";
                if (output instanceof Number) {
                    double dd = ((Number)output).doubleValue();
                    if (dd == -0.0) {
                        result.append(nf.format(0.0));
                    } else {
                        result.append(nf.format(output));
                    }
                    int weight2 = this.dotWeightInverted ? (int)(20.0 - dd) : (int)dd;
                    if (weight2 > 0) {
                        wt = ", weight = \"" + weight2 + "\"";
                    }
                    if (this.dotWeightInverted && dd <= 2.0 || !this.dotWeightInverted && dd >= 20.0) {
                        wt = wt + ", style=bold";
                    }
                } else {
                    result.append(output);
                }
                result.append("\"");
                result.append(wt);
                if (arc.getInput().toString().equals("EPSILON")) {
                    result.append(", style = \"dashed\" ");
                } else {
                    result.append(", style = \"solid\" ");
                }
                result.append("];\n");
            }
        }
        result.append("}\n");
        return result.toString();
    }

    public double inFlow(Object node) {
        Set<Arc> arcs = this.getArcsByTarget(node);
        return this.sumOutputs(arcs);
    }

    public double outFlow(Object node) {
        Set<Arc> arcs = this.getArcsBySource(node);
        return this.sumOutputs(arcs);
    }

    private double sumOutputs(Set<Arc> arcs) {
        double sum = 0.0;
        for (Arc arc : arcs) {
            sum += ((Double)arc.getOutput()).doubleValue();
        }
        return sum;
    }

    public double getSourceTotal(Object node) {
        double result = 0.0;
        Set<Arc> arcs = this.getArcsBySource(node);
        if (arcs.size() == 0) {
            System.err.println("No outbound arcs from node.");
            return result;
        }
        for (Arc arc : arcs) {
            result += ((Double)arc.getOutput()).doubleValue();
        }
        return result;
    }

    public double getOutputOfPathInGraph(List path) {
        double score = 0.0;
        Object node = this.getStartNode();
        for (Object input : path) {
            Arc arc = this.getArcBySourceAndInput(node, input);
            if (arc == null) {
                System.out.println(" NOT ACCEPTED :" + path);
                return Double.NEGATIVE_INFINITY;
            }
            score += ((Double)arc.getOutput()).doubleValue();
            node = arc.getTargetNode();
        }
        return score;
    }

    public List sampleUniformPathFromGraph() {
        ArrayList list = new ArrayList();
        Object node = this.getStartNode();
        Set endNodes = this.getEndNodes();
        while (!endNodes.contains(node)) {
            ArrayList<Arc> arcs = new ArrayList<Arc>(this.getArcsBySource(node));
            Arc arc = (Arc)arcs.get(r.nextInt(arcs.size()));
            list.add(arc.getInput());
            node = arc.getTargetNode();
        }
        return list;
    }

    public Map<List, Double> samplePathsFromGraph(int numPaths) {
        HashMap<List, Double> result = new HashMap<List, Double>();
        for (int i = 0; i < numPaths; ++i) {
            List l = this.sampleUniformPathFromGraph();
            result.put(l, new Double(this.getOutputOfPathInGraph(l)));
        }
        return result;
    }

    public static void printPathOutputs(List<List> pathList, TransducerGraph graph, boolean printPaths) {
        int i = 0;
        for (List path : pathList) {
            if (printPaths) {
                Iterator j = path.iterator();
                while (j.hasNext()) {
                    System.out.print(j.next() + " ");
                }
            } else {
                System.out.print(i++ + " ");
            }
            System.out.print("output: " + graph.getOutputOfPathInGraph(path));
            System.out.println();
        }
    }

    public List<Double> getPathOutputs(List<List> pathList) {
        ArrayList<Double> outputList = new ArrayList<Double>();
        for (List path : pathList) {
            outputList.add(new Double(this.getOutputOfPathInGraph(path)));
        }
        return outputList;
    }

    public static boolean testGraphPaths(TransducerGraph sourceGraph, TransducerGraph testGraph, int numPaths) {
        for (int i = 0; i < numPaths; ++i) {
            double newScore;
            List path = sourceGraph.sampleUniformPathFromGraph();
            double score = sourceGraph.getOutputOfPathInGraph(path);
            if (!((score - (newScore = testGraph.getOutputOfPathInGraph(path))) / (score + newScore) > 1.0E-10)) continue;
            System.out.println("Problem: " + score + " vs. " + newScore + " on " + path);
            return false;
        }
        return true;
    }

    public boolean canAddPath(List path) {
        Object node = this.getStartNode();
        for (int j = 0; j < path.size() - 1; ++j) {
            Object input = path.get(j);
            Arc arc = this.getArcBySourceAndInput(node, input);
            if (arc == null) {
                return true;
            }
            node = arc.getTargetNode();
        }
        Object input = path.get(path.size() - 1);
        Arc arc = this.getArcBySourceAndInput(node, input);
        if (arc == null) {
            return true;
        }
        return this.getEndNodes().contains(arc.getTargetNode());
    }

    public static TransducerGraph createGraphFromPaths(List paths, int markovOrder) {
        ClassicCounter pathCounter = new ClassicCounter();
        for (Object o : paths) {
            pathCounter.incrementCount((List)o);
        }
        return TransducerGraph.createGraphFromPaths(pathCounter, markovOrder);
    }

    public static <T> TransducerGraph createGraphFromPaths(ClassicCounter<List<T>> pathCounter, int markovOrder) {
        TransducerGraph graph = new TransducerGraph();
        for (List<T> path : pathCounter.keySet()) {
            double count = pathCounter.getCount(path);
            TransducerGraph.addOnePathToGraph(path, count, markovOrder, graph);
        }
        return graph;
    }

    public static void addOnePathToGraph(List path, double count, int markovOrder, TransducerGraph graph) {
        Object source = graph.getStartNode();
        for (int j = 0; j < path.size(); ++j) {
            Object input = path.get(j);
            Arc a = graph.getArcBySourceAndInput(source, input);
            if (a != null) {
                a.output = new Double((Double)a.output + count);
            } else {
                Object target = input.equals(EPSILON_INPUT) ? "END" : (markovOrder == 0 ? source : (markovOrder > 0 ? path.subList(j < markovOrder ? 0 : j - markovOrder + 1, j + 1) : path.subList(0, j + 1)));
                Double output = new Double(count);
                a = new Arc(source, target, input, output);
                graph.addArc(a);
            }
            source = a.getTargetNode();
        }
        graph.setEndNode(source);
    }

    public static TransducerGraph createRandomGraph(int numPaths, int pathLengthMean, double pathLengthVariance, int numInputs, List pathList) {
        int pathLength = (int)(r.nextGaussian() * pathLengthVariance + (double)pathLengthMean);
        for (int i = 0; i < numPaths; ++i) {
            ArrayList<Integer> path = new ArrayList<Integer>();
            for (int j = 0; j < pathLength; ++j) {
                Integer input = r.nextInt(numInputs);
                path.add(input);
            }
            pathList.add(path);
        }
        return TransducerGraph.createGraphFromPaths(pathList, -1);
    }

    public static List createRandomPaths(int numPaths, int pathLengthMean, double pathLengthVariance, int numInputs) {
        ArrayList pathList = new ArrayList();
        int pathLength = (int)(r.nextGaussian() * pathLengthVariance + (double)pathLengthMean);
        for (int i = 0; i < numPaths; ++i) {
            Object input;
            ArrayList<Object> path = new ArrayList<Object>();
            for (int j = 0; j < pathLength; ++j) {
                input = r.nextInt(numInputs);
                path.add(input);
            }
            input = EPSILON_INPUT;
            path.add(input);
            pathList.add(path);
        }
        return pathList;
    }

    public void depthFirstSearch(boolean forward, StringBuffer b) {
        if (forward) {
            this.depthFirstSearchHelper(this.getStartNode(), new HashSet(), 0, true, b);
        } else {
            for (Object o : this.getEndNodes()) {
                this.depthFirstSearchHelper(o, new HashSet(), 0, false, b);
            }
        }
    }

    private void depthFirstSearchHelper(Object node, Set marked, int level, boolean forward, StringBuffer b) {
        if (marked.contains(node)) {
            return;
        }
        marked.add(node);
        Set<Arc> arcs = forward ? this.getArcsBySource(node) : this.getArcsByTarget(node);
        if (arcs == null) {
            return;
        }
        for (Arc newArc : arcs) {
            for (int i = 0; i < level; ++i) {
                b.append("  ");
            }
            if (this.getEndNodes().contains(newArc.getTargetNode())) {
                b.append(newArc + " END\n");
            } else {
                b.append(newArc + "\n");
            }
            if (forward) {
                this.depthFirstSearchHelper(newArc.getTargetNode(), marked, level + 1, forward, b);
                continue;
            }
            this.depthFirstSearchHelper(newArc.getSourceNode(), marked, level + 1, forward, b);
        }
    }

    public static void main(String[] args) {
        ArrayList<List> pathList = new ArrayList<List>();
        TransducerGraph graph = TransducerGraph.createRandomGraph(1000, 10, 0.0, 10, pathList);
        System.out.println("Done creating random graph");
        TransducerGraph.printPathOutputs(pathList, graph, true);
        System.out.println("Depth first search from start node");
        StringBuffer b = new StringBuffer();
        graph.depthFirstSearch(true, b);
        System.out.println(b.toString());
        b = new StringBuffer();
        System.out.println("Depth first search back from end node");
        graph.depthFirstSearch(false, b);
        System.out.println(b.toString());
    }

    public static interface GraphProcessor {
        public TransducerGraph processGraph(TransducerGraph var1);
    }

    public static class ObjectToSetNodeProcessor
    implements NodeProcessor {
        public Object processNode(Object node) {
            return Collections.singleton(node);
        }
    }

    public static class SetToStringNodeProcessor
    implements NodeProcessor {
        private TreebankLanguagePack tlp;

        public SetToStringNodeProcessor(TreebankLanguagePack tlp) {
            this.tlp = tlp;
        }

        public Object processNode(Object node) {
            String str;
            Set s = null;
            if (node instanceof Set) {
                s = (Set)node;
            } else if (node instanceof Block) {
                Block b = (Block)node;
                s = b.getMembers();
            } else {
                throw new RuntimeException("Unexpected node class");
            }
            Object sampleNode = s.iterator().next();
            if (s.size() == 1) {
                if (sampleNode instanceof Block) {
                    return this.processNode(sampleNode);
                }
                return sampleNode;
            }
            if (sampleNode instanceof String && (str = (String)sampleNode).charAt(0) != '@') {
                return this.tlp.basicCategory(str) + "-" + ((Object)s).hashCode();
            }
            return "@NodeSet-" + ((Object)s).hashCode();
        }
    }

    public static interface NodeProcessor {
        public Object processNode(Object var1);
    }

    public static class NodeProcessorWrappingArcProcessor
    implements ArcProcessor {
        NodeProcessor nodeProcessor;

        public NodeProcessorWrappingArcProcessor(NodeProcessor nodeProcessor) {
            this.nodeProcessor = nodeProcessor;
        }

        public Arc processArc(Arc a) {
            a = new Arc(a);
            a.setSourceNode(this.nodeProcessor.processNode(a.getSourceNode()));
            a.setTargetNode(this.nodeProcessor.processNode(a.getTargetNode()));
            return a;
        }
    }

    public static class InputSplittingProcessor
    implements ArcProcessor {
        public Arc processArc(Arc a) {
            a = new Arc(a);
            Pair p = (Pair)a.getInput();
            a.setInput(p.first);
            a.setOutput(p.second);
            return a;
        }
    }

    public static class OutputCombiningProcessor
    implements ArcProcessor {
        public Arc processArc(Arc a) {
            a = new Arc(a);
            a.setInput(Generics.newPair(a.getInput(), a.getOutput()));
            a.setOutput(null);
            return a;
        }
    }

    public static interface ArcProcessor {
        public Arc processArc(Arc var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Arc<NODE, IN, OUT> {
        protected NODE sourceNode;
        protected NODE targetNode;
        protected IN input;
        protected OUT output;

        public NODE getSourceNode() {
            return this.sourceNode;
        }

        public NODE getTargetNode() {
            return this.targetNode;
        }

        public IN getInput() {
            return this.input;
        }

        public OUT getOutput() {
            return this.output;
        }

        public void setSourceNode(NODE o) {
            this.sourceNode = o;
        }

        public void setTargetNode(NODE o) {
            this.targetNode = o;
        }

        public void setInput(IN o) {
            this.input = o;
        }

        public void setOutput(OUT o) {
            this.output = o;
        }

        public int hashCode() {
            return this.sourceNode.hashCode() ^ this.targetNode.hashCode() << 16 ^ this.input.hashCode() << 16;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Arc)) {
                return false;
            }
            Arc a = (Arc)o;
            return (this.sourceNode == null ? a.sourceNode == null : this.sourceNode.equals(a.sourceNode)) && (this.targetNode == null ? a.targetNode == null : this.targetNode.equals(a.targetNode)) && (this.input == null ? a.input == null : this.input.equals(a.input));
        }

        protected Arc(Arc<NODE, IN, OUT> a) {
            this(a.getSourceNode(), a.getTargetNode(), a.getInput(), a.getOutput());
        }

        protected Arc(NODE sourceNode, NODE targetNode) {
            this(sourceNode, targetNode, null, null);
        }

        protected Arc(NODE sourceNode, NODE targetNode, IN input) {
            this(sourceNode, targetNode, input, null);
        }

        protected Arc(NODE sourceNode, NODE targetNode, IN input, OUT output) {
            this.sourceNode = sourceNode;
            this.targetNode = targetNode;
            this.input = input;
            this.output = output;
        }

        public String toString() {
            return this.sourceNode + " --> " + this.targetNode + " (" + this.input + " : " + this.output + ")";
        }
    }
}

