/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ie.crf.CRFDatum;
import edu.stanford.nlp.ie.crf.CRFLabel;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.optimization.GoldenSectionLineSearch;
import edu.stanford.nlp.sequences.Clique;
import edu.stanford.nlp.sequences.FeatureFactory;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.PaddedList;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRFBiasedClassifier<IN extends CoreMap>
extends CRFClassifier<IN> {
    private static final String BIAS = "@@@DECODING_CLASS_BIAS@@@";
    private boolean testTime = false;
    private CRFBiasedClassifierOptimizer optimizer = null;

    public CRFBiasedClassifier(Properties props) {
        super(props);
    }

    @Override
    public CRFDatum<List<String>, CRFLabel> makeDatum(List<IN> info, int loc, FeatureFactory<IN> featureFactory) {
        this.pad.set(CoreAnnotations.AnswerAnnotation.class, this.flags.backgroundSymbol);
        PaddedList<CoreMap> pInfo = new PaddedList<CoreMap>(info, this.pad);
        ArrayList features = new ArrayList();
        HashSet<Clique> done = new HashSet<Clique>();
        for (int i = 0; i < this.windowSize; ++i) {
            ArrayList<String> featuresC = new ArrayList<String>();
            List<Clique> windowCliques = FeatureFactory.getCliques(i, 0);
            windowCliques.removeAll(done);
            done.addAll(windowCliques);
            for (Clique c : windowCliques) {
                featuresC.addAll(featureFactory.getCliqueFeatures(pInfo, loc, c));
                if (!this.testTime || i != 0) continue;
                featuresC.add(BIAS);
            }
            features.add(featuresC);
        }
        int[] labels = new int[this.windowSize];
        for (int i = 0; i < this.windowSize; ++i) {
            String answer = (String)pInfo.get(loc + i - this.windowSize + 1).get(CoreAnnotations.AnswerAnnotation.class);
            labels[i] = this.classIndex.indexOf(answer);
        }
        return new CRFDatum<List<String>, CRFLabel>(features, new CRFLabel(labels));
    }

    void addBiasFeature() {
        if (!this.featureIndex.contains(BIAS)) {
            this.featureIndex.add(BIAS);
            double[][] newweights = new double[this.weights.length + 1][];
            System.arraycopy(this.weights, 0, newweights, 0, this.weights.length);
            newweights[this.weights.length] = new double[this.classIndex.size()];
            this.weights = newweights;
        }
    }

    public void setBiasWeight(String cname, double weight2) {
        int ci = this.classIndex.indexOf(cname);
        this.setBiasWeight(ci, weight2);
    }

    public void setBiasWeight(int cindex, double weight2) {
        this.addBiasFeature();
        int fi = this.featureIndex.indexOf(BIAS);
        this.weights[fi][cindex] = weight2;
    }

    @Override
    public List<IN> classify(List<IN> document) {
        this.testTime = true;
        List<IN> l = super.classify(document);
        this.testTime = false;
        return l;
    }

    public void adjustBias(List<List<IN>> develData, Function<Double, Double> evalFunction, double low, double high) {
        GoldenSectionLineSearch ls = new GoldenSectionLineSearch(true, 0.01, low, high);
        this.optimizer = new CRFBiasedClassifierOptimizer(this, evalFunction);
        double optVal = ls.minimize(this.optimizer);
        int bi = this.featureIndex.indexOf(BIAS);
        System.err.println("Class bias of " + this.weights[bi][0] + " reaches optimial value " + optVal);
    }

    public static void main(String[] args) throws Exception {
        System.err.println("CRFBiasedClassifier invoked at " + new Date() + " with arguments:");
        for (String arg : args) {
            System.err.print(" " + arg);
        }
        System.err.println();
        Properties props = StringUtils.argsToProperties(args);
        CRFBiasedClassifier crf = new CRFBiasedClassifier(props);
        String testFile = crf.flags.testFile;
        String loadPath = crf.flags.loadClassifier;
        if (loadPath != null) {
            crf.loadClassifierNoExceptions(loadPath, props);
        } else if (crf.flags.loadJarClassifier != null) {
            crf.loadJarClassifier(crf.flags.loadJarClassifier, props);
        } else {
            crf.loadDefaultClassifier();
        }
        if (crf.flags.classBias != null) {
            StringTokenizer biases = new StringTokenizer(crf.flags.classBias, ",");
            while (biases.hasMoreTokens()) {
                StringTokenizer bias = new StringTokenizer(biases.nextToken(), ":");
                String cname = bias.nextToken();
                double w = Double.parseDouble(bias.nextToken());
                crf.setBiasWeight(cname, w);
                System.err.println("Setting bias for class " + cname + " to " + w);
            }
        }
        if (testFile != null) {
            if (crf.flags.printFirstOrderProbs) {
                crf.printFirstOrderProbs(testFile);
            } else if (crf.flags.printProbs) {
                crf.printProbs(testFile);
            } else if (crf.flags.useKBest) {
                int k = crf.flags.kBest;
                crf.classifyAndWriteAnswersKBest(testFile, k);
            } else {
                crf.classifyAndWriteAnswers(testFile);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CRFBiasedClassifierOptimizer
    implements Function<Double, Double> {
        CRFBiasedClassifier<IN> crf;
        Function<Double, Double> evalFunction;

        CRFBiasedClassifierOptimizer(CRFBiasedClassifier<IN> c, Function<Double, Double> e) {
            this.crf = c;
            this.evalFunction = e;
        }

        @Override
        public Double apply(Double w) {
            this.crf.setBiasWeight(0, (double)w);
            return this.evalFunction.apply(w);
        }
    }
}

