/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.util.Index;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactorTable {
    private int numClasses;
    private int windowSize;
    private double[] table;

    public FactorTable(int numClasses, int windowSize) {
        this.numClasses = numClasses;
        this.windowSize = windowSize;
        this.table = new double[SloppyMath.intPow(numClasses, windowSize)];
        Arrays.fill(this.table, Double.NEGATIVE_INFINITY);
    }

    public boolean containsNaN() {
        for (int i = 0; i < this.table.length; ++i) {
            if (!Double.isNaN(this.table[i])) continue;
            return true;
        }
        return false;
    }

    public String toProbString() {
        StringBuilder sb = new StringBuilder("{\n");
        for (int i = 0; i < this.table.length; ++i) {
            sb.append(Arrays.toString(this.toArray(i)));
            sb.append(": ");
            sb.append(this.prob(this.toArray(i)));
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public <L> String toString(Index<L> classIndex) {
        StringBuilder sb = new StringBuilder("{\n");
        for (int i = 0; i < this.table.length; ++i) {
            sb.append(FactorTable.toString(this.toArray(i), classIndex));
            sb.append(": ");
            sb.append(this.getValue(i));
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{\n");
        for (int i = 0; i < this.table.length; ++i) {
            sb.append(Arrays.toString(this.toArray(i)));
            sb.append(": ");
            sb.append(this.getValue(i));
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private static <L> String toString(int[] array, Index<L> classIndex) {
        ArrayList<L> l = new ArrayList<L>();
        for (int i = 0; i < array.length; ++i) {
            l.add(classIndex.get(array[i]));
        }
        return ((Object)l).toString();
    }

    private int[] toArray(int index) {
        int[] indices = new int[this.windowSize];
        for (int i = indices.length - 1; i >= 0; --i) {
            indices[i] = index % this.numClasses;
            index /= this.numClasses;
        }
        return indices;
    }

    private int indexOf(int[] entry) {
        int index = 0;
        for (int i = 0; i < entry.length; ++i) {
            index *= this.numClasses;
            index += entry[i];
        }
        if (index < 0) {
            throw new RuntimeException("index=" + index + " entry=" + Arrays.toString(entry));
        }
        return index;
    }

    private int indexOf(int[] front, int end) {
        int index = 0;
        for (int i = 0; i < front.length; ++i) {
            index *= this.numClasses;
            index += front[i];
        }
        index *= this.numClasses;
        return index += end;
    }

    private int indexOf(int front, int[] end) {
        int index = front;
        for (int i = 0; i < end.length; ++i) {
            index *= this.numClasses;
            index += end[i];
        }
        return index;
    }

    private int[] indicesEnd(int[] entries) {
        int i;
        int[] indices = new int[SloppyMath.intPow(this.numClasses, this.windowSize - entries.length)];
        int offset = SloppyMath.intPow(this.numClasses, entries.length);
        int index = 0;
        for (i = 0; i < entries.length; ++i) {
            index *= this.numClasses;
            index += entries[i];
        }
        for (i = 0; i < indices.length; ++i) {
            indices[i] = index;
            index += offset;
        }
        return indices;
    }

    private int[] indicesFront(int[] entries) {
        int i;
        int[] indices = new int[SloppyMath.intPow(this.numClasses, this.windowSize - entries.length)];
        int offset = SloppyMath.intPow(this.numClasses, this.windowSize - entries.length);
        int start = 0;
        for (int i2 = 0; i2 < entries.length; ++i2) {
            start *= this.numClasses;
            start += entries[i2];
        }
        start *= offset;
        int end = 0;
        for (i = 0; i < entries.length; ++i) {
            end *= this.numClasses;
            end += entries[i];
            if (i != entries.length - 1) continue;
            ++end;
        }
        end *= offset;
        for (i = start; i < end; ++i) {
            indices[i - start] = i;
        }
        return indices;
    }

    public int windowSize() {
        return this.windowSize;
    }

    public int numClasses() {
        return this.numClasses;
    }

    private int size() {
        return this.table.length;
    }

    public double totalMass() {
        return ArrayMath.logSum(this.table);
    }

    public double unnormalizedLogProb(int[] label) {
        return this.getValue(label);
    }

    public double logProb(int[] label) {
        return this.unnormalizedLogProb(label) - this.totalMass();
    }

    public double prob(int[] label) {
        return Math.pow(Math.E, this.unnormalizedLogProb(label) - this.totalMass());
    }

    public double conditionalLogProbGivenPrevious(int[] given, int of) {
        if (given.length != this.windowSize - 1) {
            System.err.println("error computing conditional log prob");
            System.exit(0);
        }
        int[] label = this.indicesFront(given);
        double[] masses = new double[label.length];
        for (int i = 0; i < masses.length; ++i) {
            masses[i] = this.table[label[i]];
        }
        double z = ArrayMath.logSum(masses);
        int i = this.indexOf(given, of);
        return this.table[i] - z;
    }

    public double[] conditionalLogProbsGivenPrevious(int[] given) {
        if (given.length != this.windowSize - 1) {
            System.err.println("error computing conditional log prob");
            System.exit(0);
        }
        double[] result = new double[this.numClasses];
        for (int i = 0; i < this.numClasses; ++i) {
            int index = this.indexOf(given, i);
            result[i] = this.table[index];
        }
        ArrayMath.logNormalize(result);
        return result;
    }

    public double conditionalLogProbGivenFirst(int given, int[] of) {
        if (of.length != this.windowSize - 1) {
            System.err.println("error computing conditional log prob");
            System.exit(0);
        }
        int[] labels = new int[this.windowSize];
        labels[0] = given;
        System.arraycopy(of, 0, labels, 1, this.windowSize - 1);
        double probAll = this.unnormalizedLogProb(labels);
        double probGiven = this.unnormalizedLogProbFront(given);
        return probAll - probGiven;
    }

    public double unnormalizedConditionalLogProbGivenFirst(int given, int[] of) {
        if (of.length != this.windowSize - 1) {
            System.err.println("error computing conditional log prob");
            System.exit(0);
        }
        int[] labels = new int[this.windowSize];
        labels[0] = given;
        System.arraycopy(of, 0, labels, 1, this.windowSize - 1);
        double probAll = this.unnormalizedLogProb(labels);
        return probAll;
    }

    public double conditionalLogProbGivenNext(int[] given, int of) {
        if (given.length != this.windowSize - 1) {
            System.err.println("error computing conditional log prob");
            System.exit(0);
        }
        int[] label = this.indicesEnd(given);
        double[] masses = new double[label.length];
        for (int i = 0; i < masses.length; ++i) {
            masses[i] = this.table[label[i]];
        }
        double z = ArrayMath.logSum(masses);
        return this.table[this.indexOf(of, given)] - z;
    }

    public double unnormalizedLogProbFront(int[] labels) {
        labels = this.indicesFront(labels);
        double[] masses = new double[labels.length];
        for (int i = 0; i < masses.length; ++i) {
            masses[i] = this.table[labels[i]];
        }
        return ArrayMath.logSum(masses);
    }

    public double logProbFront(int[] label) {
        return this.unnormalizedLogProbFront(label) - this.totalMass();
    }

    public double unnormalizedLogProbFront(int label) {
        int[] labels = new int[]{label};
        return this.unnormalizedLogProbFront(labels);
    }

    public double logProbFront(int label) {
        return this.unnormalizedLogProbFront(label) - this.totalMass();
    }

    public double unnormalizedLogProbEnd(int[] labels) {
        labels = this.indicesEnd(labels);
        double[] masses = new double[labels.length];
        for (int i = 0; i < masses.length; ++i) {
            masses[i] = this.table[labels[i]];
        }
        return ArrayMath.logSum(masses);
    }

    public double logProbEnd(int[] labels) {
        return this.unnormalizedLogProbEnd(labels) - this.totalMass();
    }

    public double unnormalizedLogProbEnd(int label) {
        int[] labels = new int[]{label};
        return this.unnormalizedLogProbEnd(labels);
    }

    public double logProbEnd(int label) {
        return this.unnormalizedLogProbEnd(label) - this.totalMass();
    }

    private double getValue(int index) {
        return this.table[index];
    }

    public double getValue(int[] label) {
        return this.table[this.indexOf(label)];
    }

    private void setValue(int index, double value) {
        this.table[index] = value;
    }

    public void setValue(int[] label, double value) {
        this.table[this.indexOf((int[])label)] = value;
    }

    public void incrementValue(int[] label, double value) {
        int n = this.indexOf(label);
        this.table[n] = this.table[n] + value;
    }

    private void logIncrementValue(int index, double value) {
        this.table[index] = SloppyMath.logAdd(this.table[index], value);
    }

    public void logIncrementValue(int[] label, double value) {
        int index = this.indexOf(label);
        this.table[index] = SloppyMath.logAdd(this.table[index], value);
    }

    public void multiplyInFront(FactorTable other) {
        int divisor = SloppyMath.intPow(this.numClasses, this.windowSize - other.windowSize());
        for (int i = 0; i < this.table.length; ++i) {
            int n = i;
            this.table[n] = this.table[n] + other.getValue(i / divisor);
        }
    }

    public void multiplyInEnd(FactorTable other) {
        int divisor = SloppyMath.intPow(this.numClasses, other.windowSize());
        for (int i = 0; i < this.table.length; ++i) {
            int n = i;
            this.table[n] = this.table[n] + other.getValue(i % divisor);
        }
    }

    public FactorTable sumOutEnd() {
        FactorTable ft = new FactorTable(this.numClasses, this.windowSize - 1);
        for (int i = 0; i < this.table.length; ++i) {
            ft.logIncrementValue(i / this.numClasses, this.table[i]);
        }
        return ft;
    }

    public FactorTable sumOutFront() {
        FactorTable ft = new FactorTable(this.numClasses, this.windowSize - 1);
        int mod = SloppyMath.intPow(this.numClasses, this.windowSize - 1);
        for (int i = 0; i < this.table.length; ++i) {
            ft.logIncrementValue(i % mod, this.table[i]);
        }
        return ft;
    }

    public void divideBy(FactorTable other) {
        for (int i = 0; i < this.table.length; ++i) {
            if (this.table[i] == Double.NEGATIVE_INFINITY && other.table[i] == Double.NEGATIVE_INFINITY) continue;
            int n = i;
            this.table[n] = this.table[n] - other.table[i];
        }
    }

    public static void main(String[] args) {
        int j;
        int i;
        int[] b;
        FactorTable ft = new FactorTable(6, 3);
        for (int i2 = 0; i2 < 6; ++i2) {
            for (int j2 = 0; j2 < 6; ++j2) {
                for (int k = 0; k < 6; ++k) {
                    b = new int[]{i2, j2, k};
                    ft.setValue(b, (double)(i2 * 4 + j2 * 2 + k));
                }
            }
        }
        FactorTable ft2 = new FactorTable(6, 2);
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 6; ++j) {
                b = new int[]{i, j};
                ft2.setValue(b, (double)(i * 6 + j));
            }
        }
        System.out.println(ft);
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 6; ++j) {
                b = new int[]{i, j};
                double t = 0.0;
                for (int k = 0; k < 6; ++k) {
                    t += Math.pow(Math.E, ft.conditionalLogProbGivenPrevious(b, k));
                    System.err.println(k + "|" + i + "," + j + " : " + Math.pow(Math.E, ft.conditionalLogProbGivenPrevious(b, k)));
                }
                System.out.println(t);
            }
        }
    }
}

