/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.structure;

import edu.stanford.nlp.ie.machinereading.structure.ExtractionObject;
import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.CoreMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMention
extends ExtractionObject {
    private static final long serialVersionUID = -2745903102654191527L;
    private final String mentionType;
    private String corefID = "-1";
    private Span headTokenSpan;
    private int syntacticHeadTokenPosition;
    private String normalizedName;
    private static int MENTION_COUNTER = 0;

    public EntityMention(String objectId, CoreMap sentence, Span extentSpan, Span headSpan, String type, String subtype, String mentionType) {
        super(objectId, sentence, extentSpan, type, subtype);
        this.mentionType = mentionType != null ? mentionType.intern() : null;
        this.headTokenSpan = headSpan;
        this.syntacticHeadTokenPosition = -1;
        this.normalizedName = null;
    }

    public String getCorefID() {
        return this.corefID;
    }

    public void setCorefID(String id) {
        this.corefID = id;
    }

    public String getMentionType() {
        return this.mentionType;
    }

    public Span getHead() {
        return this.headTokenSpan;
    }

    public int getHeadTokenStart() {
        return this.headTokenSpan.start();
    }

    public int getHeadTokenEnd() {
        return this.headTokenSpan.end();
    }

    public void setHeadTokenSpan(Span s) {
        this.headTokenSpan = s;
    }

    public void setHeadTokenPosition(int i) {
        this.syntacticHeadTokenPosition = i;
    }

    public int getSyntacticHeadTokenPosition() {
        return this.syntacticHeadTokenPosition;
    }

    public CoreLabel getSyntacticHeadToken() {
        List tokens = (List)this.sentence.get(CoreAnnotations.TokensAnnotation.class);
        return (CoreLabel)tokens.get(this.syntacticHeadTokenPosition);
    }

    public Tree getSyntacticHeadTree() {
        Tree tree = (Tree)this.sentence.get(CoreAnnotations.TreeAnnotation.class);
        return tree.getLeaves().get(this.syntacticHeadTokenPosition);
    }

    public String getNormalizedName() {
        return this.normalizedName;
    }

    public void setNormalizedName(String n) {
        this.normalizedName = n;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof EntityMention)) {
            return false;
        }
        EntityMention otherEnt = (EntityMention)other;
        return this.equals(otherEnt, true);
    }

    public boolean headIncludes(EntityMention otherEnt, boolean useSubType) {
        return otherEnt.getSyntacticHeadTokenPosition() >= this.getHeadTokenStart() && otherEnt.getSyntacticHeadTokenPosition() < this.getHeadTokenEnd() && (this.type != null && otherEnt.type != null && this.type.equals(otherEnt.type) || this.type == null && otherEnt.type == null) && (!useSubType || this.subType != null && otherEnt.subType != null && this.subType.equals(otherEnt.subType) || this.subType == null && otherEnt.subType == null);
    }

    public boolean equals(EntityMention otherEnt, boolean useSubType) {
        return this.textEquals(otherEnt) && this.labelEquals(otherEnt, useSubType);
    }

    public boolean labelEquals(EntityMention otherEnt, boolean useSubType) {
        return (this.type != null && otherEnt.type != null && this.type.equals(otherEnt.type) || this.type == null && otherEnt.type == null) && (!useSubType || this.subType != null && otherEnt.subType != null && this.subType.equals(otherEnt.subType) || this.subType == null && otherEnt.subType == null);
    }

    public boolean textEquals(EntityMention otherEnt) {
        if (this.syntacticHeadTokenPosition != -1 && otherEnt.syntacticHeadTokenPosition != -1) {
            return this.syntacticHeadTokenPosition == otherEnt.syntacticHeadTokenPosition;
        }
        if (this.headTokenSpan != null && otherEnt.headTokenSpan != null) {
            return this.headTokenSpan.equals(otherEnt.headTokenSpan);
        }
        if (this.extentTokenSpan != null && otherEnt.extentTokenSpan != null) {
            return this.extentTokenSpan.equals(otherEnt.extentTokenSpan);
        }
        return false;
    }

    @Override
    public String getValue() {
        List tokens = (List)this.sentence.get(CoreAnnotations.TokensAnnotation.class);
        StringBuilder sb = new StringBuilder();
        for (int i = this.headTokenSpan.start(); i < this.headTokenSpan.end(); ++i) {
            CoreLabel token = (CoreLabel)tokens.get(i);
            if (i > this.headTokenSpan.start()) {
                sb.append(" ");
            }
            sb.append(token.word());
        }
        return sb.toString();
    }

    public String toString() {
        return "EntityMention [type=" + this.type + (this.subType != null ? ", subType=" + this.subType : "") + (this.mentionType != null ? ", mentionType=" + this.mentionType : "") + (this.objectId != null ? ", objectId=" + this.objectId : "") + (this.headTokenSpan != null ? ", hstart=" + this.headTokenSpan.start() + ", hend=" + this.headTokenSpan.end() : "") + (this.extentTokenSpan != null ? ", estart=" + this.extentTokenSpan.start() + ", eend=" + this.extentTokenSpan.end() : "") + (this.syntacticHeadTokenPosition >= 0 ? ", headPosition=" + this.syntacticHeadTokenPosition : "") + (this.headTokenSpan != null ? ", value=\"" + this.getValue() + "\"" : "") + (this.normalizedName != null ? ", normalizedName=\"" + this.normalizedName + "\"" : "") + ", corefID=" + this.corefID + (this.typeProbabilities != null ? ", probs=" + this.probsToString() : "") + "]";
    }

    public Element toXML(String curNS) {
        Element top = new Element("entity", curNS);
        top.addAttribute(new Attribute("id", this.getObjectId()));
        Element type = new Element("type", curNS);
        type.appendChild(this.getType());
        top.appendChild((Node)type);
        if (this.normalizedName != null) {
            Element nm = new Element("normalized", curNS);
            nm.appendChild(this.normalizedName);
            top.appendChild((Node)nm);
        }
        if (this.getSubType() != null) {
            Element subtype = new Element("subtype", curNS);
            subtype.appendChild(this.getSubType());
            top.appendChild((Node)subtype);
        }
        Element span = new Element("span", curNS);
        span.addAttribute(new Attribute("start", Integer.toString(this.getHeadTokenStart())));
        span.addAttribute(new Attribute("end", Integer.toString(this.getHeadTokenEnd())));
        top.appendChild((Node)span);
        top.appendChild((Node)this.makeProbabilitiesElement(curNS));
        return top;
    }

    public static void sortByHeadSpan(List<EntityMention> mentions) {
        Collections.sort(mentions, new CompByHead());
    }

    public static synchronized String makeUniqueId() {
        return "EntityMention-" + ++MENTION_COUNTER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CompByHead
    implements Comparator<EntityMention> {
        CompByHead() {
        }

        @Override
        public int compare(EntityMention o1, EntityMention o2) {
            if (o1.getHeadTokenStart() < o2.getHeadTokenStart()) {
                return -1;
            }
            if (o1.getHeadTokenStart() > o2.getHeadTokenStart()) {
                return 1;
            }
            if (o1.getHeadTokenEnd() < o2.getHeadTokenEnd()) {
                return -1;
            }
            if (o1.getHeadTokenEnd() > o2.getHeadTokenEnd()) {
                return 1;
            }
            return 0;
        }
    }
}

