/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.regexp;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexNERSequenceClassifier
extends AbstractSequenceClassifier<CoreLabel> {
    private List<Entry> entries;
    private boolean overwriteMyLabels;
    private Set<String> myLabels;
    private boolean ignoreCase;
    private static final Pattern VALID_POS = Pattern.compile("^(NN|JJ)");

    public RegexNERSequenceClassifier(String mapping, boolean ignoreCase, boolean overwriteMyLabels) {
        super(new Properties());
        this.entries = this.readEntries(mapping, ignoreCase);
        this.ignoreCase = ignoreCase;
        this.overwriteMyLabels = overwriteMyLabels;
        this.myLabels = new HashSet<String>();
        if (this.overwriteMyLabels) {
            for (Entry entry : this.entries) {
                this.myLabels.add(entry.type);
            }
        }
        System.err.println("RegexNERSequenceClassifier using labels: " + this.myLabels);
    }

    private static boolean containsValidPos(List<CoreLabel> tokens, int start, int end) {
        for (int i = start; i < end; ++i) {
            Matcher m = VALID_POS.matcher(tokens.get(i).tag());
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<CoreLabel> classify(List<CoreLabel> document) {
        for (Entry entry : this.entries) {
            int start = 0;
            while ((start = RegexNERSequenceClassifier.findStartIndex(entry, document, start, this.myLabels)) != -1) {
                if (!this.ignoreCase || RegexNERSequenceClassifier.containsValidPos(document, start, start + entry.regex.size())) {
                    for (int i = start; i < start + entry.regex.size(); ++i) {
                        CoreLabel token = document.get(i);
                        token.set(CoreAnnotations.AnswerAnnotation.class, entry.type);
                    }
                }
                ++start;
            }
        }
        return document;
    }

    @Override
    public void train(Collection<List<CoreLabel>> docs) {
    }

    @Override
    public void printProbsDocument(List<CoreLabel> document) {
    }

    @Override
    public void serializeClassifier(String serializePath) {
    }

    @Override
    public void loadClassifier(ObjectInputStream in, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
    }

    private List<Entry> readEntries(String mapping, boolean ignoreCase) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        try {
            String line;
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(mapping);
            if (is == null) {
                is = new FileInputStream(mapping);
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            while ((line = rd.readLine()) != null) {
                String[] split = line.split("\t");
                if (split.length < 2 || split.length > 4) {
                    throw new RuntimeException("Provided mapping file is in wrong format");
                }
                String[] regexes = split[0].trim().split("\\s+");
                String type = split[1].trim();
                HashSet<String> overwritableTypes = new HashSet<String>();
                overwritableTypes.add(this.flags.backgroundSymbol);
                overwritableTypes.add(null);
                double priority = 0.0;
                if (split.length >= 3) {
                    overwritableTypes.addAll(Arrays.asList(split[2].trim().split(",")));
                }
                if (split.length == 4) {
                    priority = Double.parseDouble(split[3].trim());
                }
                ArrayList<Pattern> tokens = new ArrayList<Pattern>();
                for (String str : regexes) {
                    if (ignoreCase) {
                        tokens.add(Pattern.compile(str, 2));
                        continue;
                    }
                    tokens.add(Pattern.compile(str));
                }
                entries.add(new Entry(tokens, type, overwritableTypes, priority));
            }
            rd.close();
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Collections.sort(entries);
        return entries;
    }

    private static int findStartIndex(Entry entry, List<CoreLabel> document, int searchStart, Set<String> myLabels) {
        List<Pattern> regex = entry.regex;
        for (int start = searchStart; start <= document.size() - regex.size(); ++start) {
            boolean failed = false;
            for (int i = 0; i < regex.size(); ++i) {
                Pattern pattern = regex.get(i);
                CoreLabel token = document.get(start + i);
                String NERType = (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                String currentType = (String)token.get(CoreAnnotations.AnswerAnnotation.class);
                if (pattern.matcher(token.word()).matches() && currentType == null && (entry.overwritableTypes.contains(NERType) || myLabels.contains(NERType) || NERType.equals("O"))) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            return start;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry
    implements Comparable<Entry> {
        public List<Pattern> regex;
        public String type;
        public Set<String> overwritableTypes;
        public double priority;

        public Entry(List<Pattern> regex, String type, Set<String> overwritableTypes, double priority) {
            this.regex = regex;
            this.type = type.intern();
            this.overwritableTypes = overwritableTypes;
            this.priority = priority;
        }

        @Override
        public int compareTo(Entry other) {
            if (this.priority > other.priority) {
                return -1;
            }
            if (this.priority < other.priority) {
                return 1;
            }
            return other.regex.size() - this.regex.size();
        }
    }
}

