/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.optimization.AbstractStochasticCachingDiffFunction;
import edu.stanford.nlp.optimization.Evaluator;
import edu.stanford.nlp.optimization.Function;
import edu.stanford.nlp.optimization.HasEvaluators;
import edu.stanford.nlp.optimization.Minimizer;
import edu.stanford.nlp.optimization.StochasticCalculateMethods;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Timing;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StochasticMinimizer<T extends Function>
implements Minimizer<T>,
HasEvaluators {
    public boolean outputIterationsToFile = false;
    public int outputFrequency = 1000;
    public static double gain = 0.1;
    protected double[] x;
    protected double[] newX;
    protected double[] grad;
    protected double[] newGrad;
    protected double[] v;
    protected int numBatches;
    protected int k;
    protected static int bSize = 15;
    protected boolean quiet = false;
    protected List<double[]> gradList = null;
    protected int memory = 10;
    protected int numPasses = -1;
    protected Random gen = new Random(1L);
    protected PrintWriter file = null;
    protected PrintWriter infoFile = null;
    protected long maxTime = Long.MAX_VALUE;
    private int evaluateIters = 0;
    private Evaluator[] evaluators;
    private static NumberFormat nf = new DecimalFormat("0.000E0");

    public void shutUp() {
        this.quiet = true;
    }

    protected abstract String getName();

    protected abstract void takeStep(AbstractStochasticCachingDiffFunction var1);

    @Override
    public void setEvaluators(int iters, Evaluator[] evaluators) {
        this.evaluateIters = iters;
        this.evaluators = evaluators;
    }

    protected double gainSchedule(int it, double tau) {
        return tau / (tau + (double)it);
    }

    protected double[] smooth(List<double[]> toSmooth) {
        double[] smoothed = new double[toSmooth.get(0).length];
        for (double[] thisArray : toSmooth) {
            ArrayMath.pairwiseAddInPlace(smoothed, thisArray);
        }
        ArrayMath.multiplyInPlace(smoothed, 1.0 / (double)toSmooth.size());
        return smoothed;
    }

    private void ensureFinite(double[] vect, String name) throws InvalidElementException {
        for (int i = 0; i < vect.length; ++i) {
            if (Double.isNaN(vect[i])) {
                throw new InvalidElementException("NAN found in " + name + " element " + i);
            }
            if (!Double.isInfinite(vect[i])) continue;
            throw new InvalidElementException("Infinity found in " + name + " element " + i);
        }
    }

    private void initFiles() {
        if (this.outputIterationsToFile) {
            String fileName = this.getName() + ".output";
            String infoName = this.getName() + ".info";
            try {
                this.file = new PrintWriter(new FileOutputStream(fileName), true);
                this.infoFile = new PrintWriter(new FileOutputStream(infoName), true);
            }
            catch (IOException e) {
                System.err.println("Caught IOException outputing data to file: " + e.getMessage());
                System.exit(1);
            }
        }
    }

    public abstract Pair<Integer, Double> tune(Function var1, double[] var2, long var3);

    public double tuneDouble(Function function, double[] initial, long msPerTest, PropertySetter<Double> ps, double lower, double upper) {
        return this.tuneDouble(function, initial, msPerTest, ps, lower, upper, 0.001 * Math.abs(upper - lower));
    }

    public double tuneDouble(Function function, double[] initial, long msPerTest, PropertySetter<Double> ps, double lower, double upper, double TOL) {
        double[] xtest = new double[initial.length];
        this.maxTime = msPerTest;
        if (!(function instanceof AbstractStochasticCachingDiffFunction)) {
            throw new UnsupportedOperationException();
        }
        AbstractStochasticCachingDiffFunction dfunction = (AbstractStochasticCachingDiffFunction)function;
        ArrayList<Pair<Double, Double>> res = new ArrayList<Pair<Double, Double>>();
        Pair<Double, Double> best = new Pair<Double, Double>(lower, Double.POSITIVE_INFINITY);
        Pair<Double, Double> low = new Pair<Double, Double>(lower, Double.POSITIVE_INFINITY);
        Pair<Double, Double> high = new Pair<Double, Double>(upper, Double.POSITIVE_INFINITY);
        Pair<Double, Double> cur = new Pair<Double, Double>();
        Pair<Double, Double> tmp = new Pair<Double, Double>();
        ArrayList<Double> queue = new ArrayList<Double>();
        queue.add(lower);
        queue.add(upper);
        int it = 1;
        boolean toContinue = true;
        this.numPasses = 10000;
        do {
            System.arraycopy(initial, 0, xtest, 0, initial.length);
            cur.first = queue.size() != 0 ? queue.remove(0) : Double.valueOf(0.5 * (low.first() + high.first()));
            ps.set((Double)cur.first());
            System.err.println("");
            System.err.println("About to test with batchsize:  " + bSize + "  gain: " + gain + " and  " + ps.toString() + " set to  " + cur.first());
            xtest = this.minimize(function, 1.0E-100, xtest);
            cur.second = Double.isNaN(xtest[0]) ? Double.valueOf(Double.POSITIVE_INFINITY) : Double.valueOf(dfunction.valueAt(xtest));
            if ((Double)cur.second() < best.second()) {
                this.copyPair(best, tmp);
                this.copyPair(cur, best);
                if (tmp.first() > best.first()) {
                    this.copyPair(tmp, high);
                } else {
                    this.copyPair(tmp, low);
                }
                queue.add(0.5 * (cur.first() + high.first()));
            } else if ((Double)cur.first() < best.first()) {
                this.copyPair(cur, low);
            } else if (cur.first() > best.first()) {
                this.copyPair(cur, high);
            }
            if (Math.abs(low.first() - high.first()) < TOL) {
                toContinue = false;
            }
            res.add(new Pair<Double, Double>(cur.first(), cur.second()));
            ++it;
            System.err.println("");
            System.err.println("Final value is: " + nf.format(cur.second()));
            System.err.println("Optimal so far using " + ps.toString() + " is: " + best.first());
        } while (toContinue);
        System.err.println("-------------");
        System.err.println(" RESULTS          ");
        System.err.println(ps.getClass().toString());
        System.err.println("-------------");
        System.err.println("  val    ,    function after " + msPerTest + " ms");
        for (int i = 0; i < res.size(); ++i) {
            System.err.println(((Pair)res.get(i)).first() + "    ,    " + ((Pair)res.get(i)).second());
        }
        System.err.println("");
        System.err.println("");
        return best.first();
    }

    private void copyPair(Pair<Double, Double> from, Pair<Double, Double> to) {
        to.first = (double)from.first();
        to.second = (double)from.second();
    }

    public double tuneGain(Function function, double[] initial, long msPerTest, double lower, double upper) {
        return this.tuneDouble(function, initial, msPerTest, new setGain(this), lower, upper);
    }

    public int tuneBatch(Function function, double[] initial, long msPerTest, int bStart) {
        double[] xtest = new double[initial.length];
        int bOpt = 0;
        double min = Double.POSITIVE_INFINITY;
        this.maxTime = msPerTest;
        double prev = Double.POSITIVE_INFINITY;
        if (!(function instanceof AbstractStochasticCachingDiffFunction)) {
            throw new UnsupportedOperationException();
        }
        AbstractStochasticCachingDiffFunction dfunction = (AbstractStochasticCachingDiffFunction)function;
        int b = bStart;
        boolean it = true;
        boolean toContinue = true;
        do {
            System.arraycopy(initial, 0, xtest, 0, initial.length);
            System.err.println("");
            System.err.println("Testing with batchsize:  " + b);
            bSize = b;
            this.quiet = true;
            this.minimize(function, 1.0E-100, xtest);
            double result = dfunction.valueAt(xtest);
            if (it) {
                b *= 2;
            }
            if (result < min) {
                min = result;
                bOpt = bSize;
                b *= 2;
                prev = result;
            } else if (result < prev) {
                b *= 2;
                prev = result;
            } else if (result > prev) {
                toContinue = false;
            }
            System.err.println("");
            System.err.println("Final value is: " + nf.format(result));
            System.err.println("Optimal so far is:  batchsize: " + bOpt);
        } while (toContinue);
        return bOpt;
    }

    public Pair<Integer, Double> tune(Function function, double[] initial, long msPerTest, List<Integer> batchSizes, List<Double> gains) {
        double[] xtest = new double[initial.length];
        int bOpt = 0;
        double gOpt = 0.0;
        double min = Double.POSITIVE_INFINITY;
        double[][] results = new double[batchSizes.size()][gains.size()];
        this.maxTime = msPerTest;
        for (int b = 0; b < batchSizes.size(); ++b) {
            for (int g = 0; g < gains.size(); ++g) {
                System.arraycopy(initial, 0, xtest, 0, initial.length);
                bSize = batchSizes.get(b);
                gain = gains.get(g);
                System.err.println("");
                System.err.println("Testing with batchsize: " + bSize + "    gain:  " + nf.format(gain));
                this.quiet = true;
                this.minimize(function, 1.0E-100, xtest);
                results[b][g] = function.valueAt(xtest);
                if (results[b][g] < min) {
                    min = results[b][g];
                    bOpt = bSize;
                    gOpt = gain;
                }
                System.err.println("");
                System.err.println("Final value is: " + nf.format(results[b][g]));
                System.err.println("Optimal so far is:  batchsize: " + bOpt + "   gain:  " + nf.format(gOpt));
            }
        }
        return new Pair<Integer, Double>(bOpt, gOpt);
    }

    protected void init(AbstractStochasticCachingDiffFunction func) {
    }

    private void doEvaluation(double[] x) {
        if (this.evaluators == null) {
            return;
        }
        for (Evaluator eval : this.evaluators) {
            this.sayln("  Evaluating: " + eval.toString());
            eval.evaluate(x);
        }
    }

    @Override
    public double[] minimize(Function function, double functionTolerance, double[] initial) {
        return this.minimize(function, functionTolerance, initial, -1);
    }

    @Override
    public double[] minimize(Function function, double functionTolerance, double[] initial, int maxIterations) {
        boolean have_max;
        if (!(function instanceof AbstractStochasticCachingDiffFunction)) {
            throw new UnsupportedOperationException();
        }
        AbstractStochasticCachingDiffFunction dfunction = (AbstractStochasticCachingDiffFunction)function;
        dfunction.method = StochasticCalculateMethods.GradientOnly;
        this.x = initial;
        this.grad = new double[this.x.length];
        this.newX = new double[this.x.length];
        this.gradList = new ArrayList<double[]>();
        this.numBatches = dfunction.dataDimension() / bSize;
        this.outputFrequency = (int)Math.ceil((double)this.numBatches / (double)this.outputFrequency);
        this.init(dfunction);
        this.initFiles();
        boolean bl = have_max = maxIterations > 0 || this.numPasses > 0;
        if (!have_max) {
            throw new UnsupportedOperationException("No maximum number of iterations has been specified.");
        }
        maxIterations = Math.max(maxIterations, this.numPasses) * this.numBatches;
        this.sayln("       Batchsize of: " + bSize);
        this.sayln("       Data dimension of: " + dfunction.dataDimension());
        this.sayln("       Batches per pass through data:  " + this.numBatches);
        this.sayln("       Max iterations is = " + maxIterations);
        if (this.outputIterationsToFile) {
            this.infoFile.println(function.domainDimension() + "; DomainDimension ");
            this.infoFile.println(bSize + "; batchSize ");
            this.infoFile.println(maxIterations + "; maxIterations");
            this.infoFile.println(this.numBatches + "; numBatches ");
            this.infoFile.println(this.outputFrequency + "; outputFrequency");
        }
        Timing total = new Timing();
        Timing current = new Timing();
        total.start();
        current.start();
        boolean doEval = false;
        this.k = 0;
        while (this.k < maxIterations) {
            try {
                boolean bl2 = doEval = this.k > 0 && this.evaluateIters > 0 && this.k % this.evaluateIters == 0;
                if (doEval) {
                    this.doEvaluation(this.x);
                }
                int pass = this.k / this.numBatches;
                int batch = this.k % this.numBatches;
                this.say("Iter: " + this.k + " pass " + pass + " batch " + batch);
                this.newGrad = this.k > 0 && this.gradList.size() >= this.memory ? this.gradList.remove(0) : new double[this.grad.length];
                dfunction.hasNewVals = true;
                System.arraycopy(dfunction.derivativeAt(this.x, this.v, bSize), 0, this.newGrad, 0, this.newGrad.length);
                this.ensureFinite(this.newGrad, "newGrad");
                this.gradList.add(this.newGrad);
                this.grad = this.smooth(this.gradList);
                this.takeStep(dfunction);
                this.ensureFinite(this.newX, "newX");
                if (this.outputIterationsToFile && this.k % this.outputFrequency == 0 && this.k != 0) {
                    double curVal = dfunction.valueAt(this.x);
                    this.say(" TrueValue{ " + curVal + " } ");
                    this.file.println(this.k + " , " + curVal + " , " + total.report());
                }
                if (this.k >= maxIterations) {
                    this.sayln("Stochastic Optimization complete.  Stopped after max iterations");
                    this.x = this.newX;
                    break;
                }
                if (total.report() >= this.maxTime) {
                    this.sayln("Stochastic Optimization complete.  Stopped after max time");
                    this.x = this.newX;
                    break;
                }
                System.arraycopy(this.newX, 0, this.x, 0, this.x.length);
                this.say("[" + (double)total.report() / 1000.0 + " s ");
                this.say("{" + (double)current.restart() / 1000.0 + " s}] ");
                this.say(" " + dfunction.lastValue());
                if (this.quiet) {
                    System.err.print(".");
                } else {
                    this.sayln("");
                }
            }
            catch (InvalidElementException e) {
                System.err.println(e.toString());
                for (int i = 0; i < this.x.length; ++i) {
                    this.x[i] = Double.NaN;
                }
                break;
            }
            ++this.k;
        }
        if (this.evaluateIters > 0) {
            this.doEvaluation(this.x);
        }
        if (this.outputIterationsToFile) {
            this.infoFile.println(this.k + "; Iterations");
            this.infoFile.println((double)total.report() / 1000.0 + "; Completion Time");
            this.infoFile.println(dfunction.valueAt(this.x) + "; Finalvalue");
            this.infoFile.close();
            this.file.close();
            System.err.println("Output Files Closed");
        }
        this.say("Completed in: " + (double)total.report() / 1000.0 + " s");
        return this.x;
    }

    protected void sayln(String s) {
        if (!this.quiet) {
            System.err.println(s);
        }
    }

    protected void say(String s) {
        if (!this.quiet) {
            System.err.print(s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PropertySetter<T1> {
        public void set(T1 var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class setGain
    implements PropertySetter<Double> {
        StochasticMinimizer<T> parent = null;

        public setGain(StochasticMinimizer<T> min) {
            this.parent = min;
        }

        @Override
        public void set(Double in) {
            gain = in;
        }
    }

    public static class InvalidElementException
    extends Throwable {
        private static final long serialVersionUID = 1647150702529757545L;

        public InvalidElementException(String s) {
            super(s);
        }
    }
}

