/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.DeprecatedAnnotations;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Timing;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MorphaAnnotator
implements Annotator {
    private static AtomicLong millisecondsAnnotating = new AtomicLong();
    private boolean VERBOSE = false;
    private static final String[] prep = new String[]{"abroad", "across", "after", "ahead", "along", "aside", "away", "around", "back", "down", "forward", "in", "off", "on", "over", "out", "round", "together", "through", "up"};
    private List<String> particles = Arrays.asList(prep);

    public MorphaAnnotator() {
        this(true);
    }

    public MorphaAnnotator(boolean verbose) {
        this.VERBOSE = verbose;
    }

    @Override
    public void annotate(Annotation annotation) {
        Timing timer = null;
        if (this.VERBOSE) {
            timer = new Timing();
            timer.start();
            System.err.print("Finding lemma...");
        }
        Morphology morpha = new Morphology();
        if (annotation.has(DeprecatedAnnotations.WordsPLAnnotation.class)) {
            List sentences = (List)annotation.get(DeprecatedAnnotations.WordsPLAnnotation.class);
            for (List words : sentences) {
                this.doOneSentence(morpha, words);
            }
        } else if (annotation.has(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                for (int i = 0; i < tokens.size(); ++i) {
                    CoreLabel token = (CoreLabel)tokens.get(i);
                    String text = (String)token.get(CoreAnnotations.TextAnnotation.class);
                    String posTag = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                    this.addLemma(morpha, CoreAnnotations.LemmaAnnotation.class, token, text, posTag);
                }
            }
        } else {
            throw new RuntimeException("unable to find words/tokens in: " + annotation);
        }
        if (this.VERBOSE) {
            millisecondsAnnotating.getAndAdd(timer.stop("done."));
        }
    }

    private void doOneSentence(Morphology morpha, List<? extends CoreLabel> words) {
        for (CoreLabel coreLabel : words) {
            this.addLemma(morpha, CoreAnnotations.LemmaAnnotation.class, coreLabel, coreLabel.word(), coreLabel.tag());
        }
    }

    private void addLemma(Morphology morpha, Class<? extends CoreAnnotation<String>> ann, CoreMap map, String word, String tag) {
        if (tag.length() > 0) {
            String phrasalVerb = this.phrasalVerb(morpha, word, tag);
            if (phrasalVerb == null) {
                map.set(ann, morpha.stem(word, tag).word());
            } else {
                map.set(ann, phrasalVerb);
            }
        } else {
            map.set(ann, morpha.stem(new Word(word)).word());
        }
    }

    private String phrasalVerb(Morphology morpha, String word, String tag) {
        assert (word != null);
        assert (tag != null);
        if (!tag.startsWith("VB") && !word.contains("_")) {
            return null;
        }
        String[] verb = word.split("_");
        if (verb.length != 2) {
            return null;
        }
        String particle = verb[1];
        if (this.particles.contains(particle)) {
            String base = verb[0];
            String lemma = morpha.stem(base, tag).word();
            return lemma + "_" + particle;
        }
        return null;
    }
}

