/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.CyclicCoreLabel;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.DeprecatedAnnotations;
import edu.stanford.nlp.pipeline.ParserAnnotatorUtils;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserAnnotator
implements Annotator {
    private final boolean VERBOSE;
    private final LexicalizedParser parser;
    int maxSentenceLength;
    public static final String[] DEFAULT_FLAGS = new String[]{"-retainTmpSubcategories"};

    public ParserAnnotator() {
        this(true, -1, DEFAULT_FLAGS);
    }

    public ParserAnnotator(boolean verbose, int maxSent) {
        this(verbose, maxSent, DEFAULT_FLAGS);
    }

    public ParserAnnotator(boolean verbose, int maxSent, String[] flags) {
        this(System.getProperty("parser.model", LexicalizedParser.DEFAULT_PARSER_LOC), verbose, maxSent, flags);
    }

    public ParserAnnotator(String parserLoc, boolean verbose, int maxSent, String[] flags) {
        this(ParserAnnotator.loadModel(parserLoc, verbose, flags), verbose, maxSent);
    }

    public ParserAnnotator(LexicalizedParser parser, boolean verbose, int maxSent) {
        this.VERBOSE = verbose;
        this.parser = parser;
        this.maxSentenceLength = maxSent;
    }

    private static LexicalizedParser loadModel(String parserLoc, boolean verbose, String[] flags) {
        if (verbose) {
            System.err.println("Loading Parser Model [" + parserLoc + "] ...");
        }
        LexicalizedParser result = new LexicalizedParser(parserLoc);
        result.setOptionFlags(flags);
        return result;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (annotation.containsKey(DeprecatedAnnotations.WordsPLAnnotation.class)) {
            List sentences = (List)annotation.get(DeprecatedAnnotations.WordsPLAnnotation.class);
            if (this.VERBOSE) {
                System.err.println("Adding Parser annotation...");
                System.err.println("  for: " + sentences);
            }
            ArrayList<Tree> trees = new ArrayList<Tree>();
            for (List words : sentences) {
                trees.add(this.doOneSentence(words));
            }
            annotation.set(DeprecatedAnnotations.ParsePLAnnotation.class, trees);
            if (this.VERBOSE) {
                for (Tree tree : trees) {
                    System.err.println("output:\n" + tree.pennString() + "\n");
                }
            }
        } else if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                Tree tree = null;
                List words = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                if (this.VERBOSE) {
                    System.err.println("Parsing: " + words);
                }
                tree = this.maxSentenceLength <= 0 || words.size() < this.maxSentenceLength ? this.parser.apply(words) : ParserAnnotatorUtils.xTree(words);
                ParserAnnotatorUtils.fillInParseAnnotations(this.VERBOSE, sentence, tree);
            }
        } else {
            throw new RuntimeException("unable to find sentences in: " + annotation);
        }
    }

    private Tree doOneSentence(List<? extends CoreLabel> words) {
        ArrayList<CyclicCoreLabel> newWords = new ArrayList<CyclicCoreLabel>();
        for (CoreLabel coreLabel : words) {
            CyclicCoreLabel ml = new CyclicCoreLabel();
            ml.setWord(coreLabel.word());
            ml.setValue(coreLabel.word());
            newWords.add(ml);
        }
        if (this.maxSentenceLength <= 0 || newWords.size() < this.maxSentenceLength) {
            return this.parser.apply(newWords);
        }
        return ParserAnnotatorUtils.xTree(newWords);
    }
}

