/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.dcoref.CorefChain;
import edu.stanford.nlp.ie.NERClassifierCombiner;
import edu.stanford.nlp.ie.machinereading.structure.EntityMention;
import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ie.machinereading.structure.RelationMention;
import edu.stanford.nlp.io.EncodingFileWriter;
import edu.stanford.nlp.io.FileSequentialCollection;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.CorefCoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.AnnotatorPool;
import edu.stanford.nlp.pipeline.CharniakParserAnnotator;
import edu.stanford.nlp.pipeline.CleanXmlAnnotator;
import edu.stanford.nlp.pipeline.DeterministicCorefAnnotator;
import edu.stanford.nlp.pipeline.GenderAnnotator;
import edu.stanford.nlp.pipeline.MorphaAnnotator;
import edu.stanford.nlp.pipeline.NERCombinerAnnotator;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.PTBTokenizerAnnotator;
import edu.stanford.nlp.pipeline.ParserAnnotator;
import edu.stanford.nlp.pipeline.RegexNERAnnotator;
import edu.stanford.nlp.pipeline.TrueCaseAnnotator;
import edu.stanford.nlp.pipeline.WhitespaceTokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Factory;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ProcessingInstruction;
import nu.xom.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StanfordCoreNLP
extends AnnotationPipeline {
    public static final String STANFORD_TOKENIZE = "tokenize";
    public static final String STANFORD_CLEAN_XML = "cleanxml";
    public static final String STANFORD_SSPLIT = "ssplit";
    public static final String STANFORD_POS = "pos";
    public static final String STANFORD_LEMMA = "lemma";
    public static final String STANFORD_NER = "ner";
    public static final String STANFORD_REGEXNER = "regexner";
    public static final String STANFORD_GENDER = "gender";
    private static final String STANFORD_NFL_TOKENIZE = "nfltokenize";
    public static final String STANFORD_NFL = "nfl";
    public static final String STANFORD_TRUECASE = "truecase";
    public static final String STANFORD_PARSE = "parse";
    public static final String STANFORD_DETERMINISTIC_COREF = "dcoref";
    public static final String CUSTOM_ANNOTATOR_PREFIX = "customAnnotatorClass.";
    private TreePrint constituentTreePrinter;
    private TreePrint dependencyTreePrinter;
    private GrammaticalStructureFactory gsf;
    private int numWords;
    private static AnnotatorPool pool = null;
    private Properties properties;
    private static final String PROPS_SUFFIX = ".properties";
    public static String NEWLINE_SPLITTER_PROPERTY = "ssplit.eolonly";
    private static final String NAMESPACE_URI = null;
    private static final String STYLESHEET_NAME = "CoreNLP-to-HTML.xsl";

    private static void printRequiredProperties(PrintStream os) {
        os.println("The following properties can be defined:");
        os.println("(if -props or -annotators is not passed in, default properties will be loaded via the classpath)");
        os.println("\t\"annotators\" - comma separated list of annotators");
        os.println("\tThe following annotators are supported: cleanxml, tokenize, ssplit, pos, lemma, ner, truecase, parse, coref, dcoref, nfl");
        os.println("\n\tIf annotator \"tokenize\" is defined:");
        os.println("\t\"tokenize.options\" - PTBTokenizer options (see edu.stanford.nlp.process.PTBTokenizer for details)");
        os.println("\t\"tokenize.whitespace\" - If true, just use whitespace tokenization");
        os.println("\n\tIf annotator \"cleanxml\" is defined:");
        os.println("\t\"clean.xmltags\" - regex of tags to extract text from");
        os.println("\t\"clean.sentenceendingtags\" - regex of tags which mark sentence endings");
        os.println("\t\"clean.allowflawedxml\" - if set to false, don't complain about XML errors");
        os.println("\n\tIf annotator \"pos\" is defined:");
        os.println("\t\"pos.model\" - path towards the POS tagger model");
        os.println("\n\tIf annotator \"ner\" is defined:");
        os.println("\t\"ner.model.3class\" - path towards the three-class NER model");
        os.println("\t\"ner.model.7class\" - path towards the seven-class NER model");
        os.println("\t\"ner.model.MISCclass\" - path towards the NER model with a MISC class");
        os.println("\n\tIf annotator \"truecase\" is defined:");
        os.println("\t\"truecase.model\" - path towards the true-casing model; default: edu/stanford/nlp/models/truecase/noUN.ser.gz");
        os.println("\t\"truecase.bias\" - class bias of the true case model; default: INIT_UPPER:-0.7,UPPER:-0.7,O:0");
        os.println("\t\"truecase.mixedcasefile\" - path towards the mixed case file; default: edu/stanford/nlp/models/truecase/MixDisambiguation.list");
        os.println("\n\tIf annotator \"nfl\" is defined:");
        os.println("\t\"nfl.gazetteer\" - path towards the gazetteer for the NFL domain");
        os.println("\t\"nfl.relation.model\" - path towards the NFL relation extraction model");
        os.println("\n\tIf annotator \"parse\" is defined:");
        os.println("\t\"parser.model\" - path towards the PCFG parser model");
        os.println("\nCommand line properties:");
        os.println("\t\"file\" - run the pipeline on the content of this file, or on the content of the files in this directory");
        os.println("\t         XML output is generated for every input file \"file\" as file.xml");
        os.println("\t\"extension\" - if -file used with a directory, process only the files with this extension");
        os.println("\t\"filelist\" - run the pipeline on the list of files given in this file");
        os.println("\t             output is generated for every input file as file.outputExtension");
        os.println("\t\"outputDirectory\" - where to put output (defaults to the current directory)");
        os.println("\t\"outputExtension\" - extension to use for the output file (defaults to \".xml\" for XML, \".ser.gz\" for serialized).  Don't forget the dot!");
        os.println("\t\"outputFormat\" - \"xml\" to output XML (default), \"serialized\" to output serialized Java objects");
        os.println("\t\"replaceExtension\" - flag to chop off the last extension before adding outputExtension to file");
        os.println("\t\"noClobber\" - don't automatically override (clobber) output files that already exist");
        os.println("\nIf none of the above are present, run the pipeline in an interactive shell (default properties will be loaded from the classpath).");
        os.println("The shell accepts input from stdin and displays the output at stdout.");
        os.println();
    }

    private static String getProperty(Properties props, String name) {
        String val = props.getProperty(name);
        if (val == null) {
            System.err.println("Missing property \"" + name + "\"!");
            StanfordCoreNLP.printRequiredProperties(System.err);
            throw new RuntimeException("Missing property: \"" + name + '\"');
        }
        return val;
    }

    private static String getProperty(Properties props, String name, String defaultValue) {
        return props.getProperty(name, defaultValue);
    }

    private static Properties loadPropertiesFromClasspath() {
        List<String> validNames = Arrays.asList("StanfordCoreNLP", "edu.stanford.nlp.pipeline.StanfordCoreNLP");
        for (String name : validNames) {
            Properties props = StanfordCoreNLP.loadProperties(name);
            if (props == null) continue;
            return props;
        }
        throw new RuntimeException("ERROR: Could not find properties file in the classpath!");
    }

    private static Properties loadProperties(String name) {
        return StanfordCoreNLP.loadProperties(name, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String name, ClassLoader loader) {
        if (name.endsWith(PROPS_SUFFIX)) {
            name = name.substring(0, name.length() - PROPS_SUFFIX.length());
        }
        name = name.replace('.', '/');
        name = name + PROPS_SUFFIX;
        Properties result = null;
        System.err.println("Searching for resource: " + name);
        InputStream in = loader.getResourceAsStream(name);
        try {
            if (in != null) {
                result = new Properties();
                result.load(in);
            }
        }
        catch (IOException e) {
            result = null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable ignore) {}
            }
        }
        return result;
    }

    private void construct(AnnotatorPool pool, Properties props, boolean enforceRequirements) {
        this.numWords = 0;
        this.constituentTreePrinter = new TreePrint("penn");
        this.dependencyTreePrinter = new TreePrint("typedDependenciesCollapsed");
        this.gsf = new PennTreebankLanguagePack().grammaticalStructureFactory();
        if (props == null) {
            props = StanfordCoreNLP.loadPropertiesFromClasspath();
        } else if (props.getProperty("annotators") == null) {
            Properties fromClassPath = StanfordCoreNLP.loadPropertiesFromClasspath();
            fromClassPath.putAll((Map<?, ?>)props);
            props = fromClassPath;
        }
        this.properties = props;
        if (pool == null) {
            pool = StanfordCoreNLP.getDefaultAnnotatorPool(props);
        }
        HashMap<String, List<String>> requires = new HashMap<String, List<String>>();
        if (enforceRequirements) {
            requires.put(STANFORD_TOKENIZE, Arrays.asList(new String[0]));
            requires.put(STANFORD_CLEAN_XML, Arrays.asList(STANFORD_TOKENIZE));
            requires.put(STANFORD_SSPLIT, Arrays.asList(STANFORD_TOKENIZE));
            requires.put(STANFORD_POS, Arrays.asList(STANFORD_TOKENIZE, STANFORD_SSPLIT));
            requires.put(STANFORD_LEMMA, Arrays.asList(STANFORD_TOKENIZE, STANFORD_SSPLIT, STANFORD_POS));
            requires.put(STANFORD_NER, Arrays.asList(STANFORD_TOKENIZE, STANFORD_SSPLIT, STANFORD_POS, STANFORD_LEMMA));
            requires.put(STANFORD_REGEXNER, Arrays.asList(STANFORD_TOKENIZE, STANFORD_SSPLIT));
            requires.put(STANFORD_GENDER, Arrays.asList(STANFORD_TOKENIZE, STANFORD_SSPLIT));
            requires.put(STANFORD_TRUECASE, Arrays.asList(STANFORD_TOKENIZE, STANFORD_SSPLIT, STANFORD_POS, STANFORD_LEMMA));
            requires.put(STANFORD_NFL, Arrays.asList(STANFORD_TOKENIZE, STANFORD_SSPLIT, STANFORD_POS, STANFORD_LEMMA, STANFORD_NER, STANFORD_PARSE));
            requires.put(STANFORD_PARSE, Arrays.asList(STANFORD_TOKENIZE, STANFORD_SSPLIT, STANFORD_POS));
            requires.put(STANFORD_DETERMINISTIC_COREF, Arrays.asList(STANFORD_TOKENIZE, STANFORD_SSPLIT, STANFORD_POS, STANFORD_NER, STANFORD_PARSE));
        }
        List<String> annoNames = Arrays.asList(StanfordCoreNLP.getProperty(props, "annotators").split("[, \t]+"));
        HashSet<String> alreadyAddedAnnoNames = new HashSet<String>();
        for (String name : annoNames) {
            System.err.println("Adding annotator " + name);
            if (requires.containsKey(name)) {
                for (String required : (List)requires.get(name)) {
                    if (alreadyAddedAnnoNames.contains(required)) continue;
                    String fmt = "annotator \"%s\" requires annotator \"%s\"";
                    throw new RuntimeException(String.format(fmt, name, required));
                }
            }
            Annotator an = pool.get(name);
            this.addAnnotator(an);
            if (name.equals(STANFORD_TOKENIZE) && annoNames.contains(STANFORD_NFL) && !annoNames.contains(STANFORD_NFL_TOKENIZE)) {
                Annotator pp = pool.get(STANFORD_NFL_TOKENIZE);
                this.addAnnotator(pp);
            }
            alreadyAddedAnnoNames.add(name);
        }
    }

    public StanfordCoreNLP() {
        this((Properties)null);
    }

    public StanfordCoreNLP(Properties props) {
        this(props, true);
    }

    public StanfordCoreNLP(AnnotatorPool pool, Properties props) {
        this(pool, props, true);
    }

    public StanfordCoreNLP(Properties props, boolean enforceRequirements) {
        this(null, props, enforceRequirements);
    }

    public StanfordCoreNLP(AnnotatorPool pool, Properties props, boolean enforceRequirements) {
        this.construct(pool, props, enforceRequirements);
    }

    public StanfordCoreNLP(String propsFileNamePrefix) {
        this(propsFileNamePrefix, true);
    }

    public StanfordCoreNLP(String propsFileNamePrefix, boolean enforceRequirements) {
        Properties props = StanfordCoreNLP.loadProperties(propsFileNamePrefix);
        if (props == null) {
            throw new RuntimeException("ERROR: cannot find properties file \"" + propsFileNamePrefix + "\" in the classpath!");
        }
        this.construct(null, props, enforceRequirements);
    }

    public Properties getProperties() {
        return this.properties;
    }

    private static synchronized AnnotatorPool getDefaultAnnotatorPool(final Properties props) {
        if (pool != null) {
            return pool;
        }
        pool = new AnnotatorPool();
        pool.register(STANFORD_TOKENIZE, new Factory<Annotator>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                if (Boolean.valueOf(props.getProperty("tokenize.whitespace", "false")).booleanValue()) {
                    return new WhitespaceTokenizerAnnotator(props);
                }
                String options = props.getProperty("tokenize.options", "invertible,ptb3Escaping=true");
                return new PTBTokenizerAnnotator(false, options);
            }
        });
        pool.register(STANFORD_CLEAN_XML, new Factory<Annotator>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String xmlTags = props.getProperty("clean.xmltags", ".*");
                String sentenceEndingTags = props.getProperty("clean.sentenceendingtags", "");
                String allowFlawedString = props.getProperty("clean.allowflawedxml");
                boolean allowFlawed = true;
                if (allowFlawedString != null) {
                    allowFlawed = Boolean.valueOf(allowFlawedString);
                }
                return new CleanXmlAnnotator(xmlTags, sentenceEndingTags, allowFlawed);
            }
        });
        pool.register(STANFORD_SSPLIT, new Factory<Annotator>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String isOneSentence;
                String[] toks;
                if (Boolean.valueOf(props.getProperty(NEWLINE_SPLITTER_PROPERTY, "false")).booleanValue()) {
                    WordsToSentencesAnnotator wts = WordsToSentencesAnnotator.newlineSplitter(false);
                    return wts;
                }
                WordsToSentencesAnnotator wts = new WordsToSentencesAnnotator(false);
                String bounds = props.getProperty("ssplit.boundariesToDiscard");
                if (bounds != null) {
                    toks = bounds.split(",");
                    wts.setSentenceBoundaryToDiscard(new HashSet<String>(Arrays.asList(toks)));
                }
                if ((bounds = props.getProperty("ssplit.htmlBoundariesToDiscard")) != null) {
                    toks = bounds.split(",");
                    wts.addHtmlSentenceBoundaryToDiscard(new HashSet<String>(Arrays.asList(toks)));
                }
                if ((isOneSentence = props.getProperty("ssplit.isOneSentence")) != null) {
                    wts.setOneSentence(Boolean.parseBoolean(isOneSentence));
                }
                return wts;
            }
        });
        pool.register(STANFORD_POS, new Factory<Annotator>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                try {
                    String maxLenStr = props.getProperty("pos.maxlen");
                    int maxLen = Integer.MAX_VALUE;
                    if (maxLenStr != null) {
                        maxLen = Integer.parseInt(maxLenStr);
                    }
                    return new POSTaggerAnnotator(StanfordCoreNLP.getProperty(props, "pos.model", "edu/stanford/nlp/models/pos-tagger/wsj3t0-18-left3words/left3words-distsim-wsj-0-18.tagger"), true, maxLen);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        pool.register(STANFORD_LEMMA, new Factory<Annotator>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return new MorphaAnnotator(false);
            }
        });
        pool.register(STANFORD_NER, new Factory<Annotator>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                NERClassifierCombiner nerCombiner;
                ArrayList<String> models = new ArrayList<String>();
                ArrayList<Pair<String, Object>> modelNames = new ArrayList<Pair<String, Object>>();
                modelNames.add(new Pair<String, Object>("ner.model", null));
                modelNames.add(new Pair<String, String>("ner.model.3class", "edu/stanford/nlp/models/ner/all.3class.distsim.crf.ser.gz"));
                modelNames.add(new Pair<String, String>("ner.model.7class", "edu/stanford/nlp/models/ner/muc.distsim.crf.ser.gz"));
                modelNames.add(new Pair<String, String>("ner.model.MISCclass", "edu/stanford/nlp/models/ner/conll.distsim.crf.ser.gz"));
                for (Pair pair : modelNames) {
                    String model = props.getProperty((String)pair.first, (String)pair.second);
                    if (model == null || model.length() <= 0) continue;
                    models.add(model);
                }
                if (models.isEmpty()) {
                    throw new RuntimeException("no NER models specified");
                }
                try {
                    boolean bl = Boolean.parseBoolean(props.getProperty("ner.applyNumericClassifiers", "true"));
                    nerCombiner = new NERClassifierCombiner(bl, models.toArray(new String[models.size()]));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new RuntimeException(fileNotFoundException);
                }
                return new NERCombinerAnnotator(nerCombiner, false);
            }
        });
        pool.register(STANFORD_REGEXNER, new Factory<Annotator>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String mapping = props.getProperty("regexner.mapping", "edu/stanford/nlp/models/regexner/type_map_clean");
                String ignoreCase = props.getProperty("regexner.ignorecase", "false");
                return new RegexNERAnnotator(mapping, Boolean.valueOf(ignoreCase));
            }
        });
        pool.register(STANFORD_GENDER, new Factory<Annotator>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return new GenderAnnotator(false, props.getProperty("gender.firstnames", "edu/stanford/nlp/models/gender/first_name_map_small"));
            }
        });
        pool.register(STANFORD_TRUECASE, new Factory<Annotator>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String model = props.getProperty("truecase.model", "edu/stanford/nlp/models/truecase/noUN.ser.gz");
                String bias = props.getProperty("truecase.bias", "INIT_UPPER:-0.7,UPPER:-0.7,O:0");
                String mixed = props.getProperty("truecase.mixedcasefile", "edu/stanford/nlp/models/truecase/MixDisambiguation.list");
                return new TrueCaseAnnotator(model, bias, mixed, false);
            }
        });
        pool.register(STANFORD_NFL_TOKENIZE, new Factory<Annotator>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String className = "edu.stanford.nlp.pipeline.NFLTokenizerAnnotator";
                return (Annotator)ReflectionLoading.loadByReflection("edu.stanford.nlp.pipeline.NFLTokenizerAnnotator", new Object[0]);
            }
        });
        pool.register(STANFORD_NFL, new Factory<Annotator>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String className = "edu.stanford.nlp.pipeline.NFLAnnotator";
                return (Annotator)ReflectionLoading.loadByReflection("edu.stanford.nlp.pipeline.NFLAnnotator", props);
            }
        });
        pool.register(STANFORD_PARSE, new Factory<Annotator>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String parserType = props.getProperty("parser.type", "stanford");
                String maxLenStr = props.getProperty("parser.maxlen");
                if (parserType.equalsIgnoreCase("stanford")) {
                    int maxLen = -1;
                    if (maxLenStr != null) {
                        maxLen = Integer.parseInt(maxLenStr);
                    }
                    String parserPath = props.getProperty("parser.model", "edu/stanford/nlp/models/lexparser/englishPCFG.ser.gz");
                    boolean parserDebug = PropertiesUtils.hasProperty(props, "parser.debug");
                    String parserFlags = props.getProperty("parser.flags");
                    String[] parserFlagList = parserFlags == null ? ParserAnnotator.DEFAULT_FLAGS : (parserFlags.trim().equals("") ? new String[]{} : parserFlags.trim().split("\\s+"));
                    ParserAnnotator anno = new ParserAnnotator(parserPath, parserDebug, maxLen, parserFlagList);
                    return anno;
                }
                if (parserType.equalsIgnoreCase("charniak")) {
                    String model = props.getProperty("parser.model");
                    String parserExecutable = props.getProperty("parser.executable");
                    if (model == null || parserExecutable == null) {
                        throw new RuntimeException("Both parser.model and parser.executable properties must be specified if parser.type=charniak");
                    }
                    int maxLen = 399;
                    if (maxLenStr != null) {
                        maxLen = Integer.parseInt(maxLenStr);
                    }
                    CharniakParserAnnotator anno = new CharniakParserAnnotator(model, parserExecutable, false, maxLen);
                    return anno;
                }
                throw new RuntimeException("Unknown parser type: " + parserType + " (currently supported: stanford and charniak)");
            }
        });
        pool.register(STANFORD_DETERMINISTIC_COREF, new Factory<Annotator>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return new DeterministicCorefAnnotator(props);
            }
        });
        for (Object propertyKey : props.keySet()) {
            String property;
            if (!(propertyKey instanceof String) || !(property = (String)propertyKey).startsWith(CUSTOM_ANNOTATOR_PREFIX)) continue;
            final String customName = property.substring(CUSTOM_ANNOTATOR_PREFIX.length());
            final String customClassName = props.getProperty(property);
            System.err.println("Registering annotator " + customName + " with class " + customClassName);
            pool.register(customName, new Factory<Annotator>(){
                private static final long serialVersionUID = 1L;
                private final String name;
                private final String className;
                private final Properties properties;
                {
                    this.name = customName;
                    this.className = customClassName;
                    this.properties = props;
                }

                @Override
                public Annotator create() {
                    return (Annotator)ReflectionLoading.loadByReflection(this.className, this.name, this.properties);
                }
            });
        }
        return pool;
    }

    public static synchronized Annotator getExistingAnnotator(String name) {
        if (pool == null) {
            System.err.println("ERROR: attempted to fetch annotator \"" + name + "\" before the annotator pool was created!");
            return null;
        }
        try {
            Annotator a = pool.get(name);
            return a;
        }
        catch (IllegalArgumentException e) {
            System.err.println("ERROR: attempted to fetch annotator \"" + name + "\" but the annotator pool does not store any such type!");
            return null;
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        super.annotate(annotation);
        List words = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        if (words != null) {
            this.numWords += words.size();
        }
    }

    @Override
    public String timingInformation() {
        StringBuilder sb = new StringBuilder(super.timingInformation());
        if (this.numWords >= 0) {
            long total = this.getTotalTime();
            sb.append(" for ").append(this.numWords).append(" tokens at ");
            sb.append(String.format("%.1f", (double)this.numWords / ((double)total / 1000.0)));
            sb.append(" tokens/sec.");
        }
        return sb.toString();
    }

    public Annotation process(String text) {
        Annotation annotation = new Annotation(text);
        this.annotate(annotation);
        return annotation;
    }

    public void prettyPrint(Annotation annotation, PrintWriter os) {
        List graph;
        String beamAsString = this.properties.getProperty("printable.relation.beam");
        double beam = 0.0;
        if (beamAsString != null) {
            beam = Double.parseDouble(beamAsString);
        }
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        String docId = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
        if (docId != null) {
            List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
            int nSentences = sentences != null ? sentences.size() : 0;
            int nTokens = tokens != null ? tokens.size() : 0;
            os.printf("Document: ID=%s (%d sentences, %d tokens)\n", docId, nSentences, nTokens);
        }
        if (sentences != null) {
            int sz = sentences.size();
            for (int i = 0; i < sz; ++i) {
                List relations;
                List entities;
                CoreMap sentence = (CoreMap)sentences.get(i);
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                os.printf("Sentence #%d (%d tokens):\n", i + 1, tokens.size());
                String text = (String)sentence.get(CoreAnnotations.TextAnnotation.class);
                os.println(text);
                String[] tokenAnnotations = new String[]{"Text", "PartOfSpeech", "Lemma", "Answer", "NamedEntityTag", "CharacterOffsetBegin", "CharacterOffsetEnd", "NormalizedNamedEntityTag", "TrueCase", "TrueCaseText"};
                for (CoreLabel token : tokens) {
                    os.print(token.toShorterString(tokenAnnotations));
                    os.print(' ');
                }
                os.println();
                Tree tree = (Tree)sentence.get(CoreAnnotations.TreeAnnotation.class);
                if (tree != null) {
                    this.constituentTreePrinter.printTree(tree, os);
                    this.dependencyTreePrinter.printTree(tree, os);
                }
                if ((entities = (List)sentence.get(MachineReadingAnnotations.EntityMentionsAnnotation.class)) != null) {
                    System.err.println("Extracted the following MachineReading entity mentions:");
                    for (EntityMention e : entities) {
                        System.err.println("\t" + e);
                    }
                }
                if ((relations = (List)sentence.get(MachineReadingAnnotations.RelationMentionsAnnotation.class)) == null) continue;
                System.err.println("Extracted the following MachineReading relation mentions:");
                for (RelationMention r : relations) {
                    if (!r.printableObject(beam)) continue;
                    System.err.println(r);
                }
            }
        }
        if ((graph = (List)annotation.get(CorefCoreAnnotations.CorefGraphAnnotation.class)) != null && sentences != null) {
            ArrayList<List> sents = new ArrayList<List>();
            for (CoreMap sentence : sentences) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                sents.add(tokens);
            }
            os.println("Coreference links:");
            for (Pair link : graph) {
                IntTuple src = (IntTuple)link.first;
                IntTuple dst = (IntTuple)link.second;
                os.println("\t" + src + " -> " + dst + ", that is: \"" + (String)((CoreLabel)((List)sents.get(src.get(0) - 1)).get(src.get(1) - 1)).get(CoreAnnotations.TextAnnotation.class) + "\" -> \"" + (String)((CoreLabel)((List)sents.get(dst.get(0) - 1)).get(dst.get(1) - 1)).get(CoreAnnotations.TextAnnotation.class) + "\"");
            }
        }
        os.flush();
    }

    public void xmlPrint(Annotation annotation, Writer w) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.xmlPrint(annotation, os);
        w.write(new String(os.toByteArray(), "UTF-8"));
        w.flush();
    }

    public void xmlPrint(Annotation annotation, OutputStream os) throws IOException {
        Document xmlDoc = this.annotationToDoc(annotation);
        Serializer ser = new Serializer(os, "UTF-8");
        ser.setIndent(2);
        ser.setMaxLength(0);
        ser.write(xmlDoc);
        ser.flush();
    }

    public Document annotationToDoc(Annotation annotation) {
        Element corefInfo;
        Map corefChains;
        Element root = new Element("root", NAMESPACE_URI);
        Document xmlDoc = new Document(root);
        ProcessingInstruction pi = new ProcessingInstruction("xml-stylesheet", "href=\"CoreNLP-to-HTML.xsl\" type=\"text/xsl\"");
        xmlDoc.insertChild((Node)pi, 0);
        Element docElem = new Element("document", NAMESPACE_URI);
        root.appendChild((Node)docElem);
        String docId = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
        if (docId != null) {
            docElem.appendChild((Node)new Element("docId", docId));
        }
        Element sentencesElem = new Element("sentences", NAMESPACE_URI);
        docElem.appendChild((Node)sentencesElem);
        if (annotation.get(CoreAnnotations.SentencesAnnotation.class) != null) {
            int sentCount = 1;
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                Element sentElem = new Element("sentence", NAMESPACE_URI);
                sentElem.addAttribute(new Attribute("id", Integer.toString(sentCount)));
                ++sentCount;
                Element wordTable = new Element("tokens", NAMESPACE_URI);
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                for (int j = 0; j < tokens.size(); ++j) {
                    Element wordInfo = new Element("token", NAMESPACE_URI);
                    StanfordCoreNLP.addWordInfo(wordInfo, (CoreMap)tokens.get(j), j + 1, NAMESPACE_URI);
                    wordTable.appendChild((Node)wordInfo);
                }
                sentElem.appendChild((Node)wordTable);
                Tree tree = (Tree)sentence.get(CoreAnnotations.TreeAnnotation.class);
                if (tree != null) {
                    Element parseInfo = new Element(STANFORD_PARSE, NAMESPACE_URI);
                    this.addConstituentTreeInfo(parseInfo, tree);
                    sentElem.appendChild((Node)parseInfo);
                    Element depInfo = new Element("basic-dependencies", NAMESPACE_URI);
                    StanfordCoreNLP.addDependencyTreeInfo(depInfo, (SemanticGraph)((Object)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class)), tokens, NAMESPACE_URI);
                    sentElem.appendChild((Node)depInfo);
                    depInfo = new Element("collapsed-dependencies", NAMESPACE_URI);
                    StanfordCoreNLP.addDependencyTreeInfo(depInfo, (SemanticGraph)((Object)sentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class)), tokens, NAMESPACE_URI);
                    sentElem.appendChild((Node)depInfo);
                    depInfo = new Element("collapsed-ccprocessed-dependencies", NAMESPACE_URI);
                    StanfordCoreNLP.addDependencyTreeInfo(depInfo, (SemanticGraph)((Object)sentence.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class)), tokens, NAMESPACE_URI);
                    sentElem.appendChild((Node)depInfo);
                }
                List entities = (List)sentence.get(MachineReadingAnnotations.EntityMentionsAnnotation.class);
                List relations = (List)sentence.get(MachineReadingAnnotations.RelationMentionsAnnotation.class);
                if (entities != null && entities.size() > 0) {
                    Element mrElem = new Element("MachineReading", NAMESPACE_URI);
                    Element entElem = new Element("entities", NAMESPACE_URI);
                    StanfordCoreNLP.addEntities(entities, entElem, NAMESPACE_URI);
                    mrElem.appendChild((Node)entElem);
                    if (relations != null) {
                        Element relElem = new Element("relations", NAMESPACE_URI);
                        StanfordCoreNLP.addRelations(relations, relElem, NAMESPACE_URI, this.properties.getProperty("printable.relation.beam"));
                        mrElem.appendChild((Node)relElem);
                    }
                    sentElem.appendChild((Node)mrElem);
                }
                sentencesElem.appendChild((Node)sentElem);
            }
        }
        if ((corefChains = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class)) != null && StanfordCoreNLP.addCorefGraphInfo(corefInfo = new Element("coreference", NAMESPACE_URI), corefChains, NAMESPACE_URI)) {
            docElem.appendChild((Node)corefInfo);
        }
        return xmlDoc;
    }

    private void addConstituentTreeInfo(Element treeInfo, Tree tree) {
        StringWriter treeStrWriter = new StringWriter();
        this.constituentTreePrinter.printTree(tree, new PrintWriter((Writer)treeStrWriter, true));
        String temp = treeStrWriter.toString();
        treeInfo.appendChild(temp);
    }

    private static void addDependencyTreeInfo(Element depInfo, SemanticGraph graph, List<CoreLabel> tokens, String curNS) {
        if (graph != null) {
            for (SemanticGraphEdge edge : graph.edgeList()) {
                String rel = edge.getRelation().toString();
                rel = rel.replaceAll("\\s+", "");
                int source = ((IndexedWord)edge.getSource()).index();
                int target = ((IndexedWord)edge.getTarget()).index();
                Element depElem = new Element("dep", curNS);
                depElem.addAttribute(new Attribute("type", rel));
                Element govElem = new Element("governor", curNS);
                govElem.addAttribute(new Attribute("idx", Integer.toString(source)));
                govElem.appendChild(tokens.get(source - 1).word());
                depElem.appendChild((Node)govElem);
                Element dependElem = new Element("dependent", curNS);
                dependElem.addAttribute(new Attribute("idx", Integer.toString(target)));
                dependElem.appendChild(tokens.get(target - 1).word());
                depElem.appendChild((Node)dependElem);
                depInfo.appendChild((Node)depElem);
            }
        }
    }

    private void addDependencyTreeInfo(Element depInfo, Tree tree, String curNS) {
        if (tree != null) {
            GrammaticalStructure gs = this.gsf.newGrammaticalStructure(tree);
            Collection<TypedDependency> deps = gs.typedDependencies();
            for (TypedDependency dep : deps) {
                Element depElem = new Element("dep", curNS);
                depElem.addAttribute(new Attribute("type", dep.reln().getShortName()));
                Element govElem = new Element("governor", curNS);
                govElem.addAttribute(new Attribute("idx", Integer.toString(dep.gov().index())));
                govElem.appendChild(dep.gov().value());
                depElem.appendChild((Node)govElem);
                Element dependElem = new Element("dependent", curNS);
                dependElem.addAttribute(new Attribute("idx", Integer.toString(dep.dep().index())));
                dependElem.appendChild(dep.dep().value());
                depElem.appendChild((Node)dependElem);
                depInfo.appendChild((Node)depElem);
            }
        }
    }

    private static void addEntities(List<EntityMention> entities, Element top, String curNS) {
        for (EntityMention e : entities) {
            Element ee = e.toXML(curNS);
            top.appendChild((Node)ee);
        }
    }

    private static void addRelations(List<RelationMention> relations, Element top, String curNS, String beamAsString) {
        double beam = 0.0;
        if (beamAsString != null) {
            beam = Double.parseDouble(beamAsString);
        }
        for (RelationMention r : relations) {
            if (!r.printableObject(beam)) continue;
            Element re = r.toXML(curNS);
            top.appendChild((Node)re);
        }
    }

    private static boolean addCorefGraphInfo(Element corefInfo, Map<Integer, CorefChain> corefChains, String curNS) {
        boolean foundCoref = false;
        for (CorefChain chain : corefChains.values()) {
            if (chain.getCorefMentions().size() <= 1) continue;
            foundCoref = true;
            Element chainElem = new Element("coreference", curNS);
            CorefChain.CorefMention source = chain.getRepresentativeMention();
            StanfordCoreNLP.addCorefMention(chainElem, curNS, source, true);
            for (CorefChain.CorefMention mention : chain.getCorefMentions()) {
                if (mention == source) continue;
                StanfordCoreNLP.addCorefMention(chainElem, curNS, mention, false);
            }
            corefInfo.appendChild((Node)chainElem);
        }
        return foundCoref;
    }

    private static void addCorefMention(Element chainElem, String curNS, CorefChain.CorefMention mention, boolean representative) {
        Element mentionElem = new Element("mention", curNS);
        if (representative) {
            mentionElem.addAttribute(new Attribute("representative", "true"));
        }
        StanfordCoreNLP.setSingleElement(mentionElem, "sentence", curNS, Integer.toString(mention.sentNum));
        StanfordCoreNLP.setSingleElement(mentionElem, "start", curNS, Integer.toString(mention.startIndex));
        StanfordCoreNLP.setSingleElement(mentionElem, "end", curNS, Integer.toString(mention.endIndex));
        StanfordCoreNLP.setSingleElement(mentionElem, "head", curNS, Integer.toString(mention.headIndex));
        chainElem.appendChild((Node)mentionElem);
    }

    private static void addWordInfo(Element wordInfo, CoreMap token, int id, String curNS) {
        Element cur;
        wordInfo.addAttribute(new Attribute("id", Integer.toString(id)));
        StanfordCoreNLP.setSingleElement(wordInfo, "word", curNS, (String)token.get(CoreAnnotations.TextAnnotation.class));
        StanfordCoreNLP.setSingleElement(wordInfo, STANFORD_LEMMA, curNS, (String)token.get(CoreAnnotations.LemmaAnnotation.class));
        if (token.containsKey(CoreAnnotations.CharacterOffsetBeginAnnotation.class) && token.containsKey(CoreAnnotations.CharacterOffsetEndAnnotation.class)) {
            StanfordCoreNLP.setSingleElement(wordInfo, "CharacterOffsetBegin", curNS, Integer.toString((Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)));
            StanfordCoreNLP.setSingleElement(wordInfo, "CharacterOffsetEnd", curNS, Integer.toString((Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)));
        }
        if (token.containsKey(CoreAnnotations.PartOfSpeechAnnotation.class)) {
            StanfordCoreNLP.setSingleElement(wordInfo, "POS", curNS, (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class));
        }
        if (token.containsKey(CoreAnnotations.NamedEntityTagAnnotation.class)) {
            StanfordCoreNLP.setSingleElement(wordInfo, "NER", curNS, (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class));
        }
        if (token.containsKey(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class)) {
            StanfordCoreNLP.setSingleElement(wordInfo, "NormalizedNER", curNS, (String)token.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class));
        }
        if (token.containsKey(CoreAnnotations.TrueCaseAnnotation.class)) {
            cur = new Element("TrueCase", curNS);
            cur.appendChild((String)token.get(CoreAnnotations.TrueCaseAnnotation.class));
            wordInfo.appendChild((Node)cur);
        }
        if (token.containsKey(CoreAnnotations.TrueCaseTextAnnotation.class)) {
            cur = new Element("TrueCaseText", curNS);
            cur.appendChild((String)token.get(CoreAnnotations.TrueCaseTextAnnotation.class));
            wordInfo.appendChild((Node)cur);
        }
    }

    private static void setSingleElement(Element tokenElement, String elemName, String curNS, String value) {
        Element cur = new Element(elemName, curNS);
        if (value != null) {
            cur.appendChild(value);
            tokenElement.appendChild((Node)cur);
        }
    }

    private static void shell(StanfordCoreNLP pipeline) throws IOException {
        BufferedReader is = new BufferedReader(new InputStreamReader(System.in));
        PrintWriter os = new PrintWriter(System.out);
        System.out.println("Entering interactive shell. Type q to quit.");
        while (true) {
            System.out.print("NLP> ");
            String line = is.readLine();
            if (line == null || line.length() <= 0) continue;
            if (line.equalsIgnoreCase("q")) break;
            Annotation anno = pipeline.process(line);
            pipeline.prettyPrint(anno, os);
        }
    }

    private static Collection<File> readFileList(String fileName) throws IOException {
        return ObjectBank.getLineIterator(fileName, new ObjectBank.PathToFileFunction());
    }

    private static void processFiles(StanfordCoreNLP pipeline, Collection<File> files, Properties props) throws IOException {
        for (File file : files) {
            String outputFormat;
            String defaultExtension;
            String extension;
            int lastDot;
            String outputFilename = new File(props.getProperty("outputDirectory", "."), file.getName()).getPath();
            if (props.getProperty("replaceExtension") != null && (lastDot = outputFilename.lastIndexOf(46)) > 0) {
                outputFilename = outputFilename.substring(0, lastDot);
            }
            if (!outputFilename.endsWith(extension = props.getProperty("outputExtension", defaultExtension = (outputFormat = props.getProperty("outputFormat", "xml")).equalsIgnoreCase("xml") ? ".xml" : ".ser.gz"))) {
                outputFilename = outputFilename + extension;
            }
            if ((outputFilename = new File(outputFilename).getCanonicalPath()).equals(file.getCanonicalPath())) {
                System.out.println("Skipping " + file.getName() + ": output file " + outputFilename + " has the same filename as the input file -- assuming you don't actually want to do this.");
                continue;
            }
            if (props.getProperty("noClobber") != null && new File(outputFilename).exists()) {
                System.out.println("Skipping " + file.getName() + ": output file " + outputFilename + " as it already exists.  Don't use the noClobber option to override this.");
                continue;
            }
            String encoding = props.getProperty("encoding");
            System.err.println("Processing file " + file.getAbsolutePath() + " ... (writing to " + outputFilename + ")");
            String text = IOUtils.slurpFile(file, encoding);
            Annotation annotation = pipeline.process(text);
            if (outputFormat.equalsIgnoreCase("xml")) {
                Writer writer = EncodingFileWriter.getWriter(outputFilename, encoding);
                pipeline.xmlPrint(annotation, writer);
                writer.close();
                continue;
            }
            IOUtils.writeObjectToFile((Object)annotation, outputFilename);
        }
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Timing tim = new Timing();
        Properties props = null;
        if (args.length > 0 && ((props = StringUtils.argsToProperties(args)).containsKey("h") || props.containsKey("help"))) {
            StanfordCoreNLP.printRequiredProperties(System.err);
            return;
        }
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        props = pipeline.getProperties();
        long setupTime = tim.report();
        System.err.println();
        if (props.containsKey("file")) {
            String fileName = props.getProperty("file");
            FileSequentialCollection files = new FileSequentialCollection(new File(fileName), props.getProperty("extension"), true);
            StanfordCoreNLP.processFiles(pipeline, files, props);
        } else if (props.containsKey("filelist")) {
            String fileName = props.getProperty("filelist");
            Collection<File> files = StanfordCoreNLP.readFileList(fileName);
            StanfordCoreNLP.processFiles(pipeline, files, props);
        } else {
            StanfordCoreNLP.shell(pipeline);
        }
        System.err.println();
        System.err.println(pipeline.timingInformation());
        System.err.println("Pipeline setup: " + Timing.toSecondsString(setupTime) + " sec.");
        System.err.println("Total time for StanfordCoreNLP pipeline: " + tim.toSecondsString() + " sec.");
    }
}

