/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import java.io.Reader;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhitespaceTokenizerAnnotator
extends TokenizerAnnotator {
    private final TokenizerFactory<CoreLabel> factory;
    final String EOL_PROPERTY = "tokenize.keepeol";

    public WhitespaceTokenizerAnnotator(Properties props) {
        super(false);
        boolean eolIsSignificant = Boolean.valueOf(props.getProperty("tokenize.keepeol", "false"));
        eolIsSignificant = eolIsSignificant || Boolean.valueOf(props.getProperty(StanfordCoreNLP.NEWLINE_SPLITTER_PROPERTY, "false")) != false;
        this.factory = new WhitespaceTokenizer.WhitespaceTokenizerFactory<CoreLabel>(new CoreLabelTokenFactory(), eolIsSignificant);
    }

    @Override
    Tokenizer<CoreLabel> getTokenizer(Reader r) {
        return this.factory.getTokenizer(r);
    }
}

