/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.CTBunkDict;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.RareExtractor;
import edu.stanford.nlp.tagger.maxent.TestSentence;

class CTBunkDictDetector
extends RareExtractor {
    private String t1;
    private int n1;
    private static final long serialVersionUID = 80L;

    CTBunkDictDetector(String t2, int n2) {
        this.t1 = t2;
        this.n1 = n2;
    }

    String extract(History h, PairsHolder pH) {
        String s = TestSentence.toNice(pH.getWord(h, this.n1));
        if (CTBunkDict.getTag(this.t1, s).equals("1")) {
            return "1:" + this.t1;
        }
        return "0:" + this.t1;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isDynamic() {
        return false;
    }
}

