/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.RareExtractor;

class ExtractorCapDistLC
extends RareExtractor {
    boolean verbose = false;
    private static final long serialVersionUID = 34L;

    String extract(History h, PairsHolder pH) {
        String word = pH.getWord(h, 0);
        if (!ExtractorCapDistLC.startsUpperCase(word)) {
            if (this.verbose) {
                System.out.println("did not apply because not start with upper case");
            }
            return "0";
        }
        String ret = ExtractorCapDistLC.allUpperCase(word) ? "all:" : "start";
        int current = -1;
        int distance = 1;
        while (true) {
            String prevWord;
            if (ExtractorCapDistLC.startsLowerCase(prevWord = pH.getWord(h, current))) {
                if (this.verbose) {
                    System.out.println("returning " + ret + current + "for " + word + ' ' + prevWord);
                }
                return ret + distance;
            }
            if (prevWord.equals("NA") || prevWord.equals("``")) {
                if (this.verbose) {
                    System.out.println("returning " + ret + "infinity for " + word + ' ' + prevWord);
                }
                return ret + "infinity";
            }
            --current;
            ++distance;
        }
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean isLocal() {
        return false;
    }
}

