/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.io.PrintFile;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.maxent.CGRunner;
import edu.stanford.nlp.maxent.Problem;
import edu.stanford.nlp.maxent.iis.LambdaSolve;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.objectbank.ReaderIteratorFactory;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.process.ListProcessor;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.TransformXML;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.sequences.PlainTextDocumentReaderAndWriter;
import edu.stanford.nlp.tagger.maxent.AmbiguityClasses;
import edu.stanford.nlp.tagger.maxent.Dictionary;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.ExtractorFramesRare;
import edu.stanford.nlp.tagger.maxent.Extractors;
import edu.stanford.nlp.tagger.maxent.FeatureKey;
import edu.stanford.nlp.tagger.maxent.LambdaSolveTagger;
import edu.stanford.nlp.tagger.maxent.TTags;
import edu.stanford.nlp.tagger.maxent.TaggerConfig;
import edu.stanford.nlp.tagger.maxent.TaggerExperiments;
import edu.stanford.nlp.tagger.maxent.TaggerFeatures;
import edu.stanford.nlp.tagger.maxent.TestClassifier;
import edu.stanford.nlp.tagger.maxent.TestSentence;
import edu.stanford.nlp.util.DataFilePaths;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.XMLUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxentTagger
implements Function<List<? extends HasWord>, ArrayList<TaggedWord>>,
ListProcessor<List<? extends HasWord>, ArrayList<TaggedWord>> {
    public static final String BASE_TAGGER_HOME = "$NLP_DATA_HOME/data/pos-tagger/wsj3t0-18-left3words";
    public static final String TAGGER_HOME = DataFilePaths.convert("$NLP_DATA_HOME/data/pos-tagger/wsj3t0-18-left3words");
    public static final String DEFAULT_NLP_GROUP_MODEL_PATH = new File(TAGGER_HOME, "left3words-wsj-0-18.tagger").getPath();
    public static final String DEFAULT_DISTRIBUTION_PATH = "models/left3words-wsj-0-18.tagger";
    final Dictionary dict = new Dictionary();
    TTags tags;
    byte[][] fnumArr;
    LambdaSolveTagger prob;
    HashMap<FeatureKey, Integer> fAssociations = new HashMap();
    Extractors extractors;
    Extractors extractorsRare;
    AmbiguityClasses ambClasses;
    final boolean alltags = false;
    final HashMap<String, HashSet<String>> tagTokens = new HashMap();
    static final int RARE_WORD_THRESH = 5;
    static final int MIN_FEATURE_THRESH = 5;
    static final int CUR_WORD_MIN_FEATURE_THRESH = 2;
    static final int RARE_WORD_MIN_FEATURE_THRESH = 10;
    static final int VERY_COMMON_WORD_THRESH = 250;
    static final boolean OCCURRING_TAGS_ONLY = false;
    static final boolean POSSIBLE_TAGS_ONLY = false;
    double defaultScore;
    int leftContext;
    int rightContext;
    TaggerConfig config;
    private int rareWordThresh = 5;
    int minFeatureThresh = 5;
    int curWordMinFeatureThresh = 2;
    int rareWordMinFeatureThresh = 10;
    int veryCommonWordThresh = 250;
    int xSize;
    int ySize;
    boolean occuringTagsOnly = false;
    boolean possibleTagsOnly = false;
    private boolean initted = false;
    static final boolean VERBOSE = false;

    public MaxentTagger() {
    }

    public MaxentTagger(String modelFile) throws IOException, ClassNotFoundException {
        this(modelFile, new TaggerConfig("-model", modelFile), true);
    }

    public MaxentTagger(String modelFile, TaggerConfig config) throws IOException, ClassNotFoundException {
        this(modelFile, config, true);
    }

    public MaxentTagger(String modelFile, TaggerConfig config, boolean printLoading) throws IOException, ClassNotFoundException {
        this.readModelAndInit(config, modelFile, printLoading);
    }

    LambdaSolve getLambdaSolve() {
        return this.prob;
    }

    void init(TaggerConfig config) {
        Object[] closedClassTags;
        Object[] openClassTags;
        String arch;
        String lang;
        if (this.initted) {
            return;
        }
        this.config = config;
        if (config == null) {
            lang = "english";
            arch = "left3words";
            openClassTags = StringUtils.EMPTY_STRING_ARRAY;
            closedClassTags = StringUtils.EMPTY_STRING_ARRAY;
        } else {
            lang = config.getLang();
            arch = config.getArch();
            openClassTags = config.getOpenClassTags();
            closedClassTags = config.getClosedClassTags();
            if (openClassTags.length > 0 && !lang.equals("") || closedClassTags.length > 0 && !lang.equals("") || closedClassTags.length > 0 && openClassTags.length > 0) {
                throw new RuntimeException("At least two of lang (\"" + lang + "\"), openClassTags (length " + openClassTags.length + ": " + Arrays.toString(openClassTags) + ")," + "and closedClassTags (length " + closedClassTags.length + ": " + Arrays.toString(closedClassTags) + ") specified---you must choose one!");
            }
            if (openClassTags.length == 0 && lang.equals("") && closedClassTags.length == 0 && !config.getLearnClosedClassTags()) {
                System.err.println("warning: no language set, no open-class tags specified, and no closed-class tags specified; assuming ALL tags are open class tags");
            }
        }
        if (openClassTags.length > 0) {
            this.tags = new TTags();
            this.tags.setOpenClassTags((String[])openClassTags);
        } else if (closedClassTags.length > 0) {
            this.tags = new TTags();
            this.tags.setClosedClassTags((String[])closedClassTags);
        } else {
            this.tags = new TTags(lang);
        }
        double d = this.defaultScore = lang.equals("english") ? 1.0 : 0.0;
        if (config != null) {
            this.rareWordThresh = config.getRareWordThresh();
            this.minFeatureThresh = config.getMinFeatureThresh();
            this.curWordMinFeatureThresh = config.getCurWordMinFeatureThresh();
            this.rareWordMinFeatureThresh = config.getRareWordMinFeatureThresh();
            this.veryCommonWordThresh = config.getVeryCommonWordThresh();
            this.occuringTagsOnly = config.occuringTagsOnly();
            this.possibleTagsOnly = config.possibleTagsOnly();
            if (config.getDefaultScore() >= 0.0) {
                this.defaultScore = config.getDefaultScore();
            }
        }
        if (config == null || config.getMode() == TaggerConfig.Mode.TRAIN) {
            this.extractors = new Extractors(ExtractorFrames.getExtractorFrames(arch));
            this.extractorsRare = new Extractors(ExtractorFramesRare.getExtractorFramesRare(arch, this.tags));
            this.setExtractorsGlobal();
        }
        this.ambClasses = new AmbiguityClasses(this.tags);
        this.initted = true;
    }

    protected TokenizerFactory<? extends HasWord> chooseTokenizerFactory() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MaxentTagger.chooseTokenizerFactory(this.config.getTokenize(), this.config.getTokenizerFactory(), this.config.getTokenizerOptions(), this.config.getTokenizerInvertible());
    }

    protected static TokenizerFactory<? extends HasWord> chooseTokenizerFactory(boolean tokenize, String tokenizerFactory, String tokenizerOptions, boolean invertible) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (tokenize && tokenizerFactory.trim().length() != 0) {
            Class<?> clazz = Class.forName(tokenizerFactory.trim());
            Method factoryMethod = clazz.getMethod("newTokenizerFactory", new Class[0]);
            TokenizerFactory factory = (TokenizerFactory)factoryMethod.invoke((Object)tokenizerOptions, new Object[0]);
            return factory;
        }
        if (tokenize) {
            if (invertible) {
                if (tokenizerOptions.equals("")) {
                    tokenizerOptions = "invertible=true";
                } else if (!tokenizerOptions.matches("(^|.*,)invertible=true")) {
                    tokenizerOptions = tokenizerOptions + ",invertible=true";
                }
                return PTBTokenizer.PTBTokenizerFactory.newCoreLabelTokenizerFactory(tokenizerOptions);
            }
            return PTBTokenizer.PTBTokenizerFactory.newWordTokenizerFactory(tokenizerOptions);
        }
        return WhitespaceTokenizer.factory();
    }

    int getNum(FeatureKey s) {
        Integer num = this.fAssociations.get(s);
        if (num == null) {
            return -1;
        }
        return num;
    }

    private void saveExtractors(OutputStream os) throws IOException {
        ObjectOutputStream out2 = new ObjectOutputStream(os);
        System.err.println(this.extractors.toString() + "\nrare" + this.extractorsRare.toString());
        out2.writeObject(this.extractors);
        out2.writeObject(this.extractorsRare);
    }

    private void readExtractors(String filename) throws IOException, ClassNotFoundException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));
        this.readExtractors(in);
        ((InputStream)in).close();
    }

    private void readExtractors(InputStream file) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(file);
        this.extractors = (Extractors)in.readObject();
        this.extractorsRare = (Extractors)in.readObject();
        this.extractors.initTypes();
        this.extractorsRare.initTypes();
        int left = this.extractors.leftContext();
        int left_u = this.extractorsRare.leftContext();
        if (left_u > left) {
            left = left_u;
        }
        this.leftContext = left;
        int right = this.extractors.rightContext();
        int right_u = this.extractorsRare.rightContext();
        if (right_u > right) {
            right = right_u;
        }
        this.rightContext = right;
        this.setExtractorsGlobal();
    }

    private void setExtractorsGlobal() {
        this.extractors.setGlobalHolder(this);
        this.extractorsRare.setGlobalHolder(this);
    }

    protected void saveModel(String filename, TaggerConfig config) {
        try {
            OutDataStreamFile file = new OutDataStreamFile(filename);
            config.saveConfig(file);
            file.writeInt(this.xSize);
            file.writeInt(this.ySize);
            this.dict.save(file);
            this.tags.save(file, this.tagTokens);
            this.saveExtractors(file);
            file.writeInt(this.fAssociations.size());
            for (Map.Entry<FeatureKey, Integer> item : this.fAssociations.entrySet()) {
                int numF = item.getValue();
                file.writeInt(numF);
                FeatureKey fk = item.getKey();
                fk.save(file);
            }
            LambdaSolve.save_lambdas(file, this.prob.lambda);
            file.close();
        }
        catch (IOException ioe) {
            System.err.println("Error saving tagger to file " + filename);
            ioe.printStackTrace();
        }
    }

    private static boolean convertMultifileTagger(String filename, String newFilename, TaggerConfig config) throws ClassNotFoundException, IOException, FileNotFoundException {
        InDataStreamFile rf = new InDataStreamFile(filename);
        MaxentTagger tagger = new MaxentTagger();
        tagger.init(config);
        tagger.xSize = rf.readInt();
        tagger.ySize = rf.readInt();
        tagger.dict.read(filename + ".dict");
        tagger.tags.read(filename + ".tags");
        tagger.readExtractors(filename + ".ex");
        tagger.dict.setAmbClasses(tagger.ambClasses, tagger.veryCommonWordThresh, tagger.tags);
        int[] numFA = new int[tagger.extractors.getSize() + tagger.extractorsRare.getSize()];
        int sizeAssoc = rf.readInt();
        Object pfVP = null;
        for (int i = 0; i < sizeAssoc; ++i) {
            int numF = rf.readInt();
            FeatureKey fK = new FeatureKey();
            fK.read(rf);
            int n = fK.num;
            numFA[n] = numFA[n] + 1;
            tagger.fAssociations.put(fK, numF);
        }
        tagger.prob = new LambdaSolveTagger(filename + ".prob");
        tagger.saveModel(newFilename, config);
        rf.close();
        return true;
    }

    protected void readModelAndInit(TaggerConfig config, String modelFileOrUrl, boolean printLoading) throws IOException, ClassNotFoundException {
        DataInputStream rf = config.getTaggerDataInputStream(modelFileOrUrl);
        this.readModelAndInit(config, rf, printLoading);
        rf.close();
    }

    protected void readModelAndInit(TaggerConfig config, DataInputStream rf, boolean printLoading) throws IOException, ClassNotFoundException {
        Timing t = new Timing();
        if (printLoading) {
            t.doing("Reading POS tagger model from " + config.getModel());
        }
        this.init(config);
        TaggerConfig ret = TaggerConfig.readConfig(rf);
        this.xSize = rf.readInt();
        this.ySize = rf.readInt();
        this.dict.read(rf);
        this.tags.read(rf);
        this.readExtractors(rf);
        this.dict.setAmbClasses(this.ambClasses, this.veryCommonWordThresh, this.tags);
        int[] numFA = new int[this.extractors.getSize() + this.extractorsRare.getSize()];
        int sizeAssoc = rf.readInt();
        this.fAssociations = new HashMap(sizeAssoc * 2);
        Object pfVP = null;
        for (int i = 0; i < sizeAssoc; ++i) {
            int numF = rf.readInt();
            FeatureKey fK = new FeatureKey();
            fK.read(rf);
            int n = fK.num;
            numFA[n] = numFA[n] + 1;
            this.fAssociations.put(fK, numF);
        }
        this.prob = new LambdaSolveTagger(rf);
        if (printLoading) {
            t.done();
        }
    }

    protected void dumpModel(PrintStream out2) {
        assert (this.fAssociations.size() == this.prob.lambda.length);
        for (Map.Entry<FeatureKey, Integer> fk : this.fAssociations.entrySet()) {
            out2.println(fk.getKey() + ": " + this.prob.lambda[fk.getValue()]);
        }
    }

    boolean isRare(String word) {
        return this.dict.sum(word) < this.rareWordThresh;
    }

    public TTags getTags() {
        return this.tags;
    }

    public String tagTokenizedString(String toTag) {
        ArrayList<Word> sent = Sentence.toUntaggedList(Arrays.asList(toTag.split("\\s+")));
        TestSentence testSentence = new TestSentence(this);
        testSentence.tagSentence(sent);
        return testSentence.getTaggedNice();
    }

    public String tagString(String toTag) {
        TaggerWrapper tw = new TaggerWrapper(this);
        return tw.apply(toTag);
    }

    @Override
    public ArrayList<TaggedWord> apply(List<? extends HasWord> in) {
        TestSentence testSentence = new TestSentence(this);
        return testSentence.tagSentence(in);
    }

    @Override
    public List<ArrayList<TaggedWord>> process(List<? extends List<? extends HasWord>> sentences) {
        ArrayList<ArrayList<TaggedWord>> taggedSentences = new ArrayList<ArrayList<TaggedWord>>();
        TestSentence testSentence = new TestSentence(this);
        for (List<? extends HasWord> list : sentences) {
            taggedSentences.add(testSentence.tagSentence(list));
        }
        return taggedSentences;
    }

    public ArrayList<TaggedWord> tagSentence(List<? extends HasWord> sentence) {
        TestSentence testSentence = new TestSentence(this);
        return testSentence.tagSentence(sentence);
    }

    public void tagCoreLabels(List<CoreLabel> sentence) {
        ArrayList<TaggedWord> taggedWords = this.tagSentence(sentence);
        if (taggedWords.size() != sentence.size()) {
            throw new AssertionError((Object)"Tagged word list not the same length as the original sentence");
        }
        int size = sentence.size();
        for (int i = 0; i < size; ++i) {
            sentence.get(i).setTag(((TaggedWord)taggedWords.get(i)).tag());
        }
    }

    public static void lemmatize(List<CoreLabel> sentence, Morphology morpha) {
        for (CoreLabel label : sentence) {
            morpha.stem(label);
        }
    }

    private static List<CoreLabel> castCoreLabels(List<? extends HasWord> sent) {
        ArrayList<CoreLabel> coreLabels = new ArrayList<CoreLabel>();
        for (HasWord hasWord : sent) {
            if (!(hasWord instanceof CoreLabel)) {
                throw new ClassCastException("Expected CoreLabels");
            }
            coreLabels.add((CoreLabel)hasWord);
        }
        return coreLabels;
    }

    public static List<List<HasWord>> tokenizeText(Reader r) {
        return MaxentTagger.tokenizeText(r, null);
    }

    protected static List<List<HasWord>> tokenizeText(Reader r, TokenizerFactory<? extends HasWord> tokenizerFactory) {
        DocumentPreprocessor documentPreprocessor = new DocumentPreprocessor(r);
        if (tokenizerFactory != null) {
            documentPreprocessor.setTokenizerFactory(tokenizerFactory);
        }
        ArrayList<List<HasWord>> out2 = new ArrayList<List<HasWord>>();
        for (List<HasWord> item : documentPreprocessor) {
            out2.add(item);
        }
        return out2;
    }

    private static void convertToSingleFileFormat(TaggerConfig config) {
        try {
            config.dump();
            MaxentTagger.convertMultifileTagger(config.getModel() + ".holder", config.getFile(), config);
        }
        catch (Exception e) {
            System.err.println("An error occurred while converting to the new tagger format.");
            e.printStackTrace();
        }
    }

    private static void dumpModel(TaggerConfig config) {
        try {
            MaxentTagger tagger = new MaxentTagger(config.getFile(), config, false);
            System.out.println("Serialized tagger built with config:");
            config.dump(System.out);
            tagger.dumpModel(System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void runTest(TaggerConfig config) {
        if (config.getVerbose()) {
            System.err.println("## tagger testing invoked at " + new Date() + " with arguments:");
            config.dump();
        }
        try {
            MaxentTagger tagger = new MaxentTagger(config.getModel(), config);
            Timing t = new Timing();
            TestClassifier testClassifier = new TestClassifier(config, tagger);
            long millis = t.stop();
            MaxentTagger.printErrWordsPerSec(millis, testClassifier.getNumWords());
            testClassifier.printModelAndAccuracy(config, tagger);
        }
        catch (Exception e) {
            System.err.println("An error occurred while testing the tagger.");
            e.printStackTrace();
        }
    }

    private static void trainAndSaveModel(TaggerConfig config) throws IOException {
        LambdaSolveTagger prob;
        String modelName = config.getModel();
        MaxentTagger maxentTagger = new MaxentTagger();
        maxentTagger.init(config);
        TaggerExperiments samples = new TaggerExperiments(config, maxentTagger);
        TaggerFeatures feats = samples.getTaggerFeatures();
        System.err.println("Samples from " + config.getFile());
        System.err.println("Number of features: " + feats.size());
        Problem p = new Problem(samples, feats);
        maxentTagger.prob = prob = new LambdaSolveTagger(p, 1.0E-4, 1.0E-5, maxentTagger.fnumArr);
        if (config.getSearch().equals("owlqn")) {
            CGRunner runner = new CGRunner(prob, config.getModel(), config.getSigmaSquared());
            runner.solveL1(config.getRegL1());
        } else if (config.getSearch().equals("cg")) {
            CGRunner runner = new CGRunner(prob, config.getModel(), config.getSigmaSquared());
            runner.solveCG();
        } else if (config.getSearch().equals("qn")) {
            CGRunner runner = new CGRunner(prob, config.getModel(), config.getSigmaSquared());
            runner.solveQN();
        } else {
            prob.improvedIterative(config.getIterations());
        }
        if (prob.checkCorrectness()) {
            System.err.println("Model is correct [empirical expec = model expec]");
        } else {
            System.err.println("Model is not correct");
        }
        maxentTagger.saveModel(modelName, config);
    }

    private static void runTraining(TaggerConfig config) throws Exception {
        Date now = new Date();
        System.err.println("## tagger training invoked at " + now + " with arguments:");
        config.dump();
        Timing tim = new Timing();
        try {
            PrintFile log = new PrintFile(config.getModel() + ".props");
            log.println("## tagger training invoked at " + now + " with arguments:");
            config.dump(log);
            log.close();
            MaxentTagger.trainAndSaveModel(config);
            tim.done("Training POS tagger");
        }
        catch (Exception e) {
            System.err.println("An error occurred while training a new tagger.");
            throw e;
        }
    }

    private static void printErrWordsPerSec(long milliSec, int numWords) {
        double wordspersec = (double)numWords / ((double)milliSec / 1000.0);
        DecimalFormat nf = new DecimalFormat("0.00");
        System.err.println("Tagged " + numWords + " words at " + nf.format(wordspersec) + " words per second.");
    }

    private static String getXMLWords(List<? extends HasWord> sentence, int sentNum, boolean outputLemmas) {
        boolean hasCoreLabels = sentence != null && sentence.size() > 0 && sentence.get(0) instanceof CoreLabel;
        StringBuilder sb = new StringBuilder();
        sb.append("<sentence id=\"").append(sentNum).append("\">\n");
        int wordIndex = 0;
        for (HasWord hasWord : sentence) {
            String word = hasWord.word();
            if (!(hasWord instanceof HasTag)) {
                throw new IllegalArgumentException("Expected HasTags, got " + hasWord.getClass());
            }
            String tag = ((HasTag)((Object)hasWord)).tag();
            sb.append("  <word wid=\"").append(wordIndex).append("\" pos=\"").append(XMLUtils.escapeAttributeXML(tag)).append("\"");
            if (outputLemmas && hasCoreLabels) {
                if (!(hasWord instanceof CoreLabel)) {
                    throw new IllegalArgumentException("You mixed CoreLabels with " + hasWord.getClass() + "?  " + "Why would you do that?");
                }
                CoreLabel label = (CoreLabel)hasWord;
                String lemma = label.lemma();
                if (lemma != null) {
                    sb.append(" lemma=\"" + XMLUtils.escapeElementXML(lemma) + "\"");
                }
            }
            sb.append(">").append(XMLUtils.escapeElementXML(word)).append("</word>\n");
            ++wordIndex;
        }
        sb.append("</sentence>\n");
        return sb.toString();
    }

    private static String getTsvWords(boolean verbose, boolean outputLemmas, List<? extends HasWord> sentence) {
        StringBuilder sb = new StringBuilder();
        if (verbose && sentence.size() > 0 && sentence.get(0) instanceof CoreLabel) {
            for (HasWord hasWord : sentence) {
                if (!(hasWord instanceof CoreLabel)) {
                    throw new IllegalArgumentException("You mixed CoreLabels with " + hasWord.getClass() + "?  " + "Why would you do that?");
                }
                CoreLabel label = (CoreLabel)hasWord;
                sb.append(label.word());
                sb.append("\t");
                sb.append(label.current());
                sb.append("\t");
                if (outputLemmas) {
                    sb.append(label.lemma());
                    sb.append("\t");
                }
                sb.append(label.tag());
                sb.append("\t");
                sb.append(label.beginPosition());
                sb.append("\t");
                sb.append(label.endPosition());
                sb.append("\n");
            }
            sb.append('\n');
            return sb.toString();
        }
        for (HasWord hasWord : sentence) {
            String word = hasWord.word();
            if (!(hasWord instanceof HasTag)) {
                throw new IllegalArgumentException("Expected HasTags, got " + hasWord.getClass());
            }
            String tag = ((HasTag)((Object)hasWord)).tag();
            sb.append(word).append('\t').append(tag).append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    private static void writeXMLSentence(Writer w, List<? extends HasWord> sent, int sentNum, boolean outputLemmas) {
        try {
            w.write(MaxentTagger.getXMLWords(sent, sentNum, outputLemmas));
        }
        catch (IOException e) {
            System.err.println("Error writing sentence " + sentNum + ": " + Sentence.listToString(sent));
            throw new RuntimeIOException(e);
        }
    }

    public void tagFromXML(InputStream input, Writer writer, String ... xmlTags) {
        TransformXML<String> txml = new TransformXML<String>();
        txml.transformXML(xmlTags, new TaggerWrapper(this.config, this), input, writer, new TransformXML.SAXInterface());
    }

    public void tagFromXML(Reader input, Writer writer, String ... xmlTags) {
        TransformXML<String> txml = new TransformXML<String>();
        txml.transformXML(xmlTags, new TaggerWrapper(this.config, this), input, writer, new TransformXML.SAXInterface());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void tagFromXML() {
        BufferedInputStream is = null;
        Writer w = null;
        try {
            is = new BufferedInputStream(new FileInputStream(this.config.getFile()));
            String outFile = this.config.getOutputFile();
            w = outFile.length() > 0 ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), this.config.getEncoding())) : new PrintWriter(System.out);
            this.tagFromXML(is, w, this.config.getXMLInput());
        }
        catch (FileNotFoundException e) {
            System.err.println("Input file not found: " + this.config.getFile());
            e.printStackTrace();
            IOUtils.closeIgnoringExceptions(is);
            IOUtils.closeIgnoringExceptions(w);
        }
        catch (IOException ioe) {
            System.err.println("tagFromXML: mysterious IO Exception");
            ioe.printStackTrace();
            {
                catch (Throwable throwable) {
                    IOUtils.closeIgnoringExceptions(is);
                    IOUtils.closeIgnoringExceptions(w);
                    throw throwable;
                }
            }
            IOUtils.closeIgnoringExceptions(is);
            IOUtils.closeIgnoringExceptions(w);
        }
        IOUtils.closeIgnoringExceptions(is);
        IOUtils.closeIgnoringExceptions(w);
    }

    private static void runTagger(TaggerConfig config) throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (config.getVerbose()) {
            Date now = new Date();
            System.err.println("## tagger invoked at " + now + " with arguments:");
            config.dump();
        }
        MaxentTagger tagger = new MaxentTagger(config.getModel(), config);
        tagger.runTagger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runTagger() throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String[] xmlInput = this.config.getXMLInput();
        if (!(xmlInput.length <= 0 || xmlInput.length <= 1 && xmlInput[0].equals("null"))) {
            this.tagFromXML();
            return;
        }
        BufferedWriter writer = null;
        try {
            BufferedReader br;
            String outFile = this.config.getOutputFile();
            writer = outFile.length() > 0 ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), this.config.getEncoding())) : new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, this.config.getEncoding()));
            boolean stdin = this.config.useStdin();
            if (!stdin) {
                br = IOUtils.readReaderFromString(this.config.getFile(), this.config.getEncoding());
            } else {
                System.err.println("Type some text to tag, then EOF.");
                System.err.println("  (For EOF, use Return, Ctrl-D on Unix; Enter, Ctrl-Z, Enter on Windows.)");
                br = new BufferedReader(new InputStreamReader(System.in));
            }
            this.runTagger(br, writer, this.config.getTagInside(), stdin);
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            if (writer == null) throw throwable;
            IOUtils.closeIgnoringExceptions(writer);
            throw throwable;
        }
        IOUtils.closeIgnoringExceptions(writer);
    }

    public void runTagger(BufferedReader reader, BufferedWriter writer, String tagInside, boolean stdin) throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Morphology morpha;
        Timing t = new Timing();
        String sentenceDelimiter = this.config.getSentenceDelimiter();
        TokenizerFactory<? extends HasWord> tokenizerFactory = this.chooseTokenizerFactory();
        int numWords = 0;
        int numSentences = 0;
        if (tagInside != null && !tagInside.equals("")) {
            stdin = false;
        }
        PlainTextDocumentReaderAndWriter.OutputStyle outputStyle = PlainTextDocumentReaderAndWriter.OutputStyle.fromShortName(this.config.getOutputFormat());
        boolean outputVerbosity = this.config.getOutputVerbosity();
        boolean outputLemmas = this.config.getOutputLemmas();
        Morphology morphology = morpha = outputLemmas ? new Morphology() : null;
        do {
            if (this.config.getSGML()) {
                PlainTextDocumentReaderAndWriter readerAndWriter = new PlainTextDocumentReaderAndWriter();
                ObjectBank ob = new ObjectBank(new ReaderIteratorFactory(reader), readerAndWriter);
                PrintWriter pw = new PrintWriter(writer);
                for (List sentence : ob) {
                    ArrayList s = new ArrayList(sentence);
                    numWords += s.size();
                    ArrayList<TaggedWord> taggedSentence = this.tagSentence(s);
                    Iterator origIter = sentence.iterator();
                    for (TaggedWord tw : taggedSentence) {
                        CoreLabel cl = (CoreLabel)origIter.next();
                        cl.set(CoreAnnotations.AnswerAnnotation.class, tw.tag());
                    }
                    readerAndWriter.printAnswers(sentence, pw, outputStyle, true);
                }
            } else {
                DocumentPreprocessor docProcessor;
                if (tagInside.length() > 0) {
                    docProcessor = new DocumentPreprocessor(reader, DocumentPreprocessor.DocType.XML);
                    docProcessor.setElementDelimiter(tagInside);
                } else if (stdin) {
                    String line = reader.readLine();
                    if (line == null) break;
                    docProcessor = new DocumentPreprocessor(new BufferedReader(new StringReader(line)));
                } else {
                    docProcessor = new DocumentPreprocessor(reader);
                    docProcessor.setSentenceDelimiter(sentenceDelimiter);
                }
                docProcessor.setTokenizerFactory(tokenizerFactory);
                docProcessor.setEncoding(this.config.getEncoding());
                for (List<HasWord> sentence : docProcessor) {
                    numWords += sentence.size();
                    if (sentence.size() > 0 && sentence.get(0) instanceof CoreLabel) {
                        List<CoreLabel> coreLabels = MaxentTagger.castCoreLabels(sentence);
                        this.tagCoreLabels(coreLabels);
                        if (outputLemmas) {
                            MaxentTagger.lemmatize(coreLabels, morpha);
                        }
                        sentence = coreLabels;
                    } else {
                        ArrayList<TaggedWord> taggedSentence = this.tagSentence(sentence);
                        sentence = taggedSentence;
                    }
                    switch (outputStyle) {
                        case TSV: {
                            writer.write(MaxentTagger.getTsvWords(outputVerbosity, outputLemmas, sentence));
                            break;
                        }
                        case XML: 
                        case INLINE_XML: {
                            MaxentTagger.writeXMLSentence(writer, sentence, numSentences, outputLemmas);
                            break;
                        }
                        case SLASH_TAGS: {
                            writer.write(Sentence.listToString(sentence, false, this.config.getTagSeparator()));
                            writer.newLine();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported output style " + (Object)((Object)outputStyle));
                        }
                    }
                    if (stdin) {
                        writer.newLine();
                        writer.flush();
                    }
                    ++numSentences;
                }
            }
        } while (stdin);
        writer.flush();
        long millis = t.stop();
        MaxentTagger.printErrWordsPerSec(millis, numWords);
    }

    public static void main(String[] args) throws Exception {
        TaggerConfig config = new TaggerConfig(args);
        if (config.getMode() == TaggerConfig.Mode.TRAIN) {
            MaxentTagger.runTraining(config);
        } else if (config.getMode() == TaggerConfig.Mode.TAG) {
            MaxentTagger.runTagger(config);
        } else if (config.getMode() == TaggerConfig.Mode.TEST) {
            MaxentTagger.runTest(config);
        } else if (config.getMode() == TaggerConfig.Mode.CONVERT) {
            MaxentTagger.convertToSingleFileFormat(config);
        } else if (config.getMode() == TaggerConfig.Mode.DUMP) {
            MaxentTagger.dumpModel(config);
        } else {
            System.err.println("Impossible: nothing to do. None of train, tag, test, or convert was specified.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TaggerWrapper
    implements Function<String, String> {
        private final TaggerConfig config;
        private final MaxentTagger tagger;
        private TokenizerFactory<? extends HasWord> tokenizerFactory;
        private int sentNum;
        private final boolean tokenize;
        private final boolean outputVerbosity;
        private final boolean outputLemmas;
        private final PlainTextDocumentReaderAndWriter.OutputStyle outputStyle;
        private final String tagSeparator;
        private final Morphology morpha;

        protected TaggerWrapper(MaxentTagger tagger) {
            this(null, tagger);
        }

        protected TaggerWrapper(TaggerConfig config, MaxentTagger tagger) {
            this.config = config;
            this.tagger = tagger;
            if (config != null) {
                try {
                    this.tokenizerFactory = MaxentTagger.chooseTokenizerFactory(config.getTokenize(), config.getTokenizerFactory(), config.getTokenizerOptions(), config.getTokenizerInvertible());
                }
                catch (Exception e) {
                    System.err.println("Error in tokenizer factory instantiation for class: " + config.getTokenizerFactory());
                    e.printStackTrace();
                    this.tokenizerFactory = PTBTokenizer.PTBTokenizerFactory.newWordTokenizerFactory(config.getTokenizerOptions());
                }
                this.outputStyle = PlainTextDocumentReaderAndWriter.OutputStyle.fromShortName(config.getOutputFormat());
                this.outputVerbosity = config.getOutputVerbosity();
                this.outputLemmas = config.getOutputLemmas();
                this.morpha = this.outputLemmas ? new Morphology() : null;
                this.tokenize = config.getTokenize();
                this.tagSeparator = config.getTagSeparator();
            } else {
                this.tokenizerFactory = PTBTokenizer.PTBTokenizerFactory.newWordTokenizerFactory("");
                this.outputStyle = PlainTextDocumentReaderAndWriter.OutputStyle.SLASH_TAGS;
                this.outputVerbosity = false;
                this.outputLemmas = false;
                this.morpha = null;
                this.tokenize = true;
                this.tagSeparator = null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String apply(String o) {
            List<Object> sentences;
            StringBuilder taggedResults = new StringBuilder();
            TestSentence testSentence = new TestSentence(this.tagger);
            if (this.tokenize) {
                sentences = MaxentTagger.tokenizeText(new StringReader(o), this.tokenizerFactory);
            } else {
                sentences = new ArrayList<List<HasWord>>();
                sentences.add(Sentence.toWordList(Arrays.asList(o.split("\\s+"))));
            }
            block5: for (List list : sentences) {
                if (list.size() > 0 && list.get(0) instanceof CoreLabel) {
                    List coreLabels = MaxentTagger.castCoreLabels(list);
                    this.tagger.tagCoreLabels(coreLabels);
                    if (this.outputLemmas) {
                        MaxentTagger.lemmatize(coreLabels, this.morpha);
                    }
                    List list2 = coreLabels;
                } else {
                    ArrayList<TaggedWord> taggedSentence;
                    ArrayList<TaggedWord> arrayList = taggedSentence = testSentence.tagSentence(list);
                }
                switch (this.outputStyle) {
                    case TSV: {
                        void var6_6;
                        taggedResults.append(MaxentTagger.getTsvWords(this.outputVerbosity, this.outputLemmas, (List)var6_6));
                        continue block5;
                    }
                    case XML: 
                    case INLINE_XML: {
                        void var6_6;
                        taggedResults.append(MaxentTagger.getXMLWords((List)var6_6, this.sentNum++, this.outputLemmas));
                        continue block5;
                    }
                    case SLASH_TAGS: {
                        void var6_6;
                        taggedResults.append(Sentence.listToString(var6_6, false, this.tagSeparator)).append(' ');
                        continue block5;
                    }
                }
                throw new IllegalArgumentException("Unsupported output style " + (Object)((Object)this.outputStyle));
            }
            return taggedResults.toString();
        }
    }
}

