/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.semgraph;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.semgraph.DijkstraShortestPathIgnoringEdgeDirection;
import edu.stanford.nlp.trees.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.trees.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.trees.semgraph.SemanticGraphFormatter;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringParsingTask;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.StringReader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.DirectedMultigraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticGraph
extends DirectedMultigraph<IndexedWord, SemanticGraphEdge> {
    public static boolean addSRLArcs = false;
    private static final SemanticGraphFormatter formatter = new SemanticGraphFormatter();
    private Collection<IndexedWord> roots;
    private List<IndexedWord> vlist;
    private List<SemanticGraphEdge> elist;
    private static final Pattern WORD_AND_INDEX_PATTERN = Pattern.compile("([^-]+)-([0-9]+)");
    private static final long serialVersionUID = 1L;

    public List<IndexedWord> vertexList() {
        if (this.vlist == null) {
            Set s = this.vertexSet();
            this.vlist = new ArrayList<IndexedWord>(s);
            Collections.sort(this.vlist);
            this.vlist = Collections.unmodifiableList(this.vlist);
        }
        return this.vlist;
    }

    public synchronized List<IndexedWord> vertexList(boolean refresh) {
        if (refresh || this.vlist == null) {
            Set s = this.vertexSet();
            this.vlist = new ArrayList<IndexedWord>(s);
            Collections.sort(this.vlist);
            this.vlist = Collections.unmodifiableList(this.vlist);
        }
        return this.vlist;
    }

    public List<SemanticGraphEdge> edgeList() {
        if (this.elist == null) {
            Set s = this.edgeSet();
            this.elist = new ArrayList<SemanticGraphEdge>(s);
        }
        Collections.sort(this.elist, SemanticGraphEdge.orderByTargetComparator());
        return this.elist;
    }

    public List<SemanticGraphEdge> edgeList(boolean refresh) {
        if (refresh || this.elist == null) {
            Set s = this.edgeSet();
            this.elist = new ArrayList<SemanticGraphEdge>(s);
            Collections.sort(this.elist, SemanticGraphEdge.orderByTargetComparator());
        }
        return this.elist;
    }

    public boolean isEmpty() {
        return this.edgeSet().isEmpty();
    }

    public int isAncestor(IndexedWord child, IndexedWord ancestor) {
        List<IndexedWord> parents = this.getParentList(child);
        if (parents == null) {
            return -1;
        }
        if (parents.contains(ancestor)) {
            return 1;
        }
        for (IndexedWord parent : parents) {
            List<IndexedWord> grandparents = this.getParentList(parent);
            if (!grandparents.contains(ancestor)) continue;
            return 2;
        }
        return -1;
    }

    public int commonAncestor(IndexedWord v1, IndexedWord v2) {
        List<IndexedWord> v1Parents = this.getParentList(v1);
        List<IndexedWord> v2Parents = this.getParentList(v2);
        ArrayList<IndexedWord> v1GrandParents = new ArrayList<IndexedWord>();
        ArrayList<IndexedWord> v2GrandParents = new ArrayList<IndexedWord>();
        for (IndexedWord v1Parent : v1Parents) {
            if (v2Parents.contains(v1Parent)) {
                return 1;
            }
            v1GrandParents.addAll(this.getParentList(v1Parent));
        }
        for (IndexedWord v1GrandParent : v1GrandParents) {
            if (!v2Parents.contains(v1GrandParent)) continue;
            return 2;
        }
        for (IndexedWord v2Parent : v2Parents) {
            v2GrandParents.addAll(this.getParentList(v2Parent));
        }
        for (IndexedWord v2GrandParent : v2GrandParents) {
            if (v1Parents.contains(v2GrandParent)) {
                return 1;
            }
            if (!v1GrandParents.contains(v2GrandParent)) continue;
            return 2;
        }
        return -1;
    }

    public IndexedWord getCommonAncestor(IndexedWord v1, IndexedWord v2) {
        if (this.isAncestor(v1, v2) >= 1) {
            return v2;
        }
        if (this.isAncestor(v2, v1) >= 1) {
            return v1;
        }
        List<IndexedWord> v1Parents = this.getParentList(v1);
        List<IndexedWord> v2Parents = this.getParentList(v2);
        ArrayList<IndexedWord> v1GrandParents = new ArrayList<IndexedWord>();
        ArrayList<IndexedWord> v2GrandParents = new ArrayList<IndexedWord>();
        for (IndexedWord v1Parent : v1Parents) {
            if (v2Parents.contains(v1Parent)) {
                return v1Parent;
            }
            v1GrandParents.addAll(this.getParentList(v1Parent));
        }
        for (IndexedWord v1GrandParent : v1GrandParents) {
            if (!v2Parents.contains(v1GrandParent)) continue;
            return v1GrandParent;
        }
        for (IndexedWord v2Parent : v2Parents) {
            v2GrandParents.addAll(this.getParentList(v2Parent));
        }
        for (IndexedWord v2GrandParent : v2GrandParents) {
            if (v1Parents.contains(v2GrandParent)) {
                return v2GrandParent;
            }
            if (!v1GrandParents.contains(v2GrandParent)) continue;
            return v2GrandParent;
        }
        return null;
    }

    public boolean matchPatternToVertex(String pattern, IndexedWord vertex, boolean det) {
        String[] nodePath;
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        String pat = pattern.replaceAll("<", ",<");
        pat = pat.replaceAll(">", ",>");
        for (String s : nodePath = pat.split(",")) {
            String lemma;
            boolean match;
            if (s.equals("")) continue;
            String word = s.substring(1);
            char dir = s.charAt(0);
            if (dir == '<') {
                List<IndexedWord> parents = this.getParentList(vertex);
                match = false;
                for (IndexedWord indexedWord : parents) {
                    lemma = (String)indexedWord.get(CoreAnnotations.LemmaAnnotation.class);
                    if (!lemma.equals(word)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            if (dir == '>') {
                List children;
                if (det) {
                    children = this.getChildrenWithReln(vertex, EnglishGrammaticalRelations.DETERMINER);
                    children.addAll(this.getChildrenWithReln(vertex, EnglishGrammaticalRelations.PREDETERMINER));
                    match = false;
                    for (IndexedWord indexedWord : children) {
                        lemma = (String)indexedWord.get(CoreAnnotations.LemmaAnnotation.class);
                        if (lemma.equals("")) {
                            lemma = indexedWord.word().toLowerCase();
                        }
                        if (!lemma.equals(word)) continue;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    return false;
                }
                children = this.childPairs(vertex);
                match = false;
                for (Pair pair : children) {
                    if (((GrammaticalRelation)pair.first()).toString().equals("det")) continue;
                    IndexedWord child = (IndexedWord)pair.second();
                    String lemma2 = (String)child.get(CoreAnnotations.LemmaAnnotation.class);
                    if (lemma2.equals("")) {
                        lemma2 = child.word().toLowerCase();
                    }
                    if (!lemma2.equals(word)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            throw new RuntimeException("Warning: bad pattern \"%s\"\n" + pattern);
        }
        return true;
    }

    public boolean matchPatternToVertex(String pattern, IndexedWord vertex) {
        String[] nodePath;
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        String pat = pattern.replaceAll("<", ",<");
        pat = pat.replaceAll(">", ",>");
        for (String s : nodePath = pat.split(",")) {
            String lemma;
            boolean match;
            if (s.equals("")) continue;
            String word = s.substring(1);
            char dir = s.charAt(0);
            if (dir == '<') {
                List<IndexedWord> parents = this.getParentList(vertex);
                match = false;
                for (IndexedWord parent : parents) {
                    lemma = (String)parent.get(CoreAnnotations.LemmaAnnotation.class);
                    if (!lemma.equals(word)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            if (dir == '>') {
                List<IndexedWord> children = this.getChildList(vertex);
                match = false;
                for (IndexedWord child : children) {
                    String string = lemma = child.get(CoreAnnotations.LemmaAnnotation.class) == null ? "" : (String)child.get(CoreAnnotations.LemmaAnnotation.class);
                    if (lemma.equals("")) {
                        lemma = child.word().toLowerCase();
                    }
                    if (!lemma.equals(word)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            throw new RuntimeException("Warning: bad pattern \"%s\"\n" + pattern);
        }
        return true;
    }

    public List<IndexedWord> getChildList(IndexedWord vertex) {
        if (!this.vertexSet().contains(vertex)) {
            System.err.println("Weird vertex: Index " + vertex.index() + ", word " + vertex.word());
            System.err.println("Vertices I know: " + this.vertexSet());
            throw new IllegalArgumentException();
        }
        ArrayList<IndexedWord> result = new ArrayList<IndexedWord>(this.getChildren(vertex));
        Collections.sort(result);
        return result;
    }

    public Collection<IndexedWord> getChildren(IndexedWord vertex) {
        ArrayList<IndexedWord> result = new ArrayList<IndexedWord>();
        Set outbound = this.outgoingEdgesOf(vertex);
        for (SemanticGraphEdge edge : outbound) {
            IndexedWord child = (IndexedWord)edge.getTarget();
            result.add(child);
        }
        return result;
    }

    public boolean hasChildren(IndexedWord vertex) {
        return this.outgoingEdgesOf(vertex).size() > 0;
    }

    public List<SemanticGraphEdge> getIncomingEdgesSorted(IndexedWord vertex) {
        ArrayList<SemanticGraphEdge> edges = new ArrayList<SemanticGraphEdge>(this.incomingEdgesOf(vertex));
        Collections.sort(edges);
        return edges;
    }

    public List<SemanticGraphEdge> getOutEdgesSorted(IndexedWord vertex) {
        ArrayList<SemanticGraphEdge> edges = new ArrayList<SemanticGraphEdge>(this.outgoingEdgesOf(vertex));
        Collections.sort(edges);
        return edges;
    }

    public List<IndexedWord> getParentList(IndexedWord vertex) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<IndexedWord> result = new ArrayList<IndexedWord>(this.getParents(vertex));
        Collections.sort(result);
        return result;
    }

    public Collection<IndexedWord> getParents(IndexedWord vertex) {
        ArrayList<IndexedWord> result = new ArrayList<IndexedWord>();
        Set inbound = this.incomingEdgesOf(vertex);
        for (SemanticGraphEdge edge : inbound) {
            IndexedWord parent = (IndexedWord)edge.getSource();
            result.add(parent);
        }
        return result;
    }

    public Collection<IndexedWord> getSiblings(IndexedWord vertex) {
        IndexedWord parent = this.getParent(vertex);
        if (parent != null) {
            List<IndexedWord> result = this.getChildList(parent);
            result.remove(vertex);
            return result;
        }
        return new ArrayList<IndexedWord>();
    }

    private List<IndexedWord> getPathToRoot(IndexedWord vertex, List<IndexedWord> used) {
        used.add(vertex);
        List<IndexedWord> parents = this.getParentList(vertex);
        parents.removeAll(used);
        if (this.roots.contains(vertex) || parents.size() == 0) {
            used.remove(used.size() - 1);
            if (this.roots.contains(vertex)) {
                return new Vector<IndexedWord>();
            }
            return null;
        }
        for (IndexedWord parent : parents) {
            List<IndexedWord> path = this.getPathToRoot(parent, used);
            if (path == null) continue;
            path.add(0, parent);
            used.remove(used.size() - 1);
            return path;
        }
        used.remove(used.size() - 1);
        return null;
    }

    public List<IndexedWord> getPathToRoot(IndexedWord vertex) {
        return this.getPathToRoot(vertex, new Vector<IndexedWord>());
    }

    public IndexedWord getParent(IndexedWord vertex) {
        List<IndexedWord> path = this.getPathToRoot(vertex);
        if (path != null && path.size() > 0) {
            return path.get(0);
        }
        return null;
    }

    public IndexedWord getNodeByIndex(int index) throws IllegalArgumentException {
        IndexedWord node = this.getNodeByIndexSafe(index);
        if (node == null) {
            throw new IllegalArgumentException("No SemanticGraph vertex with index " + index);
        }
        return node;
    }

    public IndexedWord getNodeByIndexSafe(int index) {
        for (IndexedWord vertex : this.vertexList()) {
            if (vertex.index() != index) continue;
            return vertex;
        }
        return null;
    }

    public IndexedWord getNodeByWordPattern(String pattern) throws IllegalArgumentException {
        Pattern p = Pattern.compile(pattern);
        for (IndexedWord vertex : this.vertexList()) {
            String w = vertex.word();
            if ((w != null || pattern != null) && (w == null || !p.matcher(w).matches())) continue;
            return vertex;
        }
        return null;
    }

    public List<IndexedWord> getAllNodesByWordPattern(String pattern) throws IllegalArgumentException {
        Pattern p = Pattern.compile(pattern);
        ArrayList<IndexedWord> nodes = new ArrayList<IndexedWord>();
        for (IndexedWord vertex : this.vertexList()) {
            String w = vertex.word();
            if ((w != null || pattern != null) && (w == null || !p.matcher(w).matches())) continue;
            nodes.add(vertex);
        }
        return nodes;
    }

    public Set<IndexedWord> descendants(IndexedWord vertex) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        HashSet<IndexedWord> descendantSet = new HashSet<IndexedWord>();
        this.descendantsHelper(vertex, descendantSet);
        return descendantSet;
    }

    private void descendantsHelper(IndexedWord curr, Set<IndexedWord> descendantSet) {
        if (descendantSet.contains(curr)) {
            return;
        }
        descendantSet.add(curr);
        for (IndexedWord child : this.getChildList(curr)) {
            this.descendantsHelper(child, descendantSet);
        }
    }

    public List<Pair<GrammaticalRelation, IndexedWord>> childPairs(IndexedWord vertex) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        Set edges = this.outgoingEdgesOf(vertex);
        ArrayList<Pair<GrammaticalRelation, IndexedWord>> childPairs = Generics.newArrayList();
        for (SemanticGraphEdge e : edges) {
            childPairs.add(new Pair(e.getRelation(), e.getTarget()));
        }
        return childPairs;
    }

    public List<Pair<GrammaticalRelation, IndexedWord>> parentPairs(IndexedWord vertex) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        Set edges = this.incomingEdgesOf(vertex);
        ArrayList<Pair<GrammaticalRelation, IndexedWord>> parentPairs = Generics.newArrayList();
        for (SemanticGraphEdge e : edges) {
            parentPairs.add(new Pair(e.getRelation(), e.getSource()));
        }
        return parentPairs;
    }

    public Set<GrammaticalRelation> relns(IndexedWord vertex) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        HashSet<GrammaticalRelation> relns = Generics.newHashSet();
        List<Pair<GrammaticalRelation, IndexedWord>> pairs = this.parentPairs(vertex);
        for (Pair<GrammaticalRelation, IndexedWord> p : pairs) {
            relns.add(p.first());
        }
        return relns;
    }

    public GrammaticalRelation reln(IndexedWord a, IndexedWord b) {
        if (!this.vertexSet().contains(a)) {
            throw new IllegalArgumentException();
        }
        List<Pair<GrammaticalRelation, IndexedWord>> pairs = this.childPairs(a);
        for (Pair<GrammaticalRelation, IndexedWord> p : pairs) {
            if (!p.second().equals(b)) continue;
            return p.first();
        }
        return null;
    }

    public Set<GrammaticalRelation> childRelns(IndexedWord vertex) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        HashSet<GrammaticalRelation> relns = Generics.newHashSet();
        List<Pair<GrammaticalRelation, IndexedWord>> pairs = this.childPairs(vertex);
        for (Pair<GrammaticalRelation, IndexedWord> p : pairs) {
            relns.add(p.first());
        }
        return relns;
    }

    public Collection<IndexedWord> getRoots() {
        return this.roots;
    }

    public List<IndexedWord> getVerticesWithoutParents() {
        ArrayList<IndexedWord> result = new ArrayList<IndexedWord>();
        Set vertices = this.vertexSet();
        for (IndexedWord v : vertices) {
            int inDegree = this.inDegreeOf(v);
            if (inDegree != 0) continue;
            result.add(v);
        }
        Collections.sort(result);
        return result;
    }

    public IndexedWord getFirstRoot() {
        if (this.roots.isEmpty()) {
            throw new RuntimeException("No roots in graph:\n" + (Object)((Object)this) + "\nFind where this graph was created and make sure you're adding roots.");
        }
        return this.roots.iterator().next();
    }

    public void addRoot(IndexedWord root) {
        this.addVertex(root);
        this.roots.add(root);
    }

    public void resetRoots() {
        List<IndexedWord> newRoots = this.getVerticesWithoutParents();
        if (newRoots.size() > 0) {
            this.roots.clear();
            this.roots.addAll(newRoots);
            return;
        }
        ClassicCounter<Pair<IndexedWord, IndexedWord>> nodeDists = new ClassicCounter<Pair<IndexedWord, IndexedWord>>();
        TreeSet nodes = new TreeSet(this.vertexSet());
        for (IndexedWord node1 : nodes) {
            for (IndexedWord node2 : nodes) {
                Pair<IndexedWord, IndexedWord> key = new Pair<IndexedWord, IndexedWord>(node1, node2);
                List<SemanticGraphEdge> path = this.getShortestDirectPathEdges(node1, node2);
                if (path == null) continue;
                int dist = path.size();
                nodeDists.setCount(key, dist);
            }
        }
        ClassicCounter<IndexedWord> dominatedEdgeCount = new ClassicCounter<IndexedWord>();
        TreeSet nodesList = new TreeSet(this.vertexSet());
        for (IndexedWord outer : nodesList) {
            for (IndexedWord inner : nodesList) {
                Pair<IndexedWord, IndexedWord> key = new Pair<IndexedWord, IndexedWord>(outer, inner);
                dominatedEdgeCount.incrementCount(outer, nodeDists.getCount(key));
            }
        }
        IndexedWord winner = (IndexedWord)Counters.argmax(dominatedEdgeCount);
        this.setRoot(winner);
    }

    public void setRoot(IndexedWord word) {
        this.roots.clear();
        this.roots.add(word);
    }

    public void setRoots(Collection<IndexedWord> words) {
        this.roots.clear();
        this.roots.addAll(words);
    }

    public List<IndexedWord> topologicalSort() throws Exception {
        LinkedList<IndexedWord> q = new LinkedList<IndexedWord>(this.getVerticesWithoutParents());
        HashSet remainingEdges = new HashSet(this.edgeSet());
        ArrayList<IndexedWord> result = new ArrayList<IndexedWord>();
        while (!q.isEmpty()) {
            IndexedWord node = q.removeLast();
            result.add(node);
            Set outbound = this.outgoingEdgesOf(node);
            for (SemanticGraphEdge e : outbound) {
                IndexedWord target = (IndexedWord)e.getTarget();
                remainingEdges.remove(e);
                Set inc = this.incomingEdgesOf(target);
                boolean hasInbound = false;
                for (SemanticGraphEdge other : inc) {
                    if (!remainingEdges.contains(other)) continue;
                    hasInbound = true;
                    break;
                }
                if (hasInbound) continue;
                q.addLast(target);
            }
        }
        if (result.size() != this.vertexSet().size()) {
            throw new Exception("This graph has cycles. Topological sort not possible: " + result);
        }
        return result;
    }

    public boolean hasChild(IndexedWord vertex, GrammaticalRelation reln, String childLemma) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        Set edges = this.outgoingEdgesOf(vertex);
        for (SemanticGraphEdge edge : edges) {
            if (!edge.getRelation().equals(reln) || !((String)((IndexedWord)edge.getTarget()).get(CoreAnnotations.LemmaAnnotation.class)).equals(childLemma)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildWithReln(IndexedWord vertex, GrammaticalRelation reln) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        Set edges = this.outgoingEdgesOf(vertex);
        for (SemanticGraphEdge edge : edges) {
            if (!edge.getRelation().equals(reln)) continue;
            return true;
        }
        return false;
    }

    public boolean hasParentWithReln(IndexedWord vertex, GrammaticalRelation reln) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        Set edges = this.incomingEdgesOf(vertex);
        for (SemanticGraphEdge edge : edges) {
            if (!edge.getRelation().equals(reln)) continue;
            return true;
        }
        return false;
    }

    public IndexedWord getChildWithReln(IndexedWord vertex, GrammaticalRelation reln) {
        if (vertex.equals(IndexedWord.NO_WORD)) {
            return null;
        }
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        Set edges = this.outgoingEdgesOf(vertex);
        for (SemanticGraphEdge edge : edges) {
            if (!edge.getRelation().equals(reln)) continue;
            return (IndexedWord)edge.getTarget();
        }
        return null;
    }

    public List<IndexedWord> getParentsWithReln(IndexedWord vertex, GrammaticalRelation reln) {
        if (vertex.equals(IndexedWord.NO_WORD)) {
            return new ArrayList<IndexedWord>();
        }
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<IndexedWord> parentList = Generics.newArrayList();
        Set edges = this.incomingEdgesOf(vertex);
        for (SemanticGraphEdge edge : edges) {
            if (!edge.getRelation().equals(reln)) continue;
            parentList.add((IndexedWord)edge.getSource());
        }
        return parentList;
    }

    public List<IndexedWord> getChildrenWithReln(IndexedWord vertex, GrammaticalRelation reln) {
        if (vertex.equals(IndexedWord.NO_WORD)) {
            return new ArrayList<IndexedWord>();
        }
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<IndexedWord> childList = Generics.newArrayList();
        Set edges = this.outgoingEdgesOf(vertex);
        for (SemanticGraphEdge edge : edges) {
            if (!edge.getRelation().equals(reln)) continue;
            childList.add((IndexedWord)edge.getTarget());
        }
        return childList;
    }

    public List<IndexedWord> getChildrenWithRelns(IndexedWord vertex, Collection<GrammaticalRelation> relns) {
        if (vertex.equals(IndexedWord.NO_WORD)) {
            return new ArrayList<IndexedWord>();
        }
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<IndexedWord> childList = new ArrayList<IndexedWord>();
        Set edges = this.outgoingEdgesOf(vertex);
        for (SemanticGraphEdge edge : edges) {
            if (!relns.contains(edge.getRelation())) continue;
            childList.add((IndexedWord)edge.getTarget());
        }
        return childList;
    }

    public SemanticGraphEdge getEdge(IndexedWord gov, IndexedWord dep, GrammaticalRelation reln) {
        Set edges = this.getAllEdges(gov, dep);
        if (edges != null) {
            for (SemanticGraphEdge edge : edges) {
                if (!((IndexedWord)edge.getSource()).equals(gov) || !edge.getRelation().equals(reln)) continue;
                return edge;
            }
        }
        return null;
    }

    public boolean isNegatedVertex(IndexedWord vertex) {
        if (vertex == IndexedWord.NO_WORD) {
            return false;
        }
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException("Vertex " + vertex + " not in graph " + (Object)((Object)this));
        }
        return this.hasChildWithReln(vertex, EnglishGrammaticalRelations.NEGATION_MODIFIER) || this.hasChild(vertex, GrammaticalRelation.DEPENDENT, "nor");
    }

    private boolean isNegatedVerb(IndexedWord vertex) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        return vertex.tag().startsWith("VB") && this.isNegatedVertex(vertex);
    }

    public boolean isInConditionalContext(IndexedWord vertex) {
        List<IndexedWord> children = this.getChildrenWithReln(vertex, EnglishGrammaticalRelations.MARKER);
        for (IndexedWord child : children) {
            if (!child.word().equalsIgnoreCase("if")) continue;
            return true;
        }
        return false;
    }

    public boolean attachedNegatedVerb(IndexedWord vertex) {
        for (IndexedWord parent : this.getParentList(vertex)) {
            if (!this.isNegatedVerb(parent)) continue;
            return true;
        }
        return false;
    }

    public boolean isAuxiliaryVerb(IndexedWord vertex) {
        Set<GrammaticalRelation> relns = this.relns(vertex);
        if (relns.isEmpty()) {
            return false;
        }
        boolean result = relns.contains(EnglishGrammaticalRelations.AUX_MODIFIER) || relns.contains(EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER);
        return result;
    }

    public Set<IndexedWord> getLeafVertices() {
        HashSet<IndexedWord> result = new HashSet<IndexedWord>();
        Set vertices = this.vertexSet();
        for (IndexedWord v : vertices) {
            int outDegree = this.outDegreeOf(v);
            if (outDegree != 0) continue;
            result.add(v);
        }
        return result;
    }

    public int size() {
        return this.vertexSet().size();
    }

    public boolean isDag() {
        HashSet<IndexedWord> unused = new HashSet<IndexedWord>(this.vertexSet());
        while (!unused.isEmpty()) {
            IndexedWord arbitrary = (IndexedWord)unused.iterator().next();
            boolean result = this.isDagHelper(arbitrary, unused, new HashSet<IndexedWord>());
            if (!result) continue;
            return false;
        }
        return true;
    }

    private boolean isDagHelper(IndexedWord current, Set<IndexedWord> unused, Set<IndexedWord> trail) {
        if (trail.contains(current)) {
            return true;
        }
        if (!unused.contains(current)) {
            return false;
        }
        unused.remove(current);
        trail.add(current);
        for (IndexedWord child : this.getChildList(current)) {
            boolean result = this.isDagHelper(child, unused, trail);
            if (!result) continue;
            return true;
        }
        trail.remove(current);
        return false;
    }

    private void insertSpecificIntoList(String specific, IndexedWord relnTgtNode, List<IndexedWord> tgtList) {
        int currIndex;
        Set<IndexedWord> descendents = this.descendants(relnTgtNode);
        IndexedWord specificNode = new IndexedWord();
        specificNode.set(CoreAnnotations.LemmaAnnotation.class, specific);
        specificNode.set(CoreAnnotations.TextAnnotation.class, specific);
        specificNode.set(CoreAnnotations.CurrentAnnotation.class, specific);
        for (currIndex = tgtList.indexOf(relnTgtNode); currIndex >= 1 && descendents.contains(tgtList.get(currIndex - 1)); --currIndex) {
        }
        tgtList.add(currIndex, specificNode);
    }

    public String toString() {
        Collection<IndexedWord> rootNodes = this.getRoots();
        if (rootNodes.isEmpty()) {
            return this.toString("readable");
        }
        StringBuilder sb = new StringBuilder();
        HashSet<IndexedWord> used = new HashSet<IndexedWord>();
        for (IndexedWord root : rootNodes) {
            sb.append("-> ").append(root).append(" (root)\n");
            this.recToString(root, sb, 1, used);
        }
        HashSet nodes = new HashSet(this.vertexSet());
        nodes.removeAll(used);
        while (!nodes.isEmpty()) {
            IndexedWord node = (IndexedWord)nodes.iterator().next();
            sb.append(node).append("\n");
            this.recToString(node, sb, 1, used);
            nodes.removeAll(used);
        }
        return sb.toString();
    }

    private void recToString(IndexedWord curr, StringBuilder sb, int offset, Set<IndexedWord> used) {
        ArrayList edges;
        used.add(curr);
        try {
            edges = new ArrayList(this.outgoingEdgesOf(curr));
        }
        catch (IllegalArgumentException iae) {
            edges = new ArrayList();
        }
        Collections.sort(edges);
        for (SemanticGraphEdge edge : edges) {
            IndexedWord target = (IndexedWord)edge.getTarget();
            sb.append(SemanticGraph.space(2 * offset)).append("-> ").append(target).append(" (").append(edge.getRelation()).append(")\n");
            if (used.contains(target)) continue;
            this.recToString(target, sb, offset + 1, used);
        }
    }

    private static String space(int width) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < width; ++i) {
            b.append(" ");
        }
        return b.toString();
    }

    public String toRecoveredSentenceString() {
        StringBuilder sb = new StringBuilder();
        boolean pastFirst = false;
        for (IndexedWord word : this.vertexList()) {
            if (pastFirst) {
                sb.append(' ');
            }
            pastFirst = true;
            sb.append(word.word());
        }
        return sb.toString();
    }

    public String toRecoveredSentenceStringWithIndexMarking() {
        StringBuilder sb = new StringBuilder();
        boolean pastFirst = false;
        int index = 0;
        for (IndexedWord word : this.vertexList()) {
            if (pastFirst) {
                sb.append(' ');
            }
            pastFirst = true;
            sb.append(word.word());
            sb.append("(");
            sb.append(index++);
            sb.append(")");
        }
        return sb.toString();
    }

    public String toEnUncollapsedSentenceString() {
        LinkedList<IndexedWord> uncompressedList = Generics.newLinkedList(this.vertexSet());
        ArrayList<Pair<String, IndexedWord>> specifics = Generics.newArrayList();
        for (IndexedWord indexedWord : this.vertexSet()) {
            for (SemanticGraphEdge edge : this.incomingEdgesOf(indexedWord)) {
                GrammaticalRelation relation = edge.getRelation();
                String specific = relation.getSpecific();
                if (specific == null && edge.getRelation().equals(EnglishGrammaticalRelations.AGENT)) {
                    specific = "by";
                }
                if (specific == null) continue;
                Pair<String, IndexedWord> specPair = new Pair<String, IndexedWord>(specific, indexedWord);
                specifics.add(specPair);
            }
        }
        for (Pair pair : specifics) {
            this.insertSpecificIntoList((String)pair.first(), (IndexedWord)pair.second(), uncompressedList);
        }
        return StringUtils.join(uncompressedList, " ");
    }

    public String toString(String format) {
        if (format != null && format.equals("xml")) {
            return this.toXMLString();
        }
        if (format != null && format.equals("readable")) {
            return this.toReadableString();
        }
        return this.toList();
    }

    public String toList() {
        StringBuilder buf = new StringBuilder();
        for (SemanticGraphEdge edge : this.edgeList()) {
            buf.append(edge.getRelation().toString()).append("(");
            buf.append(SemanticGraph.toDepStyle((IndexedWord)edge.getSource())).append(",");
            buf.append(SemanticGraph.toDepStyle((IndexedWord)edge.getTarget())).append(")\n");
        }
        return buf.toString();
    }

    public String toPOSList() {
        StringBuilder buf = new StringBuilder();
        for (SemanticGraphEdge edge : this.edgeList()) {
            buf.append(edge.getRelation().toString()).append("(");
            buf.append(SemanticGraph.toPOSStyle((IndexedWord)edge.getSource())).append(",");
            buf.append(SemanticGraph.toPOSStyle((IndexedWord)edge.getTarget())).append(")\n");
        }
        return buf.toString();
    }

    private static String toDepStyle(IndexedWord fl) {
        StringBuilder buf = new StringBuilder();
        buf.append(fl.word());
        buf.append("-");
        buf.append(fl.index());
        return buf.toString();
    }

    private static String toPOSStyle(IndexedWord fl) {
        StringBuilder buf = new StringBuilder();
        buf.append(fl.word());
        buf.append("/");
        buf.append(fl.tag());
        buf.append("-");
        buf.append(fl.index());
        return buf.toString();
    }

    private String toReadableString() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("%-20s%-20s%-20s%n", "dep", "reln", "gov"));
        buf.append(String.format("%-20s%-20s%-20s%n", "---", "----", "---"));
        for (IndexedWord root : this.getRoots()) {
            buf.append(String.format("%-20s%-20s%-20s%n", SemanticGraph.toDepStyle(root), "root", "root"));
        }
        for (SemanticGraphEdge edge : this.edgeList()) {
            buf.append(String.format("%-20s%-20s%-20s%n", SemanticGraph.toDepStyle((IndexedWord)edge.getTarget()), edge.getRelation().toString(), SemanticGraph.toDepStyle((IndexedWord)edge.getSource())));
        }
        return buf.toString();
    }

    private String toXMLString() {
        StringBuilder buf = new StringBuilder("<dependencies style=\"typed\">\n");
        for (SemanticGraphEdge edge : this.edgeList()) {
            String reln = edge.getRelation().toString();
            String gov = ((IndexedWord)edge.getSource()).word();
            int govIdx = ((IndexedWord)edge.getSource()).index();
            String dep = ((IndexedWord)edge.getTarget()).word();
            int depIdx = ((IndexedWord)edge.getTarget()).index();
            buf.append("  <dep type=\"").append(reln).append("\">\n");
            buf.append("    <governor idx=\"").append(govIdx).append("\">").append(gov).append("</governor>\n");
            buf.append("    <dependent idx=\"").append(depIdx).append("\">").append(dep).append("</dependent>\n");
            buf.append("  </dep>\n");
        }
        buf.append("</dependencies>\n");
        return buf.toString();
    }

    public String toCompactString() {
        return this.toCompactString(false);
    }

    public String toCompactString(boolean showTags) {
        StringBuilder sb = new StringBuilder();
        HashSet<IndexedWord> used = new HashSet<IndexedWord>();
        Collection<IndexedWord> roots = this.getRoots();
        if (roots.isEmpty()) {
            if (this.size() == 0) {
                return "[EMPTY_SEMANTIC_GRAPH]";
            }
            return "[UNROOTED_SEMANTIC_GRAPH]";
        }
        for (IndexedWord root : roots) {
            this.toCompactStringHelper(root, sb, used, showTags);
        }
        return sb.toString();
    }

    private void toCompactStringHelper(IndexedWord node, StringBuilder sb, Set<IndexedWord> used, boolean showTags) {
        used.add(node);
        try {
            boolean isntLeaf;
            boolean bl = isntLeaf = this.outDegreeOf(node) > 0;
            if (isntLeaf) {
                sb.append("[");
            }
            sb.append(node.word());
            if (showTags) {
                sb.append("/");
                sb.append(node.tag());
            }
            for (SemanticGraphEdge edge : this.getOutEdgesSorted(node)) {
                IndexedWord target = (IndexedWord)edge.getTarget();
                sb.append(" ").append(edge.getRelation()).append(":");
                if (!used.contains(target)) {
                    this.toCompactStringHelper(target, sb, used, showTags);
                    continue;
                }
                sb.append(target.word());
                if (!showTags) continue;
                sb.append("/");
                sb.append(target.tag());
            }
            if (isntLeaf) {
                sb.append("]");
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("WHOA!  SemanticGraph.toCompactStringHelper() ran into problems at node " + node);
            throw new IllegalArgumentException(e);
        }
    }

    public String toFormattedString() {
        return formatter.formatSemanticGraph(this);
    }

    public String toFormattedString(SemanticGraphFormatter formatter) {
        return formatter.formatSemanticGraph(this);
    }

    public void prettyPrint(SemanticGraphFormatter formatter) {
        System.out.println(formatter.formatSemanticGraph(this));
    }

    public void prettyPrint() {
        System.out.println(formatter.formatSemanticGraph(this));
    }

    @Deprecated
    public SemanticGraphEdge addEdge(IndexedWord s, IndexedWord d) {
        throw new UnsupportedOperationException("Use the format with more parameters.");
    }

    public SemanticGraphEdge addEdge(IndexedWord s, IndexedWord d, GrammaticalRelation reln, double weight2) {
        SemanticGraphEdge newEdge = new SemanticGraphEdge(s, d, reln, weight2);
        super.addEdge((Object)s, (Object)d, (Object)newEdge);
        return newEdge;
    }

    public static SemanticGraph valueOf(String s) {
        return new SemanticGraphParsingTask(s).parse();
    }

    public SemanticGraph() {
        super((EdgeFactory)new SemanticGraphEdge.Factory());
        this.roots = new HashSet<IndexedWord>();
    }

    public SemanticGraph(SemanticGraph g) {
        super(g.getEdgeFactory());
        ArrayList<IndexedWord> oldRoots = new ArrayList<IndexedWord>(g.getRoots());
        Set vertexes = g.vertexSet();
        HashMap<IndexedWord, IndexedWord> prevToNewMap = new HashMap<IndexedWord, IndexedWord>();
        for (IndexedWord vertex : vertexes) {
            IndexedWord newVertex = new IndexedWord(vertex);
            this.addVertex(newVertex);
            prevToNewMap.put(vertex, newVertex);
        }
        this.roots = new HashSet<IndexedWord>();
        for (IndexedWord oldRoot : oldRoots) {
            this.roots.add((IndexedWord)prevToNewMap.get(oldRoot));
        }
        Set edges = g.edgeSet();
        for (SemanticGraphEdge edge : edges) {
            IndexedWord newGov = (IndexedWord)prevToNewMap.get(edge.getGovernor());
            IndexedWord newDep = (IndexedWord)prevToNewMap.get(edge.getDependent());
            this.addEdge(newGov, newDep, edge.getRelation(), edge.getWeight());
        }
    }

    public SemanticGraph(SemanticGraph g, Map<IndexedWord, IndexedWord> prevToNewMap) {
        super(g.getEdgeFactory());
        ArrayList<IndexedWord> oldRoots = new ArrayList<IndexedWord>(g.getRoots());
        if (prevToNewMap == null) {
            prevToNewMap = new HashMap<IndexedWord, IndexedWord>();
        }
        Set vertexes = g.vertexSet();
        for (IndexedWord vertex : vertexes) {
            IndexedWord newVertex = new IndexedWord(vertex);
            this.addVertex(newVertex);
            prevToNewMap.put(vertex, newVertex);
        }
        this.roots = new HashSet<IndexedWord>();
        for (IndexedWord oldRoot : oldRoots) {
            this.roots.add(prevToNewMap.get(oldRoot));
        }
        Set edges = g.edgeSet();
        for (SemanticGraphEdge edge : edges) {
            IndexedWord newGov = prevToNewMap.get(edge.getGovernor());
            IndexedWord newDep = prevToNewMap.get(edge.getDependent());
            this.addEdge(newGov, newDep, edge.getRelation(), edge.getWeight());
        }
    }

    public SemanticGraph(Collection<TypedDependency> dependencies, Collection<TreeGraphNode> roots) {
        this(dependencies, roots, "", 0);
    }

    public SemanticGraph(Collection<TypedDependency> dependencies, Collection<TreeGraphNode> rootNodes, String docID, int sentIndex) {
        this(dependencies, rootNodes, docID, sentIndex, false, false);
    }

    public SemanticGraph(Collection<TypedDependency> dependencies, Collection<TreeGraphNode> rootNodes, String docID, int sentIndex, boolean lemmatize, boolean threadSafe) {
        super((EdgeFactory)new SemanticGraphEdge.Factory());
        for (TypedDependency d : dependencies) {
            TreeGraphNode gov = d.gov();
            TreeGraphNode dep = d.dep();
            GrammaticalRelation reln = d.reln();
            CoreLabel govLabel = new CoreLabel(gov.label());
            CoreLabel depLabel = new CoreLabel(dep.label());
            IndexedWord govVertex = new IndexedWord(docID, sentIndex, gov.index(), govLabel);
            govVertex.setTag(gov.highestNodeWithSameHead().headTagNode().value());
            IndexedWord depVertex = new IndexedWord(docID, sentIndex, dep.index(), depLabel);
            depVertex.setTag(dep.highestNodeWithSameHead().headTagNode().value());
            if (lemmatize) {
                if (!threadSafe) {
                    govVertex.setLemma(Morphology.stemStatic(govVertex.value(), govVertex.tag(), true).value());
                    depVertex.setLemma(Morphology.stemStatic(depVertex.value(), depVertex.tag(), true).value());
                } else {
                    govVertex.setLemma(Morphology.stemStaticSynchronized(govVertex.value(), govVertex.tag(), true).value());
                    depVertex.setLemma(Morphology.stemStaticSynchronized(depVertex.value(), depVertex.tag(), true).value());
                }
            }
            this.addVertex(govVertex);
            this.addVertex(depVertex);
            this.addEdge(govVertex, depVertex, reln, Double.NEGATIVE_INFINITY);
        }
        this.roots = new HashSet<IndexedWord>();
        if (rootNodes != null) {
            for (TreeGraphNode rootNode : rootNodes) {
                CoreLabel rootLabel = new CoreLabel(rootNode.label());
                IndexedWord root = new IndexedWord(docID, sentIndex, rootNode.index(), rootLabel);
                this.roots.add(root);
            }
        }
    }

    public List<SemanticGraphEdge> getShortestPathEdges(IndexedWord source, IndexedWord target) {
        assert (this.containsVertex(source) && this.containsVertex(target));
        return DijkstraShortestPathIgnoringEdgeDirection.findPathBetween(this, source, target);
    }

    public List<SemanticGraphEdge> getShortestDirectPathEdges(IndexedWord source, IndexedWord target) {
        return DijkstraShortestPath.findPathBetween((Graph)this, (Object)source, (Object)target);
    }

    public List<IndexedWord> getShortestPathNodes(IndexedWord source, IndexedWord target) {
        if (source == target) {
            ArrayList<IndexedWord> path = new ArrayList<IndexedWord>();
            path.add(source);
            return path;
        }
        List<SemanticGraphEdge> edgePath = this.getShortestPathEdges(source, target);
        if (edgePath == null || edgePath.size() == 0) {
            return null;
        }
        ArrayList<IndexedWord> result = Generics.newArrayList(edgePath.size() + 1);
        IndexedWord lastNode = source;
        result.add(lastNode);
        for (SemanticGraphEdge edge : edgePath) {
            lastNode = !((IndexedWord)edge.getTarget()).equals(lastNode) ? (IndexedWord)edge.getTarget() : (IndexedWord)edge.getSource();
            result.add(lastNode);
        }
        assert (((IndexedWord)result.get(result.size() - 1)).equals(target));
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SemanticGraph)) {
            return false;
        }
        SemanticGraph g = (SemanticGraph)((Object)o);
        return ((Object)this.edgeSet()).equals(g.edgeSet());
    }

    public int hashCode() {
        return ((Object)this.edgeSet()).hashCode();
    }

    public List<SemanticGraphEdge> findAllRelns(GrammaticalRelation tgtRelation) {
        ArrayList<SemanticGraphEdge> relns = new ArrayList<SemanticGraphEdge>();
        for (SemanticGraphEdge edge : this.edgeList()) {
            GrammaticalRelation edgeRelation = edge.getRelation();
            if (edgeRelation == null || !edgeRelation.equals(tgtRelation)) continue;
            relns.add(edge);
        }
        return relns;
    }

    public Collection<TypedDependency> typedDependencies() {
        ArrayList<TypedDependency> dependencies = new ArrayList<TypedDependency>();
        for (SemanticGraphEdge e : this.edgeList()) {
            TreeGraphNode gov = new TreeGraphNode(e.getGovernor());
            TreeGraphNode dep = new TreeGraphNode(e.getDependent());
            TypedDependency dependency = new TypedDependency(e.getRelation(), gov, dep);
            dependencies.add(dependency);
        }
        return dependencies;
    }

    public static void main(String[] args) {
        MemoryTreebank tb = new MemoryTreebank();
        Properties props = StringUtils.argsToProperties(args);
        String treeFileName = props.getProperty("treeFile");
        String sentFileName = props.getProperty("sentFile");
        String testGraph = props.getProperty("testGraph");
        if (testGraph == null) {
            testGraph = "false";
        }
        String load = props.getProperty("load");
        String save = props.getProperty("save");
        if (load != null) {
            System.err.println("Load not implemented!");
            return;
        }
        if (sentFileName == null && treeFileName == null) {
            System.err.println("Usage: java SemanticGraph [-sentFile file|-treeFile file] [-testGraph]");
            Tree t = Tree.valueOf("(ROOT (S (NP (NP (DT An) (NN attempt)) (PP (IN on) (NP (NP (NNP Andres) (NNP Pastrana) (POS 's)) (NN life)))) (VP (VBD was) (VP (VBN carried) (PP (IN out) (S (VP (VBG using) (NP (DT a) (JJ powerful) (NN bomb))))))) (. .)))");
            ((AbstractCollection)tb).add(t);
        } else if (treeFileName != null) {
            tb.loadPath(treeFileName);
        } else {
            String[] opts = new String[]{"-retainNPTmpSubcategories"};
            LexicalizedParser lp = new LexicalizedParser("/u/nlp/data/lexparser/englishPCFG.ser.gz");
            lp.setOptionFlags(opts);
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(sentFileName));
            }
            catch (FileNotFoundException e) {
                System.err.println("Cannot find " + sentFileName);
                System.exit(1);
            }
            try {
                String line;
                System.out.println("Processing sentence file " + sentFileName);
                while ((line = reader.readLine()) != null) {
                    System.out.println("Processing sentence: " + line);
                    PTBTokenizer<Word> ptb = PTBTokenizer.newPTBTokenizer(new StringReader(line));
                    List words = ptb.tokenize();
                    lp.parse(words);
                    Tree parseTree = lp.getBestParse();
                    ((AbstractCollection)tb).add(parseTree);
                }
                reader.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception reading key file " + sentFileName, e);
            }
        }
        for (Tree t : tb) {
            SemanticGraph sg = SemanticGraphFactory.makeFromTree(t, false);
            System.out.println(sg.toString());
            System.out.println(sg.toCompactString());
            if (!testGraph.equals("true")) continue;
            SemanticGraph g1 = SemanticGraphFactory.makeFromTree(t);
            System.out.println("TEST SEMANTIC GRAPH - graph ----------------------------");
            System.out.println(g1.toString());
            System.out.println("readable ----------------------------");
            System.out.println(g1.toString("readable"));
            System.out.println("List of dependencies ----------------------------");
            System.out.println(g1.toList());
            System.out.println("xml ----------------------------");
            System.out.println(g1.toString("xml"));
        }
        if (save != null) {
            // empty if block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SemanticGraphParsingTask
    extends StringParsingTask<SemanticGraph> {
        private SemanticGraph sg;
        private Set<Integer> indexesUsed = new HashSet<Integer>();

        public SemanticGraphParsingTask(String s) {
            super(s);
        }

        @Override
        public SemanticGraph parse() {
            this.sg = new SemanticGraph();
            try {
                this.readWhiteSpace();
                if (!SemanticGraphParsingTask.isLeftBracket(this.peek())) {
                    return null;
                }
                this.readDep(null, null);
                return this.sg;
            }
            catch (StringParsingTask.ParserException e) {
                System.err.println("SemanticGraphParser warning: " + e.getMessage());
                return null;
            }
        }

        private void readDep(IndexedWord gov, String reln) {
            this.readWhiteSpace();
            if (!SemanticGraphParsingTask.isLeftBracket(this.peek())) {
                String label = this.readName();
                IndexedWord dep = this.makeVertex(label);
                this.sg.addVertex(dep);
                if (gov == null) {
                    this.sg.roots.add(dep);
                }
                this.sg.addEdge(gov, dep, GrammaticalRelation.valueOf(reln), Double.NEGATIVE_INFINITY);
            } else {
                this.readLeftBracket();
                String label = this.readName();
                IndexedWord dep = this.makeVertex(label);
                this.sg.addVertex(dep);
                if (gov == null) {
                    this.sg.roots.add(dep);
                }
                if (gov != null && reln != null) {
                    this.sg.addEdge(gov, dep, GrammaticalRelation.valueOf(reln), Double.NEGATIVE_INFINITY);
                }
                this.readWhiteSpace();
                while (!SemanticGraphParsingTask.isRightBracket(this.peek()) && !this.isEOF) {
                    reln = this.readName();
                    this.readColon();
                    this.readDep(dep, reln);
                    this.readWhiteSpace();
                }
                this.readRightBracket();
            }
        }

        private IndexedWord makeVertex(String word) {
            Integer index;
            Pair<String, Integer> wordAndIndex = SemanticGraphParsingTask.readWordAndIndex(word);
            if (wordAndIndex != null) {
                word = wordAndIndex.first();
                index = wordAndIndex.second();
            } else {
                index = this.getNextFreeIndex();
            }
            this.indexesUsed.add(index);
            IndexedWord ifl = new IndexedWord(null, 0, index);
            String[] wordAndTag = word.split("/");
            ifl.set(CoreAnnotations.TextAnnotation.class, wordAndTag[0]);
            if (wordAndTag.length > 1) {
                ifl.set(CoreAnnotations.PartOfSpeechAnnotation.class, wordAndTag[1]);
            }
            return ifl;
        }

        private static Pair<String, Integer> readWordAndIndex(String word) {
            Matcher matcher = WORD_AND_INDEX_PATTERN.matcher(word);
            if (!matcher.matches()) {
                return null;
            }
            word = matcher.group(1);
            Integer index = Integer.valueOf(matcher.group(2));
            return new Pair<String, Integer>(word, index);
        }

        private Integer getNextFreeIndex() {
            int i = 0;
            while (this.indexesUsed.contains(i)) {
                ++i;
            }
            return i;
        }

        private void readLeftBracket() {
            this.readWhiteSpace();
            char ch = this.read();
            if (!SemanticGraphParsingTask.isLeftBracket(ch)) {
                throw new StringParsingTask.ParserException("Expected left paren!");
            }
        }

        private void readRightBracket() {
            this.readWhiteSpace();
            char ch = this.read();
            if (!SemanticGraphParsingTask.isRightBracket(ch)) {
                throw new StringParsingTask.ParserException("Expected right paren!");
            }
        }

        private void readColon() {
            this.readWhiteSpace();
            if (SemanticGraphParsingTask.isColon(this.peek())) {
                this.read();
            }
        }

        private static boolean isLeftBracket(char ch) {
            return ch == '[';
        }

        private static boolean isRightBracket(char ch) {
            return ch == ']';
        }

        private static boolean isColon(char ch) {
            return ch == ':';
        }

        @Override
        protected boolean isPunct(char ch) {
            return SemanticGraphParsingTask.isLeftBracket(ch) || SemanticGraphParsingTask.isRightBracket(ch) || SemanticGraphParsingTask.isColon(ch);
        }
    }
}

